/* CONSOLE INTERFACE */

#ifndef __CONSOLE_H
#define __CONSOLE_H

/* cursor modes */
#define C_NORMAL 0
#define C_HIDE 1

/* special key values */
#define K_TAB 9
#define K_BACKSPACE 8
#define K_ENTER 10
#define K_ESCAPE 0
#define K_UP 128
#define K_DOWN 129
#define K_LEFT 130
#define K_RIGHT 131

extern int console_ok;

extern void c_init(void);
extern void c_shutdown(void);
extern void c_cls(void);
extern void c_print(char *text);
extern void c_goto(int x, int y);
extern unsigned char c_getkey(void);
extern void c_clear(int x1,int y1,int x2, int y2);
extern int c_kbhit(void);
extern void c_cursor(int c);
extern void c_bell(void);
extern void c_setcolor(char a);
extern void c_refresh(void);

#endif
