/* EXECUTIVE DISASSEMBLING FUNCTIONS */
/* Note: I suppose all functions get correct arguments */

#include <stdio.h>

#include "disasm.h"
#include "z80-asm.h"
#include "z80-dis.h"
#include "regs.h"
#include "asm.h"


/* sets parity according to byte */
void
__parity(_uchar byte)
{
 int a;
 _uchar v;
 for (a=0,v=0;a<8;a++,v^=(byte)&1,byte>>=1)
  ;
 set_flag(v?F_PO:F_PE);
}


void
f_nop (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;t1=t1;a2=a2;t2=t2;
 if (mode==M_PRINT)
  print("nop");
}


void
f_bit (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];
 static char t[64];
 int a=0;

 switch (mode)
 {
  case M_PRINT:
  reg_str(t,a2,t2);
  sprintf(txt,"bit %d,%s",a1,t);
  print(txt);
  break;

  case M_EXEC:
  switch (t2)
  {
   case A_REG:
   a=*(reg_ptr(a2));
   break;

   case A_PODLE_REG:
   a=memory[(H<<8)+L];
   break;

   case A_PODLE_IX_PLUS:
   a=memory[(_ushort)(IX+a2)];
   break;

   case A_PODLE_IY_PLUS:
   a=memory[(_ushort)(IY+a2)];
   break;
  }
  set_flag(a&(1<<a1)?F_NZ:F_Z);
  set_flag(F_H);
  set_flag(F_NN);
  break;
 }
}


void
f_set (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];
 _uchar *a=0;
 static char t[64];
 
 switch (mode)
 {
  case M_PRINT:
  reg_str(t,a2,t2);
  sprintf(txt,"set %d,%s",a1,t);
  print(txt);
  break;

  case M_EXEC:
  switch (t2)
  {
   case A_REG:
   a=reg_ptr(a2);
   break;

   case A_PODLE_REG:
   a=memory+(H<<8)+L;
   break;

   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a2);
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a2);
   break;
  }
  *a|=1<<a1;
  break;
 }
}


void
f_res (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];
 _uchar *a=0;
 static char t[64];

 switch (mode)
 {
  case M_PRINT:
  reg_str(t,a2,t2);
  sprintf(txt,"res %d,%s",a1,t);
  print(txt);
  break;

  case M_EXEC:
  switch (t2)
  {
   case A_REG:
   a=reg_ptr(a2);
   break;

   case A_PODLE_REG:
   a=memory+(H<<8)+L;
   break;

   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a2);
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a2);
   break;
  }
  *a&=255-(1<<a1);
  break;
 }
}


void
f_defb (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];

 a1=a1;t1=t1;a2=a2;t2=t2;
 if (mode==M_PRINT)
 {
  sprintf(txt,"defb %d",a1);
  print(txt);
 }
}


void
f_ld (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char arg1[16];
 static char arg2[16];
 static char txt[48];
 _ushort rval=0;
 
 switch(mode)
 {
  case M_PRINT:
  switch(t1)
  {
   case A_PODLE_NUM:
   sprintf(arg1,"(%u)",a1);
   break;
   
   default:
   reg_str(arg1,a1,t1);
   break;
  }
  switch(t2)
  {
   case A_PODLE_NUM:
   sprintf(arg2,"(%u)",a2);
   break;

   case A_NUM:
   sprintf(arg2,"%u",a2);
   break;
   
   default:
   reg_str(arg2,a2,t2);
   break;
  }
  sprintf(txt,"ld %s,%s",arg1,arg2);
  print(txt);
  break;

  case M_EXEC:
  switch(t2)
  {
   case A_NUM:
   rval=a2;
   break;

   case A_PODLE_NUM:
   rval=memory[a2];
   break;

   case A_PODLE_REG:
   switch(a2)
   {
    case R_BC:
    rval=memory[(B<<8)+C];
    break;

    case R_HL:
    rval=memory[(H<<8)+L];
    break;

    case R_DE:
    rval=memory[(D<<8)+E];
    break;
   }

   case A_REG:
   switch(a2)
   {
    case R_BC:
    rval=C+(B<<8);
    break;
 
    case R_DE:
    rval=E+(D<<8);
    break;
    
    case R_HL:
    rval=L+(H<<8);
    break;
 
    case R_IX:
    rval=IX;
    break;
 
    case R_IY:
    rval=IY;
    break;
    
    case R_SP:
    rval=SP;
    break;
 
    default:
    rval=*reg_ptr(a2);
    break;
   }
   break;

   case A_PODLE_IX_PLUS:
   rval=memory[IX+(signed short)a2];
   break;
 
   case A_PODLE_IY_PLUS:
   rval=memory[IY+(signed short)a2];
   break;
  }
  switch(t1)
  {
   case A_PODLE_NUM:
   memory[a1]=(_uchar)rval;
   break;

   case A_PODLE_IX_PLUS:
   memory[IX+(signed short)a1]=(_uchar)rval;
   break;
   
   case A_PODLE_IY_PLUS:
   memory[IY+(signed short)a1]=(_uchar)rval;
   break;

   case A_PODLE_REG:
   switch(a1)
   {
    case R_BC:
    memory[(B<<8)+C]=(_uchar)rval;
    break;

    case R_DE:
    memory[(D<<8)+E]=(_uchar)rval;
    break;

    case R_HL:
    memory[(H<<8)+L]=(_uchar)rval;
    break;
   }
   break;

   case A_REG:
   switch(a1)
   {
    case R_IX:
    IX=rval;
    break;

    case R_IY:
    IY=rval;
    break;

    case R_SP:
    SP=rval;
    break;

    case R_BC:
    C=rval&255;
    B=rval>>8;
    break;

    case R_DE:
    E=rval&255;
    D=rval>>8;
    break;

    case R_HL:
    L=rval&255;
    H=rval>>8;
    break;

    default:
    *reg_ptr(a1)=(_uchar)rval;
    break;
   }
   break;
  }
  break;
 }

 if (t1==A_REG&&t2==A_REG&&a1==R_A&&(a2==R_I||a2==R_R))
 {
  set_flag(F_NH);
  set_flag(F_NN);
  set_flag(F_PE);
  set_flag(A?F_NZ:F_Z);
  set_flag((A&128)?F_M:F_P);
 }
}


void 
f_call (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];
 static char t[64];
 _ushort addr=0;
 
 switch (mode)
 {
  case M_PRINT:
  if (t1==A_FLAG)
  {
   flag_str(t,a1);
   sprintf(txt,"call %s,%u",t,a2);
  }
  else
   sprintf(txt,"call %d",a1);
  print(txt);
  break;

  case M_EXEC:
  switch (t1)
  {
   case A_FLAG:
   if (!is_flag(a1))return;
   addr=a2;
   break;
   
   default:
   addr=a1;
   break;
  }
  SP-=2;
  memory[SP]=PC&255;
  memory[(_ushort)(SP+1)]=PC>>8;
  PC=addr;
  break;
 }
}


void 
f_ret (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];
 static char t[64];
 
 a2=a2;t2=t2;t1=t1;
 switch (mode)
 {
  case M_PRINT:
  flag_str(t,a1);
  sprintf(txt,"ret %s",t);
  print(txt);
  break;

  case M_EXEC:
  if (!is_flag(a1))break;  /* empty flag is always set */
  PC=memory[SP]+(memory[(_ushort)(SP+1)]<<8);
  SP+=2;
  break;
 }
}


void 
f_inc (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar *a;
 unsigned char z=is_flag(F_Z),s=is_flag(F_M),h=is_flag(F_H),p=0;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"inc %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    case R_IX:
    IX++;
    break;
    
    case R_IY:
    IY++;
    break;
    
    case R_SP:
    SP++;
    break;
    
    case R_DE:
    E++;D=E?D:D+1;
    break;
    
    case R_HL:
    L++;H=L?H:H+1;
    break;
    
    case R_BC:
    C++;B=C?B:B+1;
    break;
    
    default:
    a=reg_ptr(a1);
    h=(((*a)&15)==15);
    p=(((signed)(*a)+1)>127)?1:0;
    (*a)++;
    z=!(*a);
    s=((*a)&128);
    break;
   }
   break;

   case A_PODLE_REG:  /* inc (HL) */
   a=memory+(H<<8)+L;
   h=(((*a)&15)==15);
   p=(((signed)(*a)+1)>127)?1:0;
   (*a)++;
   z=!(*a);
   s=((*a)&128);
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a1);
   h=(((*a)&15)==15);
   p=(((signed)(*a)+1)>127)?1:0;
   (*a)++;
   z=!(*a);
   s=((*a)&128);
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a1);
   h=(((*a)&15)==15);
   p=(((signed)(*a)+1)>127)?1:0;
   (*a)++;
   z=!(*a);
   s=((*a)&128);
   break;
  }
  set_flag(F_NN);
  set_flag(z?F_Z:F_NZ);
  set_flag(s?F_M:F_P);
  set_flag(h?F_H:F_NH);
  set_flag(p?F_PE:F_PO);
  break;
 }
}


void 
f_dec (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar *a;
 unsigned char z=is_flag(F_Z),s=is_flag(F_M),h=is_flag(F_H),p=0;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"dec %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    case R_IX:
    IX--;
    break;
    
    case R_IY:
    IY--;
    break;
    
    case R_SP:
    SP--;
    break;
    
    case R_DE:
    D=E?D:D-1;E--;
    break;
    
    case R_HL:
    H=L?H:H-1;L--;
    break;
    
    case R_BC:
    B=C?B:B-1;C--;
    break;
    
    default:
    a=reg_ptr(a1);
    h=!((*a)&15);
    p=(((signed)(*a)-1)<128)?1:0;
    (*a)--;
    z=!(*a);
    s=((*a)&128);
    break;
   }
   break;

   case A_PODLE_REG:  /* dec (HL) */
   a=memory+(H<<8)+L;
   h=!((*a)&15);
   p=(((signed)(*a)-1)<128)?1:0;
   (*a)--;
   z=!(*a);
   s=((*a)&128);
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a1);
   h=!((*a)&15);
   p=(((signed)(*a)-1)<128)?1:0;
   (*a)--;
   z=!(*a);
   s=((*a)&128);
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a1);
   h=!((*a)&15);
   p=(((signed)(*a)-1)<128)?1:0;
   (*a)--;
   z=!(*a);
   s=((*a)&128);
   break;
  }
  set_flag(F_N);
  set_flag(z?F_Z:F_NZ);
  set_flag(s?F_M:F_P);
  set_flag(h?F_H:F_NH);
  set_flag(p?F_PE:F_PO);
  break;
 }
}


void 
f_rrca (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 _uchar b;
 
 a2=a2;t2=t2;a1=a1;t1=t1;
 switch(mode)
 {
  case M_PRINT:
  print("rrca");
  break;
  
  case M_EXEC:
  b=A&1;
  set_flag(b?F_C:F_NC);
  A>>=1;
  A|=b<<7;
  set_flag(F_NN);
  set_flag(F_NH);
  break;
 }
}


void 
f_rra (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 _uchar b;
 
 a2=a2;t2=t2;a1=a1;t1=t1;
 switch(mode)
 {
  case M_PRINT:
  print("rra");
  break;
  
  case M_EXEC:
  b=is_flag(F_C);
  set_flag((A&1)?F_C:F_NC);
  A>>=1;
  A|=b<<7;
  set_flag(F_NN);
  set_flag(F_NH);
  break;
 }
}


void 
f_rla (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 _uchar b;
 
 a2=a2;t2=t2;a1=a1;t1=t1;
 switch(mode)
 {
  case M_PRINT:
  print("rla");
  break;
  
  case M_EXEC:
  b=is_flag(F_C);
  set_flag((A&128)?F_C:F_NC);
  A<<=1;
  A|=b;
  set_flag(F_NN);
  set_flag(F_NH);
  break;
 }
}


void 
f_rlca (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 _uchar b;
 
 a2=a2;t2=t2;a1=a1;t1=t1;
 switch(mode)
 {
  case M_PRINT:
  print("rlca");
  break;
  
  case M_EXEC:
  b=A&128;
  set_flag(b?F_C:F_NC);
  A<<=1;
  A|=b>>7;
  set_flag(F_NN);
  set_flag(F_NH);
  break;
 }
}


void 
f_add (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16],tt[16];
 _uchar a=0;
 _ushort lv=0,rv=0;
 unsigned char h,v,c,index=0;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  if (t2==A_NUM)sprintf(tt,"%d",a2);
  else reg_str(tt,a2,t2);
  sprintf(txt,"add %s,%s",t,tt);
  print(txt);
  break;
  
  case M_EXEC:
  switch(a1)
  {
   case R_A:
   switch(t2)
   {
    case A_REG:
    switch(a2)
    {
     default:
     a=*reg_ptr(a2);
     break;
    }
    break;

    case A_PODLE_REG:  /* add A,(HL) */
    a=memory[(H<<8)+L];
    break;

    case A_NUM:
    a=a2;
    break;
    
    case A_PODLE_IY_PLUS:
    a=memory[(_ushort)(IY+a2)];
    break;
    
    case A_PODLE_IX_PLUS:
    a=memory[(_ushort)(IX+a2)];
    break;
   }
   v=((int)A+a)>127;
   c=((int)A+a)>255;
   h=((int)(A&15)+(a&15))>15;
   
   A+=a;
   
   set_flag(v?F_PO:F_PE);
   set_flag(c?F_C:F_NC);
   set_flag(h?F_H:F_NH);
   set_flag(A?F_NZ:F_Z);
   set_flag(A&128?F_M:F_P);
   set_flag(F_NN);
   break;

   case R_IY:
   index++;
   case R_IX:
   index++;
   case R_HL:
   switch(a2)
   {
    case R_BC:
    rv=(B<<8)+C;
    break;

    case R_DE:
    rv=(D<<8)+E;
    break;

    case R_HL:
    rv=(H<<8)+L;
    break;

    case R_IX:
    rv=IX;
    break;

    case R_IY:
    rv=IY;
    break;

    case R_SP:
    rv=SP;
    break;
   }
   rv+=is_flag(F_C);
   switch(index)
   {
    case 0:    /* HL */
    lv=(H<<8)+L;
    break;

    case 1:    /* IX */
    lv=IX;
    break;

    case 2:    /* IY */
    lv=IY;
    break;
   }

   c=((int)lv+rv)>65535;
   
   lv+=rv;
   switch(index)
   {
    case 0:    /* HL */
    L=lv&255;H=lv>>8;
    break;

    case 1:    /* IX */
    IX=lv;
    break;

    case 2:    /* IY */
    IY=lv;
    break;
   }

   set_flag(F_NN);
   set_flag(c?F_C:F_NC);
   break;
  }
 }
 
}


void 
f_sub (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar a=0;
 unsigned char h,v,c;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  if (t1==A_NUM)sprintf(t,"%u",a1);
  else reg_str(t,a1,t1);
  sprintf(txt,"sub %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   a=*reg_ptr(a1);
   break;

   case A_PODLE_REG:  /* sub (HL) */
   a=memory[(H<<8)+L];
   break;

   case A_NUM:
   a=a1;
   break;
   
   case A_PODLE_IY_PLUS:
   a=memory[(_ushort)(IY+a1)];
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory[(_ushort)(IX+a1)];
   break;
  }
  v=((int)A-a)<-128;
  c=((int)A-a)<0;
  h=((int)(A&15)-(a&15))<0;
  
  A-=a;

  set_flag(v?F_PO:F_PE);
  set_flag(c?F_C:F_NC);
  set_flag(h?F_H:F_NH);
  set_flag(F_N);
  set_flag(A?F_NZ:F_Z);
  set_flag(A&128?F_M:F_P);
  break;
 }
}


void 
f_sbc (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16],tt[16];
 _uchar a=0;
 _ushort lv,rv=0;
 unsigned char h,v,c;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  if (t2==A_NUM)sprintf(tt,"%d",a2);
  else reg_str(tt,a2,t2);
  sprintf(txt,"sbc %s,%s",t,tt);
  print(txt);
  break;
  
  case M_EXEC:
  switch(a1)
  {
   case R_A:
   switch(t2)
   {
    case A_REG:
    switch(a2)
    {
     default:
     a=*reg_ptr(a2);
     break;
    }
    break;

    case A_PODLE_REG:  /* sbc A,(HL) */
    a=memory[(H<<8)+L];
    break;

    case A_NUM:
    a=a2;
    break;
    
    case A_PODLE_IY_PLUS:
    a=memory[(_ushort)(IY+a2)];
    break;
    
    case A_PODLE_IX_PLUS:
    a=memory[(_ushort)(IX+a2)];
    break;
   }
   a+=is_flag(F_C);
   v=((int)A-a)<-128;
   c=((int)A-a)<0;
   h=((int)(A&15)-(a&15))<0;
   
   A-=a;
   
   set_flag(v?F_PO:F_PE);
   set_flag(c?F_C:F_NC);
   set_flag(h?F_H:F_NH);
   set_flag(A?F_NZ:F_Z);
   set_flag(A&128?F_M:F_P);
   set_flag(F_N);
   break;

   case R_HL:
   switch(a2)
   {
    case R_BC:
    rv=(B<<8)+C;
    break;

    case R_DE:
    rv=(D<<8)+E;
    break;

    case R_HL:
    rv=(H<<8)+L;
    break;

    case R_SP:
    rv=SP;
    break;
   }
   rv+=is_flag(F_C);
   lv=(H<<8)+L;

   c=((int)lv-rv)<0;
   v=((int)lv-rv)<-32768;
   
   lv-=rv;
   L=lv&255;H=lv>>8;
   
   set_flag(F_N);
   set_flag(lv&32768?F_M:F_P);
   set_flag(v?F_PO:F_PE);
   set_flag(c?F_C:F_NC);
   set_flag(lv?F_NZ:F_Z);
   break;
  }
 }
}


void 
f_adc (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16],tt[16];
 _uchar a=0;
 _ushort lv,rv=0;
 unsigned char h,v,c;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  if (t2==A_NUM)sprintf(tt,"%d",a2);
  else reg_str(tt,a2,t2);
  sprintf(txt,"adc %s,%s",t,tt);
  print(txt);
  break;
  
  case M_EXEC:
  switch(a1)
  {
   case R_A:
   switch(t2)
   {
    case A_REG:
    switch(a2)
    {
     default:
     a=*reg_ptr(a2);
     break;
    }
    break;

    case A_PODLE_REG:  /* adc A,(HL) */
    a=memory[(H<<8)+L];
    break;

    case A_NUM:
    a=a2;
    break;
    
    case A_PODLE_IY_PLUS:
    a=memory[(_ushort)(IY+a2)];
    break;
    
    case A_PODLE_IX_PLUS:
    a=memory[(_ushort)(IX+a2)];
    break;
   }
   a+=is_flag(F_C);
   v=((int)A+a)>127;
   c=((int)A+a)>255;
   h=((int)(A&15)+(a&15))>15;
   
   A+=a;
   
   set_flag(v?F_PO:F_PE);
   set_flag(c?F_C:F_NC);
   set_flag(h?F_H:F_NH);
   set_flag(A?F_NZ:F_Z);
   set_flag(A&128?F_M:F_P);
   set_flag(F_NN);
   break;

   case R_HL:
   switch(a2)
   {
    case R_BC:
    rv=(B<<8)+C;
    break;

    case R_DE:
    rv=(D<<8)+E;
    break;

    case R_HL:
    rv=(H<<8)+L;
    break;

    case R_SP:
    rv=SP;
    break;
   }
   rv+=is_flag(F_C);
   lv=(H<<8)+L;

   c=((int)lv+rv)>65535;
   v=((int)lv+rv)>32767;
   
   lv+=rv;
   L=lv&255;H=lv>>8;
   
   set_flag(F_NN);
   set_flag(lv&32768?F_M:F_P);
   set_flag(v?F_PO:F_PE);
   set_flag(c?F_C:F_NC);
   set_flag(lv?F_NZ:F_Z);
   break;
  }
 }
}


void 
f_djnz (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];
 
 t2=t2;a2=a2;
 switch (mode)
 {
  case M_PRINT:
  sprintf(txt,"djnz %d",(signed char)a1);
  print(txt);
  break;

  case M_EXEC:
  B--;
  if (B)
   PC+=(signed char)a1;
  break;
 }
}


void 
f_jp (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];
 static char t[64];
 _ushort addr=0;
 
 switch (mode)
 {
  case M_PRINT:
  switch (t1)
  {
   case A_FLAG:
   flag_str(t,a1);
   sprintf(txt,"jp %s,%u",t,a2);
   break;
   
   case A_PODLE_REG:
   reg_str(t,a1,t1);
   sprintf(txt,"jp %s",t);
   break;

   default:
   sprintf(txt,"jp %d",a1);
   break;
  }
  print(txt);
  break;

  case M_EXEC:
  switch (t1)
  {
   case A_FLAG:
   if (!is_flag(a1))return;
   addr=a2;
   break;
   
   case A_PODLE_REG:
   switch(a1)
   {
    case R_IX:
    addr=IX;
    break;
    
    case R_IY:
    addr=IY;
    break;
    
    case R_HL:
    addr=(H<<8)+L;
    break;
    
   }
   break;

   default:
   addr=a1;
   break;
  }
  PC=addr;
  break;
 }
}


void 
f_jr (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];
 static char t[64];
 
 switch (mode)
 {
  case M_PRINT:
  if (t1==A_FLAG)
  {
   flag_str(t,a1);
   sprintf(txt,"jr %s,%d",t,(signed char)a2);
  }
  else
   sprintf(txt,"jr %d",(signed char)a1);
  print(txt);
  break;

  case M_EXEC:
  if (t1==A_FLAG&&!is_flag(a1))break;
  PC+=(t1==A_FLAG)?(signed char)a2:(signed char)a1;
  break;
 }
}


void 
f_daa (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 int a=0;
 
 switch(mode)
 {
  case M_PRINT:
  print("daa");
  break;

  case M_EXEC:
  if (is_flag(F_C))a+=60;
  if (is_flag(F_H))a+=6;
  if ((A&15)>9)a+=6;
  if ((A>>4)>9)a+=60;

  set_flag((int)A+a>255?F_C:F_NC);
  set_flag((int)(A&15)+(a&15)>15?F_H:F_NH);
  A+=a;

  set_flag(A?F_NZ:F_Z);
  set_flag(A&128?F_M:F_P);
  __parity(A);
  break;
 }
}


void 
f_cpl (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;t1=t1;a2=a2;t2=t2;

 switch (mode)
 {
  case M_PRINT:
  print("cpl");
  break;

  case M_EXEC:
  A^=255;
  set_flag(F_N);
  set_flag(F_H);
  break;
 }
}


void 
f_scf (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;t1=t1;a2=a2;t2=t2;

 switch (mode)
 {
  case M_PRINT:
  print("scf");
  break;

  case M_EXEC:
  set_flag(F_C);
  set_flag(F_NN);
  set_flag(F_NH);
  break;
 }
}


void 
f_ccf (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;t1=t1;a2=a2;t2=t2;

 switch (mode)
 {
  case M_PRINT:
  print("ccf");
  break;

  case M_EXEC:
  set_flag(is_flag(F_C)?F_NC:F_C);
  set_flag(F_NN);
  break;
 }
}


void 
f_halt (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;t1=t1;a2=a2;t2=t2;
 if (mode==M_PRINT)
 {
  print("halt");
 }
 else
  {
   switch(EI)
   {
    case 0:
    error(0,"","HALT with disabled interrupt!");
    run=0;
    break;
    
    case 1:
    warning("HALT.");
    break;
   }
  }
}


void 
f_and (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar a=0;
 unsigned char z,s;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  if (t1==A_NUM)sprintf(t,"%d",a1);
  else reg_str(t,a1,t1);
  sprintf(txt,"and %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=*reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* and (HL) */
   a=memory[(H<<8)+L];
   break;

   case A_NUM:
   a=a1;
   break;
   
   case A_PODLE_IY_PLUS:
   a=memory[(_ushort)(IY+a1)];
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory[(_ushort)(IX+a1)];
   break;
  }
  A&=a;
  z=!A;
  s=A&128;
  __parity(A);
  set_flag(F_NC);
  set_flag(F_NN);
  set_flag(F_NH);
  set_flag(z?F_Z:F_NZ);
  set_flag(s?F_M:F_P);
  break;
 }
}


void 
f_xor (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar a=0;
 unsigned char z,s;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  if (t1==A_NUM)sprintf(t,"%d",a1);
  else reg_str(t,a1,t1);
  sprintf(txt,"xor %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=*reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* xor (HL) */
   a=memory[(H<<8)+L];
   break;

   case A_NUM:
   a=a1;
   break;
   
   case A_PODLE_IY_PLUS:
   a=memory[(_ushort)(IY+a1)];
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory[(_ushort)(IX+a1)];
   break;
  }
  A^=a;
  z=!A;
  s=A&128;
  __parity(A);
  set_flag(F_NC);
  set_flag(F_NH);
  set_flag(F_NN);
  set_flag(z?F_Z:F_NZ);
  set_flag(s?F_M:F_P);
  break;
 }
}


void 
f_or (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar a=0;
 unsigned char z,s;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  if (t1==A_NUM)sprintf(t,"%d",a1);
  else reg_str(t,a1,t1);
  sprintf(txt,"or %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=*reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* or (HL) */
   a=memory[(H<<8)+L];
   break;

   case A_NUM:
   a=a1;
   break;
   
   case A_PODLE_IY_PLUS:
   a=memory[(_ushort)(IY+a1)];
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory[(_ushort)(IX+a1)];
   break;
  }
  A|=a;
  z=!A;
  s=A&128;
  __parity(A);
  set_flag(F_NC);
  set_flag(F_NH);
  set_flag(F_NN);
  set_flag(z?F_Z:F_NZ);
  set_flag(s?F_M:F_P);
  break;
 }
}


void 
f_cp (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar a=0;
 unsigned char z,s,h,v,c;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  if (t1==A_NUM)sprintf(t,"%d",a1);
  else reg_str(t,a1,t1);
  sprintf(txt,"cp %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=*reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* cp (HL) */
   a=memory[(H<<8)+L];
   break;

   case A_NUM:
   a=a1;
   break;
   
   case A_PODLE_IY_PLUS:
   a=memory[(_ushort)(IY+a1)];
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory[(_ushort)(IX+a1)];
   break;
  }
  v=((int)A-a)<-128;
  c=((int)A-a)<0;
  h=((int)(A>>4)-(a>>4))<0;
  z=!(A-a);
  s=(A-a)&128;
  set_flag(v?F_PO:F_PE);
  set_flag(F_N);
  set_flag(c?F_C:F_NC);
  set_flag(z?F_Z:F_NZ);
  set_flag(s?F_M:F_P);
  set_flag(h?F_H:F_NH);
  break;
 }
}


void 
f_pop (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];
 static char t[64];
 _uchar l,h;
 
 a2=a2;t2=t2;
 switch (mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"pop %s",t);
  print(txt);
  break;

  case M_EXEC:
  l=memory[SP];h=memory[(_ushort)(SP+1)];
  SP+=2;
  switch (a1)
  {
   case R_AF:
   A=h;F=l;
   break;
   
   case R_BC:
   B=h;C=l;
   break;
   
   case R_DE:
   D=h;E=l;
   break;
   
   case R_HL:
   H=h;L=l;
   break;
   
   case R_IX:
   IX=((_ushort)h<<8)+l;
   break;

   case R_IY:
   IY=((_ushort)h<<8)+l;
   break;
  }
 }
}


void 
f_push (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[256];
 static char t[64];
 _uchar l=0,h=0;
 
 a2=a2;t2=t2;
 switch (mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"push %s",t);
  print(txt);
  break;

  case M_EXEC:
  switch (a1)
  {
   case R_AF:
   h=A;l=F;
   break;
   
   case R_BC:
   h=B;l=C;
   break;
   
   case R_DE:
   h=D;l=E;
   break;
   
   case R_HL:
   h=H;l=L;
   break;
   
   case R_IX:
   h=(IX>>8)&255;l=IX&255;
   break;

   case R_IY:
   h=(IY>>8)&255;l=IY&255;
   break;
  }
  SP-=2;
  memory[SP]=l;memory[(_ushort)(SP+1)]=h;
 }
}


void 
f_rst (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 char txt[64];
 a2=a2;t2=t2;t1=t1;

 switch (mode)
 {
  case M_PRINT:
  sprintf(txt,"rst 0x%x",a1);
  print(txt);
  break;

  case M_EXEC:
  SP-=2;
  memory[SP]=PC&255;
  memory[(_ushort)(SP+1)]=PC>>8;
  PC=a1;
  break;
 }
}


void 
f_out (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char tf[16];
 static char ts[16];
 
 if (mode==M_PRINT)
 {
  if (t1==A_PODLE_NUM)sprintf(tf,"%d",a1);
  else sprintf(tf,"c");
  reg_str(ts,a2,t2);
  sprintf(txt,"out (%s),%s",tf,ts);
  print(txt);
 }
}


void 
f_in (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char tf[16];
 static char ts[16];
 
 if (mode==M_PRINT)
 {
  if (t2==A_PODLE_NUM)sprintf(ts,"%d",a2);
  else sprintf(ts,"c");
  reg_str(tf,a1,t1);
  sprintf(txt,"in %s,(%s)",tf,ts);
  print(txt);
 }
 else
  if (t2==A_PODLE_REG)set_flag(F_NN);  /* we don't set the rest of flags, because we don't have a value to be inned */
}


void 
f_exx (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 int a;
 
 a1=a1;t1=t1;a2=a2;t2=t2;
 switch (mode)
 {
  case M_PRINT:
  print("exx");
  break;

  case M_EXEC:
  a=B;B=B_;B_=a;
  a=C;C=C_;C_=a;
  a=D;D=D_;D_=a;
  a=E;E=E_;E_=a;
  a=H;H=H_;H_=a;
  a=L;L=L_;L_=a;
  break;
 }
}


void 
f_di (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 if (mode==M_PRINT)
  print("di");
 else EI=0;
}


void 
f_ei (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 if (mode==M_PRINT)
  print("ei");
 else EI=1;
}


void 
f_rrc (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar *a=0;
 _uchar b;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"rrc %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* rrc (HL) */
   a=memory+(H<<8)+L;
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a1);
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a1);
   break;
  }
  b=(*a)&1;
  set_flag(b?F_C:F_NC);
  (*a)>>=1;
  *a|=b<<7;
  set_flag(F_NN);
  set_flag(F_NH);
  set_flag((*a)?F_NZ:F_Z);
  set_flag(((*a)&128)?F_M:F_P);
  __parity(*a);
  break;
 }
}


void 
f_rlc (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar *a=0;
 _uchar b;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"rlc %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* rlc (HL) */
   a=memory+(H<<8)+L;
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a1);
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a1);
   break;
  }
  b=(*a)&128;
  set_flag(b?F_C:F_NC);
  (*a)<<=1;
  *a|=b>>7;
  set_flag(F_NN);
  set_flag(F_NH);
  set_flag((*a)?F_NZ:F_Z);
  set_flag(((*a)&128)?F_M:F_P);
  __parity(*a);
  break;
 }
}


void 
f_ex (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[32];
 static char r1[8],r2[8];
 _uchar x,y;
 
 switch(mode)
 {
  case M_PRINT:
  reg_str(r1,a1,t1);
  reg_str(r2,a2,t2);
  sprintf(txt,"ex %s,%s",r1,r2);
  print(txt);
  break;

  case M_EXEC:
  switch(a1)
  {
   case R_AF:       /* ex af,af' */
   x=A;A=A_;A_=x;
   x=F;F=F_;F_=x;
   break;

   case R_DE:        /* ex de,hl */
   x=D;D=H;H=x;
   x=E;E=L;L=x;
   break;

   case R_SP:         /* ex (sp),rr */
   switch(a2)
   {
    case R_HL:
    x=memory[SP];memory[SP]=L;L=x;
    x=memory[(_ushort)(SP+1)];memory[(_ushort)(SP+1)]=H;H=x;
    break;

    case R_IX:
    x=memory[SP];y=memory[(_ushort)(SP+1)];
    memory[SP]=IX&255;memory[(_ushort)(SP+1)]=IX>>8;
    IX=x+(y<<8);

    case R_IY:
    x=memory[SP];y=memory[(_ushort)(SP+1)];
    memory[SP]=IY&255;memory[(_ushort)(SP+1)]=IY>>8;
    IY=x+(y<<8);
   }
   break;
  }
  break;
 }
}


void 
f_rr (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar *a=0;
 _uchar b;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"rr %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* rr (HL) */
   a=memory+(H<<8)+L;
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a1);
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a1);
   break;
  }
  b=is_flag(F_C);
  set_flag(((*a)&1)?F_C:F_NC);
  (*a)>>=1;
  *a|=b<<7;
  set_flag(F_NN);
  set_flag(F_NH);
  set_flag((*a)?F_NZ:F_Z);
  set_flag(((*a)&128)?F_M:F_P);
  __parity(*a);
  break;
 }
}


void 
f_rl (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar *a=0;
 _uchar b;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"rl %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* rl (HL) */
   a=memory+(H<<8)+L;
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a1);
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a1);
   break;
  }
  b=is_flag(F_C);
  set_flag(((*a)&128)?F_C:F_NC);
  (*a)<<=1;
  *a|=b;
  set_flag(F_NN);
  set_flag(F_NH);
  set_flag((*a)?F_NZ:F_Z);
  set_flag(((*a)&128)?F_M:F_P);
  __parity(*a);
  break;
 }
}


void 
f_sla (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar *a=0;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"sla %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* sla (HL) */
   a=memory+(H<<8)+L;
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a1);
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a1);
   break;
  }
  set_flag(((*a)&128)?F_C:F_NC);
  (*a)<<=1;
  set_flag(F_NN);
  set_flag(F_NH);
  set_flag((*a)?F_NZ:F_Z);
  set_flag(((*a)&128)?F_M:F_P);
  __parity(*a);
  break;
 }
}


void 
f_srl (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar *a=0;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"srl %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* srl (HL) */
   a=memory+(H<<8)+L;
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a1);
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a1);
   break;
  }
  set_flag(((*a)&1)?F_C:F_NC);
  (*a)>>=1;
  set_flag(F_NN);
  set_flag(F_NH);
  set_flag((*a)?F_NZ:F_Z);
  set_flag(F_P);   /* highest bit is always 0 */
  __parity(*a);
  break;
 }
}


void 
f_neg (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 unsigned char h;
 a1=a1;t1=t1;a2=a2;t2=t2;

 switch (mode)
 {
  case M_PRINT:
  print("neg");
  break;

  case M_EXEC:
  h=A&15;
  A--;
  A^=255;
  set_flag(h?F_H:F_N);
  set_flag(F_N);
  set_flag(A?F_NZ:F_Z);
  set_flag((A&128)?F_M:F_P);
  break;
 }
}


void 
f_reti (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a2=a2;t2=t2;t1=t1;
 switch (mode)
 {
  case M_PRINT:
  print("reti");
  break;

  case M_EXEC:
  PC=memory[SP]+(memory[(_ushort)(SP+1)]<<8);
  SP+=2;
  break;
 }
}


void 
f_retn (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a2=a2;t2=t2;t1=t1;
 switch (mode)
 {
  case M_PRINT:
  print("retn");
  break;

  case M_EXEC:
  PC=memory[SP]+(memory[(_ushort)(SP+1)]<<8);
  SP+=2;
  break;
 }
}


void 
f_sra (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 static char txt[64];
 static char t[16];
 _uchar *a=0;
 _uchar b;
 
 a2=a2;t2=t2;
 switch(mode)
 {
  case M_PRINT:
  reg_str(t,a1,t1);
  sprintf(txt,"sra %s",t);
  print(txt);
  break;
  
  case M_EXEC:
  switch(t1)
  {
   case A_REG:
   switch(a1)
   {
    default:
    a=reg_ptr(a1);
    break;
   }
   break;

   case A_PODLE_REG:  /* sra (HL) */
   a=memory+(H<<8)+L;
   break;

   case A_PODLE_IY_PLUS:
   a=memory+(_ushort)(IY+a1);
   break;
   
   case A_PODLE_IX_PLUS:
   a=memory+(_ushort)(IX+a1);
   break;
  }
  set_flag(((*a)&1)?F_C:F_NC);
  b=(*a)&128;
  (*a)>>=1;
  (*a)|=b;
  set_flag(F_NN);
  set_flag(F_NH);
  set_flag((*a)?F_NZ:F_Z);
  set_flag(b?F_M:F_P);
  __parity(*a);
  break;
 }
}


void 
f_im (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 char txt[16];
 t1=t1;a2=a2;t2=t2;

 switch (mode)
 {
  case M_PRINT:
  sprintf(txt,"im %d",a1);
  print(txt);
  break;

  case M_EXEC:
  IM=a1;
  break;
 }
}


void 
f_rrd (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 _uchar a;
 const _ushort hl=L+(H<<8);
 a1=a1;t1=t1;a2=a2;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("rrd");
  break;

  case M_EXEC:
  a=A;
  A&=240;
  A+=memory[hl]&240;
  memory[hl]>>=4;
  memory[hl]+=(a&15)<<4;
  set_flag(F_NH);
  set_flag(F_NN);
  set_flag(A?F_NZ:F_Z);
  set_flag((A&128)?F_M:F_P);
  __parity(A);
  break;
 }
}


void 
f_rld (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 _uchar a;
 const _ushort hl=L+(H<<8);
 a1=a1;t1=t1;a2=a2;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("rld");
  break;

  case M_EXEC:
  a=A;
  A&=240;
  A+=(memory[hl]&240)>>4;
  memory[hl]<<=4;
  memory[hl]+=a&15;
  set_flag(F_NH);
  set_flag(F_NN);
  set_flag(A?F_NZ:F_Z);
  set_flag((A&128)?F_M:F_P);
  __parity(A);
  break;
 }
}


void 
f_ldd (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("ldd");
  break;

  case M_EXEC:
  memory[(D<<8)+E]=memory[(H<<8)+L];
  H=L?H:H-1;L--;
  D=E?D:D-1;E--;
  B=C?B:B-1;C--;
  set_flag(F_NN);
  set_flag(F_NH);
  set_flag((B|C)?F_PE:F_PO);
  break;
 }
}


void 
f_lddr (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("lddr");
  break;

  case M_EXEC:
  memory[(D<<8)+E]=memory[(H<<8)+L];
  H=L?H:H-1;L--;
  D=E?D:D-1;E--;
  B=C?B:B-1;C--;
  set_flag(F_NN);
  set_flag(F_NH);
  if(!(B|C))set_flag(F_PO);
  else {set_flag(F_PE);PC-=2;}
  break;
 }
}


void 
f_ldi (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("ldi");
  break;

  case M_EXEC:
  memory[(D<<8)+E]=memory[(H<<8)+L];
  L++;H=L?H:H+1;
  E++;D=E?D:D+1;
  B=C?B:B-1;C--;
  set_flag(F_NN);
  set_flag(F_NH);
  set_flag((B|C)?F_PE:F_PO);
  break;
 }
}


void 
f_ldir (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("ldir");
  break;

  case M_EXEC:
  memory[(D<<8)+E]=memory[(H<<8)+L];
  L++;H=L?H:H+1;
  E++;D=E?D:D+1;
  B=C?B:B-1;C--;
  set_flag(F_NN);
  set_flag(F_NH);
  if(!(B|C))
   set_flag(F_PO);
  else
   {set_flag(F_PE);PC-=2;}
  break;
 }
}


void 
f_cpd (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 _uchar a;
 unsigned char z,s,h;
 
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("cpd");
  break;

  case M_EXEC:
  a=memory[(H<<8)+L];
  H=L?H:H-1;L--;
  B=C?B:B-1;C--;

  h=((int)(A>>4)-(a>>4))<0;
  z=!(A-a);
  s=(A-a)&128;
  
  set_flag(z?F_Z:F_NZ);
  set_flag(s?F_M:F_P);
  set_flag(h?F_H:F_NH);
  set_flag(F_N);
  set_flag((B|C)?F_PE:F_PO);
  break;
 }
}


void 
f_cpdr (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 _uchar a;
 unsigned char z,s,h;
 
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("cpdr");
  break;

  case M_EXEC:
  a=memory[(H<<8)+L];
  H=L?H:H-1;L--;
  B=C?B:B-1;C--;

  h=((int)(A>>4)-(a>>4))<0;
  z=!(A-a);
  s=(A-a)&128;
  
  set_flag(z?F_Z:F_NZ);
  set_flag(s?F_M:F_P);
  set_flag(h?F_H:F_NH);
  set_flag(F_N);
  set_flag((B|C)?F_PE:F_PO);
  if ((B|C)&&!z)PC-=2;
  break;
 }
}


void 
f_cpi (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 _uchar a;
 unsigned char z,s,h;
 
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("cpi");
  break;

  case M_EXEC:
  a=memory[(H<<8)+L];
  L++;H=L?H:H+1;
  B=C?B:B-1;C--;

  h=((int)(A>>4)-(a>>4))<0;
  z=!(A-a);
  s=(A-a)&128;
  
  set_flag(z?F_Z:F_NZ);
  set_flag(s?F_M:F_P);
  set_flag(h?F_H:F_NH);
  set_flag(F_N);
  set_flag((B|C)?F_PE:F_PO);
  break;
 }
}


void 
f_cpir (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 _uchar a;
 unsigned char z,s,h;
 
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("cpir");
  break;

  case M_EXEC:
  a=memory[(H<<8)+L];
  L++;H=L?H:H+1;
  B=C?B:B-1;C--;

  h=((int)(A>>4)-(a>>4))<0;
  z=!(A-a);
  s=(A-a)&128;
  
  set_flag(z?F_Z:F_NZ);
  set_flag(s?F_M:F_P);
  set_flag(h?F_H:F_NH);
  set_flag(F_N);
  set_flag((B|C)?F_PE:F_PO);
  if ((B|C)&&!z)PC-=2;
  break;
 }
}


void 
f_ind (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("ind");
  break;

  case M_EXEC:
  memory[(H<<8)+L]=0;
  H=L?H:H-1;L--;
  B--;
  set_flag(F_N);
  if (!B)set_flag(F_Z);
  break;
 }
}


void 
f_indr (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("indr");
  break;

  case M_EXEC:
  memory[(H<<8)+L]=0;
  H=L?H:H-1;L--;
  B--;
  set_flag(F_N);
  if(!B)
   set_flag(F_Z);
  else
   PC-=2;
  break;
 }
}


void 
f_ini (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("ini");
  break;

  case M_EXEC:
  memory[(H<<8)+L]=0;
  L++;H=L?H:H+1;
  B--;
  set_flag(F_N);
  if (!B)set_flag(F_Z);
  break;
 }
}


void 
f_inir (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("inir");
  break;

  case M_EXEC:
  memory[(H<<8)+L]=0;
  L++;H=L?H:H+1;
  B--;
  set_flag(F_N);
  if(!B)
   set_flag(F_Z);
  else
   PC-=2;
  break;
 }
}


void 
f_outd (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("outd");
  break;

  case M_EXEC:
  H=L?H:H-1;L--;
  B--;
  set_flag(F_N);
  if (!B)set_flag(F_Z);
  break;
 }
}


void 
f_otdr (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("otdr");
  break;

  case M_EXEC:
  H=L?H:H-1;L--;
  B--;
  set_flag(F_N);
  if(!B)
   set_flag(F_Z);
  else
   PC-=2;
  break;
 }
}


void 
f_outi (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("outi");
  break;

  case M_EXEC:
  L++;H=L?H:H+1;
  B--;
  set_flag(F_N);
  if (!B)set_flag(F_Z);
  break;
 }
}


void 
f_otir (_ushort a1,_uchar t1,_ushort a2,_uchar t2)
{
 a1=a1;a2=a2;t1=t1;t2=t2;

 switch(mode)
 {
  case M_PRINT:
  print("otir");
  break;

  case M_EXEC:
  L++;H=L?H:H+1;
  B--;
  set_flag(F_N);
  if(!B)
   set_flag(F_Z);
  else
   PC-=2;
  break;
 }
}


