/* Routines for manipulating with Z80 ASM files */

#include <stdio.h>


unsigned char header[9]="Z80ASM\032\n";
#define HEADER_LEN 8


void write_header(FILE *stream,int address)
{
 unsigned char c,d;
 c=address&255;
 d=address>>8;
 fwrite(header,1,HEADER_LEN,stream);
 fwrite(&c,1,1,stream);
 fwrite(&d,1,1,stream);
}


/* reads header of a file and tests if it's Z80 ASM file, reads address */
/* return value: 0=OK, 1=this is not a z80 asm file */
int read_header(FILE *stream,int *address, int *len)
{
 unsigned char tmp[9];
 unsigned char c,d;
 int a,b;

 tmp[8]=0;
 if ((fread(tmp,1,8,stream))!=8)return 1;
 if (strcmp(tmp,header))return 1;
 if (!fread(&c,1,1,stream))return 1;
 if (!fread(&d,1,1,stream))return 1;
 *address=c+(d<<8);

 a=ftell(stream);
 fseek(stream,0,SEEK_END);
 b=ftell(stream);
 fseek(stream,a,SEEK_SET);
 *len=b-a;
 return 0;
}
