/* HASHING TABLE */

#ifndef __HASH_H
#define __HASH_H

#define TABLE_SIZE 32768    /* size of hashing table (must be power of 2) */
#define MAGICKA_KONSTANTA  13  /* proof MJ's magic constant */

struct table_type{                    /* HASHING TABLE */
unsigned char count;
int* address;                         /* label address in Z80 memory */
char **pointer;              /* pointer to a label string */
};

extern struct table_type table[TABLE_SIZE];


/* hashing function */

unsigned int hash(char *slovo);


/* adds item to hash table */

int add_to_table(char *txt,int address);


/* tests if label is in table */
/* returns address of label if true, otherwise -1 */

int is_in_table(char *txt);


/* initializes hash table */

void hash_table_init(void);


/* removes hash table from memory */

void free_hash_table(void);


#endif
