/* INSTRUCTION TABLES FOR DISASSEMBLING */

#include "disasm.h"
#include "regs.h"
#include "z80-asm.h"


/* non prefixed instructions */
struct instruction_type instr_normal[256]={
/*0x00*/ {f_nop,0,0,0,0},
/*0x01*/ {f_ld,R_BC,A_REG,2,A_NUM},
/*0x02*/ {f_ld,R_BC,A_PODLE_REG,R_A,A_REG},
/*0x03*/ {f_inc,R_BC,A_REG,0,0},
/*0x04*/ {f_inc,R_B,A_REG,0,0},
/*0x05*/ {f_dec,R_B,A_REG,0,0},
/*0x06*/ {f_ld,R_B,A_REG,1,A_NUM},
/*0x07*/ {f_rlca,0,0,0,0},
/*0x08*/ {f_ex,R_AF,A_REG,R_AF_,A_REG},
/*0x09*/ {f_add,R_HL,A_REG,R_BC,A_REG},
/*0x0a*/ {f_ld,R_A,A_REG,R_BC,A_PODLE_REG},
/*0x0b*/ {f_dec,R_BC,A_REG,0,0},
/*0x0c*/ {f_inc,R_C,A_REG,0,0},
/*0x0d*/ {f_dec,R_C,A_REG,0,0},
/*0x0e*/ {f_ld,R_C,A_REG,1,A_NUM},
/*0x0f*/ {f_rrca,0,0,0,0},
/*0x10*/ {f_djnz,1,A_NUM,0,0},
/*0x11*/ {f_ld,R_DE,A_REG,2,A_NUM},
/*0x12*/ {f_ld,R_DE,A_PODLE_REG,R_A,A_REG},
/*0x13*/ {f_inc,R_DE,A_REG,0,0},
/*0x14*/ {f_inc,R_D,A_REG,0,0},
/*0x15*/ {f_dec,R_D,A_REG,0,0},
/*0x16*/ {f_ld,R_D,A_REG,1,A_NUM},
/*0x17*/ {f_rla,0,0,0,0},
/*0x18*/ {f_jr,1,A_NUM,0,0},
/*0x19*/ {f_add,R_HL,A_REG,R_DE,A_REG},
/*0x1a*/ {f_ld,R_A,A_REG,R_DE,A_PODLE_REG},
/*0x1b*/ {f_dec,R_DE,A_REG,0,0},
/*0x1c*/ {f_inc,R_E,A_REG,0,0},
/*0x1d*/ {f_dec,R_E,A_REG,0,0},
/*0x1e*/ {f_ld,R_E,A_REG,1,A_NUM},
/*0x1f*/ {f_rra,0,0,0,0},
/*0x20*/ {f_jr,F_NZ,A_FLAG,1,A_NUM},
/*0x21*/ {f_ld,R_HL,A_REG,2,A_NUM},
/*0x22*/ {f_ld,2,A_PODLE_NUM,R_HL,A_REG},
/*0x23*/ {f_inc,R_HL,A_REG,0,0},
/*0x24*/ {f_inc,R_H,A_REG,0,0},
/*0x25*/ {f_dec,R_H,A_REG,0,0},
/*0x26*/ {f_ld,R_H,A_REG,1,A_NUM},
/*0x27*/ {f_daa,0,0,0,0},
/*0x28*/ {f_jr,F_Z,A_FLAG,1,A_NUM},
/*0x29*/ {f_add,R_HL,A_REG,R_HL,A_REG},
/*0x2a*/ {f_ld,R_HL,A_REG,2,A_PODLE_NUM},
/*0x2b*/ {f_dec,R_HL,A_REG,0,0},
/*0x2c*/ {f_inc,R_L,A_REG,0,0},
/*0x2d*/ {f_dec,R_L,A_REG,0,0},
/*0x2e*/ {f_ld,R_L,A_REG,1,A_NUM},
/*0x2f*/ {f_cpl,0,0,0,0},
/*0x30*/ {f_jr,F_NC,A_FLAG,1,A_NUM},
/*0x31*/ {f_ld,R_SP,A_REG,2,A_NUM},
/*0x32*/ {f_ld,2,A_PODLE_NUM,R_A,A_REG},
/*0x33*/ {f_inc,R_SP,A_REG,0,0},
/*0x34*/ {f_inc,R_HL,A_PODLE_REG,0,0},
/*0x35*/ {f_dec,R_HL,A_PODLE_REG,0,0},
/*0x36*/ {f_ld,R_HL,A_PODLE_REG,1,A_NUM},
/*0x37*/ {f_scf,0,0,0,0},
/*0x38*/ {f_jr,F_C,A_FLAG,1,A_NUM},
/*0x39*/ {f_add,R_HL,A_REG,R_SP,A_REG},
/*0x3a*/ {f_ld,R_A,A_REG,2,A_PODLE_NUM},
/*0x3b*/ {f_dec,R_SP,A_REG,0,0},
/*0x3c*/ {f_inc,R_A,A_REG,0,0},
/*0x3d*/ {f_dec,R_A,A_REG,0,0},
/*0x3e*/ {f_ld,R_A,A_REG,1,A_NUM},
/*0x3f*/ {f_ccf,0,0,0,0},
/*0x40*/ {f_ld,R_B,A_REG,R_B,A_REG},
/*0x41*/ {f_ld,R_B,A_REG,R_C,A_REG},
/*0x42*/ {f_ld,R_B,A_REG,R_D,A_REG},
/*0x43*/ {f_ld,R_B,A_REG,R_E,A_REG},
/*0x44*/ {f_ld,R_B,A_REG,R_H,A_REG},
/*0x45*/ {f_ld,R_B,A_REG,R_L,A_REG},
/*0x46*/ {f_ld,R_B,A_REG,R_HL,A_PODLE_REG},
/*0x47*/ {f_ld,R_B,A_REG,R_A,A_REG},
/*0x48*/ {f_ld,R_C,A_REG,R_B,A_REG},
/*0x49*/ {f_ld,R_C,A_REG,R_C,A_REG},
/*0x4a*/ {f_ld,R_C,A_REG,R_D,A_REG},
/*0x4b*/ {f_ld,R_C,A_REG,R_E,A_REG},
/*0x4c*/ {f_ld,R_C,A_REG,R_H,A_REG},
/*0x4d*/ {f_ld,R_C,A_REG,R_L,A_REG},
/*0x4e*/ {f_ld,R_C,A_REG,R_HL,A_PODLE_REG},
/*0x4f*/ {f_ld,R_C,A_REG,R_A,A_REG},
/*0x50*/ {f_ld,R_D,A_REG,R_B,A_REG},
/*0x51*/ {f_ld,R_D,A_REG,R_C,A_REG},
/*0x52*/ {f_ld,R_D,A_REG,R_D,A_REG},
/*0x53*/ {f_ld,R_D,A_REG,R_E,A_REG},
/*0x54*/ {f_ld,R_D,A_REG,R_H,A_REG},
/*0x55*/ {f_ld,R_D,A_REG,R_L,A_REG},
/*0x56*/ {f_ld,R_D,A_REG,R_HL,A_PODLE_REG},
/*0x57*/ {f_ld,R_D,A_REG,R_A,A_REG},
/*0x58*/ {f_ld,R_E,A_REG,R_B,A_REG},
/*0x59*/ {f_ld,R_E,A_REG,R_C,A_REG},
/*0x5a*/ {f_ld,R_E,A_REG,R_D,A_REG},
/*0x5b*/ {f_ld,R_E,A_REG,R_E,A_REG},
/*0x5c*/ {f_ld,R_E,A_REG,R_H,A_REG},
/*0x5d*/ {f_ld,R_E,A_REG,R_L,A_REG},
/*0x5e*/ {f_ld,R_E,A_REG,R_HL,A_PODLE_REG},
/*0x5f*/ {f_ld,R_E,A_REG,R_A,A_REG},
/*0x60*/ {f_ld,R_H,A_REG,R_B,A_REG},
/*0x61*/ {f_ld,R_H,A_REG,R_C,A_REG},
/*0x62*/ {f_ld,R_H,A_REG,R_D,A_REG},
/*0x63*/ {f_ld,R_H,A_REG,R_E,A_REG},
/*0x64*/ {f_ld,R_H,A_REG,R_H,A_REG},
/*0x65*/ {f_ld,R_H,A_REG,R_L,A_REG},
/*0x66*/ {f_ld,R_H,A_REG,R_HL,A_PODLE_REG},
/*0x67*/ {f_ld,R_H,A_REG,R_A,A_REG},
/*0x68*/ {f_ld,R_L,A_REG,R_B,A_REG},
/*0x69*/ {f_ld,R_L,A_REG,R_C,A_REG},
/*0x6a*/ {f_ld,R_L,A_REG,R_D,A_REG},
/*0x6b*/ {f_ld,R_L,A_REG,R_E,A_REG},
/*0x6c*/ {f_ld,R_L,A_REG,R_H,A_REG},
/*0x6d*/ {f_ld,R_L,A_REG,R_L,A_REG},
/*0x6e*/ {f_ld,R_L,A_REG,R_HL,A_PODLE_REG},
/*0x6f*/ {f_ld,R_L,A_REG,R_A,A_REG},
/*0x70*/ {f_ld,R_HL,A_PODLE_REG,R_B,A_REG},
/*0x71*/ {f_ld,R_HL,A_PODLE_REG,R_C,A_REG},
/*0x72*/ {f_ld,R_HL,A_PODLE_REG,R_D,A_REG},
/*0x73*/ {f_ld,R_HL,A_PODLE_REG,R_E,A_REG},
/*0x74*/ {f_ld,R_HL,A_PODLE_REG,R_H,A_REG},
/*0x75*/ {f_ld,R_HL,A_PODLE_REG,R_L,A_REG},
/*0x76*/ {f_halt,0,0,0,0},
/*0x77*/ {f_ld,R_HL,A_PODLE_REG,R_A,A_REG},
/*0x78*/ {f_ld,R_A,A_REG,R_B,A_REG},
/*0x79*/ {f_ld,R_A,A_REG,R_C,A_REG},
/*0x7a*/ {f_ld,R_A,A_REG,R_D,A_REG},
/*0x7b*/ {f_ld,R_A,A_REG,R_E,A_REG},
/*0x7c*/ {f_ld,R_A,A_REG,R_H,A_REG},
/*0x7d*/ {f_ld,R_A,A_REG,R_L,A_REG},
/*0x7e*/ {f_ld,R_A,A_REG,R_HL,A_PODLE_REG},
/*0x7f*/ {f_ld,R_A,A_REG,R_A,A_REG},
/*0x80*/ {f_add,R_A,A_REG,R_B,A_REG},
/*0x81*/ {f_add,R_A,A_REG,R_C,A_REG},
/*0x82*/ {f_add,R_A,A_REG,R_D,A_REG},
/*0x83*/ {f_add,R_A,A_REG,R_E,A_REG},
/*0x84*/ {f_add,R_A,A_REG,R_H,A_REG},
/*0x85*/ {f_add,R_A,A_REG,R_L,A_REG},
/*0x86*/ {f_add,R_A,A_REG,R_HL,A_PODLE_REG},
/*0x87*/ {f_add,R_A,A_REG,R_A,A_REG},
/*0x88*/ {f_adc,R_A,A_REG,R_B,A_REG},
/*0x89*/ {f_adc,R_A,A_REG,R_C,A_REG},
/*0x8a*/ {f_adc,R_A,A_REG,R_D,A_REG},
/*0x8b*/ {f_adc,R_A,A_REG,R_E,A_REG},
/*0x8c*/ {f_adc,R_A,A_REG,R_H,A_REG},
/*0x8d*/ {f_adc,R_A,A_REG,R_L,A_REG},
/*0x8e*/ {f_adc,R_A,A_REG,R_HL,A_PODLE_REG},
/*0x8f*/ {f_adc,R_A,A_REG,R_A,A_REG},
/*0x90*/ {f_sub,R_B,A_REG,0,0},
/*0x91*/ {f_sub,R_C,A_REG,0,0},
/*0x92*/ {f_sub,R_D,A_REG,0,0},
/*0x93*/ {f_sub,R_E,A_REG,0,0},
/*0x94*/ {f_sub,R_H,A_REG,0,0},
/*0x95*/ {f_sub,R_L,A_REG,0,0},
/*0x96*/ {f_sub,R_HL,A_PODLE_REG,0,0},
/*0x97*/ {f_sub,R_A,A_REG,0,0},
/*0x98*/ {f_sbc,R_A,A_REG,R_B,A_REG},
/*0x99*/ {f_sbc,R_A,A_REG,R_C,A_REG},
/*0x9a*/ {f_sbc,R_A,A_REG,R_D,A_REG},
/*0x9b*/ {f_sbc,R_A,A_REG,R_E,A_REG},
/*0x9c*/ {f_sbc,R_A,A_REG,R_H,A_REG},
/*0x9d*/ {f_sbc,R_A,A_REG,R_L,A_REG},
/*0x9e*/ {f_sbc,R_A,A_REG,R_HL,A_PODLE_REG},
/*0x9f*/ {f_sbc,R_A,A_REG,R_A,A_REG},
/*0xa0*/ {f_and,R_B,A_REG,0,0},
/*0xa1*/ {f_and,R_C,A_REG,0,0},
/*0xa2*/ {f_and,R_D,A_REG,0,0},
/*0xa3*/ {f_and,R_E,A_REG,0,0},
/*0xa4*/ {f_and,R_H,A_REG,0,0},
/*0xa5*/ {f_and,R_L,A_REG,0,0},
/*0xa6*/ {f_and,R_HL,A_PODLE_REG,0,0},
/*0xa7*/ {f_and,R_A,A_REG,0,0},
/*0xa8*/ {f_xor,R_B,A_REG,0,0},
/*0xa9*/ {f_xor,R_C,A_REG,0,0},
/*0xaa*/ {f_xor,R_D,A_REG,0,0},
/*0xab*/ {f_xor,R_E,A_REG,0,0},
/*0xac*/ {f_xor,R_H,A_REG,0,0},
/*0xad*/ {f_xor,R_L,A_REG,0,0},
/*0xae*/ {f_xor,R_HL,A_PODLE_REG,0,0},
/*0xaf*/ {f_xor,R_A,A_REG,0,0},
/*0xb0*/ {f_or,R_B,A_REG,0,0},
/*0xb1*/ {f_or,R_C,A_REG,0,0},
/*0xb2*/ {f_or,R_D,A_REG,0,0},
/*0xb3*/ {f_or,R_E,A_REG,0,0},
/*0xb4*/ {f_or,R_H,A_REG,0,0},
/*0xb5*/ {f_or,R_L,A_REG,0,0},
/*0xb6*/ {f_or,R_HL,A_PODLE_REG,0,0},
/*0xb7*/ {f_or,R_A,A_REG,0,0},
/*0xb8*/ {f_cp,R_B,A_REG,0,0},
/*0xb9*/ {f_cp,R_C,A_REG,0,0},
/*0xba*/ {f_cp,R_D,A_REG,0,0},
/*0xbb*/ {f_cp,R_E,A_REG,0,0},
/*0xbc*/ {f_cp,R_H,A_REG,0,0},
/*0xbd*/ {f_cp,R_L,A_REG,0,0},
/*0xbe*/ {f_cp,R_HL,A_PODLE_REG,0,0},
/*0xbf*/ {f_cp,R_A,A_REG,0,0},
/*0xc0*/ {f_ret,F_NZ,A_FLAG,0,0},
/*0xc1*/ {f_pop,R_BC,A_REG,0,0},
/*0xc2*/ {f_jp,F_NZ,A_FLAG,2,A_NUM},
/*0xc3*/ {f_jp,2,A_NUM,0,0},
/*0xc4*/ {f_call,F_NZ,A_FLAG,2,A_NUM},
/*0xc5*/ {f_push,R_BC,A_REG,0,0},
/*0xc6*/ {f_add,R_A,A_REG,1,A_NUM},
/*0xc7*/ {f_rst,0x0,A_CONST,0,0},
/*0xc8*/ {f_ret,F_Z,A_FLAG,0,0},
/*0xc9*/ {f_ret,0,0,0,0},
/*0xca*/ {f_jp,F_Z,A_FLAG,2,A_NUM},
/*0xcb*/ {0,0,0,0,0},
/*0xcc*/ {f_call,F_Z,A_FLAG,2,A_NUM},
/*0xcd*/ {f_call,2,A_NUM,0,0},
/*0xce*/ {f_adc,R_A,A_REG,1,A_NUM},
/*0xcf*/ {f_rst,0x8,A_CONST,0,0},
/*0xd0*/ {f_ret,F_NC,A_FLAG,0,0},
/*0xd1*/ {f_pop,R_DE,A_REG,0,0},
/*0xd2*/ {f_jp,F_NC,A_FLAG,2,A_NUM},
/*0xd3*/ {f_out,1,A_PODLE_NUM,R_A,A_REG},
/*0xd4*/ {f_call,F_NC,A_FLAG,2,A_NUM},
/*0xd5*/ {f_push,R_DE,A_REG,0,0},
/*0xd6*/ {f_sub,1,A_NUM,0,0},
/*0xd7*/ {f_rst,0x10,A_CONST,0,0},
/*0xd8*/ {f_ret,F_C,A_FLAG,0,0},
/*0xd9*/ {f_exx,0,0,0,0},
/*0xda*/ {f_jp,F_C,A_FLAG,2,A_NUM},
/*0xdb*/ {f_in,R_A,A_REG,1,A_PODLE_NUM},
/*0xdc*/ {f_call,F_C,A_FLAG,2,A_NUM},
/*0xdd*/ {0,0,0,0,0},
/*0xde*/ {f_sbc,R_A,A_REG,1,A_NUM},
/*0xdf*/ {f_rst,0x18,A_CONST,0,0},
/*0xe0*/ {f_ret,F_PO,A_FLAG,0,0},
/*0xe1*/ {f_pop,R_HL,A_REG,0,0},
/*0xe2*/ {f_jp,F_PO,A_FLAG,2,A_NUM},
/*0xe3*/ {f_ex,R_SP,A_PODLE_REG,R_HL,A_REG},
/*0xe4*/ {f_call,F_PO,A_FLAG,2,A_NUM},
/*0xe5*/ {f_push,R_HL,A_REG,0,0},
/*0xe6*/ {f_and,1,A_NUM,0,0},
/*0xe7*/ {f_rst,0x20,A_CONST,0,0},
/*0xe8*/ {f_ret,F_PE,A_FLAG,0,0},
/*0xe9*/ {f_jp,R_HL,A_PODLE_REG,0,0},
/*0xea*/ {f_jp,F_PE,A_FLAG,2,A_NUM},
/*0xeb*/ {f_ex,R_DE,A_REG,R_HL,A_REG},
/*0xec*/ {f_call,F_PE,A_FLAG,2,A_NUM},
/*0xed*/ {0,0,0,0,0},
/*0xee*/ {f_xor,1,A_NUM,0,0},
/*0xef*/ {f_rst,0x28,A_CONST,0,0},
/*0xf0*/ {f_ret,F_P,A_FLAG,0,0},
/*0xf1*/ {f_pop,R_AF,A_REG,0,0},
/*0xf2*/ {f_jp,F_P,A_FLAG,2,A_NUM},
/*0xf3*/ {f_di,0,0,0,0},
/*0xf4*/ {f_call,F_P,A_FLAG,2,A_NUM},
/*0xf5*/ {f_push,R_AF,A_REG,0,0},
/*0xf6*/ {f_or,1,A_NUM,0,0},
/*0xf7*/ {f_rst,0x30,A_CONST,0,0},
/*0xf8*/ {f_ret,F_M,A_FLAG,0,0},
/*0xf9*/ {f_ld,R_SP,A_REG,R_HL,A_REG},
/*0xfa*/ {f_jp,F_M,A_FLAG,2,A_NUM},
/*0xfb*/ {f_ei,0,0,0,0},
/*0xfc*/ {f_call,F_M,A_FLAG,2,A_NUM},
/*0xfd*/ {0,0,0,0,0},
/*0xfe*/ {f_cp,1,A_NUM,0,0},
/*0xff*/ {f_rst,0x38,A_CONST,0,0}
};

/* prefix CB */
struct instruction_type instr_cb[256]={
/*0x00*/ {f_rlc,R_B,A_REG,0,0},
/*0x01*/ {f_rlc,R_C,A_REG,0,0},
/*0x02*/ {f_rlc,R_D,A_REG,0,0},
/*0x03*/ {f_rlc,R_E,A_REG,0,0},
/*0x04*/ {f_rlc,R_H,A_REG,0,0},
/*0x05*/ {f_rlc,R_L,A_REG,0,0},
/*0x06*/ {f_rlc,R_HL,A_PODLE_REG,0,0},
/*0x07*/ {f_rlc,R_A,A_REG,0,0},
/*0x08*/ {f_rrc,R_B,A_REG,0,0},
/*0x09*/ {f_rrc,R_C,A_REG,0,0},
/*0x0a*/ {f_rrc,R_D,A_REG,0,0},
/*0x0b*/ {f_rrc,R_E,A_REG,0,0},
/*0x0c*/ {f_rrc,R_H,A_REG,0,0},
/*0x0d*/ {f_rrc,R_L,A_REG,0,0},
/*0x0e*/ {f_rrc,R_HL,A_PODLE_REG,0,0},
/*0x0f*/ {f_rrc,R_A,A_REG,0,0},
/*0x10*/ {f_rl,R_B,A_REG,0,0},
/*0x11*/ {f_rl,R_C,A_REG,0,0},
/*0x12*/ {f_rl,R_D,A_REG,0,0},
/*0x13*/ {f_rl,R_E,A_REG,0,0},
/*0x14*/ {f_rl,R_H,A_REG,0,0},
/*0x15*/ {f_rl,R_L,A_REG,0,0},
/*0x16*/ {f_rl,R_HL,A_PODLE_REG,0,0},
/*0x17*/ {f_rl,R_A,A_REG,0,0},
/*0x18*/ {f_rr,R_B,A_REG,0,0},
/*0x19*/ {f_rr,R_C,A_REG,0,0},
/*0x1a*/ {f_rr,R_D,A_REG,0,0},
/*0x1b*/ {f_rr,R_E,A_REG,0,0},
/*0x1c*/ {f_rr,R_H,A_REG,0,0},
/*0x1d*/ {f_rr,R_L,A_REG,0,0},
/*0x1e*/ {f_rr,R_HL,A_PODLE_REG,0,0},
/*0x1f*/ {f_rr,R_A,A_REG,0,0},
/*0x20*/ {f_sla,R_B,A_REG,0,0},
/*0x21*/ {f_sla,R_C,A_REG,0,0},
/*0x22*/ {f_sla,R_D,A_REG,0,0},
/*0x23*/ {f_sla,R_E,A_REG,0,0},
/*0x24*/ {f_sla,R_H,A_REG,0,0},
/*0x25*/ {f_sla,R_L,A_REG,0,0},
/*0x26*/ {f_sla,R_HL,A_PODLE_REG,0,0},
/*0x27*/ {f_sla,R_A,A_REG,0,0},
/*0x28*/ {f_sra,R_B,A_REG,0,0},
/*0x29*/ {f_sra,R_C,A_REG,0,0},
/*0x2a*/ {f_sra,R_D,A_REG,0,0},
/*0x2b*/ {f_sra,R_E,A_REG,0,0},
/*0x2c*/ {f_sra,R_H,A_REG,0,0},
/*0x2d*/ {f_sra,R_L,A_REG,0,0},
/*0x2e*/ {f_sra,R_HL,A_PODLE_REG,0,0},
/*0x2f*/ {f_sra,R_A,A_REG,0,0},
/*0x30*/ {0,0,0,0,0},
/*0x31*/ {0,0,0,0,0},
/*0x32*/ {0,0,0,0,0},
/*0x33*/ {0,0,0,0,0},
/*0x34*/ {0,0,0,0,0},
/*0x35*/ {0,0,0,0,0},
/*0x36*/ {0,0,0,0,0},
/*0x37*/ {0,0,0,0,0},
/*0x38*/ {f_srl,R_B,A_REG,0,0},
/*0x39*/ {f_srl,R_C,A_REG,0,0},
/*0x3a*/ {f_srl,R_D,A_REG,0,0},
/*0x3b*/ {f_srl,R_E,A_REG,0,0},
/*0x3c*/ {f_srl,R_H,A_REG,0,0},
/*0x3d*/ {f_srl,R_L,A_REG,0,0},
/*0x3e*/ {f_srl,R_HL,A_PODLE_REG,0,0},
/*0x3f*/ {f_srl,R_A,A_REG,0,0},
/*0x40*/ {f_bit,0,A_CONST,R_B,A_REG},
/*0x41*/ {f_bit,0,A_CONST,R_C,A_REG},
/*0x42*/ {f_bit,0,A_CONST,R_D,A_REG},
/*0x43*/ {f_bit,0,A_CONST,R_E,A_REG},
/*0x44*/ {f_bit,0,A_CONST,R_H,A_REG},
/*0x45*/ {f_bit,0,A_CONST,R_L,A_REG},
/*0x46*/ {f_bit,0,A_CONST,R_HL,A_PODLE_REG},
/*0x47*/ {f_bit,0,A_CONST,R_A,A_REG},
/*0x48*/ {f_bit,1,A_CONST,R_B,A_REG},
/*0x49*/ {f_bit,1,A_CONST,R_C,A_REG},
/*0x4a*/ {f_bit,1,A_CONST,R_D,A_REG},
/*0x4b*/ {f_bit,1,A_CONST,R_E,A_REG},
/*0x4c*/ {f_bit,1,A_CONST,R_H,A_REG},
/*0x4d*/ {f_bit,1,A_CONST,R_L,A_REG},
/*0x4e*/ {f_bit,1,A_CONST,R_HL,A_PODLE_REG},
/*0x4f*/ {f_bit,1,A_CONST,R_A,A_REG},
/*0x50*/ {f_bit,2,A_CONST,R_B,A_REG},
/*0x51*/ {f_bit,2,A_CONST,R_C,A_REG},
/*0x52*/ {f_bit,2,A_CONST,R_D,A_REG},
/*0x53*/ {f_bit,2,A_CONST,R_E,A_REG},
/*0x54*/ {f_bit,2,A_CONST,R_H,A_REG},
/*0x55*/ {f_bit,2,A_CONST,R_L,A_REG},
/*0x56*/ {f_bit,2,A_CONST,R_HL,A_PODLE_REG},
/*0x57*/ {f_bit,2,A_CONST,R_A,A_REG},
/*0x58*/ {f_bit,3,A_CONST,R_B,A_REG},
/*0x59*/ {f_bit,3,A_CONST,R_C,A_REG},
/*0x5a*/ {f_bit,3,A_CONST,R_D,A_REG},
/*0x5b*/ {f_bit,3,A_CONST,R_E,A_REG},
/*0x5c*/ {f_bit,3,A_CONST,R_H,A_REG},
/*0x5d*/ {f_bit,3,A_CONST,R_L,A_REG},
/*0x5e*/ {f_bit,3,A_CONST,R_HL,A_PODLE_REG},
/*0x5f*/ {f_bit,3,A_CONST,R_A,A_REG},
/*0x60*/ {f_bit,4,A_CONST,R_B,A_REG},
/*0x61*/ {f_bit,4,A_CONST,R_C,A_REG},
/*0x62*/ {f_bit,4,A_CONST,R_D,A_REG},
/*0x63*/ {f_bit,4,A_CONST,R_E,A_REG},
/*0x64*/ {f_bit,4,A_CONST,R_H,A_REG},
/*0x65*/ {f_bit,4,A_CONST,R_L,A_REG},
/*0x66*/ {f_bit,4,A_CONST,R_HL,A_PODLE_REG},
/*0x67*/ {f_bit,4,A_CONST,R_A,A_REG},
/*0x68*/ {f_bit,5,A_CONST,R_B,A_REG},
/*0x69*/ {f_bit,5,A_CONST,R_C,A_REG},
/*0x6a*/ {f_bit,5,A_CONST,R_D,A_REG},
/*0x6b*/ {f_bit,5,A_CONST,R_E,A_REG},
/*0x6c*/ {f_bit,5,A_CONST,R_H,A_REG},
/*0x6d*/ {f_bit,5,A_CONST,R_L,A_REG},
/*0x6e*/ {f_bit,5,A_CONST,R_HL,A_PODLE_REG},
/*0x6f*/ {f_bit,5,A_CONST,R_A,A_REG},
/*0x70*/ {f_bit,6,A_CONST,R_B,A_REG},
/*0x71*/ {f_bit,6,A_CONST,R_C,A_REG},
/*0x72*/ {f_bit,6,A_CONST,R_D,A_REG},
/*0x73*/ {f_bit,6,A_CONST,R_E,A_REG},
/*0x74*/ {f_bit,6,A_CONST,R_H,A_REG},
/*0x75*/ {f_bit,6,A_CONST,R_L,A_REG},
/*0x76*/ {f_bit,6,A_CONST,R_HL,A_PODLE_REG},
/*0x77*/ {f_bit,6,A_CONST,R_A,A_REG},
/*0x78*/ {f_bit,7,A_CONST,R_B,A_REG},
/*0x79*/ {f_bit,7,A_CONST,R_C,A_REG},
/*0x7a*/ {f_bit,7,A_CONST,R_D,A_REG},
/*0x7b*/ {f_bit,7,A_CONST,R_E,A_REG},
/*0x7c*/ {f_bit,7,A_CONST,R_H,A_REG},
/*0x7d*/ {f_bit,7,A_CONST,R_L,A_REG},
/*0x7e*/ {f_bit,7,A_CONST,R_HL,A_PODLE_REG},
/*0x7f*/ {f_bit,7,A_CONST,R_A,A_REG},
/*0x80*/ {f_res,0,A_CONST,R_B,A_REG},
/*0x81*/ {f_res,0,A_CONST,R_C,A_REG},
/*0x82*/ {f_res,0,A_CONST,R_D,A_REG},
/*0x83*/ {f_res,0,A_CONST,R_E,A_REG},
/*0x84*/ {f_res,0,A_CONST,R_H,A_REG},
/*0x85*/ {f_res,0,A_CONST,R_L,A_REG},
/*0x86*/ {f_res,0,A_CONST,R_HL,A_PODLE_REG},
/*0x87*/ {f_res,0,A_CONST,R_A,A_REG},
/*0x88*/ {f_res,1,A_CONST,R_B,A_REG},
/*0x89*/ {f_res,1,A_CONST,R_C,A_REG},
/*0x8a*/ {f_res,1,A_CONST,R_D,A_REG},
/*0x8b*/ {f_res,1,A_CONST,R_E,A_REG},
/*0x8c*/ {f_res,1,A_CONST,R_H,A_REG},
/*0x8d*/ {f_res,1,A_CONST,R_L,A_REG},
/*0x8e*/ {f_res,1,A_CONST,R_HL,A_PODLE_REG},
/*0x8f*/ {f_res,1,A_CONST,R_A,A_REG},
/*0x90*/ {f_res,2,A_CONST,R_B,A_REG},
/*0x91*/ {f_res,2,A_CONST,R_C,A_REG},
/*0x92*/ {f_res,2,A_CONST,R_D,A_REG},
/*0x93*/ {f_res,2,A_CONST,R_E,A_REG},
/*0x94*/ {f_res,2,A_CONST,R_H,A_REG},
/*0x95*/ {f_res,2,A_CONST,R_L,A_REG},
/*0x96*/ {f_res,2,A_CONST,R_HL,A_PODLE_REG},
/*0x97*/ {f_res,2,A_CONST,R_A,A_REG},
/*0x98*/ {f_res,3,A_CONST,R_B,A_REG},
/*0x99*/ {f_res,3,A_CONST,R_C,A_REG},
/*0x9a*/ {f_res,3,A_CONST,R_D,A_REG},
/*0x9b*/ {f_res,3,A_CONST,R_E,A_REG},
/*0x9c*/ {f_res,3,A_CONST,R_H,A_REG},
/*0x9d*/ {f_res,3,A_CONST,R_L,A_REG},
/*0x9e*/ {f_res,3,A_CONST,R_HL,A_PODLE_REG},
/*0x9f*/ {f_res,3,A_CONST,R_A,A_REG},
/*0xa0*/ {f_res,4,A_CONST,R_B,A_REG},
/*0xa1*/ {f_res,4,A_CONST,R_C,A_REG},
/*0xa2*/ {f_res,4,A_CONST,R_D,A_REG},
/*0xa3*/ {f_res,4,A_CONST,R_E,A_REG},
/*0xa4*/ {f_res,4,A_CONST,R_H,A_REG},
/*0xa5*/ {f_res,4,A_CONST,R_L,A_REG},
/*0xa6*/ {f_res,4,A_CONST,R_HL,A_PODLE_REG},
/*0xa7*/ {f_res,4,A_CONST,R_A,A_REG},
/*0xa8*/ {f_res,5,A_CONST,R_B,A_REG},
/*0xa9*/ {f_res,5,A_CONST,R_C,A_REG},
/*0xaa*/ {f_res,5,A_CONST,R_D,A_REG},
/*0xab*/ {f_res,5,A_CONST,R_E,A_REG},
/*0xac*/ {f_res,5,A_CONST,R_H,A_REG},
/*0xad*/ {f_res,5,A_CONST,R_L,A_REG},
/*0xae*/ {f_res,5,A_CONST,R_HL,A_PODLE_REG},
/*0xaf*/ {f_res,5,A_CONST,R_A,A_REG},
/*0xb0*/ {f_res,6,A_CONST,R_B,A_REG},
/*0xb1*/ {f_res,6,A_CONST,R_C,A_REG},
/*0xb2*/ {f_res,6,A_CONST,R_D,A_REG},
/*0xb3*/ {f_res,6,A_CONST,R_E,A_REG},
/*0xb4*/ {f_res,6,A_CONST,R_H,A_REG},
/*0xb5*/ {f_res,6,A_CONST,R_L,A_REG},
/*0xb6*/ {f_res,6,A_CONST,R_HL,A_PODLE_REG},
/*0xb7*/ {f_res,6,A_CONST,R_A,A_REG},
/*0xb8*/ {f_res,7,A_CONST,R_B,A_REG},
/*0xb9*/ {f_res,7,A_CONST,R_C,A_REG},
/*0xba*/ {f_res,7,A_CONST,R_D,A_REG},
/*0xbb*/ {f_res,7,A_CONST,R_E,A_REG},
/*0xbc*/ {f_res,7,A_CONST,R_H,A_REG},
/*0xbd*/ {f_res,7,A_CONST,R_L,A_REG},
/*0xbe*/ {f_res,7,A_CONST,R_HL,A_PODLE_REG},
/*0xbf*/ {f_res,7,A_CONST,R_A,A_REG},
/*0xc0*/ {f_set,0,A_CONST,R_B,A_REG},
/*0xc1*/ {f_set,0,A_CONST,R_C,A_REG},
/*0xc2*/ {f_set,0,A_CONST,R_D,A_REG},
/*0xc3*/ {f_set,0,A_CONST,R_E,A_REG},
/*0xc4*/ {f_set,0,A_CONST,R_H,A_REG},
/*0xc5*/ {f_set,0,A_CONST,R_L,A_REG},
/*0xc6*/ {f_set,0,A_CONST,R_HL,A_PODLE_REG},
/*0xc7*/ {f_set,0,A_CONST,R_A,A_REG},
/*0xc8*/ {f_set,1,A_CONST,R_B,A_REG},
/*0xc9*/ {f_set,1,A_CONST,R_C,A_REG},
/*0xca*/ {f_set,1,A_CONST,R_D,A_REG},
/*0xcb*/ {f_set,1,A_CONST,R_E,A_REG},
/*0xcc*/ {f_set,1,A_CONST,R_H,A_REG},
/*0xcd*/ {f_set,1,A_CONST,R_L,A_REG},
/*0xce*/ {f_set,1,A_CONST,R_HL,A_PODLE_REG},
/*0xcf*/ {f_set,1,A_CONST,R_A,A_REG},
/*0xd0*/ {f_set,2,A_CONST,R_B,A_REG},
/*0xd1*/ {f_set,2,A_CONST,R_C,A_REG},
/*0xd2*/ {f_set,2,A_CONST,R_D,A_REG},
/*0xd3*/ {f_set,2,A_CONST,R_E,A_REG},
/*0xd4*/ {f_set,2,A_CONST,R_H,A_REG},
/*0xd5*/ {f_set,2,A_CONST,R_L,A_REG},
/*0xd6*/ {f_set,2,A_CONST,R_HL,A_PODLE_REG},
/*0xd7*/ {f_set,2,A_CONST,R_A,A_REG},
/*0xd8*/ {f_set,3,A_CONST,R_B,A_REG},
/*0xd9*/ {f_set,3,A_CONST,R_C,A_REG},
/*0xda*/ {f_set,3,A_CONST,R_D,A_REG},
/*0xdb*/ {f_set,3,A_CONST,R_E,A_REG},
/*0xdc*/ {f_set,3,A_CONST,R_H,A_REG},
/*0xdd*/ {f_set,3,A_CONST,R_L,A_REG},
/*0xde*/ {f_set,3,A_CONST,R_HL,A_PODLE_REG},
/*0xdf*/ {f_set,3,A_CONST,R_A,A_REG},
/*0xe0*/ {f_set,4,A_CONST,R_B,A_REG},
/*0xe1*/ {f_set,4,A_CONST,R_C,A_REG},
/*0xe2*/ {f_set,4,A_CONST,R_D,A_REG},
/*0xe3*/ {f_set,4,A_CONST,R_E,A_REG},
/*0xe4*/ {f_set,4,A_CONST,R_H,A_REG},
/*0xe5*/ {f_set,4,A_CONST,R_L,A_REG},
/*0xe6*/ {f_set,4,A_CONST,R_HL,A_PODLE_REG},
/*0xe7*/ {f_set,4,A_CONST,R_A,A_REG},
/*0xe8*/ {f_set,5,A_CONST,R_B,A_REG},
/*0xe9*/ {f_set,5,A_CONST,R_C,A_REG},
/*0xea*/ {f_set,5,A_CONST,R_D,A_REG},
/*0xeb*/ {f_set,5,A_CONST,R_E,A_REG},
/*0xec*/ {f_set,5,A_CONST,R_H,A_REG},
/*0xed*/ {f_set,5,A_CONST,R_L,A_REG},
/*0xee*/ {f_set,5,A_CONST,R_HL,A_PODLE_REG},
/*0xef*/ {f_set,5,A_CONST,R_A,A_REG},
/*0xf0*/ {f_set,6,A_CONST,R_B,A_REG},
/*0xf1*/ {f_set,6,A_CONST,R_C,A_REG},
/*0xf2*/ {f_set,6,A_CONST,R_D,A_REG},
/*0xf3*/ {f_set,6,A_CONST,R_E,A_REG},
/*0xf4*/ {f_set,6,A_CONST,R_H,A_REG},
/*0xf5*/ {f_set,6,A_CONST,R_L,A_REG},
/*0xf6*/ {f_set,6,A_CONST,R_HL,A_PODLE_REG},
/*0xf7*/ {f_set,6,A_CONST,R_A,A_REG},
/*0xf8*/ {f_set,7,A_CONST,R_B,A_REG},
/*0xf9*/ {f_set,7,A_CONST,R_C,A_REG},
/*0xfa*/ {f_set,7,A_CONST,R_D,A_REG},
/*0xfb*/ {f_set,7,A_CONST,R_E,A_REG},
/*0xfc*/ {f_set,7,A_CONST,R_H,A_REG},
/*0xfd*/ {f_set,7,A_CONST,R_L,A_REG},
/*0xfe*/ {f_set,7,A_CONST,R_HL,A_PODLE_REG},
/*0xff*/ {f_set,7,A_CONST,R_A,A_REG}
};

/* prefix DD or FD */
struct instruction_type instr_dd[256]={
/*0x00*/ {0,0,0,0,0},
/*0x01*/ {0,0,0,0,0},
/*0x02*/ {0,0,0,0,0},
/*0x03*/ {0,0,0,0,0},
/*0x04*/ {0,0,0,0,0},
/*0x05*/ {0,0,0,0,0},
/*0x06*/ {0,0,0,0,0},
/*0x07*/ {0,0,0,0,0},
/*0x08*/ {0,0,0,0,0},
/*0x09*/ {f_add,R_IX,A_REG,R_BC,A_REG},
/*0x0a*/ {0,0,0,0,0},
/*0x0b*/ {0,0,0,0,0},
/*0x0c*/ {0,0,0,0,0},
/*0x0d*/ {0,0,0,0,0},
/*0x0e*/ {0,0,0,0,0},
/*0x0f*/ {0,0,0,0,0},
/*0x10*/ {0,0,0,0,0},
/*0x11*/ {0,0,0,0,0},
/*0x12*/ {0,0,0,0,0},
/*0x13*/ {0,0,0,0,0},
/*0x14*/ {0,0,0,0,0},
/*0x15*/ {0,0,0,0,0},
/*0x16*/ {0,0,0,0,0},
/*0x17*/ {0,0,0,0,0},
/*0x18*/ {0,0,0,0,0},
/*0x19*/ {f_add,R_IX,A_REG,R_DE,A_REG},
/*0x1a*/ {0,0,0,0,0},
/*0x1b*/ {0,0,0,0,0},
/*0x1c*/ {0,0,0,0,0},
/*0x1d*/ {0,0,0,0,0},
/*0x1e*/ {0,0,0,0,0},
/*0x1f*/ {0,0,0,0,0},
/*0x20*/ {0,0,0,0,0},
/*0x21*/ {f_ld,R_IX,A_REG,2,A_NUM},
/*0x22*/ {f_ld,2,A_PODLE_NUM,R_IX,A_REG},
/*0x23*/ {f_inc,R_IX,A_REG,0,0},
/*0x24*/ {0,0,0,0,0},
/*0x25*/ {0,0,0,0,0},
/*0x26*/ {0,0,0,0,0},
/*0x27*/ {0,0,0,0,0},
/*0x28*/ {0,0,0,0,0},
/*0x29*/ {f_add,R_IX,A_REG,R_IX,A_REG},
/*0x2a*/ {f_ld,R_IX,A_REG,2,A_PODLE_NUM},
/*0x2b*/ {f_dec,R_IX,A_REG,0,0},
/*0x2c*/ {0,0,0,0,0},
/*0x2d*/ {0,0,0,0,0},
/*0x2e*/ {0,0,0,0,0},
/*0x2f*/ {0,0,0,0,0},
/*0x30*/ {0,0,0,0,0},
/*0x31*/ {0,0,0,0,0},
/*0x32*/ {0,0,0,0,0},
/*0x33*/ {0,0,0,0,0},
/*0x34*/ {f_inc,1,A_PODLE_IX_PLUS,0,0},
/*0x35*/ {f_dec,1,A_PODLE_IX_PLUS,0,0},
/*0x36*/ {f_ld,1,A_PODLE_IX_PLUS,1,A_NUM},
/*0x37*/ {0,0,0,0,0},
/*0x38*/ {0,0,0,0,0},
/*0x39*/ {f_add,R_IX,A_REG,R_SP,A_REG},
/*0x3a*/ {0,0,0,0,0},
/*0x3b*/ {0,0,0,0,0},
/*0x3c*/ {0,0,0,0,0},
/*0x3d*/ {0,0,0,0,0},
/*0x3e*/ {0,0,0,0,0},
/*0x3f*/ {0,0,0,0,0},
/*0x40*/ {0,0,0,0,0},
/*0x41*/ {0,0,0,0,0},
/*0x42*/ {0,0,0,0,0},
/*0x43*/ {0,0,0,0,0},
/*0x44*/ {0,0,0,0,0},
/*0x45*/ {0,0,0,0,0},
/*0x46*/ {f_ld,R_B,A_REG,1,A_PODLE_IX_PLUS},
/*0x47*/ {0,0,0,0,0},
/*0x48*/ {0,0,0,0,0},
/*0x49*/ {0,0,0,0,0},
/*0x4a*/ {0,0,0,0,0},
/*0x4b*/ {0,0,0,0,0},
/*0x4c*/ {0,0,0,0,0},
/*0x4d*/ {0,0,0,0,0},
/*0x4e*/ {f_ld,R_C,A_REG,1,A_PODLE_IX_PLUS},
/*0x4f*/ {0,0,0,0,0},
/*0x50*/ {0,0,0,0,0},
/*0x51*/ {0,0,0,0,0},
/*0x52*/ {0,0,0,0,0},
/*0x53*/ {0,0,0,0,0},
/*0x54*/ {0,0,0,0,0},
/*0x55*/ {0,0,0,0,0},
/*0x56*/ {f_ld,R_D,A_REG,1,A_PODLE_IX_PLUS},
/*0x57*/ {0,0,0,0,0},
/*0x58*/ {0,0,0,0,0},
/*0x59*/ {0,0,0,0,0},
/*0x5a*/ {0,0,0,0,0},
/*0x5b*/ {0,0,0,0,0},
/*0x5c*/ {0,0,0,0,0},
/*0x5d*/ {0,0,0,0,0},
/*0x5e*/ {f_ld,R_E,A_REG,1,A_PODLE_IX_PLUS},
/*0x5f*/ {0,0,0,0,0},
/*0x60*/ {0,0,0,0,0},
/*0x61*/ {0,0,0,0,0},
/*0x62*/ {0,0,0,0,0},
/*0x63*/ {0,0,0,0,0},
/*0x64*/ {0,0,0,0,0},
/*0x65*/ {0,0,0,0,0},
/*0x66*/ {f_ld,R_H,A_REG,1,A_PODLE_IX_PLUS},
/*0x67*/ {0,0,0,0,0},
/*0x68*/ {0,0,0,0,0},
/*0x69*/ {0,0,0,0,0},
/*0x6a*/ {0,0,0,0,0},
/*0x6b*/ {0,0,0,0,0},
/*0x6c*/ {0,0,0,0,0},
/*0x6d*/ {0,0,0,0,0},
/*0x6e*/ {f_ld,R_L,A_REG,1,A_PODLE_IX_PLUS},
/*0x6f*/ {0,0,0,0,0},
/*0x70*/ {f_ld,1,A_PODLE_IX_PLUS,R_B,A_REG},
/*0x71*/ {f_ld,1,A_PODLE_IX_PLUS,R_C,A_REG},
/*0x72*/ {f_ld,1,A_PODLE_IX_PLUS,R_D,A_REG},
/*0x73*/ {f_ld,1,A_PODLE_IX_PLUS,R_E,A_REG},
/*0x74*/ {f_ld,1,A_PODLE_IX_PLUS,R_H,A_REG},
/*0x75*/ {f_ld,1,A_PODLE_IX_PLUS,R_L,A_REG},
/*0x76*/ {0,0,0,0,0},
/*0x77*/ {f_ld,1,A_PODLE_IX_PLUS,R_A,A_REG},
/*0x78*/ {0,0,0,0,0},
/*0x79*/ {0,0,0,0,0},
/*0x7a*/ {0,0,0,0,0},
/*0x7b*/ {0,0,0,0,0},
/*0x7c*/ {0,0,0,0,0},
/*0x7d*/ {0,0,0,0,0},
/*0x7e*/ {f_ld,R_A,A_REG,1,A_PODLE_IX_PLUS},
/*0x7f*/ {0,0,0,0,0},
/*0x80*/ {0,0,0,0,0},
/*0x81*/ {0,0,0,0,0},
/*0x82*/ {0,0,0,0,0},
/*0x83*/ {0,0,0,0,0},
/*0x84*/ {0,0,0,0,0},
/*0x85*/ {0,0,0,0,0},
/*0x86*/ {f_add,R_A,A_REG,1,A_PODLE_IX_PLUS},
/*0x87*/ {0,0,0,0,0},
/*0x88*/ {0,0,0,0,0},
/*0x89*/ {0,0,0,0,0},
/*0x8a*/ {0,0,0,0,0},
/*0x8b*/ {0,0,0,0,0},
/*0x8c*/ {0,0,0,0,0},
/*0x8d*/ {0,0,0,0,0},
/*0x8e*/ {f_adc,R_A,A_REG,1,A_PODLE_IX_PLUS},
/*0x8f*/ {0,0,0,0,0},
/*0x90*/ {0,0,0,0,0},
/*0x91*/ {0,0,0,0,0},
/*0x92*/ {0,0,0,0,0},
/*0x93*/ {0,0,0,0,0},
/*0x94*/ {0,0,0,0,0},
/*0x95*/ {0,0,0,0,0},
/*0x96*/ {f_sub,1,A_PODLE_IX_PLUS,0,0},
/*0x97*/ {0,0,0,0,0},
/*0x98*/ {0,0,0,0,0},
/*0x99*/ {0,0,0,0,0},
/*0x9a*/ {0,0,0,0,0},
/*0x9b*/ {0,0,0,0,0},
/*0x9c*/ {0,0,0,0,0},
/*0x9d*/ {0,0,0,0,0},
/*0x9e*/ {f_sbc,R_A,A_REG,1,A_PODLE_IX_PLUS},
/*0x9f*/ {0,0,0,0,0},
/*0xa0*/ {0,0,0,0,0},
/*0xa1*/ {0,0,0,0,0},
/*0xa2*/ {0,0,0,0,0},
/*0xa3*/ {0,0,0,0,0},
/*0xa4*/ {0,0,0,0,0},
/*0xa5*/ {0,0,0,0,0},
/*0xa6*/ {f_and,1,A_PODLE_IX_PLUS,0,0},
/*0xa7*/ {0,0,0,0,0},
/*0xa8*/ {0,0,0,0,0},
/*0xa9*/ {0,0,0,0,0},
/*0xaa*/ {0,0,0,0,0},
/*0xab*/ {0,0,0,0,0},
/*0xac*/ {0,0,0,0,0},
/*0xad*/ {0,0,0,0,0},
/*0xae*/ {f_xor,1,A_PODLE_IX_PLUS,0,0},
/*0xaf*/ {0,0,0,0,0},
/*0xb0*/ {0,0,0,0,0},
/*0xb1*/ {0,0,0,0,0},
/*0xb2*/ {0,0,0,0,0},
/*0xb3*/ {0,0,0,0,0},
/*0xb4*/ {0,0,0,0,0},
/*0xb5*/ {0,0,0,0,0},
/*0xb6*/ {f_or,1,A_PODLE_IX_PLUS,0,0},
/*0xb7*/ {0,0,0,0,0},
/*0xb8*/ {0,0,0,0,0},
/*0xb9*/ {0,0,0,0,0},
/*0xba*/ {0,0,0,0,0},
/*0xbb*/ {0,0,0,0,0},
/*0xbc*/ {0,0,0,0,0},
/*0xbd*/ {0,0,0,0,0},
/*0xbe*/ {f_cp,1,A_PODLE_IX_PLUS,0,0},
/*0xbf*/ {0,0,0,0,0},
/*0xc0*/ {0,0,0,0,0},
/*0xc1*/ {0,0,0,0,0},
/*0xc2*/ {0,0,0,0,0},
/*0xc3*/ {0,0,0,0,0},
/*0xc4*/ {0,0,0,0,0},
/*0xc5*/ {0,0,0,0,0},
/*0xc6*/ {0,0,0,0,0},
/*0xc7*/ {0,0,0,0,0},
/*0xc8*/ {0,0,0,0,0},
/*0xc9*/ {0,0,0,0,0},
/*0xca*/ {0,0,0,0,0},
/*0xcb*/ {0,0,0,0,0},
/*0xcc*/ {0,0,0,0,0},
/*0xcd*/ {0,0,0,0,0},
/*0xce*/ {0,0,0,0,0},
/*0xcf*/ {0,0,0,0,0},
/*0xd0*/ {0,0,0,0,0},
/*0xd1*/ {0,0,0,0,0},
/*0xd2*/ {0,0,0,0,0},
/*0xd3*/ {0,0,0,0,0},
/*0xd4*/ {0,0,0,0,0},
/*0xd5*/ {0,0,0,0,0},
/*0xd6*/ {0,0,0,0,0},
/*0xd7*/ {0,0,0,0,0},
/*0xd8*/ {0,0,0,0,0},
/*0xd9*/ {0,0,0,0,0},
/*0xda*/ {0,0,0,0,0},
/*0xdb*/ {0,0,0,0,0},
/*0xdc*/ {0,0,0,0,0},
/*0xdd*/ {0,0,0,0,0},
/*0xde*/ {0,0,0,0,0},
/*0xdf*/ {0,0,0,0,0},
/*0xe0*/ {0,0,0,0,0},
/*0xe1*/ {f_pop,R_IX,A_REG,0,0},
/*0xe2*/ {0,0,0,0,0},
/*0xe3*/ {f_ex,R_SP,A_PODLE_REG,R_IX,A_REG},
/*0xe4*/ {0,0,0,0,0},
/*0xe5*/ {f_push,R_IX,A_REG,0,0},
/*0xe6*/ {0,0,0,0,0},
/*0xe7*/ {0,0,0,0,0},
/*0xe8*/ {0,0,0,0,0},
/*0xe9*/ {f_jp,R_IX,A_PODLE_REG,0,0},
/*0xea*/ {0,0,0,0,0},
/*0xeb*/ {0,0,0,0,0},
/*0xec*/ {0,0,0,0,0},
/*0xed*/ {0,0,0,0,0},
/*0xee*/ {0,0,0,0,0},
/*0xef*/ {0,0,0,0,0},
/*0xf0*/ {0,0,0,0,0},
/*0xf1*/ {0,0,0,0,0},
/*0xf2*/ {0,0,0,0,0},
/*0xf3*/ {0,0,0,0,0},
/*0xf4*/ {0,0,0,0,0},
/*0xf5*/ {0,0,0,0,0},
/*0xf6*/ {0,0,0,0,0},
/*0xf7*/ {0,0,0,0,0},
/*0xf8*/ {0,0,0,0,0},
/*0xf9*/ {f_ld,R_SP,A_REG,R_IX,A_REG},
/*0xfa*/ {0,0,0,0,0},
/*0xfb*/ {0,0,0,0,0},
/*0xfc*/ {0,0,0,0,0},
/*0xfd*/ {0,0,0,0,0},
/*0xfe*/ {0,0,0,0,0},
/*0xff*/ {0,0,0,0,0}
};

/* prefix (DD or FD) and CB */
struct instruction_type instr_dd_cb[256]={
/*0x00*/ {0,0,0,0,0},
/*0x01*/ {0,0,0,0,0},
/*0x02*/ {0,0,0,0,0},
/*0x03*/ {0,0,0,0,0},
/*0x04*/ {0,0,0,0,0},
/*0x05*/ {0,0,0,0,0},
/*0x06*/ {f_rlc,1,A_PODLE_IX_PLUS,0,0},
/*0x07*/ {0,0,0,0,0},
/*0x08*/ {0,0,0,0,0},
/*0x09*/ {0,0,0,0,0},
/*0x0a*/ {0,0,0,0,0},
/*0x0b*/ {0,0,0,0,0},
/*0x0c*/ {0,0,0,0,0},
/*0x0d*/ {0,0,0,0,0},
/*0x0e*/ {f_rrc,1,A_PODLE_IX_PLUS,0,0},
/*0x0f*/ {0,0,0,0,0},
/*0x10*/ {0,0,0,0,0},
/*0x11*/ {0,0,0,0,0},
/*0x12*/ {0,0,0,0,0},
/*0x13*/ {0,0,0,0,0},
/*0x14*/ {0,0,0,0,0},
/*0x15*/ {0,0,0,0,0},
/*0x16*/ {f_rl,1,A_PODLE_IX_PLUS,0,0},
/*0x17*/ {0,0,0,0,0},
/*0x18*/ {0,0,0,0,0},
/*0x19*/ {0,0,0,0,0},
/*0x1a*/ {0,0,0,0,0},
/*0x1b*/ {0,0,0,0,0},
/*0x1c*/ {0,0,0,0,0},
/*0x1d*/ {0,0,0,0,0},
/*0x1e*/ {f_rr,1,A_PODLE_IX_PLUS,0,0},
/*0x1f*/ {0,0,0,0,0},
/*0x20*/ {0,0,0,0,0},
/*0x21*/ {0,0,0,0,0},
/*0x22*/ {0,0,0,0,0},
/*0x23*/ {0,0,0,0,0},
/*0x24*/ {0,0,0,0,0},
/*0x25*/ {0,0,0,0,0},
/*0x26*/ {f_sla,1,A_PODLE_IX_PLUS,0,0},
/*0x27*/ {0,0,0,0,0},
/*0x28*/ {0,0,0,0,0},
/*0x29*/ {0,0,0,0,0},
/*0x2a*/ {0,0,0,0,0},
/*0x2b*/ {0,0,0,0,0},
/*0x2c*/ {0,0,0,0,0},
/*0x2d*/ {0,0,0,0,0},
/*0x2e*/ {f_sra,1,A_PODLE_IX_PLUS,0,0},
/*0x2f*/ {0,0,0,0,0},
/*0x30*/ {0,0,0,0,0},
/*0x31*/ {0,0,0,0,0},
/*0x32*/ {0,0,0,0,0},
/*0x33*/ {0,0,0,0,0},
/*0x34*/ {0,0,0,0,0},
/*0x35*/ {0,0,0,0,0},
/*0x36*/ {0,0,0,0,0},
/*0x37*/ {0,0,0,0,0},
/*0x38*/ {0,0,0,0,0},
/*0x39*/ {0,0,0,0,0},
/*0x3a*/ {0,0,0,0,0},
/*0x3b*/ {0,0,0,0,0},
/*0x3c*/ {0,0,0,0,0},
/*0x3d*/ {0,0,0,0,0},
/*0x3e*/ {f_srl,1,A_PODLE_IX_PLUS,0,0},
/*0x3f*/ {0,0,0,0,0},
/*0x40*/ {0,0,0,0,0},
/*0x41*/ {0,0,0,0,0},
/*0x42*/ {0,0,0,0,0},
/*0x43*/ {0,0,0,0,0},
/*0x44*/ {0,0,0,0,0},
/*0x45*/ {0,0,0,0,0},
/*0x46*/ {f_bit,0,A_CONST,1,A_PODLE_IX_PLUS},
/*0x47*/ {0,0,0,0,0},
/*0x48*/ {0,0,0,0,0},
/*0x49*/ {0,0,0,0,0},
/*0x4a*/ {0,0,0,0,0},
/*0x4b*/ {0,0,0,0,0},
/*0x4c*/ {0,0,0,0,0},
/*0x4d*/ {0,0,0,0,0},
/*0x4e*/ {f_bit,1,A_CONST,1,A_PODLE_IX_PLUS},
/*0x4f*/ {0,0,0,0,0},
/*0x50*/ {0,0,0,0,0},
/*0x51*/ {0,0,0,0,0},
/*0x52*/ {0,0,0,0,0},
/*0x53*/ {0,0,0,0,0},
/*0x54*/ {0,0,0,0,0},
/*0x55*/ {0,0,0,0,0},
/*0x56*/ {f_bit,2,A_CONST,1,A_PODLE_IX_PLUS},
/*0x57*/ {0,0,0,0,0},
/*0x58*/ {0,0,0,0,0},
/*0x59*/ {0,0,0,0,0},
/*0x5a*/ {0,0,0,0,0},
/*0x5b*/ {0,0,0,0,0},
/*0x5c*/ {0,0,0,0,0},
/*0x5d*/ {0,0,0,0,0},
/*0x5e*/ {f_bit,3,A_CONST,1,A_PODLE_IX_PLUS},
/*0x5f*/ {0,0,0,0,0},
/*0x60*/ {0,0,0,0,0},
/*0x61*/ {0,0,0,0,0},
/*0x62*/ {0,0,0,0,0},
/*0x63*/ {0,0,0,0,0},
/*0x64*/ {0,0,0,0,0},
/*0x65*/ {0,0,0,0,0},
/*0x66*/ {f_bit,4,A_CONST,1,A_PODLE_IX_PLUS},
/*0x67*/ {0,0,0,0,0},
/*0x68*/ {0,0,0,0,0},
/*0x69*/ {0,0,0,0,0},
/*0x6a*/ {0,0,0,0,0},
/*0x6b*/ {0,0,0,0,0},
/*0x6c*/ {0,0,0,0,0},
/*0x6d*/ {0,0,0,0,0},
/*0x6e*/ {f_bit,5,A_CONST,1,A_PODLE_IX_PLUS},
/*0x6f*/ {0,0,0,0,0},
/*0x70*/ {0,0,0,0,0},
/*0x71*/ {0,0,0,0,0},
/*0x72*/ {0,0,0,0,0},
/*0x73*/ {0,0,0,0,0},
/*0x74*/ {0,0,0,0,0},
/*0x75*/ {0,0,0,0,0},
/*0x76*/ {f_bit,6,A_CONST,1,A_PODLE_IX_PLUS},
/*0x77*/ {0,0,0,0,0},
/*0x78*/ {0,0,0,0,0},
/*0x79*/ {0,0,0,0,0},
/*0x7a*/ {0,0,0,0,0},
/*0x7b*/ {0,0,0,0,0},
/*0x7c*/ {0,0,0,0,0},
/*0x7d*/ {0,0,0,0,0},
/*0x7e*/ {f_bit,7,A_CONST,1,A_PODLE_IX_PLUS},
/*0x7f*/ {0,0,0,0,0},
/*0x80*/ {0,0,0,0,0},
/*0x81*/ {0,0,0,0,0},
/*0x82*/ {0,0,0,0,0},
/*0x83*/ {0,0,0,0,0},
/*0x84*/ {0,0,0,0,0},
/*0x85*/ {0,0,0,0,0},
/*0x86*/ {f_res,0,A_CONST,1,A_PODLE_IX_PLUS},
/*0x87*/ {0,0,0,0,0},
/*0x88*/ {0,0,0,0,0},
/*0x89*/ {0,0,0,0,0},
/*0x8a*/ {0,0,0,0,0},
/*0x8b*/ {0,0,0,0,0},
/*0x8c*/ {0,0,0,0,0},
/*0x8d*/ {0,0,0,0,0},
/*0x8e*/ {f_res,1,A_CONST,1,A_PODLE_IX_PLUS},
/*0x8f*/ {0,0,0,0,0},
/*0x90*/ {0,0,0,0,0},
/*0x91*/ {0,0,0,0,0},
/*0x92*/ {0,0,0,0,0},
/*0x93*/ {0,0,0,0,0},
/*0x94*/ {0,0,0,0,0},
/*0x95*/ {0,0,0,0,0},
/*0x96*/ {f_res,2,A_CONST,1,A_PODLE_IX_PLUS},
/*0x97*/ {0,0,0,0,0},
/*0x98*/ {0,0,0,0,0},
/*0x99*/ {0,0,0,0,0},
/*0x9a*/ {0,0,0,0,0},
/*0x9b*/ {0,0,0,0,0},
/*0x9c*/ {0,0,0,0,0},
/*0x9d*/ {0,0,0,0,0},
/*0x9e*/ {f_res,3,A_CONST,1,A_PODLE_IX_PLUS},
/*0x9f*/ {0,0,0,0,0},
/*0xa0*/ {0,0,0,0,0},
/*0xa1*/ {0,0,0,0,0},
/*0xa2*/ {0,0,0,0,0},
/*0xa3*/ {0,0,0,0,0},
/*0xa4*/ {0,0,0,0,0},
/*0xa5*/ {0,0,0,0,0},
/*0xa6*/ {f_res,4,A_CONST,1,A_PODLE_IX_PLUS},
/*0xa7*/ {0,0,0,0,0},
/*0xa8*/ {0,0,0,0,0},
/*0xa9*/ {0,0,0,0,0},
/*0xaa*/ {0,0,0,0,0},
/*0xab*/ {0,0,0,0,0},
/*0xac*/ {0,0,0,0,0},
/*0xad*/ {0,0,0,0,0},
/*0xae*/ {f_res,5,A_CONST,1,A_PODLE_IX_PLUS},
/*0xaf*/ {0,0,0,0,0},
/*0xb0*/ {0,0,0,0,0},
/*0xb1*/ {0,0,0,0,0},
/*0xb2*/ {0,0,0,0,0},
/*0xb3*/ {0,0,0,0,0},
/*0xb4*/ {0,0,0,0,0},
/*0xb5*/ {0,0,0,0,0},
/*0xb6*/ {f_res,6,A_CONST,1,A_PODLE_IX_PLUS},
/*0xb7*/ {0,0,0,0,0},
/*0xb8*/ {0,0,0,0,0},
/*0xb9*/ {0,0,0,0,0},
/*0xba*/ {0,0,0,0,0},
/*0xbb*/ {0,0,0,0,0},
/*0xbc*/ {0,0,0,0,0},
/*0xbd*/ {0,0,0,0,0},
/*0xbe*/ {f_res,7,A_CONST,1,A_PODLE_IX_PLUS},
/*0xbf*/ {0,0,0,0,0},
/*0xc0*/ {0,0,0,0,0},
/*0xc1*/ {0,0,0,0,0},
/*0xc2*/ {0,0,0,0,0},
/*0xc3*/ {0,0,0,0,0},
/*0xc4*/ {0,0,0,0,0},
/*0xc5*/ {0,0,0,0,0},
/*0xc6*/ {f_set,0,A_CONST,1,A_PODLE_IX_PLUS},
/*0xc7*/ {0,0,0,0,0},
/*0xc8*/ {0,0,0,0,0},
/*0xc9*/ {0,0,0,0,0},
/*0xca*/ {0,0,0,0,0},
/*0xcb*/ {0,0,0,0,0},
/*0xcc*/ {0,0,0,0,0},
/*0xcd*/ {0,0,0,0,0},
/*0xce*/ {f_set,1,A_CONST,1,A_PODLE_IX_PLUS},
/*0xcf*/ {0,0,0,0,0},
/*0xd0*/ {0,0,0,0,0},
/*0xd1*/ {0,0,0,0,0},
/*0xd2*/ {0,0,0,0,0},
/*0xd3*/ {0,0,0,0,0},
/*0xd4*/ {0,0,0,0,0},
/*0xd5*/ {0,0,0,0,0},
/*0xd6*/ {f_set,2,A_CONST,1,A_PODLE_IX_PLUS},
/*0xd7*/ {0,0,0,0,0},
/*0xd8*/ {0,0,0,0,0},
/*0xd9*/ {0,0,0,0,0},
/*0xda*/ {0,0,0,0,0},
/*0xdb*/ {0,0,0,0,0},
/*0xdc*/ {0,0,0,0,0},
/*0xdd*/ {0,0,0,0,0},
/*0xde*/ {f_set,3,A_CONST,1,A_PODLE_IX_PLUS},
/*0xdf*/ {0,0,0,0,0},
/*0xe0*/ {0,0,0,0,0},
/*0xe1*/ {0,0,0,0,0},
/*0xe2*/ {0,0,0,0,0},
/*0xe3*/ {0,0,0,0,0},
/*0xe4*/ {0,0,0,0,0},
/*0xe5*/ {0,0,0,0,0},
/*0xe6*/ {f_set,4,A_CONST,1,A_PODLE_IX_PLUS},
/*0xe7*/ {0,0,0,0,0},
/*0xe8*/ {0,0,0,0,0},
/*0xe9*/ {0,0,0,0,0},
/*0xea*/ {0,0,0,0,0},
/*0xeb*/ {0,0,0,0,0},
/*0xec*/ {0,0,0,0,0},
/*0xed*/ {0,0,0,0,0},
/*0xee*/ {f_set,5,A_CONST,1,A_PODLE_IX_PLUS},
/*0xef*/ {0,0,0,0,0},
/*0xf0*/ {0,0,0,0,0},
/*0xf1*/ {0,0,0,0,0},
/*0xf2*/ {0,0,0,0,0},
/*0xf3*/ {0,0,0,0,0},
/*0xf4*/ {0,0,0,0,0},
/*0xf5*/ {0,0,0,0,0},
/*0xf6*/ {f_set,6,A_CONST,1,A_PODLE_IX_PLUS},
/*0xf7*/ {0,0,0,0,0},
/*0xf8*/ {0,0,0,0,0},
/*0xf9*/ {0,0,0,0,0},
/*0xfa*/ {0,0,0,0,0},
/*0xfb*/ {0,0,0,0,0},
/*0xfc*/ {0,0,0,0,0},
/*0xfd*/ {0,0,0,0,0},
/*0xfe*/ {f_set,7,A_CONST,1,A_PODLE_IX_PLUS},
/*0xff*/ {0,0,0,0,0}
};

/* prefix ED */
struct instruction_type instr_ed[256]={
/*0x00*/ {0,0,0,0,0},
/*0x01*/ {0,0,0,0,0},
/*0x02*/ {0,0,0,0,0},
/*0x03*/ {0,0,0,0,0},
/*0x04*/ {0,0,0,0,0},
/*0x05*/ {0,0,0,0,0},
/*0x06*/ {0,0,0,0,0},
/*0x07*/ {0,0,0,0,0},
/*0x08*/ {0,0,0,0,0},
/*0x09*/ {0,0,0,0,0},
/*0x0a*/ {0,0,0,0,0},
/*0x0b*/ {0,0,0,0,0},
/*0x0c*/ {0,0,0,0,0},
/*0x0d*/ {0,0,0,0,0},
/*0x0e*/ {0,0,0,0,0},
/*0x0f*/ {0,0,0,0,0},
/*0x10*/ {0,0,0,0,0},
/*0x11*/ {0,0,0,0,0},
/*0x12*/ {0,0,0,0,0},
/*0x13*/ {0,0,0,0,0},
/*0x14*/ {0,0,0,0,0},
/*0x15*/ {0,0,0,0,0},
/*0x16*/ {0,0,0,0,0},
/*0x17*/ {0,0,0,0,0},
/*0x18*/ {0,0,0,0,0},
/*0x19*/ {0,0,0,0,0},
/*0x1a*/ {0,0,0,0,0},
/*0x1b*/ {0,0,0,0,0},
/*0x1c*/ {0,0,0,0,0},
/*0x1d*/ {0,0,0,0,0},
/*0x1e*/ {0,0,0,0,0},
/*0x1f*/ {0,0,0,0,0},
/*0x20*/ {0,0,0,0,0},
/*0x21*/ {0,0,0,0,0},
/*0x22*/ {0,0,0,0,0},
/*0x23*/ {0,0,0,0,0},
/*0x24*/ {0,0,0,0,0},
/*0x25*/ {0,0,0,0,0},
/*0x26*/ {0,0,0,0,0},
/*0x27*/ {0,0,0,0,0},
/*0x28*/ {0,0,0,0,0},
/*0x29*/ {0,0,0,0,0},
/*0x2a*/ {0,0,0,0,0},
/*0x2b*/ {0,0,0,0,0},
/*0x2c*/ {0,0,0,0,0},
/*0x2d*/ {0,0,0,0,0},
/*0x2e*/ {0,0,0,0,0},
/*0x2f*/ {0,0,0,0,0},
/*0x30*/ {0,0,0,0,0},
/*0x31*/ {0,0,0,0,0},
/*0x32*/ {0,0,0,0,0},
/*0x33*/ {0,0,0,0,0},
/*0x34*/ {0,0,0,0,0},
/*0x35*/ {0,0,0,0,0},
/*0x36*/ {0,0,0,0,0},
/*0x37*/ {0,0,0,0,0},
/*0x38*/ {0,0,0,0,0},
/*0x39*/ {0,0,0,0,0},
/*0x3a*/ {0,0,0,0,0},
/*0x3b*/ {0,0,0,0,0},
/*0x3c*/ {0,0,0,0,0},
/*0x3d*/ {0,0,0,0,0},
/*0x3e*/ {0,0,0,0,0},
/*0x3f*/ {0,0,0,0,0},
/*0x40*/ {f_in,R_B,A_REG,R_C,A_PODLE_REG},
/*0x41*/ {f_out,R_C,A_PODLE_REG,R_B,A_REG},
/*0x42*/ {f_sbc,R_HL,A_REG,R_BC,A_REG},
/*0x43*/ {f_ld,2,A_PODLE_NUM,R_BC,A_REG},
/*0x44*/ {f_neg,0,0,0,0},
/*0x45*/ {f_retn,0,0,0,0},
/*0x46*/ {f_im,0,A_CONST,0,0},
/*0x47*/ {f_ld,R_I,A_REG,R_A,A_REG},
/*0x48*/ {f_in,R_C,A_REG,R_C,A_PODLE_REG},
/*0x49*/ {f_out,R_C,A_PODLE_REG,R_C,A_REG},
/*0x4a*/ {f_adc,R_HL,A_REG,R_BC,A_REG},
/*0x4b*/ {f_ld,R_BC,A_REG,2,A_PODLE_NUM},
/*0x4c*/ {0,0,0,0,0},
/*0x4d*/ {f_reti,0,0,0,0},
/*0x4e*/ {0,0,0,0,0},
/*0x4f*/ {f_ld,R_R,A_REG,R_A,A_REG},
/*0x50*/ {f_in,R_D,A_REG,R_C,A_PODLE_REG},
/*0x51*/ {f_out,R_C,A_PODLE_REG,R_D,A_REG},
/*0x52*/ {f_sbc,R_HL,A_REG,R_DE,A_REG},
/*0x53*/ {f_ld,2,A_PODLE_NUM,R_DE,A_REG},
/*0x54*/ {0,0,0,0,0},
/*0x55*/ {0,0,0,0,0},
/*0x56*/ {f_im,1,A_CONST,0,0},
/*0x57*/ {f_ld,R_A,A_REG,R_I,A_REG},
/*0x58*/ {f_in,R_E,A_REG,R_C,A_PODLE_REG},
/*0x59*/ {f_out,R_C,A_PODLE_REG,R_E,A_REG},
/*0x5a*/ {f_adc,R_HL,A_REG,R_DE,A_REG},
/*0x5b*/ {f_ld,R_DE,A_REG,2,A_PODLE_NUM},
/*0x5c*/ {0,0,0,0,0},
/*0x5d*/ {0,0,0,0,0},
/*0x5e*/ {f_im,2,A_CONST,0,0},
/*0x5f*/ {f_ld,R_A,A_REG,R_R,A_REG},
/*0x60*/ {f_in,R_H,A_REG,R_C,A_PODLE_REG},
/*0x61*/ {f_out,R_C,A_PODLE_REG,R_H,A_REG},
/*0x62*/ {f_sbc,R_HL,A_REG,R_HL,A_REG},
/*0x63*/ {f_ld,2,A_NUM,R_HL,A_REG},
/*0x64*/ {0,0,0,0,0},
/*0x65*/ {0,0,0,0,0},
/*0x66*/ {0,0,0,0,0},
/*0x67*/ {f_rrd,0,0,0,0},
/*0x68*/ {f_in,R_L,A_REG,R_C,A_PODLE_REG},
/*0x69*/ {f_out,R_C,A_PODLE_REG,R_L,A_REG},
/*0x6a*/ {f_adc,R_HL,A_REG,R_HL,A_REG},
/*0x6b*/ {f_ld,R_HL,A_REG,2,A_PODLE_NUM},
/*0x6c*/ {0,0,0,0,0},
/*0x6d*/ {0,0,0,0,0},
/*0x6e*/ {0,0,0,0,0},
/*0x6f*/ {f_rld,0,0,0,0},
/*0x70*/ {0,0,0,0,0},
/*0x71*/ {0,0,0,0,0},
/*0x72*/ {f_sbc,R_HL,A_REG,R_SP,A_REG},
/*0x73*/ {f_ld,2,A_PODLE_NUM,R_SP,A_REG},
/*0x74*/ {0,0,0,0,0},
/*0x75*/ {0,0,0,0,0},
/*0x76*/ {0,0,0,0,0},
/*0x77*/ {0,0,0,0,0},
/*0x78*/ {f_in,R_A,A_REG,R_C,A_PODLE_REG},
/*0x79*/ {f_out,R_C,A_PODLE_REG,R_A,A_REG},
/*0x7a*/ {f_adc,R_HL,A_REG,R_SP,A_REG},
/*0x7b*/ {f_ld,R_SP,A_REG,2,A_PODLE_NUM},
/*0x7c*/ {0,0,0,0,0},
/*0x7d*/ {0,0,0,0,0},
/*0x7e*/ {0,0,0,0,0},
/*0x7f*/ {0,0,0,0,0},
/*0x80*/ {0,0,0,0,0},
/*0x81*/ {0,0,0,0,0},
/*0x82*/ {0,0,0,0,0},
/*0x83*/ {0,0,0,0,0},
/*0x84*/ {0,0,0,0,0},
/*0x85*/ {0,0,0,0,0},
/*0x86*/ {0,0,0,0,0},
/*0x87*/ {0,0,0,0,0},
/*0x88*/ {0,0,0,0,0},
/*0x89*/ {0,0,0,0,0},
/*0x8a*/ {0,0,0,0,0},
/*0x8b*/ {0,0,0,0,0},
/*0x8c*/ {0,0,0,0,0},
/*0x8d*/ {0,0,0,0,0},
/*0x8e*/ {0,0,0,0,0},
/*0x8f*/ {0,0,0,0,0},
/*0x90*/ {0,0,0,0,0},
/*0x91*/ {0,0,0,0,0},
/*0x92*/ {0,0,0,0,0},
/*0x93*/ {0,0,0,0,0},
/*0x94*/ {0,0,0,0,0},
/*0x95*/ {0,0,0,0,0},
/*0x96*/ {0,0,0,0,0},
/*0x97*/ {0,0,0,0,0},
/*0x98*/ {0,0,0,0,0},
/*0x99*/ {0,0,0,0,0},
/*0x9a*/ {0,0,0,0,0},
/*0x9b*/ {0,0,0,0,0},
/*0x9c*/ {0,0,0,0,0},
/*0x9d*/ {0,0,0,0,0},
/*0x9e*/ {0,0,0,0,0},
/*0x9f*/ {0,0,0,0,0},
/*0xa0*/ {f_ldi,0,0,0,0},
/*0xa1*/ {f_cpi,0,0,0,0},
/*0xa2*/ {f_ini,0,0,0,0},
/*0xa3*/ {f_outi,0,0,0,0},
/*0xa4*/ {0,0,0,0,0},
/*0xa5*/ {0,0,0,0,0},
/*0xa6*/ {0,0,0,0,0},
/*0xa7*/ {0,0,0,0,0},
/*0xa8*/ {f_ldd,0,0,0,0},
/*0xa9*/ {f_cpd,0,0,0,0},
/*0xaa*/ {f_ind,0,0,0,0},
/*0xab*/ {f_outd,0,0,0,0},
/*0xac*/ {0,0,0,0,0},
/*0xad*/ {0,0,0,0,0},
/*0xae*/ {0,0,0,0,0},
/*0xaf*/ {0,0,0,0,0},
/*0xb0*/ {f_ldir,0,0,0,0},
/*0xb1*/ {f_cpir,0,0,0,0},
/*0xb2*/ {f_inir,0,0,0,0},
/*0xb3*/ {f_otir,0,0,0,0},
/*0xb4*/ {0,0,0,0,0},
/*0xb5*/ {0,0,0,0,0},
/*0xb6*/ {0,0,0,0,0},
/*0xb7*/ {0,0,0,0,0},
/*0xb8*/ {f_lddr,0,0,0,0},
/*0xb9*/ {f_cpdr,0,0,0,0},
/*0xba*/ {f_indr,0,0,0,0},
/*0xbb*/ {f_otdr,0,0,0,0},
/*0xbc*/ {0,0,0,0,0},
/*0xbd*/ {0,0,0,0,0},
/*0xbe*/ {0,0,0,0,0},
/*0xbf*/ {0,0,0,0,0},
/*0xc0*/ {0,0,0,0,0},
/*0xc1*/ {0,0,0,0,0},
/*0xc2*/ {0,0,0,0,0},
/*0xc3*/ {0,0,0,0,0},
/*0xc4*/ {0,0,0,0,0},
/*0xc5*/ {0,0,0,0,0},
/*0xc6*/ {0,0,0,0,0},
/*0xc7*/ {0,0,0,0,0},
/*0xc8*/ {0,0,0,0,0},
/*0xc9*/ {0,0,0,0,0},
/*0xca*/ {0,0,0,0,0},
/*0xcb*/ {0,0,0,0,0},
/*0xcc*/ {0,0,0,0,0},
/*0xcd*/ {0,0,0,0,0},
/*0xce*/ {0,0,0,0,0},
/*0xcf*/ {0,0,0,0,0},
/*0xd0*/ {0,0,0,0,0},
/*0xd1*/ {0,0,0,0,0},
/*0xd2*/ {0,0,0,0,0},
/*0xd3*/ {0,0,0,0,0},
/*0xd4*/ {0,0,0,0,0},
/*0xd5*/ {0,0,0,0,0},
/*0xd6*/ {0,0,0,0,0},
/*0xd7*/ {0,0,0,0,0},
/*0xd8*/ {0,0,0,0,0},
/*0xd9*/ {0,0,0,0,0},
/*0xda*/ {0,0,0,0,0},
/*0xdb*/ {0,0,0,0,0},
/*0xdc*/ {0,0,0,0,0},
/*0xdd*/ {0,0,0,0,0},
/*0xde*/ {0,0,0,0,0},
/*0xdf*/ {0,0,0,0,0},
/*0xe0*/ {0,0,0,0,0},
/*0xe1*/ {0,0,0,0,0},
/*0xe2*/ {0,0,0,0,0},
/*0xe3*/ {0,0,0,0,0},
/*0xe4*/ {0,0,0,0,0},
/*0xe5*/ {0,0,0,0,0},
/*0xe6*/ {0,0,0,0,0},
/*0xe7*/ {0,0,0,0,0},
/*0xe8*/ {0,0,0,0,0},
/*0xe9*/ {0,0,0,0,0},
/*0xea*/ {0,0,0,0,0},
/*0xeb*/ {0,0,0,0,0},
/*0xec*/ {0,0,0,0,0},
/*0xed*/ {0,0,0,0,0},
/*0xee*/ {0,0,0,0,0},
/*0xef*/ {0,0,0,0,0},
/*0xf0*/ {0,0,0,0,0},
/*0xf1*/ {0,0,0,0,0},
/*0xf2*/ {0,0,0,0,0},
/*0xf3*/ {0,0,0,0,0},
/*0xf4*/ {0,0,0,0,0},
/*0xf5*/ {0,0,0,0,0},
/*0xf6*/ {0,0,0,0,0},
/*0xf7*/ {0,0,0,0,0},
/*0xf8*/ {0,0,0,0,0},
/*0xf9*/ {0,0,0,0,0},
/*0xfa*/ {0,0,0,0,0},
/*0xfb*/ {0,0,0,0,0},
/*0xfc*/ {0,0,0,0,0},
/*0xfd*/ {0,0,0,0,0},
/*0xfe*/ {0,0,0,0,0},
/*0xff*/ {0,0,0,0,0}
};
