/* INSTRUCTION TYPES FOR LEXICAL ANALYSIS (DURING ASSEMBLING) */

#ifndef __INSTR_H
#define __INSTR_H

#define I_DEFS 71
#define I_DEFW 70
#define I_DEFB 69
#define I_ADC 68
#define I_ADD 1
#define I_AND 2
#define I_BIT 3
#define I_CALL 4
#define I_CCF 5
#define I_CP 6
#define I_CPD 7
#define I_CPDR 8
#define I_CPI 9
#define I_CPIR 10
#define I_CPL 11
#define I_DAA 12
#define I_DEC 13
#define I_DI 14
#define I_DJNZ 15
#define I_EI 16
#define I_EX 17
#define I_EXX 18
#define I_HALT 19
#define I_IM 20
#define I_IN 21
#define I_INC 22
#define I_IND 23
#define I_INI 24
#define I_INDR 25
#define I_INIR 26
#define I_JP 27
#define I_JR 28
#define I_LD 29
#define I_LDD 30
#define I_LDI 31
#define I_LDDR 32
#define I_LDIR 33
#define I_NEG 34
#define I_NOP 35
#define I_OR 36
#define I_OTDR 37
#define I_OTIR 38
#define I_OUT 39
#define I_OUTD 40
#define I_OUTI 41
#define I_POP 42
#define I_PUSH 43
#define I_RES 44
#define I_RET 45
#define I_RETI 46
#define I_RETN 47
#define I_RL 48
#define I_RLA 49
#define I_RLC 50
#define I_RLCA 51
#define I_RLD 52
#define I_RR 53
#define I_RRA 54
#define I_RRC 55
#define I_RRCA 56
#define I_RRD 57
#define I_RST 58
#define I_SBC 59
#define I_SCF 60
#define I_SET 61
#define I_SLA 62
#define I_SRA 63
#define I_SRL 64
#define I_SUB 65
#define I_XOR 66
#define I_ORG 67
#define I_EMPTY 0   /* empty must be zero ! */
#define I_ILLEGAL -1   /* illegal instruction must be -1 */

#define N_INSTRUCTIONS 71

extern const struct seznam_type instruction[N_INSTRUCTIONS];

#endif
