/* REGISTER AND FLAG DEFINITIONS FOR LEXICAL ANALYSIS (PART OF ASSEMBLING) */

#ifndef __REGS_H
#define __REGS_H

#define R_EMPTY 0
#define R_A 1
#define R_B 2
#define R_C 3
#define R_D 4
#define R_E 5
#define R_H 6
#define R_L 7
#define R_I 8
#define R_R 9
#define R_AF 10
#define R_BC 11
#define R_DE 12
#define R_HL 13
#define R_SP 14
#define R_IX 15
#define R_IY 16
#define R_AF_ 17
#define R_ILLEGAL -1

#define N_REGISTERS 17

extern const struct seznam_type reg[N_REGISTERS];

#define F_EMPTY 0
#define F_Z 8
#define F_NZ 1
#define F_C 3  /* this must be same as R_C !!! */
#define F_NC 2
#define F_PE 4
#define F_PO 5
#define F_M 6
#define F_P 7

#define F_H 9
#define F_NH 10
#define F_N 11
#define F_NN 12
#define F_ILLEGAL -1

#define N_FLAGS 8  /* number of flags in table flag */

extern const struct seznam_type flag[N_FLAGS]; /* flags used in instructions */

#endif
