#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "asm.h"
#include "file.h"

FILE *input;

unsigned char memory[65536];
unsigned short start,length;


void
take_line(char *line)
{
if (!fgets(line,MAX_TEXT,input)){line[0]=0;return;}  /* end of file */
if (!feof(input))
  {
  line[strlen(line)-1]=0;
  if (!strlen(line))take_line(line);
  }
}


void
usage(void)
{
printf(
"Z80 assembler.\n"
"(c)1999-2000 Brainsoft\n"
"Usage: z80-asm [-w] <input file> <start address>[:<length>]:<output file> [<start address>[:<length>]:<output file> ...]\n"
);
}


void
error(int l,char *line,char *txt)
{
fprintf(stderr,"%s\nline %d: %s\n",line,l,txt);
}


/* return value: 0=OK, 1=syntax error */
/* parses command line options */

int
parse_arg(char *arg,char **filename)
{
 unsigned long a;
 char *p,*e;
 
 for (p=arg;(*p)&&(*p)!=':';p++);  /* find ':' or end of string */
 if (!(*p)){fprintf(stderr,"Error: Output filename not specified.\n");return 1;}
 *p=0;
 a=strtoul(arg,&e,10);
 if (*e){fprintf(stderr,"Error: Starting address is not a number.\n");return 1;}
 if (a>65535){fprintf(stderr,"Error: Starting address out of range.\n");return 1;}
 start=(unsigned short)a;
 
 p++;*filename=p;
 for (;(*p)&&(*p)!=':';p++);  /* find ':' or end of string */
 if (*p) /* start:length:filename */
 {
  *p=0;
  p++;
  a=strtoul(*filename,&e,10); 
  if (*e){fprintf(stderr,"Error: Length is not a number.\n");return 1;}
  if (a>65535){fprintf(stderr,"Error: Length out of range.\n");return 1;}
  length=(unsigned short)a;
  if ((int)start+length>65535){fprintf(stderr,"Error: File is too long.\n");return 1;}
  *filename=p;
 }
 else length=0;  /* start:filename */
 return 0;
}


void
init(void)
{
disable_defx=0;
bzero(memory,65536);
memory_ptr=memory;
}


int
main(int argc,char**argv)
{
FILE *output;
char *txt=0;
int s=0,a,b;

init();
asm_init();

if (argc>1&&!strcmp(argv[1],"-w")){printf("Warnings switched on.\n");WARNINGS=1;s=1;}
if (argc-s<3||!strcmp(argv[1+s],"-h")){usage();return 0;}

input=fopen(argv[1+s],"r");
if (!input){fprintf(stderr,"Error: Can't open input file \"%s\".\n",argv[1+s]);return 1;}

a=0;
address=0;
pruchod=1;
line=1;
while (!feof(input)&&!a)
 {
 a=compile();
 }
if (!a)
 {
 fseek(input,0,SEEK_SET);
 line=1;
 pruchod=2;
 address=0;
 while (!feof(input)&&!a)
  {
  a=compile();
  }
 }
if (!a)
{
 for (b=2+s;b<argc;b++)
 {
  if (parse_arg(argv[b],&txt))return 1;
  output=fopen(txt,"w");
  if (!output){fprintf(stderr,"Error: Can't open output file \"%s\".\n",txt); fclose(input);return 1;}
  write_header(output,start);
  fwrite(memory+start,length?length:(unsigned int)end+1-start,1,output);
  fclose(output);
 }
}
fclose(input);
asm_close();
return a;
}
