/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#include <Plot.h>
#include <X11/Xaw/SimpleP.h>

/* New fields for the Plot widget class record.  */

typedef struct
{
  int ignore;
} PlotClassPart;

/* Full class record declaration */
typedef struct _PlotClassRec
{
  CoreClassPart core_class;
  SimpleClassPart simple_class;
  PlotClassPart plot_class;
} PlotClassRec;

extern PlotClassRec plotClassRec;



/* New fields for the Plot widget record.  */
typedef struct
{
  /* resources */
  Pixel foreground;

  /* private data */
  XImage *image;
  Bool shm;
  XShmSegmentInfo shminfo;
  GC pixgc;
  GC drawgc;
  float low;
  float high;
  volatile double *maxerror;
  double lastmax;
} PlotPart;

/* Full instance record declaration.  */
typedef struct _PlotRec
{
  CorePart core;
  SimplePart simple;
  PlotPart plot;
} PlotRec;
