/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#include <float.h>
#include <gmp.h>
#include <ieee754.h>
#include <stdlib.h>

#include "zelibm.h"


void
extract_double (mpq_t r, double d)
{
  union ieee754_double u;
  unsigned int val;

  /* Make the floating point value available in the broken down form.  We
     cannot use casting of pointers and other ugly ways to access the bits.
     Using the union is the only half-way clean method.  */
  u.d = d;

  mpq_init (r);

  /* Set the high word and the denominator to 1.  */
  val = u.ieee.mantissa0;
  if (u.ieee.exponent != 0)
    val |= 1 << (DBL_MANT_DIG - 32 - 1);
  mpq_set_ui (r, val, 1);
  /* Shift in the right position.  */
  mpz_mul_2exp (mpq_numref (r), mpq_numref (r), 32);
  /* Add the lower word.  */
  mpz_add_ui (mpq_numref (r), mpq_numref (r), u.ieee.mantissa1);

  if (u.ieee.exponent == 0)
    {
      if (u.ieee.mantissa0 != 0 && u.ieee.mantissa1 != 0)
	{
	  /* The number is a denormalized.  */
	  mpz_mul_2exp (mpq_denref (r), mpq_denref (r),
			-DBL_MIN_EXP + DBL_MANT_DIG + 1);
	}
    }
  else if (u.ieee.exponent >= IEEE754_DOUBLE_BIAS + DBL_MANT_DIG)
    {
      /* We have to multiply the numerator with the exponent.  */
      mpz_mul_2exp (mpq_numref (r), mpq_numref (r),
		    (u.ieee.exponent
		     - (IEEE754_DOUBLE_BIAS + DBL_MANT_DIG - 1)));
    }
  else
    {
      /* Set denominator to the appropriate power of 2.  */
      mpz_mul_2exp (mpq_denref (r), mpq_denref (r),
		    ((IEEE754_DOUBLE_BIAS + DBL_MANT_DIG - 1)
		     - u.ieee.exponent));
    }

  if (u.ieee.negative)
    mpq_neg (r, r);
}
