/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#include <ieee754.h>
#include <stdlib.h>

#include "zelibm.h"


double
zerandom (double low, double high)
{
  /* Get two 31 bit random numbers for the initial mantissa.  */
  unsigned int r1 = random ();
  unsigned int r2 = random ();
  union ieee754_double u;
  double res;

  u.ieee.negative = 0;
  u.ieee.exponent = IEEE754_DOUBLE_BIAS - 1;
  u.ieee.mantissa0 = r1 >> 1;
  u.ieee.mantissa1 = r2 | r1 << 31;

  res = low + 2 * (u.d - 0.5) * (high - low);

  while (res > high)
    res /= 2.0;
  while (res < low)
    res *= 2.0;

  return res;
}
