/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#include "zelibm.h"

double
zesqrt_diff (double x, double lx)
{
  mpf_t f;
  mpf_t fl;
  double res;

  mpf_init_set_d (f, x);
  mpf_init_set_d (fl, lx);
  mpf_sqrt (f, f);
  mpf_sub (f, f, fl);
  res = mpf_get_d (f);
  mpf_clear (f);
  return res;
}
