/*
 * Decompiled with CFR 0.152.
 */
package cycinf.build;

import cycinf.CycinfPlugin;
import cycinf.util.ActionOnCycinfDir;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;

public final class SetUpMakeAction
extends ActionOnCycinfDir {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeFile(InputStream source, IFile target, boolean overwrite) throws CoreException {
        if (target.exists()) {
            if (!overwrite) return false;
            target.setContents(source, false, true, (IProgressMonitor)new NullProgressMonitor());
            return true;
        } else {
            target.create(source, false, (IProgressMonitor)new NullProgressMonitor());
        }
        return true;
    }

    public void run(IAction a) {
        IContainer dir2 = this.dir.getDir();
        InputStream cycinfmk = SetUpMakeAction.class.getResourceAsStream("cycinf.mk");
        InputStream psmk = SetUpMakeAction.class.getResourceAsStream("project-sample.mk");
        try {
            try {
                boolean wroteSample;
                boolean wroteCimk = this.writeFile(cycinfmk, dir2.getFile(Path.fromPortableString((String)"cycinf.mk")), true);
                if (wroteCimk) {
                    CycinfPlugin.message((String)"The Cyclone make library has been written to cycinf.mk.", (int)2);
                }
                if (wroteSample = this.writeFile(psmk, dir2.getFile(Path.fromPortableString((String)"Makefile")), false)) {
                    CycinfPlugin.message((String)"A sample Makefile has been written.  You should customize it.  At the very least, type in the names of your source files so something gets compiled.", (int)2);
                } else {
                    CycinfPlugin.message((String)"You already have a Makefile, so a sample Makefile was not written.", (int)2);
                }
                CycinfPlugin.message((String)"Done.  If you want automatic building, check \"Build on resource save\" in the project properties, and check \"Project\" -> \"Build Automatically\".  The project should then build whenever you save something.  Consider enabling \"Watch Inference Data\" too.", (int)2);
            }
            catch (CoreException e) {
                CycinfPlugin.message((String)("Something went wrong: " + e.toString()), (int)1, (String[])new String[]{"OK"}, (int)0);
            }
        }
        catch (Throwable throwable) {
            try {
                cycinfmk.close();
            }
            catch (Exception exception) {}
            try {
                psmk.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            cycinfmk.close();
        }
        catch (Exception exception) {}
        try {
            psmk.close();
        }
        catch (Exception exception) {}
    }
}

