/*
 * Decompiled with CFR 0.152.
 */
package cycinf.cvars.usedtype;

import cycinf.cvars.usedtype.Identifier;
import cycinf.cvars.usedtype.UsedTypeLayer;
import cycinf.cvars.usedtype.UsedTypeList;
import cycinf.util.ParseException;
import cycinf.util.ParsingUtils;
import general.util.Validator;
import java.text.MessageFormat;

public class ConstructorTempArgList
extends UsedTypeList {
    private final UsedTypeLayer context;
    private final Identifier datatypeName;
    private final Identifier constructorName;
    private static final String l1 = "_DFARG";
    private static final String l2 = "DD";
    private static final String l3 = "DF";
    private static final MessageFormat prettyFormat = new MessageFormat("template arg. #{0} to {1}.{2} in {3}");

    public final UsedTypeLayer getContext() {
        return this.context;
    }

    public final Identifier getDatatypeName() {
        return this.datatypeName;
    }

    public final Identifier getConstructorName() {
        return this.constructorName;
    }

    public ConstructorTempArgList(UsedTypeLayer context, Identifier datatypeName, Identifier constructorName) {
        this.context = (UsedTypeLayer)Validator.nonnull((Object)context, (String)"context");
        this.datatypeName = (Identifier)Validator.nonnull((Object)datatypeName, (String)"datatypeName");
        this.constructorName = (Identifier)Validator.nonnull((Object)constructorName, (String)"constructorName");
    }

    public final String fieldLocatorStringBase() {
        return String.valueOf(this.getContext().toString()) + l2 + this.getDatatypeName().toString() + l3 + this.getConstructorName().toString() + l1;
    }

    public final String prettyStringForVariable(int index) {
        return prettyFormat.format(new Object[]{index + 1, this.getDatatypeName().prettyString(), this.getConstructorName().prettyString(), this.getContext().prettyString()});
    }

    public static final ConstructorTempArgList parseBase1(String x) throws ParseException {
        String x1 = ParsingUtils.chopSuffix((String)x, (String)l1);
        if (x1 == null) {
            return null;
        }
        String x2 = ParsingUtils.chopIdentifierSuffix((String)x1);
        if (x2 == null) {
            throw new ParseException("DatatypeTempArgList expecting the name of the constructor: " + x);
        }
        Identifier constructorName = ParsingUtils.ival;
        String x3 = ParsingUtils.chopSuffix((String)x2, (String)l3);
        if (x3 == null) {
            throw new ParseException("DatatypeTempArgList expecting DF: " + x);
        }
        String x4 = ParsingUtils.chopIdentifierSuffix((String)x3);
        if (x4 == null) {
            throw new ParseException("DatatypeTempArgList expecting the name of the datatype: " + x);
        }
        Identifier datatypeName = ParsingUtils.ival;
        String x5 = ParsingUtils.chopSuffix((String)x4, (String)l2);
        if (x5 == null) {
            throw new ParseException("DatatypeTempArgList expecting DD: " + x);
        }
        UsedTypeLayer context = UsedTypeLayer.parse((String)x5);
        return new ConstructorTempArgList(context, datatypeName, constructorName);
    }
}

