/*
 * Decompiled with CFR 0.152.
 */
package cycinf.ui;

import cycinf.infstats.BelongsToInfstats;
import cycinf.infstats.DirInfstats;
import cycinf.infstats.DirTracker;
import cycinf.ui.GlobalSelectionListener;
import cycinf.ui.InfstatsPartView;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class InfstatsPartView<Element extends BelongsToInfstats>
extends ViewPart {
    final Class<Element> clazzElement;
    DirTracker dir = null;
    DirInfstats is = null;
    Composite viewArea;
    Layout viewAreaLayout;
    Label label;
    TableViewer theTableViewer;
    Action goToAction;
    private Observer infstatsObserver = new /* Unavailable Anonymous Inner Class!! */;
    GlobalSelectionListener<Object> globalSelectionListener;
    private static final DateFormat df = DateFormat.getDateTimeInstance(3, 3);

    Element asElement(Object o) {
        return (Element)((BelongsToInfstats)this.clazzElement.cast(o));
    }

    boolean isElement(Object o) {
        return this.clazzElement.isInstance(o);
    }

    abstract String getColumnText(Element var1, int var2);

    abstract Collection<Element> getElements();

    abstract void doRevealElement(Element var1);

    void doRevealElement1() {
        ISelection selection = this.theTableViewer.getSelection();
        if (!selection.isEmpty()) {
            BelongsToInfstats e = this.asElement(((IStructuredSelection)selection).getFirstElement());
            this.doRevealElement(e);
        }
    }

    public InfstatsPartView(Class<Element> clazzElement) {
        this.clazzElement = clazzElement;
    }

    Element marshallElementFrom(Object o) {
        return (Element)(this.isElement(o) ? this.asElement(o) : null);
    }

    abstract void setUpTableColumns(Table var1);

    private void setUpViewer() {
        this.theTableViewer = new TableViewer(this.viewArea, 770);
        this.theTableViewer.setContentProvider((IContentProvider)new ViewContentProvider(this));
        this.theTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(this));
        this.getSite().setSelectionProvider((ISelectionProvider)this.theTableViewer);
        Table theTable = this.theTableViewer.getTable();
        this.setUpTableColumns(theTable);
        theTable.setHeaderVisible(true);
        this.goToAction = new /* Unavailable Anonymous Inner Class!! */;
        this.theTableViewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void createPartControl(Composite parent) {
        this.viewArea = parent;
        this.viewAreaLayout = new FormLayout();
        this.viewArea.setLayout(this.viewAreaLayout);
        this.label = new Label(this.viewArea, 16448);
        this.setUpViewer();
        FormData lbd = new FormData();
        lbd.top = new FormAttachment(0, 2);
        lbd.left = new FormAttachment(0, 2);
        lbd.right = new FormAttachment(100, -2);
        this.label.setLayoutData((Object)lbd);
        FormData ifd = new FormData();
        ifd.top = new FormAttachment((Control)this.label, 2);
        ifd.bottom = new FormAttachment(100, -2);
        ifd.left = new FormAttachment(0, 2);
        ifd.right = new FormAttachment(100, -2);
        this.theTableViewer.getControl().setLayoutData((Object)ifd);
        this.label.setText("Empty.  Click a folder in the Navigator.");
        this.globalSelectionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this.globalSelectionListener);
    }

    void useDirectory(DirTracker newDir) {
        if (this.dir != newDir) {
            if (this.dir != null) {
                this.dir.deleteObserver(this.infstatsObserver);
            }
            this.dir = newDir;
            if (this.dir != null) {
                newDir.addObserver(this.infstatsObserver);
            }
            this.refresh();
        }
    }

    abstract String getInfstatsPartName();

    void refresh() {
        this.theTableViewer.setInput(this.dir == null ? null : this.dir.getCurInfstats());
        if (this.dir == null) {
            this.label.setText("Empty.  Click a folder in the Navigator.");
        } else if (this.is == null) {
            this.label.setText(String.valueOf(this.dir.getPath()) + ": Inference data never loaded");
        } else {
            this.label.setText(String.valueOf(this.dir.getPath()) + " as of " + InfstatsPartView.describeTime((Date)this.is.getLoadDate()));
        }
        this.viewArea.layout();
    }

    private static String describeTime(Date date) {
        return df.format(date);
    }

    public void setFocus() {
        this.theTableViewer.getControl().setFocus();
    }

    public void dispose() {
        this.globalSelectionListener.unregister();
        if (this.dir != null) {
            this.dir.deleteObserver(this.infstatsObserver);
        }
        super.dispose();
    }
}

