/*
 * Decompiled with CFR 0.152.
 */
package cycinf.util;

import cycinf.cvars.usedtype.Identifier;
import cycinf.util.ParseException;
import cycinf.util.ParsePosition;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ParsingUtils {
    private static final Pattern identifierPat = Pattern.compile("(\\d+)I");
    public static int nval;
    public static Identifier ival;

    private ParsingUtils() {
    }

    public static String preprocess(String x) throws ParseException {
        Matcher idMat = identifierPat.matcher(x);
        StringBuilder sb = new StringBuilder(x.length());
        int pos = 0;
        while (idMat.find(pos)) {
            String id;
            int chunkStart = idMat.start();
            sb.append(x.substring(pos, chunkStart));
            int idLen = Integer.parseInt(idMat.group(1));
            int idStart = idMat.end();
            int idEnd = idStart + idLen;
            try {
                id = x.substring(idStart, idEnd);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new ParseException("Failed to preprocess: invalid identifier length", (Throwable)e);
            }
            sb.append('(');
            sb.append(id);
            sb.append(')');
            pos = idEnd;
        }
        sb.append(x.substring(pos));
        return sb.toString();
    }

    public static boolean isValidIdentifier(String x) {
        if (x.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(x.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < x.length()) {
            if (!Character.isJavaIdentifierPart(x.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String validIdentifier(String x) throws ParseException {
        if (ParsingUtils.isValidIdentifier((String)x)) {
            return x;
        }
        throw new ParseException("Bad identifier: " + x);
    }

    public static String chopPrefix(String x, String prefix) {
        if (x.startsWith(prefix)) {
            return x.substring(prefix.length());
        }
        return null;
    }

    public static String chopSuffix(String x, String suffix) {
        if (x.endsWith(suffix)) {
            return x.substring(0, x.length() - suffix.length());
        }
        return null;
    }

    public static String chopNumberSuffix(String x) throws ParseException {
        int i = x.length();
        while (i > 0 && Character.isDigit(x.charAt(i - 1))) {
            --i;
        }
        if (i == x.length()) {
            return null;
        }
        String main = x.substring(0, i);
        try {
            nval = Integer.parseInt(x.substring(i));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Something wrong with a number", (Throwable)e);
        }
        return main;
    }

    public static String chopIdentifierSuffix(String x) throws ParseException {
        if (x.charAt(x.length() - 1) == ')') {
            int b = x.lastIndexOf(40);
            if (b == -1) {
                throw new ParseException("Internal: Badly bounded identifier: " + x);
            }
            ival = Identifier.unwrap((String)x.substring(b, x.length()));
            return x.substring(0, b);
        }
        return null;
    }

    public static String escape(String in) {
        StringBuffer out = new StringBuffer("\"");
        int pos = 0;
        while (pos < in.length()) {
            switch (in.charAt(pos)) {
                case '\n': {
                    out.append("\\n");
                    break;
                }
                case '\t': {
                    out.append("\\t");
                    break;
                }
                case '\\': {
                    out.append("\\\\");
                    break;
                }
                case '\'': {
                    out.append("\\'");
                    break;
                }
                case '\"': {
                    out.append("\\\"");
                    break;
                }
                default: {
                    out.append(in.charAt(pos));
                }
            }
            ++pos;
        }
        out.append('\"');
        return out.toString();
    }

    public static String unescape(String x, ParsePosition used) throws ParseException {
        StringReader is = new StringReader(x);
        StreamTokenizer st = new StreamTokenizer(is);
        try {
            st.nextToken();
        }
        catch (IOException e) {
            throw new RuntimeException("My StringReader should not throw an IOException!", e);
        }
        if (st.ttype != 34) {
            return null;
        }
        used.setIndex(ParsingUtils.escape((String)st.sval).length());
        return st.sval;
    }
}

