/*
 * Decompiled with CFR 0.152.
 */
package cycinf.util;

import cycinf.infstats.DirTracker;
import cycinf.util.ParseException;
import general.util.EqualByStringRepresentation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * Exception performing whole class analysis ignored.
 */
public class SourceLocation
extends EqualByStringRepresentation {
    public static final int UNKNOWN = -1;
    private final String filename;
    private final int line;
    private final int charPos;

    public final String getFilename() {
        return this.filename;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getCharPos() {
        return this.charPos;
    }

    public SourceLocation(String filename, int line, int charPos) {
        this.filename = filename;
        this.line = line;
        this.charPos = charPos;
    }

    public IFile findFileInDir(DirTracker dir) {
        IPath path = Path.fromPortableString((String)this.filename);
        if (path.isAbsolute()) {
            return dir.getDir().getWorkspace().getRoot().getFileForLocation(path);
        }
        return dir.getDir().getFile(Path.fromPortableString((String)this.filename));
    }

    public static SourceLocation parseIfGood(String str) throws ParseException {
        SourceLocation l = SourceLocation.parse((String)str);
        if (l.getFilename().endsWith(".cyp") && l.getLine() == 1 && l.getCharPos() == 0) {
            return null;
        }
        return l;
    }

    public static SourceLocation parse(String str) throws ParseException {
        int charPos;
        int line;
        int firstColon = str.indexOf(58);
        if (firstColon == -1) {
            throw new ParseException("Can't parse as SourceLocation, no colon: " + str);
        }
        String filename = str.substring(0, firstColon);
        String posStr = str.substring(firstColon + 1);
        if (posStr.charAt(0) == '(') {
            int secondColon = posStr.indexOf(58);
            if (secondColon == -1) {
                throw new ParseException("Can't parse as SourceLocation, bad position: " + posStr);
            }
            if (posStr.charAt(posStr.length() - 1) != ')') {
                throw new ParseException("Can't parse as SourceLocation, bad position: " + posStr);
            }
            String lineStr = posStr.substring(1, secondColon);
            String charPosStr = posStr.substring(secondColon + 1, posStr.length() - 1);
            try {
                line = Integer.parseInt(lineStr);
                charPos = Integer.parseInt(charPosStr);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Can't parse as SourceLocation, bad line or character number in position: " + posStr, (Throwable)e);
            }
        }
        try {
            line = Integer.parseInt(posStr);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Can't parse as SourceLocation, bad line number in position: " + posStr, (Throwable)e);
        }
        charPos = -1;
        return new SourceLocation(filename, line, charPos);
    }

    public int locateInString(String source) {
        int curLine = 1;
        int i = 0;
        while (curLine < this.getLine()) {
            if ((i = source.indexOf(10, i)) == -1) {
                return source.length();
            }
            ++i;
            ++curLine;
        }
        if (this.getCharPos() == -1) {
            return i;
        }
        int charsLeft = this.getCharPos();
        int end = source.indexOf(10, i);
        if (end == -1) {
            end = source.length();
        }
        while (charsLeft > 0 && i < end) {
            charsLeft = source.charAt(i) == '\t' ? (charsLeft -= 8) : --charsLeft;
            ++i;
        }
        return i;
    }

    public final String toString() {
        return String.valueOf(this.getFilename()) + ":" + (this.getCharPos() == -1 ? Integer.toString(this.getLine()) : "(" + Integer.toString(this.getLine()) + ":" + Integer.toString(this.getCharPos()) + ")");
    }
}

