/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.progress;

import java.io.IOException;
import java.io.Writer;
import net.loomchild.maligna.progress.ProgressMeter;
import net.loomchild.maligna.progress.ProgressObserver;

public class WriterProgressObserver
implements ProgressObserver {
    public static final char PROGRESS_CHAR = '.';
    private Writer writer;
    private int size;
    private int index;

    public WriterProgressObserver(Writer writer, int size) {
        this.writer = writer;
        this.size = size;
        this.reset();
    }

    @Override
    public void completeTask(ProgressMeter progressMeter) {
        int newIndex = (int)((float)this.size * progressMeter.getProgress());
        if (newIndex > this.index) {
            this.updateIndex(newIndex);
        }
    }

    private void updateIndex(int newIndex) {
        assert (newIndex > this.index && newIndex <= this.size);
        while (this.index < newIndex) {
            this.write('.');
            ++this.index;
        }
    }

    @Override
    public void registerProgressMeter(ProgressMeter progressMeter) {
        this.write(progressMeter.getName() + " [" + progressMeter.getTotalTasks() + " ops] ");
    }

    @Override
    public void unregisterProgressMeter(ProgressMeter progressMeter) {
        this.reset();
        this.write('\n');
    }

    private void reset() {
        this.index = 0;
    }

    private void write(char character) {
        try {
            this.writer.write(character);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void write(String string) {
        try {
            this.writer.write(string);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

