/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.statistics.FileData;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.statistics.StatsResult;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.gui.stat.StatisticsPanel;

public class CalcStandardStatistics
extends LongProcessThread {
    private final StatisticsPanel callback;

    public CalcStandardStatistics(StatisticsPanel callback) {
        this.callback = callback;
    }

    @Override
    public void run() {
        IProject p = Core.getProject();
        StatsResult result = CalcStandardStatistics.buildProjectStats(p);
        this.callback.setProjectTableData(StatsResult.HT_HEADERS, result.getHeaderTable());
        this.callback.setFilesTableData(StatsResult.FT_HEADERS, result.getFilesTable());
        this.callback.setTextData(result.getTextData());
        this.callback.finishData();
        String internalDir = p.getProjectProperties().getProjectInternal();
        try {
            File oldstats = new File(internalDir + "word_counts");
            if (oldstats.exists()) {
                oldstats.delete();
            }
        }
        catch (Exception oldstats) {
            // empty catch block
        }
        String fn = internalDir + "project_stats.txt";
        Statistics.writeStat(fn, result.getTextData());
        this.callback.setDataFile(fn);
    }

    public static StatsResult buildProjectStats(IProject project) {
        StatCount total = new StatCount();
        StatCount remaining = new StatCount();
        StatCount unique = new StatCount();
        StatCount remainingUnique = new StatCount();
        HashMap<Object, SourceTextEntry> uniqueSegment = new HashMap<Object, SourceTextEntry>();
        HashSet<String> translated = new HashSet<String>();
        for (SourceTextEntry ste : project.getAllEntries()) {
            TMXEntry tMXEntry;
            Object src = ste.getSrcText();
            for (ProtectedPart pp : ste.getProtectedParts()) {
                src = ((String)src).replace(pp.getTextInSourceSegment(), pp.getReplacementUniquenessCalculation());
            }
            if (!uniqueSegment.containsKey(src)) {
                uniqueSegment.put(src, ste);
            }
            if (!(tMXEntry = project.getTranslationInfo(ste)).isTranslated()) continue;
            translated.add((String)src);
        }
        HashSet<String> filesUnique = new HashSet<String>();
        HashSet<String> filesRemainingUnique = new HashSet<String>();
        for (Map.Entry entry : uniqueSegment.entrySet()) {
            StatCount count = new StatCount((SourceTextEntry)entry.getValue());
            unique.add(count);
            filesUnique.add(((SourceTextEntry)entry.getValue()).getKey().file);
            if (translated.contains(entry.getKey())) continue;
            remainingUnique.add(count);
            filesRemainingUnique.add(((SourceTextEntry)entry.getValue()).getKey().file);
        }
        unique.addFiles(filesUnique.size());
        remainingUnique.addFiles(filesRemainingUnique.size());
        ArrayList<FileData> counts = new ArrayList<FileData>();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (IProject.FileInfo file : project.getProjectFiles()) {
            FileData numbers = new FileData();
            numbers.filename = file.filePath;
            counts.add(numbers);
            int fileTotal = 0;
            int fileRemaining = 0;
            for (SourceTextEntry ste : file.entries) {
                String src = ste.getSrcText();
                for (ProtectedPart pp : ste.getProtectedParts()) {
                    src = src.replace(pp.getTextInSourceSegment(), pp.getReplacementUniquenessCalculation());
                }
                StatCount count = new StatCount(ste);
                total.add(count);
                fileTotal = 1;
                TMXEntry tr = project.getTranslationInfo(ste);
                if (!tr.isTranslated()) {
                    remaining.add(count);
                    fileRemaining = 1;
                }
                numbers.total.add(count);
                Boolean firstSeen = (Boolean)hashMap.get(src);
                if (firstSeen == null) {
                    hashMap.put(src, false);
                    numbers.unique.add(count);
                    if (!tr.isTranslated()) {
                        numbers.remainingUnique.add(count);
                    }
                }
                if (tr.isTranslated()) continue;
                numbers.remaining.add(count);
            }
            total.addFiles(fileTotal);
            remaining.addFiles(fileRemaining);
        }
        return new StatsResult(total, remaining, unique, remainingUnique, translated, counts);
    }
}

