/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.threads;

import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.omegat.core.Core;
import org.omegat.core.KnownException;
import org.omegat.core.data.IProject;
import org.omegat.core.team2.IRemoteRepository2;
import org.omegat.core.threads.IAutoSave;
import org.omegat.util.Log;
import org.omegat.util.Preferences;

public class SaveThread
extends Thread
implements IAutoSave {
    private static final Logger LOGGER = Logger.getLogger(SaveThread.class.getName());
    private int waitDuration;
    private boolean needToSaveNow;
    private boolean enabled;

    public SaveThread() {
        this.setName("Save thread");
        this.setWaitDuration(Preferences.getPreferenceDefault("auto_save_interval", 180));
        Preferences.addPropertyChangeListener("auto_save_interval", evt -> {
            this.setWaitDuration((Integer)evt.getNewValue());
            SaveThread saveThread = this;
            synchronized (saveThread) {
                this.notify();
            }
        });
    }

    private void setWaitDuration(int seconds) {
        this.waitDuration = seconds * 1000;
    }

    @Override
    public synchronized void disable() {
        Log.logDebug(LOGGER, "Disable autosave", new Object[0]);
        this.enabled = false;
    }

    @Override
    public synchronized void enable() {
        Log.logDebug(LOGGER, "Enable autosave", new Object[0]);
        this.enabled = true;
        this.needToSaveNow = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                SaveThread saveThread = this;
                synchronized (saveThread) {
                    this.needToSaveNow = true;
                    this.wait(this.waitDuration);
                }
                if (!this.needToSaveNow || !this.enabled) continue;
                IProject dataEngine = Core.getProject();
                Log.logDebug(LOGGER, "Start project save from SaveThread", new Object[0]);
                try {
                    Core.executeExclusively(false, () -> {
                        dataEngine.saveProject(false);
                        dataEngine.teamSyncPrepare();
                    });
                    Core.getMainWindow().showStatusMessageRB("ST_PROJECT_AUTOSAVED", DateFormat.getTimeInstance(3).format(new Date()));
                }
                catch (TimeoutException ex) {
                    Log.logWarningRB("AUTOSAVE_LOCK_ACQUISITION_TIMEOUT", new Object[0]);
                }
                catch (KnownException ex) {
                    Core.getMainWindow().showStatusMessageRB(ex.getMessage(), ex.getParams());
                }
                catch (IRemoteRepository2.NetworkException ex) {
                    Log.logWarningRB("TEAM_NETWORK_ERROR", ex.getMessage());
                }
                catch (OutOfMemoryError oome) {
                    long memory = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
                    Log.logErrorRB("OUT_OF_MEMORY", memory);
                    Log.log(oome);
                    Core.getMainWindow().showErrorDialogRB("TF_ERROR", "OUT_OF_MEMORY", memory);
                    System.exit(1);
                }
                catch (Exception ex) {
                    Log.logWarningRB("AUTOSAVE_GENERIC_ERROR", ex.getMessage());
                }
                Log.logDebug(LOGGER, "Finish project save from SaveThread", new Object[0]);
            }
        }
        catch (InterruptedException ex) {
            Log.logDebug(LOGGER, "Save thread interrupted: {0}", ex.getMessage());
            return;
        }
    }
}

