/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.ArithmeticError;
import org.armedbear.lisp.Autoload;
import org.armedbear.lisp.AutoloadMacro;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.Binding;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Closure;
import org.armedbear.lisp.ClosureBinding;
import org.armedbear.lisp.CompiledClosure;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.ControlError;
import org.armedbear.lisp.ControlTransfer;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DivisionByZero;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.FileStream;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.FuncallableStandardObject;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Go;
import org.armedbear.lisp.GrayStream;
import org.armedbear.lisp.IntegrityError;
import org.armedbear.lisp.Interpreter;
import org.armedbear.lisp.JarStream;
import org.armedbear.lisp.JavaClassLoader;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.JavaStackFrame;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Layout;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.MacroObject;
import org.armedbear.lisp.Nil;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.PackageError;
import org.armedbear.lisp.Packages;
import org.armedbear.lisp.ParseError;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Primitives;
import org.armedbear.lisp.ProcessingTerminated;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.RandomState;
import org.armedbear.lisp.Ratio;
import org.armedbear.lisp.Readtable;
import org.armedbear.lisp.Return;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.StackFrame;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.StorageCondition;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.SymbolMacro;
import org.armedbear.lisp.SynonymStream;
import org.armedbear.lisp.ThreadDestroyed;
import org.armedbear.lisp.TwoWayStream;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.URLStream;
import org.armedbear.lisp.UnboundVariable;
import org.armedbear.lisp.UndefinedFunction;

public final class Lisp {
    public static final boolean debug = true;
    public static boolean cold = true;
    public static boolean initialized;
    public static final Package PACKAGE_CL;
    public static final Package PACKAGE_CL_USER;
    public static final Package PACKAGE_KEYWORD;
    public static final Package PACKAGE_SYS;
    public static final Package PACKAGE_MOP;
    public static final Package PACKAGE_TPL;
    public static final Package PACKAGE_EXT;
    public static final Package PACKAGE_JVM;
    public static final Package PACKAGE_LOOP;
    public static final Package PACKAGE_PROF;
    public static final Package PACKAGE_JAVA;
    public static final Package PACKAGE_LISP;
    public static final Package PACKAGE_THREADS;
    public static final Package PACKAGE_FORMAT;
    public static final Package PACKAGE_XP;
    public static final Package PACKAGE_PRECOMPILER;
    public static final Package PACKAGE_SEQUENCE;
    public static final Package PACKAGE_GRAY_STREAMS_JAVA;
    @DocString(name="nil")
    public static final Symbol NIL;
    public static final LispObject EOF;
    public static final int randomStringHashBase;
    public static boolean profiling;
    public static boolean sampling;
    public static volatile boolean sampleNow;
    @DocString(name="interactive-eval")
    private static final Primitive INTERACTIVE_EVAL;
    public static volatile boolean interrupted;
    public static volatile LispThread threadToInterrupt;
    public static final int CALL_REGISTERS_MAX = 8;
    private static final BigInteger INT_MIN;
    private static final BigInteger INT_MAX;
    static final Charset UTF8CHARSET;
    public static final LispObject FUNCTION_NAME;
    public static final LispObject UNSIGNED_BYTE_8;
    public static final LispObject UNSIGNED_BYTE_16;
    public static final LispObject UNSIGNED_BYTE_32;
    public static final LispObject UNSIGNED_BYTE_32_MAX_VALUE;
    static final ConcurrentHashMap<String, LispObject> objectTable;
    public static final Primitive REMEMBER;
    public static final Symbol STANDARD_READTABLE;
    public static final Symbol T;
    public static final Symbol DOUBLE_COLON_PACKAGE_SEPARATORS;
    public static final Symbol _LOAD_DEPTH_;
    public static final Symbol _LOAD_STREAM_;
    public static final Symbol _FASL_LOADER_;
    public static final Symbol _SOURCE_;
    public static final Symbol _SOURCE_POSITION_;
    public static final Symbol _AUTOLOAD_VERBOSE_;
    public static final Symbol AUTOLOADING_CACHE;
    public static final Symbol _COMPILE_FILE_TYPE_;
    public static final Symbol _COMPILE_FILE_CLASS_EXTENSION_;
    public static final Symbol _COMPILE_FILE_ZIP_;
    public static final int ARRAY_DIMENSION_MAX = Integer.MAX_VALUE;
    public static final int CHAR_MAX = 65535;
    public static final Symbol _PRINT_STRUCTURE_;
    public static final Symbol _CURRENT_PRINT_LENGTH_;
    public static final Symbol _CURRENT_PRINT_LEVEL_;
    public static final Symbol _PRINT_FASL_;
    public static final Symbol CALL_REGISTERS_LIMIT;
    public static final Symbol _WARN_ON_REDEFINITION_;
    public static final Symbol _SAVED_BACKTRACE_;
    public static final Symbol _COMMAND_LINE_ARGUMENT_LIST_;
    public static final Symbol _BATCH_MODE_;
    public static final Symbol _NOINFORM_;
    public static final Symbol _DISASSEMBLER_;
    public static final Symbol _SPEED_;
    public static final Symbol _SPACE_;
    public static final Symbol _SAFETY_;
    public static final Symbol _DEBUG_;
    public static final Symbol _EXPLAIN_;
    public static final Symbol _ENABLE_INLINE_EXPANSION_;
    public static final Symbol _REQUIRE_STACK_FRAME_;
    public static final Symbol _COMPILE_FILE_ENVIRONMENT_;
    public static final LispObject UNBOUND_VALUE;
    public static final LispObject NULL_VALUE;
    public static final Symbol _SLOT_UNBOUND_;
    public static final Symbol _CL_PACKAGE_;
    public static final Symbol _KEYWORD_PACKAGE_;
    public static final Symbol _BACKQUOTE_COUNT_;
    public static final Symbol _BQ_VECTOR_FLAG_;
    public static final Symbol _TRACED_NAMES_;
    protected static boolean TRAP_OVERFLOW;
    protected static boolean TRAP_UNDERFLOW;
    private static Stream stdin;
    private static Stream stdout;
    private static final SpecialOperator WITH_INLINE_CODE;
    public static Object UNREACHED;
    public static boolean steppingTask;
    public static boolean stepping;
    public static boolean delimitedStepping;
    public static Binding stepperBlock;
    public static long stepNumber;
    public static final Primitive SET_STEPPING_TASK_ON;
    public static final Primitive SET_STEPPING_TASK_OFF;
    public static final Primitive SET_STEPPER_ON;
    public static final Primitive RETURN_FROM_STEPPER;
    public static final Primitive SET_STEPPER_OFF;
    public static final Primitive SET_DELIMITED_STEPPING_OFF;
    public static final Primitive SET_DELIMITED_STEPPING_ON;
    public static final Primitive INITIALIZE_STEP_COUNTER;
    public static final Primitive GET_STEP_COUNTER;
    public static final Primitive INITIALIZE_STEP_BLOCK;

    public static final LispObject funcall(LispObject fun, LispObject[] args, LispThread thread) {
        thread._values = null;
        switch (args.length) {
            case 0: {
                return thread.execute(fun);
            }
            case 1: {
                return thread.execute(fun, args[0]);
            }
            case 2: {
                return thread.execute(fun, args[0], args[1]);
            }
            case 3: {
                return thread.execute(fun, args[0], args[1], args[2]);
            }
            case 4: {
                return thread.execute(fun, args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return thread.execute(fun, args[0], args[1], args[2], args[3], args[4]);
            }
            case 6: {
                return thread.execute(fun, args[0], args[1], args[2], args[3], args[4], args[5]);
            }
            case 7: {
                return thread.execute(fun, args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
            case 8: {
                return thread.execute(fun, args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
            }
        }
        return thread.execute(fun, args);
    }

    public static final LispObject macroexpand(LispObject form, Environment env, LispThread thread) {
        Symbol expanded = NIL;
        while (true) {
            form = Lisp.macroexpand_1(form, env, thread);
            LispObject[] values = thread._values;
            if (values[1] == NIL) {
                values[1] = expanded;
                return form;
            }
            expanded = T;
        }
    }

    public static final LispObject macroexpand_1(LispObject form, Environment env, LispThread thread) {
        if (form instanceof Cons) {
            LispObject car = ((Cons)form).car;
            if (car instanceof Symbol) {
                Autoload autoload;
                LispObject obj = env.lookupFunction(car);
                if (obj instanceof AutoloadMacro) {
                    autoload = (Autoload)obj;
                    autoload.load();
                    obj = car.getSymbolFunction();
                }
                if (obj instanceof SpecialOperator && (obj = Lisp.get(car, Symbol.MACROEXPAND_MACRO, null)) instanceof Autoload) {
                    autoload = (Autoload)obj;
                    autoload.load();
                    obj = Lisp.get(car, Symbol.MACROEXPAND_MACRO, null);
                }
                if (obj instanceof MacroObject) {
                    LispObject expander = ((MacroObject)obj).expander;
                    if (profiling && !sampling) {
                        expander.incrementCallCount();
                    }
                    LispObject hook = Lisp.coerceToFunction(Symbol.MACROEXPAND_HOOK.symbolValue(thread));
                    return thread.setValues(hook.execute(expander, form, env), T);
                }
            }
        } else if (form instanceof Symbol) {
            Symbol symbol = (Symbol)form;
            LispObject obj = env.lookup(symbol);
            if (obj == null) {
                obj = symbol.getSymbolMacro();
            }
            if (obj instanceof SymbolMacro) {
                return thread.setValues(((SymbolMacro)obj).getExpansion(), T);
            }
        }
        return thread.setValues(form, NIL);
    }

    private static final void pushJavaStackFrames() {
        LispThread thread = LispThread.currentThread();
        StackTraceElement[] frames = thread.getJavaStackTrace();
        if (frames.length > 5 && frames[3].getClassName().equals("org.armedbear.lisp.Lisp") && frames[3].getMethodName().equals("error") && frames[4].getClassName().startsWith("org.armedbear.lisp.Lisp") && frames[4].getMethodName().equals("eval")) {
            return;
        }
        int last2 = frames.length - 1;
        for (int i = 0; i <= last2; ++i) {
            if (!frames[i].getClassName().startsWith("org.armedbear.lisp.Primitive")) continue;
            last2 = i;
        }
        while (last2 > 2) {
            thread.pushStackFrame(new JavaStackFrame(frames[last2]));
            --last2;
        }
    }

    public static final LispObject error(LispObject condition) {
        Lisp.pushJavaStackFrames();
        return Symbol.ERROR.execute(condition);
    }

    public static final LispObject stackError() {
        Lisp.pushJavaStackFrames();
        return Symbol.ERROR.execute(new StorageCondition("Stack overflow."));
    }

    public static final LispObject memoryError(OutOfMemoryError exception) {
        Lisp.pushJavaStackFrames();
        return Symbol.ERROR.execute(new StorageCondition("Out of memory: " + exception.getMessage()));
    }

    public static final int ierror(LispObject condition) {
        Lisp.error(condition);
        return 0;
    }

    public static final String serror(LispObject condition) {
        Lisp.error(condition);
        return "";
    }

    public static final LispObject error(LispObject condition, LispObject message) {
        Lisp.pushJavaStackFrames();
        return Symbol.ERROR.execute(condition, Keyword.FORMAT_CONTROL, message);
    }

    public static final int ierror(LispObject condition, LispObject message) {
        Lisp.error(condition, message);
        return 0;
    }

    public static final String serror(LispObject condition, LispObject message) {
        Lisp.error(condition, message);
        return "";
    }

    public static final LispObject parse_error(String message) {
        return Lisp.error(new ParseError(message));
    }

    public static final LispObject simple_error(String formatControl, Object ... args) {
        LispObject lispArgs = NIL;
        for (int i = 0; i < args.length; ++i) {
            lispArgs = args[i] instanceof LispObject ? lispArgs.push((LispObject)args[i]) : (args[i] instanceof String ? lispArgs.push(new SimpleString((String)args[i])) : lispArgs.push(new JavaObject(args[i])));
        }
        lispArgs = lispArgs.nreverse();
        SimpleString format = new SimpleString(formatControl);
        SimpleError s = new SimpleError(format, lispArgs);
        return Lisp.error(s);
    }

    public static final LispObject type_error(LispObject datum, LispObject expectedType) {
        return Lisp.error(new TypeError(datum, expectedType));
    }

    public static final LispObject type_error(String message, LispObject datum, LispObject expectedType) {
        return Lisp.error(new TypeError(message, datum, expectedType));
    }

    public static final LispObject program_error(String message) {
        return Lisp.error(new ProgramError(message));
    }

    public static final LispObject program_error(LispObject initArgs) {
        return Lisp.error(new ProgramError(initArgs));
    }

    public static final synchronized void setInterrupted(LispThread thread, boolean b) {
        threadToInterrupt = b ? thread : null;
        interrupted = b;
    }

    public static final synchronized void handleInterrupt() {
        LispThread currentThread = LispThread.currentThread();
        LispThread checkThread = threadToInterrupt;
        Lisp.setInterrupted(null, false);
        if (currentThread == threadToInterrupt || threadToInterrupt == null) {
            currentThread.processThreadInterrupts();
        }
        Lisp.setInterrupted(null, false);
    }

    public static final LispObject loadTimeValue(LispObject obj) {
        LispThread thread = LispThread.currentThread();
        if (Symbol.LOAD_TRUENAME.symbolValue(thread) != NIL) {
            return Lisp.eval(obj, new Environment(), thread);
        }
        return NIL;
    }

    public static final LispObject eval(LispObject obj) {
        return Lisp.eval(obj, new Environment(), LispThread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LispObject eval(LispObject obj, Environment env, LispThread thread) {
        thread._values = null;
        if (interrupted) {
            Lisp.handleInterrupt();
        }
        if (thread.isDestroyed()) {
            throw new ThreadDestroyed();
        }
        if (obj instanceof Symbol) {
            LispObject result;
            Symbol symbol = (Symbol)obj;
            if (symbol.isSpecialVariable()) {
                if (symbol.constantp()) {
                    return symbol.getSymbolValue();
                }
                result = thread.lookupSpecial(symbol);
            } else {
                result = env.isDeclaredSpecial(symbol) ? thread.lookupSpecial(symbol) : env.lookup(symbol);
            }
            if (result == null) {
                result = symbol.getSymbolMacro();
                if (result == null) {
                    result = symbol.getSymbolValue();
                }
                if (result == null) {
                    return Lisp.error(new UnboundVariable(obj));
                }
            }
            if (result instanceof SymbolMacro) {
                return Lisp.eval(((SymbolMacro)result).getExpansion(), env, thread);
            }
            return result;
        }
        if (obj instanceof Cons) {
            LispObject first = ((Cons)obj).car;
            if (first instanceof Symbol) {
                LispObject fun = env.lookupFunction(first);
                if (fun instanceof SpecialOperator) {
                    if (profiling && !sampling) {
                        fun.incrementCallCount();
                    }
                    LispObject stepInSymbolResult = Lisp.stepInSymbolP(fun, obj);
                    long stepNumberInternal = 0L;
                    if (stepInSymbolResult != NIL) {
                        stepNumberInternal = ++stepNumber;
                        Lisp.handleStepping(fun, obj != NIL ? ((Cons)obj).cdr : obj, env, LispInteger.getInstance(stepNumberInternal));
                    }
                    LispObject result = fun.execute(((Cons)obj).cdr, env);
                    if (stepInSymbolResult != NIL) {
                        Lisp.printStepValue(stepNumberInternal, result, thread);
                    }
                    Lisp.setStepCounterCompleted(stepNumberInternal);
                    return result;
                }
                if (fun instanceof MacroObject) {
                    try {
                        thread.envStack.push(new Environment(null, NIL, fun));
                        LispObject stepInSymbolResult = Lisp.eval(Lisp.macroexpand(obj, env, thread), env, thread);
                        return stepInSymbolResult;
                    }
                    finally {
                        thread.envStack.pop();
                    }
                }
                if (fun instanceof Autoload) {
                    Autoload autoload = (Autoload)fun;
                    autoload.load();
                    return Lisp.eval(obj, env, thread);
                }
                return Lisp.evalCall(fun != null ? fun : first, ((Cons)obj).cdr, env, thread);
            }
            if (first instanceof Cons && first.car() == Symbol.LAMBDA) {
                Closure closure = new Closure(first, env);
                return Lisp.evalCall(closure, ((Cons)obj).cdr, env, thread);
            }
            return Lisp.program_error("Illegal function object: " + first.princToString() + ".");
        }
        return obj;
    }

    public static final LispObject evalCall(LispObject function, LispObject args, Environment env, LispThread thread) {
        LispObject stepInSymbolResult = Lisp.stepInSymbolP(function, args);
        long stepNumberInternal = 0L;
        if (stepInSymbolResult != NIL) {
            stepNumberInternal = ++stepNumber;
            Lisp.handleStepping(function, args != NIL ? (Cons)args : args, env, LispInteger.getInstance(stepNumber));
        }
        LispObject result = NIL;
        if (args == NIL) {
            result = thread.execute(function);
            if (stepInSymbolResult != NIL) {
                Lisp.printStepValue(stepNumberInternal, result, thread);
            }
            Lisp.setStepCounterCompleted(stepNumberInternal);
            return result;
        }
        LispObject first = Lisp.eval(args.car(), env, thread);
        args = ((Cons)args).cdr;
        if (args == NIL) {
            thread._values = null;
            result = thread.execute(function, first);
            if (stepInSymbolResult != NIL) {
                Lisp.printStepValue(stepNumberInternal, result, thread);
            }
            Lisp.setStepCounterCompleted(stepNumberInternal);
            return result;
        }
        LispObject second = Lisp.eval(args.car(), env, thread);
        args = ((Cons)args).cdr;
        if (args == NIL) {
            thread._values = null;
            result = thread.execute(function, first, second);
            if (stepInSymbolResult != NIL) {
                Lisp.printStepValue(stepNumberInternal, result, thread);
            }
            Lisp.setStepCounterCompleted(stepNumberInternal);
            return result;
        }
        LispObject third = Lisp.eval(args.car(), env, thread);
        args = ((Cons)args).cdr;
        if (args == NIL) {
            thread._values = null;
            result = thread.execute(function, first, second, third);
            if (stepInSymbolResult != NIL) {
                Lisp.printStepValue(stepNumberInternal, result, thread);
            }
            Lisp.setStepCounterCompleted(stepNumberInternal);
            return result;
        }
        LispObject fourth = Lisp.eval(args.car(), env, thread);
        args = ((Cons)args).cdr;
        if (args == NIL) {
            thread._values = null;
            result = thread.execute(function, first, second, third, fourth);
            if (stepInSymbolResult != NIL) {
                Lisp.printStepValue(stepNumberInternal, result, thread);
            }
            Lisp.setStepCounterCompleted(stepNumberInternal);
            return result;
        }
        LispObject fifth = Lisp.eval(args.car(), env, thread);
        args = ((Cons)args).cdr;
        if (args == NIL) {
            thread._values = null;
            result = thread.execute(function, first, second, third, fourth, fifth);
            if (stepInSymbolResult != NIL) {
                Lisp.printStepValue(stepNumberInternal, result, thread);
            }
            Lisp.setStepCounterCompleted(stepNumberInternal);
            return result;
        }
        LispObject sixth = Lisp.eval(args.car(), env, thread);
        args = ((Cons)args).cdr;
        if (args == NIL) {
            thread._values = null;
            result = thread.execute(function, first, second, third, fourth, fifth, sixth);
            if (stepInSymbolResult != NIL) {
                Lisp.printStepValue(stepNumberInternal, result, thread);
            }
            Lisp.setStepCounterCompleted(stepNumberInternal);
            return result;
        }
        LispObject seventh = Lisp.eval(args.car(), env, thread);
        args = ((Cons)args).cdr;
        if (args == NIL) {
            thread._values = null;
            result = thread.execute(function, first, second, third, fourth, fifth, sixth, seventh);
            if (stepInSymbolResult != NIL) {
                Lisp.printStepValue(stepNumberInternal, result, thread);
            }
            Lisp.setStepCounterCompleted(stepNumberInternal);
            return result;
        }
        LispObject eighth = Lisp.eval(args.car(), env, thread);
        args = ((Cons)args).cdr;
        if (args == NIL) {
            thread._values = null;
            result = thread.execute(function, first, second, third, fourth, fifth, sixth, seventh, eighth);
            if (stepInSymbolResult != NIL) {
                Lisp.printStepValue(stepNumberInternal, result, thread);
            }
            Lisp.setStepCounterCompleted(stepNumberInternal);
            return result;
        }
        int length = args.length() + 8;
        LispObject[] array = new LispObject[length];
        array[0] = first;
        array[1] = second;
        array[2] = third;
        array[3] = fourth;
        array[4] = fifth;
        array[5] = sixth;
        array[6] = seventh;
        array[7] = eighth;
        for (int i = 8; i < length; ++i) {
            array[i] = Lisp.eval(args.car(), env, thread);
            args = args.cdr();
        }
        thread._values = null;
        result = thread.execute(function, array);
        if (stepInSymbolResult != NIL) {
            Lisp.printStepValue(stepNumberInternal, result, thread);
        }
        Lisp.setStepCounterCompleted(stepNumberInternal);
        return result;
    }

    public static final LispObject parseBody(LispObject body, boolean documentationAllowed) {
        LispObject decls = NIL;
        LispObject doc = NIL;
        while (body != NIL) {
            LispObject form = body.car();
            if (documentationAllowed && form instanceof AbstractString && body.cdr() != NIL) {
                doc = body.car();
                documentationAllowed = false;
            } else {
                if (!(form instanceof Cons) || form.car() != Symbol.DECLARE) break;
                decls = new Cons(form, decls);
            }
            body = body.cdr();
        }
        return Lisp.list(body, decls.nreverse(), doc);
    }

    public static final LispObject parseSpecials(LispObject forms) {
        LispObject specials = NIL;
        while (forms != NIL) {
            LispObject decls = forms.car();
            Debug.assertTrue(decls instanceof Cons);
            Debug.assertTrue(decls.car() == Symbol.DECLARE);
            for (decls = decls.cdr(); decls != NIL; decls = decls.cdr()) {
                LispObject decl = decls.car();
                if (!(decl instanceof Cons) || decl.car() != Symbol.SPECIAL) continue;
                for (decl = decl.cdr(); decl != NIL; decl = decl.cdr()) {
                    specials = new Cons(Lisp.checkSymbol(decl.car()), specials);
                }
            }
            forms = forms.cdr();
        }
        return specials;
    }

    public static final LispObject progn(LispObject body, Environment env, LispThread thread) {
        LispObject result = NIL;
        while (body != NIL) {
            result = Lisp.eval(body.car(), env, thread);
            body = ((Cons)body).cdr;
        }
        return result;
    }

    public static final LispObject preprocessTagBody(LispObject body, Environment env) {
        LispObject localTags = NIL;
        while (body != NIL) {
            LispObject current = body.car();
            body = ((Cons)body).cdr;
            if (current instanceof Cons) continue;
            env.addTagBinding(current, body);
            localTags = new Cons(current, localTags);
        }
        return localTags;
    }

    public static final LispObject nonLocalGo(LispObject tagbody, LispObject tag) {
        if (tagbody == null) {
            return Lisp.error(new ControlError("Unmatched tag " + tag.princToString() + " for GO outside lexical extent."));
        }
        throw new Go(tagbody, tag);
    }

    static final LispObject nonLocalGo(Binding binding, LispObject tag) {
        if (binding.env.inactive) {
            return Lisp.error(new ControlError("Unmatched tag " + binding.symbol.princToString() + " for GO outside of lexical extent."));
        }
        throw new Go(binding.env, binding.symbol);
    }

    public static final LispObject nonLocalReturn(LispObject blockId, LispObject blockName, LispObject result) {
        if (blockId == null) {
            return Lisp.error(new ControlError("Unmatched block " + blockName.princToString() + " for RETURN-FROM outside lexical extent."));
        }
        throw new Return(blockId, result);
    }

    static final LispObject nonLocalReturn(Binding binding, Symbol block, LispObject result) {
        if (binding == null) {
            return Lisp.error(new LispError("No block named " + block.getName() + " is currently visible."));
        }
        if (binding.env.inactive) {
            return Lisp.error(new ControlError("Unmatched block " + binding.symbol.princToString() + " for RETURN-FROM outside of lexical extent."));
        }
        throw new Return(binding.symbol, binding.value, result);
    }

    public static final LispObject processTagBody(LispObject body, LispObject localTags, Environment env) {
        LispObject remaining = body;
        LispThread thread = LispThread.currentThread();
        while (remaining != NIL) {
            LispObject current = remaining.car();
            if (current instanceof Cons) {
                try {
                    if (((Cons)current).car == Symbol.GO) {
                        LispObject tag;
                        Binding binding;
                        if (interrupted) {
                            Lisp.handleInterrupt();
                        }
                        if ((binding = env.getTagBinding(tag = current.cadr())) == null) {
                            return Lisp.error(new ControlError("No tag named " + tag.princToString() + " is currently visible."));
                        }
                        if (Lisp.memql(tag, localTags) && binding.value != null) {
                            remaining = binding.value;
                            continue;
                        }
                        throw new Go(binding.env, tag);
                    }
                    Lisp.eval(current, env, thread);
                }
                catch (Go go) {
                    Binding binding;
                    LispObject tag;
                    if (go.getTagBody() == env && Lisp.memql(tag = go.getTag(), localTags) && (binding = env.getTagBinding(tag)) != null && binding.value != null) {
                        remaining = binding.value;
                        continue;
                    }
                    throw go;
                }
            }
            remaining = ((Cons)remaining).cdr;
        }
        thread._values = null;
        return NIL;
    }

    static final boolean isSpecial(Symbol sym, LispObject ownSpecials) {
        if (ownSpecials != null) {
            if (sym.isSpecialVariable()) {
                return true;
            }
            while (ownSpecials != NIL) {
                if (sym == ownSpecials.car()) {
                    return true;
                }
                ownSpecials = ownSpecials.cdr();
            }
        }
        return false;
    }

    public static final void bindArg(LispObject ownSpecials, Symbol sym, LispObject value, Environment env, LispThread thread) {
        if (Lisp.isSpecial(sym, ownSpecials)) {
            env.declareSpecial(sym);
            thread.bindSpecial(sym, value);
        } else {
            env.bind(sym, value);
        }
    }

    public static void bindArg(boolean special, Symbol sym, LispObject value, Environment env, LispThread thread) {
        if (special) {
            env.declareSpecial(sym);
            thread.bindSpecial(sym, value);
        } else {
            env.bind(sym, value);
        }
    }

    public static LispObject list(LispObject[] obj) {
        LispObject theList = NIL;
        if (obj.length > 0) {
            for (int i = obj.length - 1; i >= 0; --i) {
                theList = new Cons(obj[i], theList);
            }
        }
        return theList;
    }

    public static final Cons list(LispObject obj1, LispObject ... remaining) {
        Cons theList = null;
        if (remaining.length > 0) {
            theList = new Cons(remaining[remaining.length - 1]);
            for (int i = remaining.length - 2; i >= 0; --i) {
                theList = new Cons(remaining[i], (LispObject)theList);
            }
        }
        return theList == null ? new Cons(obj1) : new Cons(obj1, theList);
    }

    @Deprecated
    public static final Cons list1(LispObject obj1) {
        return new Cons(obj1);
    }

    @Deprecated
    public static final Cons list2(LispObject obj1, LispObject obj2) {
        return new Cons(obj1, (LispObject)new Cons(obj2));
    }

    @Deprecated
    public static final Cons list3(LispObject obj1, LispObject obj2, LispObject obj3) {
        return new Cons(obj1, (LispObject)new Cons(obj2, (LispObject)new Cons(obj3)));
    }

    @Deprecated
    public static final Cons list4(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4) {
        return new Cons(obj1, (LispObject)new Cons(obj2, (LispObject)new Cons(obj3, (LispObject)new Cons(obj4))));
    }

    @Deprecated
    public static final Cons list5(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5) {
        return new Cons(obj1, (LispObject)new Cons(obj2, (LispObject)new Cons(obj3, (LispObject)new Cons(obj4, (LispObject)new Cons(obj5)))));
    }

    @Deprecated
    public static final Cons list6(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5, LispObject obj6) {
        return new Cons(obj1, (LispObject)new Cons(obj2, (LispObject)new Cons(obj3, (LispObject)new Cons(obj4, (LispObject)new Cons(obj5, (LispObject)new Cons(obj6))))));
    }

    @Deprecated
    public static final Cons list7(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5, LispObject obj6, LispObject obj7) {
        return new Cons(obj1, (LispObject)new Cons(obj2, (LispObject)new Cons(obj3, (LispObject)new Cons(obj4, (LispObject)new Cons(obj5, (LispObject)new Cons(obj6, (LispObject)new Cons(obj7)))))));
    }

    @Deprecated
    public static final Cons list8(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5, LispObject obj6, LispObject obj7, LispObject obj8) {
        return new Cons(obj1, (LispObject)new Cons(obj2, (LispObject)new Cons(obj3, (LispObject)new Cons(obj4, (LispObject)new Cons(obj5, (LispObject)new Cons(obj6, (LispObject)new Cons(obj7, (LispObject)new Cons(obj8))))))));
    }

    @Deprecated
    public static final Cons list9(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5, LispObject obj6, LispObject obj7, LispObject obj8, LispObject obj9) {
        return new Cons(obj1, (LispObject)new Cons(obj2, (LispObject)new Cons(obj3, (LispObject)new Cons(obj4, (LispObject)new Cons(obj5, (LispObject)new Cons(obj6, (LispObject)new Cons(obj7, (LispObject)new Cons(obj8, (LispObject)new Cons(obj9)))))))));
    }

    public static final LispObject multipleValueList(LispObject result) {
        LispThread thread = LispThread.currentThread();
        LispObject[] values = thread._values;
        if (values == null) {
            return new Cons(result);
        }
        thread._values = null;
        LispObject list = NIL;
        int i = values.length;
        while (i-- > 0) {
            list = new Cons(values[i], list);
        }
        return list;
    }

    public static final LispObject multipleValueCall1(LispObject result, LispObject function, LispThread thread) {
        LispObject[] values = thread._values;
        thread._values = null;
        if (values == null) {
            return thread.execute(Lisp.coerceToFunction(function), result);
        }
        return Lisp.funcall(Lisp.coerceToFunction(function), values, thread);
    }

    public static final void progvBindVars(LispObject symbols, LispObject values, LispThread thread) {
        for (LispObject list = symbols; list != NIL; list = list.cdr()) {
            LispObject value;
            Symbol symbol = Lisp.checkSymbol(list.car());
            if (values != NIL) {
                value = values.car();
                values = values.cdr();
            } else {
                value = null;
            }
            thread.bindSpecial(symbol, value);
        }
    }

    public static final LispInteger checkInteger(LispObject obj) {
        if (obj instanceof LispInteger) {
            return (LispInteger)obj;
        }
        return (LispInteger)Lisp.type_error(obj, Symbol.INTEGER);
    }

    public static final Symbol checkSymbol(LispObject obj) {
        if (obj instanceof Symbol) {
            return (Symbol)obj;
        }
        return (Symbol)Lisp.type_error(obj, Symbol.SYMBOL);
    }

    public static final LispObject checkList(LispObject obj) {
        if (obj.listp()) {
            return obj;
        }
        return Lisp.type_error(obj, Symbol.LIST);
    }

    public static final AbstractArray checkArray(LispObject obj) {
        if (obj instanceof AbstractArray) {
            return (AbstractArray)obj;
        }
        return (AbstractArray)Lisp.type_error(obj, Symbol.ARRAY);
    }

    public static final AbstractVector checkVector(LispObject obj) {
        if (obj instanceof AbstractVector) {
            return (AbstractVector)obj;
        }
        return (AbstractVector)Lisp.type_error(obj, Symbol.VECTOR);
    }

    public static final DoubleFloat checkDoubleFloat(LispObject obj) {
        if (obj instanceof DoubleFloat) {
            return (DoubleFloat)obj;
        }
        return (DoubleFloat)Lisp.type_error(obj, Symbol.DOUBLE_FLOAT);
    }

    public static final SingleFloat checkSingleFloat(LispObject obj) {
        if (obj instanceof SingleFloat) {
            return (SingleFloat)obj;
        }
        return (SingleFloat)Lisp.type_error(obj, Symbol.SINGLE_FLOAT);
    }

    public static final StackFrame checkStackFrame(LispObject obj) {
        if (obj instanceof StackFrame) {
            return (StackFrame)obj;
        }
        return (StackFrame)Lisp.type_error(obj, Symbol.STACK_FRAME);
    }

    public static final Symbol gensym(LispThread thread) {
        return Lisp.gensym("G", thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Symbol gensym(String prefix, LispThread thread) {
        LispObject oldValue;
        StringBuilder sb = new StringBuilder(prefix);
        Symbol gensymCounter = Symbol.GENSYM_COUNTER;
        SpecialBinding binding = thread.getSpecialBinding(gensymCounter);
        if (binding != null) {
            oldValue = binding.value;
            if ((oldValue instanceof Fixnum || oldValue instanceof Bignum) && Fixnum.ZERO.isLessThanOrEqualTo(oldValue)) {
                binding.value = oldValue.incr();
            } else {
                binding.value = Fixnum.ZERO;
                Lisp.error(new TypeError("The value of *GENSYM-COUNTER* was not a nonnegative integer. Old value: " + oldValue.princToString() + " New value: 0"));
            }
        } else {
            Symbol symbol = gensymCounter;
            synchronized (symbol) {
                oldValue = gensymCounter.getSymbolValue();
                if ((oldValue instanceof Fixnum || oldValue instanceof Bignum) && Fixnum.ZERO.isLessThanOrEqualTo(oldValue)) {
                    gensymCounter.setSymbolValue(oldValue.incr());
                } else {
                    gensymCounter.setSymbolValue(Fixnum.ZERO);
                    Lisp.error(new TypeError("The value of *GENSYM-COUNTER* was not a nonnegative integer. Old value: " + oldValue.princToString() + " New value: 0"));
                }
            }
        }
        if (oldValue instanceof Fixnum) {
            sb.append(((Fixnum)oldValue).value);
        } else if (oldValue instanceof Bignum) {
            sb.append(((Bignum)oldValue).value.toString());
        }
        return new Symbol(new SimpleString(sb));
    }

    public static final String javaString(LispObject arg) {
        if (arg instanceof AbstractString) {
            return arg.getStringValue();
        }
        if (arg instanceof Symbol) {
            return ((Symbol)arg).getName();
        }
        if (arg instanceof LispCharacter) {
            return String.valueOf(new char[]{((LispCharacter)arg).value});
        }
        Lisp.type_error(arg, Lisp.list(Symbol.OR, Symbol.STRING, Symbol.SYMBOL, Symbol.CHARACTER));
        return null;
    }

    public static final LispObject number(long n) {
        if (n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE) {
            return Fixnum.getInstance((int)n);
        }
        return Bignum.getInstance(n);
    }

    public static final LispObject number(BigInteger numerator, BigInteger denominator) {
        BigInteger gcd;
        if (denominator.signum() == 0) {
            Cons operands = new Cons(Bignum.getInstance(numerator), (LispObject)new Cons(Bignum.getInstance(denominator)));
            Cons args = new Cons(Keyword.OPERATION, (LispObject)new Cons(Symbol.SLASH, (LispObject)new Cons(Keyword.OPERANDS, (LispObject)new Cons((LispObject)operands))));
            Lisp.error(new DivisionByZero(args));
        }
        if (denominator.signum() < 0) {
            numerator = numerator.negate();
            denominator = denominator.negate();
        }
        if (!(gcd = numerator.gcd(denominator)).equals(BigInteger.ONE)) {
            numerator = numerator.divide(gcd);
            denominator = denominator.divide(gcd);
        }
        if (denominator.equals(BigInteger.ONE)) {
            return Lisp.number(numerator);
        }
        return new Ratio(numerator, denominator);
    }

    public static final LispObject number(BigInteger n) {
        if (n.compareTo(INT_MIN) >= 0 && n.compareTo(INT_MAX) <= 0) {
            return Fixnum.getInstance(n.intValue());
        }
        return Bignum.getInstance(n);
    }

    public static final int mod(int number, int divisor) {
        int r;
        try {
            r = number % divisor;
        }
        catch (ArithmeticException e) {
            Lisp.error(new ArithmeticError("Division by zero."));
            return 0;
        }
        if (r == 0) {
            return r;
        }
        if (divisor < 0 ? number > 0 : number < 0) {
            return r + divisor;
        }
        return r;
    }

    public static final int mix(long x, long y) {
        long xy = x * 3L + y;
        return (int)(0x1FFFFFFFL & (0x1A510271L ^ xy ^ xy >> 5));
    }

    public static LispObject readObjectFromString(String s) {
        return Lisp.readObjectFromReader(new StringReader(s));
    }

    public static LispObject readObjectFromStream(InputStream s) {
        return Lisp.readObjectFromReader(new InputStreamReader(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LispObject readObjectFromReader(Reader r) {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        try {
            thread.bindSpecial(Symbol.READ_BASE, LispInteger.getInstance(10));
            thread.bindSpecial(Symbol.READ_EVAL, Symbol.T);
            thread.bindSpecial(Symbol.READ_SUPPRESS, Nil.NIL);
            LispObject lispObject = new Stream(Symbol.SYSTEM_STREAM, r).read(true, NIL, false, LispThread.currentThread(), Stream.faslReadtable);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    @Deprecated
    public static final LispObject loadCompiledFunction(String namestring) {
        Pathname name = Pathname.create(namestring);
        byte[] bytes = Lisp.readFunctionBytes(name);
        if (bytes != null) {
            return Lisp.loadClassBytes(bytes);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFunctionBytes(Pathname name) {
        LispThread thread = LispThread.currentThread();
        Pathname load = null;
        LispObject truenameFasl = Symbol.LOAD_TRUENAME_FASL.symbolValue(thread);
        LispObject truename = Symbol.LOAD_TRUENAME.symbolValue(thread);
        load = truenameFasl instanceof Pathname ? Pathname.mergePathnames(name, (Pathname)truenameFasl, Keyword.NEWEST) : (truename instanceof Pathname ? Pathname.mergePathnames(name, (Pathname)truename, Keyword.NEWEST) : (!Symbol.PROBE_FILE.execute(name).equals(NIL) ? name : null));
        InputStream input = null;
        if (load != null) {
            input = load.getInputStream();
        } else {
            URL url = null;
            try {
                url = Lisp.class.getResource(name.getNamestring());
                input = url.openStream();
            }
            catch (IOException e) {
                System.err.println("Failed to read class bytes from boot class " + String.valueOf(url));
                Lisp.error(new LispError("Failed to read class bytes from boot class " + String.valueOf(url)));
            }
        }
        byte[] bytes = new byte[4096];
        try {
            if (input == null) {
                Debug.trace("Pathname: " + String.valueOf(name));
                Debug.trace("load: " + String.valueOf(load));
                Debug.trace("LOAD_TRUENAME_FASL: " + String.valueOf(truenameFasl));
                Debug.trace("LOAD_TRUENAME: " + String.valueOf(truename));
                Debug.assertTrue(input != null);
            }
            int n = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                while (n >= 0) {
                    n = input.read(bytes, 0, 4096);
                    if (n < 0) continue;
                    baos.write(bytes, 0, n);
                }
            }
            catch (IOException e) {
                Debug.trace("Failed to read bytes from '" + name.getNamestring() + "'");
                byte[] byArray = null;
                try {
                    input.close();
                }
                catch (IOException e2) {
                    Debug.trace("Failed to close InputStream: " + String.valueOf(e2));
                }
                return byArray;
            }
            bytes = baos.toByteArray();
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                Debug.trace("Failed to close InputStream: " + String.valueOf(e));
            }
        }
        return bytes;
    }

    public static final Function makeCompiledFunctionFromClass(Class<?> c) {
        try {
            if (c != null) {
                Function obj = (Function)c.newInstance();
                return obj;
            }
            return null;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static final LispObject loadCompiledFunction(InputStream in, int size) {
        byte[] bytes = Lisp.readFunctionBytes(in, size);
        if (bytes != null) {
            return Lisp.loadClassBytes(bytes);
        }
        return Lisp.error(new FileError("Can't read file off stream."));
    }

    private static final byte[] readFunctionBytes(InputStream in, int size) {
        try {
            int bytesRemaining;
            int n;
            byte[] bytes = new byte[size];
            int bytesRead = 0;
            for (bytesRemaining = size; bytesRemaining > 0 && (n = in.read(bytes, bytesRead, bytesRemaining)) >= 0; bytesRemaining -= n) {
                bytesRead += n;
            }
            in.close();
            if (bytesRemaining > 0) {
                Debug.trace("bytesRemaining = " + bytesRemaining);
            }
            return bytes;
        }
        catch (IOException t) {
            Debug.trace(t);
            return null;
        }
    }

    public static final Function loadClassBytes(byte[] bytes) {
        return Lisp.loadClassBytes(bytes, new JavaClassLoader());
    }

    public static final Function loadClassBytes(byte[] bytes, JavaClassLoader cl) {
        Class<?> c = cl.loadClassFromByteArray(null, bytes, 0, bytes.length);
        Function obj = Lisp.makeCompiledFunctionFromClass(c);
        if (obj != null) {
            obj.setClassBytes(bytes);
        }
        return obj;
    }

    public static final LispObject makeCompiledClosure(LispObject template, ClosureBinding[] context) {
        return ((CompiledClosure)template).dup().setContext(context);
    }

    public static final String safeWriteToString(LispObject obj) {
        try {
            return obj.printObject();
        }
        catch (NullPointerException e) {
            Debug.trace(e);
            return "null";
        }
    }

    public static final boolean isValidSetfFunctionName(LispObject obj) {
        if (obj instanceof Cons) {
            Cons cons = (Cons)obj;
            if (cons.car == Symbol.SETF && cons.cdr instanceof Cons) {
                Cons cdr = (Cons)cons.cdr;
                return cdr.car instanceof Symbol && cdr.cdr == NIL;
            }
        }
        return false;
    }

    public static final boolean isValidMacroFunctionName(LispObject obj) {
        if (obj instanceof Cons) {
            Cons cons = (Cons)obj;
            if (cons.car == Symbol.MACRO_FUNCTION && cons.cdr instanceof Cons) {
                Cons cdr = (Cons)cons.cdr;
                return cdr.car instanceof Symbol && cdr.cdr == NIL;
            }
        }
        return false;
    }

    public static final LispObject getUpgradedArrayElementType(LispObject type) {
        if (type instanceof Symbol) {
            if (type == Symbol.CHARACTER || type == Symbol.BASE_CHAR || type == Symbol.STANDARD_CHAR) {
                return Symbol.CHARACTER;
            }
            if (type == Symbol.BIT) {
                return Symbol.BIT;
            }
            if (type == NIL) {
                return NIL;
            }
        }
        if (type == BuiltInClass.CHARACTER) {
            return Symbol.CHARACTER;
        }
        if (type instanceof Cons) {
            if (type.equal(UNSIGNED_BYTE_8)) {
                return type;
            }
            if (type.equal(UNSIGNED_BYTE_16)) {
                return type;
            }
            if (type.equal(UNSIGNED_BYTE_32)) {
                return type;
            }
            LispObject car = type.car();
            if (car == Symbol.INTEGER) {
                LispObject lower = type.cadr();
                LispObject upper = type.cdr().cadr();
                if (lower instanceof Cons) {
                    lower = lower.car().incr();
                }
                if (upper instanceof Cons) {
                    upper = upper.car().decr();
                }
                if (lower.integerp() && upper.integerp()) {
                    int l;
                    if (lower instanceof Fixnum && upper instanceof Fixnum && (l = ((Fixnum)lower).value) >= 0) {
                        int u = ((Fixnum)upper).value;
                        if (u <= 1) {
                            return Symbol.BIT;
                        }
                        if (u <= 255) {
                            return UNSIGNED_BYTE_8;
                        }
                        if (u <= 65535) {
                            return UNSIGNED_BYTE_16;
                        }
                        return UNSIGNED_BYTE_32;
                    }
                    if (lower.isGreaterThanOrEqualTo(Fixnum.ZERO) && lower.isLessThanOrEqualTo(UNSIGNED_BYTE_32_MAX_VALUE) && upper.isLessThanOrEqualTo(UNSIGNED_BYTE_32_MAX_VALUE)) {
                        return UNSIGNED_BYTE_32;
                    }
                }
            } else if (car == Symbol.EQL) {
                LispObject obj = type.cadr();
                if (obj instanceof Fixnum) {
                    int val = ((Fixnum)obj).value;
                    if (val >= 0) {
                        if (val <= 1) {
                            return Symbol.BIT;
                        }
                        if (val <= 255) {
                            return UNSIGNED_BYTE_8;
                        }
                        if (val <= 65535) {
                            return UNSIGNED_BYTE_16;
                        }
                        return UNSIGNED_BYTE_32;
                    }
                } else if (obj instanceof Bignum && obj.isGreaterThanOrEqualTo(Fixnum.ZERO) && obj.isLessThanOrEqualTo(UNSIGNED_BYTE_32_MAX_VALUE)) {
                    return UNSIGNED_BYTE_32;
                }
            } else if (car == Symbol.MEMBER) {
                for (LispObject rest = type.cdr(); rest != NIL; rest = rest.cdr()) {
                    LispObject obj = rest.car();
                    if (obj instanceof LispCharacter) {
                        continue;
                    }
                    return T;
                }
                return Symbol.CHARACTER;
            }
        }
        return T;
    }

    public static final char coerceToJavaChar(LispObject obj) {
        return (char)Fixnum.getValue(obj);
    }

    public static final byte coerceToJavaByte(LispObject obj) {
        return (byte)Fixnum.getValue(obj);
    }

    public static final int coerceToJavaUnsignedInt(LispObject obj) {
        return (int)(obj.longValue() & 0xFFFFFFFFL);
    }

    public static final LispObject coerceFromJavaByte(byte b) {
        return Fixnum.constants[b & 0xFF];
    }

    public static final LispCharacter checkCharacter(LispObject obj) {
        if (obj instanceof LispCharacter) {
            return (LispCharacter)obj;
        }
        return (LispCharacter)Lisp.type_error(obj, Symbol.CHARACTER);
    }

    public static final Package checkPackage(LispObject obj) {
        if (obj instanceof Package) {
            return (Package)obj;
        }
        return (Package)Lisp.type_error(obj, Symbol.PACKAGE);
    }

    public static Pathname checkPathname(LispObject obj) {
        if (obj instanceof Pathname) {
            return (Pathname)obj;
        }
        return (Pathname)Lisp.type_error(obj, Symbol.PATHNAME);
    }

    public static final Function checkFunction(LispObject obj) {
        if (obj instanceof Function) {
            return (Function)obj;
        }
        return (Function)Lisp.type_error(obj, Symbol.FUNCTION);
    }

    public static final Stream checkStream(LispObject obj) {
        if (obj instanceof Stream) {
            return (Stream)obj;
        }
        if (obj.typep(Symbol.STREAM).equal(T)) {
            GrayStream result = GrayStream.findOrCreate(obj);
            return result;
        }
        return (Stream)Lisp.type_error(obj, Symbol.STREAM);
    }

    public static final Stream checkCharacterInputStream(LispObject obj) {
        Stream stream = Lisp.checkStream(obj);
        if (stream.isCharacterInputStream()) {
            return stream;
        }
        return (Stream)Lisp.error(new TypeError("The value " + obj.princToString() + " is not a character input stream."));
    }

    public static final Stream checkCharacterOutputStream(LispObject obj) {
        Stream stream = Lisp.checkStream(obj);
        if (stream.isCharacterOutputStream()) {
            return stream;
        }
        return (Stream)Lisp.error(new TypeError("The value " + obj.princToString() + " is not a character output stream."));
    }

    public static final Stream checkBinaryInputStream(LispObject obj) {
        Stream stream = Lisp.checkStream(obj);
        if (stream.isBinaryInputStream()) {
            return stream;
        }
        return (Stream)Lisp.error(new TypeError("The value " + obj.princToString() + " is not a binary input stream."));
    }

    public static final Stream outSynonymOf(LispObject obj) {
        if (obj instanceof Stream) {
            return (Stream)obj;
        }
        if (obj instanceof StandardObject) {
            return Lisp.checkStream(obj);
        }
        if (obj == T) {
            return Lisp.checkCharacterOutputStream(Symbol.TERMINAL_IO.symbolValue());
        }
        if (obj == NIL) {
            return Lisp.checkCharacterOutputStream(Symbol.STANDARD_OUTPUT.symbolValue());
        }
        return (Stream)Lisp.type_error(obj, Symbol.STREAM);
    }

    public static final Stream inSynonymOf(LispObject obj) {
        if (obj instanceof Stream) {
            return (Stream)obj;
        }
        if (obj instanceof StandardObject) {
            return Lisp.checkStream(obj);
        }
        if (obj == T) {
            return Lisp.checkCharacterInputStream(Symbol.TERMINAL_IO.symbolValue());
        }
        if (obj == NIL) {
            return Lisp.checkCharacterInputStream(Symbol.STANDARD_INPUT.symbolValue());
        }
        return (Stream)Lisp.type_error(obj, Symbol.STREAM);
    }

    public static final void writeByte(int n, LispObject obj) {
        if (n < 0 || n > 255) {
            Lisp.type_error(Fixnum.getInstance(n), UNSIGNED_BYTE_8);
        }
        Lisp.checkStream(obj)._writeByte(n);
    }

    public static final Readtable checkReadtable(LispObject obj) {
        if (obj instanceof Readtable) {
            return (Readtable)obj;
        }
        return (Readtable)Lisp.type_error(obj, Symbol.READTABLE);
    }

    public static final AbstractString checkString(LispObject obj) {
        if (obj instanceof AbstractString) {
            return (AbstractString)obj;
        }
        return (AbstractString)Lisp.type_error(obj, Symbol.STRING);
    }

    public static final Layout checkLayout(LispObject obj) {
        if (obj instanceof Layout) {
            return (Layout)obj;
        }
        return (Layout)Lisp.type_error(obj, Symbol.LAYOUT);
    }

    public static final Readtable designator_readtable(LispObject obj) {
        if (obj == NIL) {
            obj = STANDARD_READTABLE.symbolValue();
        }
        if (obj == null) {
            throw new NullPointerException();
        }
        return Lisp.checkReadtable(obj);
    }

    public static final Environment checkEnvironment(LispObject obj) {
        if (obj instanceof Environment) {
            return (Environment)obj;
        }
        return (Environment)Lisp.type_error(obj, Symbol.ENVIRONMENT);
    }

    public static final void checkBounds(int start, int end, int length) {
        if (start < 0 || end < 0 || start > end || end > length) {
            StringBuilder sb = new StringBuilder("The bounding indices ");
            sb.append(start);
            sb.append(" and ");
            sb.append(end);
            sb.append(" are bad for a sequence of length ");
            sb.append(length);
            sb.append('.');
            Lisp.error(new TypeError(sb.toString()));
        }
    }

    public static final LispObject coerceToFunction(LispObject obj) {
        if (obj instanceof Function) {
            return obj;
        }
        if (obj instanceof FuncallableStandardObject) {
            return obj;
        }
        if (obj instanceof Symbol) {
            LispObject fun = obj.getSymbolFunction();
            if (fun instanceof Function) {
                return (Function)fun;
            }
            if (fun instanceof FuncallableStandardObject) {
                return fun;
            }
        } else if (obj instanceof Cons && obj.car() == Symbol.LAMBDA) {
            return new Closure(obj, new Environment());
        }
        if (obj instanceof Cons && obj.car() == Symbol.NAMED_LAMBDA) {
            LispObject name = obj.cadr();
            if (name instanceof Symbol || Lisp.isValidSetfFunctionName(name)) {
                return new Closure(name, new Cons(Symbol.LAMBDA, obj.cddr()), new Environment());
            }
            return Lisp.type_error(name, FUNCTION_NAME);
        }
        Lisp.error(new UndefinedFunction(obj));
        return null;
    }

    public static final Package coerceToPackage(LispObject obj) {
        if (obj instanceof Package) {
            return (Package)obj;
        }
        String name = Lisp.javaString(obj);
        Package pkg = Lisp.getCurrentPackage().findPackage(name);
        if (pkg != null) {
            return pkg;
        }
        Lisp.error(new PackageError(obj.princToString() + " is not the name of a package.", obj));
        return null;
    }

    public static Pathname coerceToPathname(LispObject arg) {
        if (arg instanceof Pathname) {
            return (Pathname)arg;
        }
        if (arg instanceof AbstractString) {
            return Pathname.create(((AbstractString)arg).toString());
        }
        if (arg instanceof FileStream) {
            return ((FileStream)arg).getPathname();
        }
        if (arg instanceof JarStream) {
            return ((JarStream)arg).getPathname();
        }
        if (arg instanceof URLStream) {
            return ((URLStream)arg).getPathname();
        }
        Lisp.type_error(arg, Lisp.list(Symbol.OR, Symbol.STRING, Symbol.PATHNAME, Symbol.JAR_PATHNAME, Symbol.URL_PATHNAME, Symbol.FILE_STREAM, Symbol.JAR_STREAM, Symbol.URL_STREAM));
        return null;
    }

    public static LispObject assq(LispObject item, LispObject alist) {
        while (alist instanceof Cons) {
            LispObject entry = ((Cons)alist).car;
            if (entry instanceof Cons) {
                if (((Cons)entry).car == item) {
                    return entry;
                }
            } else if (entry != NIL) {
                return Lisp.type_error(entry, Symbol.LIST);
            }
            alist = ((Cons)alist).cdr;
        }
        if (alist != NIL) {
            return Lisp.type_error(alist, Symbol.LIST);
        }
        return NIL;
    }

    public static final boolean memq(LispObject item, LispObject list) {
        while (list instanceof Cons) {
            if (item == ((Cons)list).car) {
                return true;
            }
            list = ((Cons)list).cdr;
        }
        if (list != NIL) {
            Lisp.type_error(list, Symbol.LIST);
        }
        return false;
    }

    public static final boolean memql(LispObject item, LispObject list) {
        while (list instanceof Cons) {
            if (item.eql(((Cons)list).car)) {
                return true;
            }
            list = ((Cons)list).cdr;
        }
        if (list != NIL) {
            Lisp.type_error(list, Symbol.LIST);
        }
        return false;
    }

    public static final LispObject getf(LispObject plist, LispObject indicator, LispObject defaultValue) {
        for (LispObject list = plist; list != NIL; list = list.cddr()) {
            if (list.car() == indicator) {
                return list.cadr();
            }
            if (list.cdr() instanceof Cons) {
                continue;
            }
            return Lisp.error(new TypeError("Malformed property list: " + plist.princToString()));
        }
        return defaultValue;
    }

    public static final LispObject get(LispObject symbol, LispObject indicator) {
        for (LispObject list = Lisp.checkSymbol(symbol).getPropertyList(); list != NIL; list = list.cddr()) {
            if (list.car() != indicator) continue;
            return list.cadr();
        }
        return NIL;
    }

    public static final LispObject get(LispObject symbol, LispObject indicator, LispObject defaultValue) {
        for (LispObject list = Lisp.checkSymbol(symbol).getPropertyList(); list != NIL; list = list.cddr()) {
            if (list.car() != indicator) continue;
            return list.cadr();
        }
        return defaultValue;
    }

    public static final LispObject put(Symbol symbol, LispObject indicator, LispObject value) {
        for (LispObject list = symbol.getPropertyList(); list != NIL; list = list.cddr()) {
            if (list.car() != indicator) continue;
            LispObject rest = list.cdr();
            rest.setCar(value);
            return value;
        }
        symbol.setPropertyList(new Cons(indicator, (LispObject)new Cons(value, symbol.getPropertyList())));
        return value;
    }

    public static final LispObject putf(LispObject plist, LispObject indicator, LispObject value) {
        for (LispObject list = plist; list != NIL; list = list.cddr()) {
            if (list.car() != indicator) continue;
            LispObject rest = list.cdr();
            rest.setCar(value);
            return plist;
        }
        return new Cons(indicator, (LispObject)new Cons(value, plist));
    }

    public static final LispObject remprop(Symbol symbol, LispObject indicator) {
        LispObject prev = null;
        for (LispObject list = Lisp.checkList(symbol.getPropertyList()); list != NIL; list = list.cddr()) {
            if (!(list.cdr() instanceof Cons)) {
                Lisp.error(new ProgramError("The symbol " + symbol.princToString() + " has an odd number of items in its property list."));
            }
            if (list.car() == indicator) {
                if (prev != null) {
                    prev.setCdr(list.cddr());
                } else {
                    symbol.setPropertyList(list.cddr());
                }
                return T;
            }
            prev = list.cdr();
        }
        return NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String format(LispObject formatControl, LispObject formatArguments) {
        LispThread thread = LispThread.currentThread();
        String control = formatControl.getStringValue();
        LispObject[] args = formatArguments.copyToArray();
        StringBuffer sb = new StringBuffer();
        if (control != null) {
            int limit = control.length();
            int j = 0;
            boolean NEUTRAL = false;
            boolean TILDE = true;
            boolean state = false;
            for (int i = 0; i < limit; ++i) {
                char c = control.charAt(i);
                if (!state) {
                    if (c == '~') {
                        state = true;
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (state) {
                    if (c == 'A' || c == 'a') {
                        if (j < args.length) {
                            obj = args[j++];
                            mark = thread.markSpecialBindings();
                            thread.bindSpecial(Symbol.PRINT_ESCAPE, NIL);
                            thread.bindSpecial(Symbol.PRINT_READABLY, NIL);
                            try {
                                sb.append(obj.printObject());
                            }
                            finally {
                                thread.resetSpecialBindings(mark);
                            }
                        }
                    } else if (c == 'S' || c == 's') {
                        if (j < args.length) {
                            obj = args[j++];
                            mark = thread.markSpecialBindings();
                            thread.bindSpecial(Symbol.PRINT_ESCAPE, T);
                            try {
                                sb.append(obj.printObject());
                            }
                            finally {
                                thread.resetSpecialBindings(mark);
                            }
                        }
                    } else if (c == 'D' || c == 'd') {
                        if (j < args.length) {
                            obj = args[j++];
                            mark = thread.markSpecialBindings();
                            thread.bindSpecial(Symbol.PRINT_ESCAPE, NIL);
                            thread.bindSpecial(Symbol.PRINT_RADIX, NIL);
                            thread.bindSpecial(Symbol.PRINT_BASE, Fixnum.constants[10]);
                            try {
                                sb.append(obj.printObject());
                            }
                            finally {
                                thread.resetSpecialBindings(mark);
                            }
                        }
                    } else if (c == 'X' || c == 'x') {
                        if (j < args.length) {
                            obj = args[j++];
                            mark = thread.markSpecialBindings();
                            thread.bindSpecial(Symbol.PRINT_ESCAPE, NIL);
                            thread.bindSpecial(Symbol.PRINT_RADIX, NIL);
                            thread.bindSpecial(Symbol.PRINT_BASE, Fixnum.constants[16]);
                            try {
                                sb.append(obj.printObject());
                            }
                            finally {
                                thread.resetSpecialBindings(mark);
                            }
                        }
                    } else if (c == '%') {
                        sb.append('\n');
                    }
                    state = false;
                    continue;
                }
                Debug.assertTrue(false);
            }
        }
        return sb.toString();
    }

    public static final Symbol intern(String name, Package pkg) {
        return pkg.intern(name);
    }

    public static final Symbol internInPackage(String name, String packageName) {
        Package pkg = Lisp.getCurrentPackage().findPackage(packageName);
        if (pkg == null) {
            Lisp.error(new LispError(packageName + " is not the name of a package."));
        }
        return pkg.intern(name);
    }

    public static final Symbol internKeyword(String s) {
        return PACKAGE_KEYWORD.intern(s);
    }

    public static LispObject recall(String key) {
        return objectTable.remove(key);
    }

    public static LispObject recall(SimpleString key) {
        return objectTable.remove(key.getStringValue());
    }

    public static final Symbol internSpecial(String name, Package pkg, LispObject value) {
        Symbol symbol = pkg.intern(name);
        symbol.setSpecial(true);
        symbol.setSymbolValue(value);
        return symbol;
    }

    public static final Symbol internConstant(String name, Package pkg, LispObject value) {
        Symbol symbol = pkg.intern(name);
        symbol.initializeConstant(value);
        return symbol;
    }

    public static final Symbol exportSpecial(String name, Package pkg, LispObject value) {
        Symbol symbol = pkg.intern(name);
        pkg.export(symbol);
        symbol.setSpecial(true);
        symbol.setSymbolValue(value);
        return symbol;
    }

    public static final Symbol exportConstant(String name, Package pkg, LispObject value) {
        Symbol symbol = pkg.intern(name);
        pkg.export(symbol);
        symbol.initializeConstant(value);
        return symbol;
    }

    public static final Package getCurrentPackage() {
        return (Package)Symbol._PACKAGE_.symbolValueNoThrow();
    }

    public static final void resetIO(Stream in, Stream out) {
        stdin = in;
        stdout = out;
        Symbol.STANDARD_INPUT.setSymbolValue(stdin);
        Symbol.STANDARD_OUTPUT.setSymbolValue(stdout);
        Symbol.ERROR_OUTPUT.setSymbolValue(stdout);
        Symbol.TRACE_OUTPUT.setSymbolValue(stdout);
        Symbol.TERMINAL_IO.setSymbolValue(new TwoWayStream(stdin, stdout, true));
        Symbol.QUERY_IO.setSymbolValue(new TwoWayStream(stdin, stdout, true));
        Symbol.DEBUG_IO.setSymbolValue(new TwoWayStream(stdin, stdout, true));
    }

    public static final void resetIO() {
        Lisp.resetIO(new Stream(Symbol.SYSTEM_STREAM, System.in, (LispObject)Symbol.CHARACTER, true), new Stream(Symbol.SYSTEM_STREAM, (OutputStream)System.out, (LispObject)Symbol.CHARACTER, true));
    }

    public static final TwoWayStream getTerminalIO() {
        return (TwoWayStream)Symbol.TERMINAL_IO.symbolValueNoThrow();
    }

    public static final Stream getStandardInput() {
        return (Stream)Symbol.STANDARD_INPUT.symbolValueNoThrow();
    }

    public static final Stream getStandardOutput() {
        LispObject value = Symbol.STANDARD_OUTPUT.symbolValue();
        value = SynonymStream.OUT_SYNONYM_OF.execute(value);
        Stream result = Lisp.checkStream(value);
        return Lisp.checkCharacterOutputStream(result);
    }

    public static final Readtable currentReadtable() {
        return (Readtable)Symbol.CURRENT_READTABLE.symbolValue();
    }

    public static void exit(int status) {
        Interpreter interpreter = Interpreter.getInstance();
        if (interpreter != null) {
            interpreter.kill(status);
        }
    }

    private static final void loadClass(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Debug.trace(e);
        }
    }

    public static LispObject stepInSymbolP(LispObject fun, LispObject obj) {
        LispThread currentThread = LispThread.currentThread();
        if (steppingTask) {
            return NIL;
        }
        if (stepping) {
            Package stepper = Packages.findPackageGlobally("ABCL-STEPPER");
            Symbol symbol = stepper.findAccessibleSymbol("STEP-IN-SYMBOL-P");
            LispObject stepInSymbolPFunction = Lisp.coerceToFunction(symbol);
            LispObject result = Lisp.funcall(stepInSymbolPFunction, new LispObject[]{fun, obj, LispObject.getInstance(delimitedStepping)}, currentThread);
            return result;
        }
        return NIL;
    }

    public static final synchronized void handleStepping(LispObject function, LispObject args, Environment env, LispInteger stepCount) {
        LispThread currentThread = LispThread.currentThread();
        Package stepper = Packages.findPackageGlobally("ABCL-STEPPER");
        Symbol symbolPprintFormToStep = stepper.findAccessibleSymbol("PPRINT-FORM-TO-STEP");
        Symbol symbolHandleUserInteraction = stepper.findAccessibleSymbol("HANDLE-USER-INTERACTION");
        LispObject functionPprintFormToStep = Lisp.coerceToFunction(symbolPprintFormToStep);
        LispObject functionHandleUserInteraction = Lisp.coerceToFunction(symbolHandleUserInteraction);
        if (stepperBlock == null) {
            stepperBlock = env.getOuterMostBlock();
        }
        if (function instanceof FuncallableStandardObject) {
            function = ((FuncallableStandardObject)function).function;
        }
        LispObject closureName = ((Operator)function).getLambdaName();
        Lisp.setSteppingOff();
        if (closureName != null) {
            Lisp.funcall(functionPprintFormToStep, new LispObject[]{closureName, args, stepCount}, currentThread);
        } else {
            Lisp.funcall(functionPprintFormToStep, new LispObject[]{(Operator)function, args, stepCount}, currentThread);
        }
        Lisp.setSteppingOn();
        Lisp.funcall(functionHandleUserInteraction, new LispObject[]{env}, currentThread);
    }

    public static final void printStepValue(long stepNumberInternal, LispObject result, LispThread thread) {
        Package stepper = Packages.findPackageGlobally("ABCL-STEPPER");
        Symbol symbolPrintStepperStr = stepper.findAccessibleSymbol("PRINT-STEPPER-STR");
        LispObject functionPrintStepperStr = Lisp.coerceToFunction(symbolPrintStepperStr);
        LispObject[] values = thread._values;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                Lisp.funcall(functionPrintStepperStr, new LispObject[]{new SimpleString("step " + stepNumberInternal + " ==> value: " + values[i].printObject()), Symbol.T}, thread);
            }
        } else {
            Lisp.funcall(functionPrintStepperStr, new LispObject[]{new SimpleString("step " + stepNumberInternal + " ==> value: " + result.printObject()), Symbol.T}, thread);
        }
        thread._values = values;
    }

    public static final void setStepCounterCompleted(long stepNumberInternal) {
        if (stepping) {
            LispThread currentThread = LispThread.currentThread();
            Package stepper = Packages.findPackageGlobally("ABCL-STEPPER");
            Symbol symbolSetStepCounterCompleted = stepper.findAccessibleSymbol("SET-STEP-COUNTER-COMPLETED");
            LispObject functionSetStepCounterCompleted = Lisp.coerceToFunction(symbolSetStepCounterCompleted);
            LispObject[] values = currentThread._values;
            Lisp.funcall(functionSetStepCounterCompleted, new LispObject[]{LispInteger.getInstance(stepNumberInternal)}, currentThread);
            currentThread._values = values;
        }
    }

    public static void setSteppingTaskOn() {
        steppingTask = true;
    }

    public static void setSteppingTaskOff() {
        steppingTask = false;
    }

    public static void setDelimitedSteppingOn() {
        delimitedStepping = true;
    }

    public static void setDelimitedSteppingOff() {
        delimitedStepping = false;
    }

    public static void setSteppingOn() {
        stepping = true;
    }

    public static void initializeStepCounter() {
        stepNumber = 0L;
    }

    public static LispObject getStepCounter() {
        return LispInteger.getInstance(stepNumber);
    }

    public static void setSteppingOff() {
        stepping = false;
    }

    public static void initializeStepBlock() {
        stepperBlock = null;
    }

    static {
        PACKAGE_CL = Packages.createPackage("COMMON-LISP", 2048);
        PACKAGE_CL_USER = Packages.createPackage("COMMON-LISP-USER", 1024);
        PACKAGE_KEYWORD = Packages.createPackage("KEYWORD", 1024);
        PACKAGE_SYS = Packages.createPackage("SYSTEM", 2048);
        PACKAGE_MOP = Packages.createPackage("MOP", 512);
        PACKAGE_TPL = Packages.createPackage("TOP-LEVEL", 128);
        PACKAGE_EXT = Packages.createPackage("EXTENSIONS", 256);
        PACKAGE_JVM = Packages.createPackage("JVM", 2048);
        PACKAGE_LOOP = Packages.createPackage("LOOP", 512);
        PACKAGE_PROF = Packages.createPackage("PROFILER");
        PACKAGE_JAVA = Packages.createPackage("JAVA");
        PACKAGE_LISP = Packages.createPackage("LISP");
        PACKAGE_THREADS = Packages.createPackage("THREADS");
        PACKAGE_FORMAT = Packages.createPackage("FORMAT");
        PACKAGE_XP = Packages.createPackage("XP");
        PACKAGE_PRECOMPILER = Packages.createPackage("PRECOMPILER");
        PACKAGE_SEQUENCE = Packages.createPackage("SEQUENCE", 128);
        PACKAGE_GRAY_STREAMS_JAVA = Packages.createPackage("GRAY-STREAMS/JAVA");
        NIL = Nil.NIL;
        PACKAGE_CL.addNickname("CL");
        PACKAGE_CL_USER.addNickname("CL-USER");
        PACKAGE_CL_USER.usePackage(PACKAGE_CL);
        PACKAGE_CL_USER.usePackage(PACKAGE_EXT);
        PACKAGE_CL_USER.usePackage(PACKAGE_JAVA);
        PACKAGE_SYS.addNickname("SYS");
        PACKAGE_SYS.usePackage(PACKAGE_CL);
        PACKAGE_SYS.usePackage(PACKAGE_EXT);
        PACKAGE_MOP.usePackage(PACKAGE_CL);
        PACKAGE_MOP.usePackage(PACKAGE_EXT);
        PACKAGE_MOP.usePackage(PACKAGE_SYS);
        PACKAGE_TPL.addNickname("TPL");
        PACKAGE_TPL.usePackage(PACKAGE_CL);
        PACKAGE_TPL.usePackage(PACKAGE_EXT);
        PACKAGE_EXT.addNickname("EXT");
        PACKAGE_EXT.usePackage(PACKAGE_CL);
        PACKAGE_EXT.usePackage(PACKAGE_THREADS);
        PACKAGE_JVM.usePackage(PACKAGE_CL);
        PACKAGE_JVM.usePackage(PACKAGE_EXT);
        PACKAGE_JVM.usePackage(PACKAGE_SYS);
        PACKAGE_LOOP.usePackage(PACKAGE_CL);
        PACKAGE_PROF.addNickname("PROF");
        PACKAGE_PROF.usePackage(PACKAGE_CL);
        PACKAGE_PROF.usePackage(PACKAGE_EXT);
        PACKAGE_JAVA.usePackage(PACKAGE_CL);
        PACKAGE_JAVA.usePackage(PACKAGE_EXT);
        PACKAGE_LISP.usePackage(PACKAGE_CL);
        PACKAGE_LISP.usePackage(PACKAGE_EXT);
        PACKAGE_LISP.usePackage(PACKAGE_SYS);
        PACKAGE_THREADS.usePackage(PACKAGE_CL);
        PACKAGE_THREADS.usePackage(PACKAGE_EXT);
        PACKAGE_THREADS.usePackage(PACKAGE_SYS);
        PACKAGE_FORMAT.usePackage(PACKAGE_CL);
        PACKAGE_FORMAT.usePackage(PACKAGE_EXT);
        PACKAGE_XP.usePackage(PACKAGE_CL);
        PACKAGE_PRECOMPILER.addNickname("PRE");
        PACKAGE_PRECOMPILER.usePackage(PACKAGE_CL);
        PACKAGE_PRECOMPILER.usePackage(PACKAGE_EXT);
        PACKAGE_PRECOMPILER.usePackage(PACKAGE_SYS);
        PACKAGE_SEQUENCE.usePackage(PACKAGE_CL);
        PACKAGE_GRAY_STREAMS_JAVA.usePackage(PACKAGE_CL);
        EOF = new LispObject();
        randomStringHashBase = (int)new Date().getTime();
        INTERACTIVE_EVAL = new Primitive("interactive-eval", PACKAGE_SYS, true){

            @Override
            public LispObject execute(LispObject object) {
                LispObject result;
                LispThread thread = LispThread.currentThread();
                thread.setSpecialVariable(Symbol.MINUS, object);
                try {
                    result = thread.execute(Symbol.EVAL.getSymbolFunction(), object);
                }
                catch (OutOfMemoryError e) {
                    return Lisp.error(new StorageCondition("Out of memory " + e.getMessage()));
                }
                catch (StackOverflowError e) {
                    thread.setSpecialVariable(_SAVED_BACKTRACE_, thread.backtrace(0));
                    return Lisp.error(new StorageCondition("Stack overflow."));
                }
                catch (ControlTransfer c) {
                    throw c;
                }
                catch (ProcessingTerminated c) {
                    throw c;
                }
                catch (IntegrityError c) {
                    throw c;
                }
                catch (Throwable t) {
                    Debug.trace(t);
                    thread.setSpecialVariable(_SAVED_BACKTRACE_, thread.backtrace(0));
                    return Lisp.error(new LispError("Caught " + String.valueOf(t) + "."));
                }
                Debug.assertTrue(result != null);
                thread.setSpecialVariable(Symbol.STAR_STAR_STAR, thread.safeSymbolValue(Symbol.STAR_STAR));
                thread.setSpecialVariable(Symbol.STAR_STAR, thread.safeSymbolValue(Symbol.STAR));
                thread.setSpecialVariable(Symbol.STAR, result);
                thread.setSpecialVariable(Symbol.PLUS_PLUS_PLUS, thread.safeSymbolValue(Symbol.PLUS_PLUS));
                thread.setSpecialVariable(Symbol.PLUS_PLUS, thread.safeSymbolValue(Symbol.PLUS));
                thread.setSpecialVariable(Symbol.PLUS, thread.safeSymbolValue(Symbol.MINUS));
                LispObject[] values = thread._values;
                thread.setSpecialVariable(Symbol.SLASH_SLASH_SLASH, thread.safeSymbolValue(Symbol.SLASH_SLASH));
                thread.setSpecialVariable(Symbol.SLASH_SLASH, thread.safeSymbolValue(Symbol.SLASH));
                if (values != null) {
                    LispObject slash = NIL;
                    int i = values.length;
                    while (i-- > 0) {
                        slash = new Cons(values[i], slash);
                    }
                    thread.setSpecialVariable(Symbol.SLASH, slash);
                } else {
                    thread.setSpecialVariable(Symbol.SLASH, new Cons(result));
                }
                return result;
            }
        };
        Symbol.GENSYM_COUNTER.initializeSpecial(Fixnum.ZERO);
        INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
        INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
        UTF8CHARSET = Charset.forName("UTF-8");
        FUNCTION_NAME = Lisp.list(Symbol.OR, Symbol.SYMBOL, Lisp.list(Symbol.CONS, Lisp.list(Symbol.EQL, Symbol.SETF), Lisp.list(Symbol.CONS, Symbol.SYMBOL, Symbol.NULL)));
        UNSIGNED_BYTE_8 = Lisp.list(Symbol.UNSIGNED_BYTE, Fixnum.constants[8]);
        UNSIGNED_BYTE_16 = Lisp.list(Symbol.UNSIGNED_BYTE, Fixnum.constants[16]);
        UNSIGNED_BYTE_32 = Lisp.list(Symbol.UNSIGNED_BYTE, Fixnum.constants[32]);
        UNSIGNED_BYTE_32_MAX_VALUE = Bignum.getInstance(0xFFFFFFFFL);
        objectTable = new ConcurrentHashMap();
        REMEMBER = new Primitive("remember", PACKAGE_SYS, true){

            @Override
            public LispObject execute(LispObject key, LispObject value) {
                objectTable.put(key.getStringValue(), value);
                return NIL;
            }
        };
        String userDir = System.getProperty("user.dir");
        if (userDir != null && userDir.length() > 0 && userDir.charAt(userDir.length() - 1) != File.separatorChar) {
            userDir = userDir.concat(File.separator);
        }
        Symbol.DEFAULT_PATHNAME_DEFAULTS.initializeSpecial(new SimpleString(userDir));
        Symbol._PACKAGE_.initializeSpecial(PACKAGE_CL_USER);
        Symbol.CURRENT_READTABLE.initializeSpecial(new Readtable());
        STANDARD_READTABLE = Lisp.internConstant("+STANDARD-READTABLE+", PACKAGE_SYS, new Readtable());
        Symbol.READ_SUPPRESS.initializeSpecial(NIL);
        Symbol.DEBUGGER_HOOK.initializeSpecial(NIL);
        Symbol.MOST_POSITIVE_FIXNUM.initializeConstant(Fixnum.getInstance(Integer.MAX_VALUE));
        Symbol.MOST_NEGATIVE_FIXNUM.initializeConstant(Fixnum.getInstance(Integer.MIN_VALUE));
        Symbol.MOST_POSITIVE_JAVA_LONG.initializeConstant(Bignum.getInstance(Long.MAX_VALUE));
        Symbol.MOST_NEGATIVE_JAVA_LONG.initializeConstant(Bignum.getInstance(Long.MIN_VALUE));
        T = Symbol.T;
        T.initializeConstant(T);
        Symbol.READ_EVAL.initializeSpecial(T);
        String osName = System.getProperty("os.name");
        String javaVersion = System.getProperty("java.version");
        String osArch = System.getProperty("os.arch");
        LispObject featureList = Lisp.list(Keyword.ARMEDBEAR, Keyword.ABCL, Keyword.COMMON_LISP, Keyword.ANSI_CL, Keyword.CDR6, Keyword.MOP, Lisp.internKeyword("PACKAGE-LOCAL-NICKNAMES"));
        featureList = featureList.push(Lisp.internKeyword("JVM-" + javaVersion));
        String platformVersion = null;
        if (javaVersion.startsWith("1.")) {
            i = javaVersion.indexOf(".", 2);
            platformVersion = javaVersion.substring(2, i);
        } else {
            i = javaVersion.indexOf(".");
            platformVersion = i >= 0 ? javaVersion.substring(0, i) : javaVersion;
        }
        try {
            Integer.parseInt(javaVersion);
        }
        catch (NumberFormatException e) {
            for (int i = 0; i < javaVersion.length(); ++i) {
                char c = javaVersion.charAt(i);
                if (Character.isDigit(c)) continue;
                featureList.push(Lisp.internKeyword("JAVA-" + javaVersion));
                platformVersion = javaVersion.substring(0, i);
                break;
            }
        }
        featureList = featureList.push(Lisp.internKeyword("JAVA-" + platformVersion));
        if (javaVersion.startsWith("1.5")) {
            featureList = new Cons(Keyword.JAVA_1_5, featureList);
        } else if (javaVersion.startsWith("1.6")) {
            featureList = new Cons(Keyword.JAVA_1_6, featureList);
        } else if (javaVersion.startsWith("1.7")) {
            featureList = new Cons(Keyword.JAVA_1_7, featureList);
        } else if (javaVersion.startsWith("1.8")) {
            featureList = new Cons(Keyword.JAVA_1_8, featureList);
        }
        if (osName.startsWith("Linux")) {
            featureList = Primitives.APPEND.execute((LispObject)Lisp.list(Keyword.UNIX, Keyword.LINUX), featureList);
        } else if (osName.startsWith("SunOS")) {
            featureList = Primitives.APPEND.execute((LispObject)Lisp.list(Keyword.UNIX, Keyword.SUNOS, Keyword.SOLARIS), featureList);
        } else if (osName.startsWith("Mac OS X") || osName.startsWith("Darwin")) {
            featureList = Primitives.APPEND.execute((LispObject)Lisp.list(Keyword.UNIX, Keyword.DARWIN), featureList);
        } else if (osName.startsWith("FreeBSD")) {
            featureList = Primitives.APPEND.execute((LispObject)Lisp.list(Keyword.UNIX, Keyword.FREEBSD), featureList);
        } else if (osName.startsWith("OpenBSD")) {
            featureList = Primitives.APPEND.execute((LispObject)Lisp.list(Keyword.UNIX, Keyword.OPENBSD), featureList);
        } else if (osName.startsWith("NetBSD")) {
            featureList = Primitives.APPEND.execute((LispObject)Lisp.list(Keyword.UNIX, Keyword.NETBSD), featureList);
        } else if (osName.startsWith("Windows")) {
            featureList = new Cons(Keyword.WINDOWS, featureList);
        }
        if (osArch != null) {
            featureList = osArch.equals("amd64") || osArch.equals("x86_64") ? featureList.push(Keyword.X86_64) : (osArch.equals("x86") || osArch.equals("i386") ? featureList.push(Keyword.X86) : featureList.push(Lisp.internKeyword(osArch.toUpperCase())));
        }
        if (LispThread.virtualThreadingAvailable()) {
            featureList = featureList.push(Lisp.internKeyword("VIRTUAL-THREADS"));
        }
        Symbol.FEATURES.initializeSpecial(featureList);
        Symbol.MODULES.initializeSpecial(NIL);
        Symbol.LOAD_VERBOSE.initializeSpecial(NIL);
        Symbol.LOAD_PRINT.initializeSpecial(NIL);
        Symbol.LOAD_PATHNAME.initializeSpecial(NIL);
        Symbol.LOAD_TRUENAME.initializeSpecial(NIL);
        Symbol.LOAD_TRUENAME_FASL.initializeSpecial(NIL);
        Symbol.COMPILE_VERBOSE.initializeSpecial(T);
        Symbol.COMPILE_PRINT.initializeSpecial(T);
        Symbol._COMPILE_FILE_PATHNAME_.initializeSpecial(NIL);
        Symbol.COMPILE_FILE_TRUENAME.initializeSpecial(NIL);
        DOUBLE_COLON_PACKAGE_SEPARATORS = Lisp.internSpecial("*DOUBLE-COLON-PACKAGE-SEPARATORS*", PACKAGE_SYS, NIL);
        _LOAD_DEPTH_ = Lisp.internSpecial("*LOAD-DEPTH*", PACKAGE_SYS, Fixnum.ZERO);
        _LOAD_STREAM_ = Lisp.internSpecial("*LOAD-STREAM*", PACKAGE_SYS, NIL);
        _FASL_LOADER_ = Lisp.exportSpecial("*FASL-LOADER*", PACKAGE_SYS, NIL);
        _SOURCE_ = Lisp.exportSpecial("*SOURCE*", PACKAGE_SYS, NIL);
        _SOURCE_POSITION_ = Lisp.exportSpecial("*SOURCE-POSITION*", PACKAGE_SYS, NIL);
        _AUTOLOAD_VERBOSE_ = Lisp.exportSpecial("*AUTOLOAD-VERBOSE*", PACKAGE_EXT, NIL);
        AUTOLOADING_CACHE = Lisp.internSpecial("*AUTOLOADING-CACHE*", PACKAGE_SYS, NIL);
        _COMPILE_FILE_TYPE_ = Lisp.exportSpecial("*COMPILE-FILE-TYPE*", PACKAGE_SYS, new SimpleString("abcl"));
        _COMPILE_FILE_CLASS_EXTENSION_ = Lisp.exportSpecial("*COMPILE-FILE-CLASS-EXTENSION*", PACKAGE_SYS, new SimpleString("cls"));
        _COMPILE_FILE_ZIP_ = Lisp.exportSpecial("*COMPILE-FILE-ZIP*", PACKAGE_SYS, T);
        Symbol.MACROEXPAND_HOOK.initializeSpecial(Symbol.FUNCALL);
        Symbol.ARRAY_DIMENSION_LIMIT.initializeConstant(Fixnum.getInstance(Integer.MAX_VALUE));
        Symbol.CHAR_CODE_LIMIT.initializeConstant(Fixnum.getInstance(65536));
        Symbol.READ_BASE.initializeSpecial(Fixnum.constants[10]);
        Symbol.READ_DEFAULT_FLOAT_FORMAT.initializeSpecial(Symbol.SINGLE_FLOAT);
        Symbol.PRINT_ARRAY.initializeSpecial(T);
        Symbol.PRINT_BASE.initializeSpecial(Fixnum.constants[10]);
        Symbol.PRINT_CASE.initializeSpecial(Keyword.UPCASE);
        Symbol.PRINT_CIRCLE.initializeSpecial(NIL);
        Symbol.PRINT_ESCAPE.initializeSpecial(T);
        Symbol.PRINT_GENSYM.initializeSpecial(T);
        Symbol.PRINT_LENGTH.initializeSpecial(NIL);
        Symbol.PRINT_LEVEL.initializeSpecial(NIL);
        Symbol.PRINT_LINES.initializeSpecial(NIL);
        Symbol.PRINT_MISER_WIDTH.initializeSpecial(NIL);
        Symbol.PRINT_PPRINT_DISPATCH.initializeSpecial(NIL);
        Symbol.PRINT_PRETTY.initializeSpecial(NIL);
        Symbol.PRINT_RADIX.initializeSpecial(NIL);
        Symbol.PRINT_READABLY.initializeSpecial(NIL);
        Symbol.PRINT_RIGHT_MARGIN.initializeSpecial(NIL);
        _PRINT_STRUCTURE_ = Lisp.exportSpecial("*PRINT-STRUCTURE*", PACKAGE_EXT, T);
        _CURRENT_PRINT_LENGTH_ = Lisp.exportSpecial("*CURRENT-PRINT-LENGTH*", PACKAGE_SYS, Fixnum.ZERO);
        _CURRENT_PRINT_LEVEL_ = Lisp.exportSpecial("*CURRENT-PRINT-LEVEL*", PACKAGE_SYS, Fixnum.ZERO);
        _PRINT_FASL_ = Lisp.internSpecial("*PRINT-FASL*", PACKAGE_SYS, NIL);
        Symbol._RANDOM_STATE_.initializeSpecial(new RandomState());
        Symbol.STAR.initializeSpecial(NIL);
        Symbol.STAR_STAR.initializeSpecial(NIL);
        Symbol.STAR_STAR_STAR.initializeSpecial(NIL);
        Symbol.MINUS.initializeSpecial(NIL);
        Symbol.PLUS.initializeSpecial(NIL);
        Symbol.PLUS_PLUS.initializeSpecial(NIL);
        Symbol.PLUS_PLUS_PLUS.initializeSpecial(NIL);
        Symbol.SLASH.initializeSpecial(NIL);
        Symbol.SLASH_SLASH.initializeSpecial(NIL);
        Symbol.SLASH_SLASH_SLASH.initializeSpecial(NIL);
        Symbol.PI.initializeConstant(new DoubleFloat(Math.PI));
        Symbol.SHORT_FLOAT_EPSILON.initializeConstant(new SingleFloat(5.960465E-8f));
        Symbol.SINGLE_FLOAT_EPSILON.initializeConstant(new SingleFloat(5.960465E-8f));
        Symbol.DOUBLE_FLOAT_EPSILON.initializeConstant(new DoubleFloat(1.1102230246251568E-16));
        Symbol.LONG_FLOAT_EPSILON.initializeConstant(new DoubleFloat(1.1102230246251568E-16));
        Symbol.SHORT_FLOAT_NEGATIVE_EPSILON.initializeConstant(new SingleFloat(2.9802326E-8f));
        Symbol.SINGLE_FLOAT_NEGATIVE_EPSILON.initializeConstant(new SingleFloat(2.9802326E-8f));
        Symbol.DOUBLE_FLOAT_NEGATIVE_EPSILON.initializeConstant(new DoubleFloat(5.551115123125784E-17));
        Symbol.LONG_FLOAT_NEGATIVE_EPSILON.initializeConstant(new DoubleFloat(5.551115123125784E-17));
        Symbol.MOST_POSITIVE_SHORT_FLOAT.initializeConstant(new SingleFloat(Float.MAX_VALUE));
        Symbol.MOST_POSITIVE_SINGLE_FLOAT.initializeConstant(new SingleFloat(Float.MAX_VALUE));
        Symbol.MOST_POSITIVE_DOUBLE_FLOAT.initializeConstant(new DoubleFloat(Double.MAX_VALUE));
        Symbol.MOST_POSITIVE_LONG_FLOAT.initializeConstant(new DoubleFloat(Double.MAX_VALUE));
        Symbol.LEAST_POSITIVE_SHORT_FLOAT.initializeConstant(new SingleFloat(Float.MIN_VALUE));
        Symbol.LEAST_POSITIVE_SINGLE_FLOAT.initializeConstant(new SingleFloat(Float.MIN_VALUE));
        Symbol.LEAST_POSITIVE_DOUBLE_FLOAT.initializeConstant(new DoubleFloat(Double.MIN_VALUE));
        Symbol.LEAST_POSITIVE_LONG_FLOAT.initializeConstant(new DoubleFloat(Double.MIN_VALUE));
        Symbol.LEAST_POSITIVE_NORMALIZED_SHORT_FLOAT.initializeConstant(new SingleFloat(Float.MIN_NORMAL));
        Symbol.LEAST_POSITIVE_NORMALIZED_SINGLE_FLOAT.initializeConstant(new SingleFloat(Float.MIN_NORMAL));
        Symbol.LEAST_POSITIVE_NORMALIZED_DOUBLE_FLOAT.initializeConstant(new DoubleFloat(Double.MIN_NORMAL));
        Symbol.LEAST_POSITIVE_NORMALIZED_LONG_FLOAT.initializeConstant(new DoubleFloat(Double.MIN_NORMAL));
        Symbol.MOST_NEGATIVE_SHORT_FLOAT.initializeConstant(new SingleFloat(-3.4028235E38f));
        Symbol.MOST_NEGATIVE_SINGLE_FLOAT.initializeConstant(new SingleFloat(-3.4028235E38f));
        Symbol.MOST_NEGATIVE_DOUBLE_FLOAT.initializeConstant(new DoubleFloat(-1.7976931348623157E308));
        Symbol.MOST_NEGATIVE_LONG_FLOAT.initializeConstant(new DoubleFloat(-1.7976931348623157E308));
        Symbol.LEAST_NEGATIVE_SHORT_FLOAT.initializeConstant(new SingleFloat(-1.4E-45f));
        Symbol.LEAST_NEGATIVE_SINGLE_FLOAT.initializeConstant(new SingleFloat(-1.4E-45f));
        Symbol.LEAST_NEGATIVE_DOUBLE_FLOAT.initializeConstant(new DoubleFloat(-4.9E-324));
        Symbol.LEAST_NEGATIVE_LONG_FLOAT.initializeConstant(new DoubleFloat(-4.9E-324));
        Symbol.LEAST_NEGATIVE_NORMALIZED_SHORT_FLOAT.initializeConstant(new SingleFloat(-1.1754944E-38f));
        Symbol.LEAST_NEGATIVE_NORMALIZED_SINGLE_FLOAT.initializeConstant(new SingleFloat(-1.1754944E-38f));
        Symbol.LEAST_NEGATIVE_NORMALIZED_DOUBLE_FLOAT.initializeConstant(new DoubleFloat(-2.2250738585072014E-308));
        Symbol.LEAST_NEGATIVE_NORMALIZED_LONG_FLOAT.initializeConstant(new DoubleFloat(-2.2250738585072014E-308));
        Symbol.BOOLE_CLR.initializeConstant(Fixnum.ZERO);
        Symbol.BOOLE_SET.initializeConstant(Fixnum.ONE);
        Symbol.BOOLE_1.initializeConstant(Fixnum.TWO);
        Symbol.BOOLE_2.initializeConstant(Fixnum.constants[3]);
        Symbol.BOOLE_C1.initializeConstant(Fixnum.constants[4]);
        Symbol.BOOLE_C2.initializeConstant(Fixnum.constants[5]);
        Symbol.BOOLE_AND.initializeConstant(Fixnum.constants[6]);
        Symbol.BOOLE_IOR.initializeConstant(Fixnum.constants[7]);
        Symbol.BOOLE_XOR.initializeConstant(Fixnum.constants[8]);
        Symbol.BOOLE_EQV.initializeConstant(Fixnum.constants[9]);
        Symbol.BOOLE_NAND.initializeConstant(Fixnum.constants[10]);
        Symbol.BOOLE_NOR.initializeConstant(Fixnum.constants[11]);
        Symbol.BOOLE_ANDC1.initializeConstant(Fixnum.constants[12]);
        Symbol.BOOLE_ANDC2.initializeConstant(Fixnum.constants[13]);
        Symbol.BOOLE_ORC1.initializeConstant(Fixnum.constants[14]);
        Symbol.BOOLE_ORC2.initializeConstant(Fixnum.constants[15]);
        Symbol.CALL_ARGUMENTS_LIMIT.initializeConstant(Fixnum.getInstance(Integer.MAX_VALUE));
        Symbol.LAMBDA_PARAMETERS_LIMIT.initializeConstant(Fixnum.getInstance(1024));
        Symbol.MULTIPLE_VALUES_LIMIT.initializeConstant(Fixnum.constants[32]);
        Symbol.INTERNAL_TIME_UNITS_PER_SECOND.initializeConstant(Fixnum.getInstance(1000));
        Symbol.LAMBDA_LIST_KEYWORDS.initializeConstant(Lisp.list(Symbol.AND_OPTIONAL, Symbol.AND_REST, Symbol.AND_KEY, Symbol.AND_AUX, Symbol.AND_BODY, Symbol.AND_WHOLE, Symbol.AND_ALLOW_OTHER_KEYS, Symbol.AND_ENVIRONMENT));
        CALL_REGISTERS_LIMIT = Lisp.exportConstant("CALL-REGISTERS-LIMIT", PACKAGE_SYS, Fixnum.constants[8]);
        _WARN_ON_REDEFINITION_ = Lisp.exportSpecial("*WARN-ON-REDEFINITION*", PACKAGE_EXT, T);
        _SAVED_BACKTRACE_ = Lisp.exportSpecial("*SAVED-BACKTRACE*", PACKAGE_EXT, NIL);
        _COMMAND_LINE_ARGUMENT_LIST_ = Lisp.exportSpecial("*COMMAND-LINE-ARGUMENT-LIST*", PACKAGE_EXT, NIL);
        _BATCH_MODE_ = Lisp.exportSpecial("*BATCH-MODE*", PACKAGE_EXT, NIL);
        _NOINFORM_ = Lisp.exportSpecial("*NOINFORM*", PACKAGE_SYS, NIL);
        _DISASSEMBLER_ = Lisp.exportSpecial("*DISASSEMBLER*", PACKAGE_EXT, new SimpleString("javap -c -verbose"));
        _SPEED_ = Lisp.exportSpecial("*SPEED*", PACKAGE_SYS, Fixnum.ONE);
        _SPACE_ = Lisp.exportSpecial("*SPACE*", PACKAGE_SYS, Fixnum.ONE);
        _SAFETY_ = Lisp.exportSpecial("*SAFETY*", PACKAGE_SYS, Fixnum.ONE);
        _DEBUG_ = Lisp.exportSpecial("*DEBUG*", PACKAGE_SYS, Fixnum.ONE);
        _EXPLAIN_ = Lisp.exportSpecial("*EXPLAIN*", PACKAGE_SYS, NIL);
        _ENABLE_INLINE_EXPANSION_ = Lisp.exportSpecial("*ENABLE-INLINE-EXPANSION*", PACKAGE_EXT, T);
        _REQUIRE_STACK_FRAME_ = Lisp.exportSpecial("*REQUIRE-STACK-FRAME*", PACKAGE_EXT, NIL);
        Symbol.SUPPRESS_COMPILER_WARNINGS.initializeSpecial(NIL);
        _COMPILE_FILE_ENVIRONMENT_ = Lisp.exportSpecial("*COMPILE-FILE-ENVIRONMENT*", PACKAGE_SYS, NIL);
        UNBOUND_VALUE = new unboundValue();
        NULL_VALUE = new nullValue();
        _SLOT_UNBOUND_ = Lisp.exportConstant("+SLOT-UNBOUND+", PACKAGE_SYS, UNBOUND_VALUE);
        _CL_PACKAGE_ = Lisp.exportConstant("+CL-PACKAGE+", PACKAGE_SYS, PACKAGE_CL);
        _KEYWORD_PACKAGE_ = Lisp.exportConstant("+KEYWORD-PACKAGE+", PACKAGE_SYS, PACKAGE_KEYWORD);
        _BACKQUOTE_COUNT_ = Lisp.internSpecial("*BACKQUOTE-COUNT*", PACKAGE_SYS, Fixnum.ZERO);
        _BQ_VECTOR_FLAG_ = Lisp.internSpecial("*BQ-VECTOR-FLAG*", PACKAGE_SYS, Lisp.list(new Symbol("bqv"), new LispObject[0]));
        _TRACED_NAMES_ = Lisp.exportSpecial("*TRACED-NAMES*", PACKAGE_SYS, NIL);
        TRAP_OVERFLOW = true;
        TRAP_UNDERFLOW = true;
        Symbol._INSPECTOR_HOOK_.initializeSpecial(NIL);
        Lisp.loadClass("org.armedbear.lisp.Primitives");
        Lisp.loadClass("org.armedbear.lisp.SpecialOperators");
        Lisp.loadClass("org.armedbear.lisp.Extensions");
        Lisp.loadClass("org.armedbear.lisp.CompiledClosure");
        Lisp.loadClass("org.armedbear.lisp.Autoload");
        Lisp.loadClass("org.armedbear.lisp.AutoloadMacro");
        Lisp.loadClass("org.armedbear.lisp.AutoloadGeneralizedReference");
        Lisp.loadClass("org.armedbear.lisp.cxr");
        Lisp.loadClass("org.armedbear.lisp.Do");
        Lisp.loadClass("org.armedbear.lisp.dolist");
        Lisp.loadClass("org.armedbear.lisp.dotimes");
        Lisp.loadClass("org.armedbear.lisp.Pathname");
        Lisp.loadClass("org.armedbear.lisp.LispClass");
        Lisp.loadClass("org.armedbear.lisp.BuiltInClass");
        Lisp.loadClass("org.armedbear.lisp.StructureObject");
        Lisp.loadClass("org.armedbear.lisp.ash");
        Lisp.loadClass("org.armedbear.lisp.Java");
        Lisp.loadClass("org.armedbear.lisp.PackageFunctions");
        cold = false;
        stdin = new Stream(Symbol.SYSTEM_STREAM, System.in, (LispObject)Symbol.CHARACTER, true);
        stdout = new Stream(Symbol.SYSTEM_STREAM, (OutputStream)System.out, (LispObject)Symbol.CHARACTER, true);
        Symbol.STANDARD_INPUT.initializeSpecial(stdin);
        Symbol.STANDARD_OUTPUT.initializeSpecial(stdout);
        Symbol.ERROR_OUTPUT.initializeSpecial(stdout);
        Symbol.TRACE_OUTPUT.initializeSpecial(stdout);
        Symbol.TERMINAL_IO.initializeSpecial(new TwoWayStream(stdin, stdout, true));
        Symbol.QUERY_IO.initializeSpecial(new TwoWayStream(stdin, stdout, true));
        Symbol.DEBUG_IO.initializeSpecial(new TwoWayStream(stdin, stdout, true));
        WITH_INLINE_CODE = new with_inline_code();
        UNREACHED = null;
        steppingTask = false;
        stepping = false;
        delimitedStepping = false;
        stepperBlock = null;
        stepNumber = 0L;
        SET_STEPPING_TASK_ON = new Primitive("%set-stepping-task-on", PACKAGE_SYS, true){

            @Override
            public LispObject execute() {
                Lisp.setSteppingTaskOn();
                return NIL;
            }
        };
        SET_STEPPING_TASK_OFF = new Primitive("%set-stepping-task-off", PACKAGE_SYS, true){

            @Override
            public LispObject execute() {
                Lisp.setSteppingTaskOff();
                return NIL;
            }
        };
        SET_STEPPER_ON = new Primitive("%set-stepper-on", PACKAGE_SYS, true){

            @Override
            public LispObject execute() {
                Lisp.setSteppingOn();
                return NIL;
            }
        };
        RETURN_FROM_STEPPER = new Primitive("%return-from-stepper", PACKAGE_SYS, true){

            @Override
            public LispObject execute() {
                throw new Return(Lisp.stepperBlock.symbol, Lisp.stepperBlock.value, NIL);
            }
        };
        SET_STEPPER_OFF = new Primitive("%set-stepper-off", PACKAGE_SYS, true){

            @Override
            public LispObject execute() {
                Lisp.setSteppingOff();
                return NIL;
            }
        };
        SET_DELIMITED_STEPPING_OFF = new Primitive("%set-delimited-stepping-off", PACKAGE_SYS, true){

            @Override
            public LispObject execute() {
                Lisp.setDelimitedSteppingOff();
                return NIL;
            }
        };
        SET_DELIMITED_STEPPING_ON = new Primitive("%set-delimited-stepping-on", PACKAGE_SYS, true){

            @Override
            public LispObject execute() {
                Lisp.setDelimitedSteppingOn();
                return NIL;
            }
        };
        INITIALIZE_STEP_COUNTER = new Primitive("%initialize-step-counter", PACKAGE_SYS, true){

            @Override
            public LispObject execute() {
                Lisp.initializeStepCounter();
                return NIL;
            }
        };
        GET_STEP_COUNTER = new Primitive("%get-step-counter", PACKAGE_SYS, true){

            @Override
            public LispObject execute() {
                return Lisp.getStepCounter();
            }
        };
        INITIALIZE_STEP_BLOCK = new Primitive("%initialize-step-block", PACKAGE_SYS, true){

            @Override
            public LispObject execute() {
                Lisp.initializeStepBlock();
                return NIL;
            }
        };
    }

    static class unboundValue
    extends LispObject {
        unboundValue() {
        }

        @Override
        public String printObject() {
            return this.unreadableString("UNBOUND", false);
        }
    }

    static class nullValue
    extends LispObject {
        nullValue() {
        }

        @Override
        public String printObject() {
            return this.unreadableString("null", false);
        }
    }

    private static class with_inline_code
    extends SpecialOperator {
        with_inline_code() {
            super("with-inline-code", PACKAGE_JVM, true, "(&optional target repr) &body body");
        }

        @Override
        public LispObject execute(LispObject args, Environment env) {
            return Lisp.error(new SimpleError("This is a placeholder. It should only be called in compiled code, and tranformed by the compiler using special form handlers."));
        }
    }
}

