/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReferenceMap
extends AbstractMap {
    private static final boolean SOFTCACHE = !"false".equals(System.getProperty("org.hyperic.sigar.softcache"));
    protected ReferenceQueue queue;
    protected Map map;

    public ReferenceMap() {
        this(new HashMap());
    }

    public ReferenceMap(Map map) {
        this.map = map;
        this.queue = new ReferenceQueue();
    }

    public static Map synchronizedMap() {
        Map map = Collections.synchronizedMap(new HashMap());
        return ReferenceMap.newInstance(map);
    }

    public static Map newInstance() {
        return ReferenceMap.newInstance(new HashMap());
    }

    public static Map newInstance(Map map) {
        if (SOFTCACHE) {
            return new ReferenceMap(map);
        }
        return map;
    }

    public Object get(Object key) {
        Reference ref = (Reference)this.map.get(key);
        if (ref == null) {
            return null;
        }
        Object o = ref.get();
        if (o == null) {
            this.map.remove(key);
        }
        return o;
    }

    public Object put(Object key, Object value) {
        this.poll();
        return this.map.put(key, new SoftValue(key, value, this.queue));
    }

    public Object remove(Object key) {
        this.poll();
        return this.map.remove(key);
    }

    public void clear() {
        this.poll();
        this.map.clear();
    }

    public int size() {
        this.poll();
        return this.map.size();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    protected void poll() {
        MapReference ref;
        while ((ref = (MapReference)((Object)this.queue.poll())) != null) {
            this.map.remove(ref.getKey());
        }
    }

    protected static final class WeakValue
    extends WeakReference
    implements MapReference {
        private Object key;

        public Object getKey() {
            return this.key;
        }

        protected WeakValue(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }
    }

    protected static final class SoftValue
    extends SoftReference
    implements MapReference {
        private Object key;

        public Object getKey() {
            return this.key;
        }

        private SoftValue(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }
    }

    protected static interface MapReference {
        public Object getKey();
    }
}

