/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.arnx.jsonic.util.BeanInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
implements Comparable<MethodInfo> {
    private Class<?> beanClass;
    private String name;
    private boolean isStatic;
    List<Method> methods = new ArrayList<Method>();

    public MethodInfo(Class<?> clazz, String string, Collection<Method> collection, boolean bl) {
        this.beanClass = clazz;
        this.name = string;
        this.isStatic = bl;
        if (collection != null) {
            this.methods.addAll(collection);
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public Object invoke(Object object, Object ... objectArray) {
        Method method = this.findMethod(objectArray);
        try {
            return method.invoke(object, objectArray);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    public int compareTo(MethodInfo methodInfo) {
        if (!this.beanClass.equals(methodInfo.beanClass)) {
            return this.beanClass.getName().compareTo(methodInfo.beanClass.getName());
        }
        return this.name.compareTo(methodInfo.name);
    }

    public Method findMethod(Object ... objectArray) {
        Method method = null;
        Class<?>[] classArray = null;
        Method method2 = null;
        Class<?>[] classArray2 = null;
        for (Method method3 : this.methods) {
            Class<?>[] classArray3 = method3.getParameterTypes();
            if (method3.isVarArgs()) {
                if (objectArray.length < classArray3.length - 1) continue;
                if (method2 == null) {
                    Class<?> clazz = classArray3[classArray3.length - 1].getComponentType();
                    Class[] classArray4 = new Class[objectArray.length];
                    System.arraycopy(classArray3, 0, classArray4, 0, classArray3.length - 1);
                    for (int i = classArray3.length - 1; i < classArray4.length; ++i) {
                        classArray4[i] = clazz;
                    }
                    method2 = method3;
                    classArray2 = classArray4;
                    continue;
                }
                int n = BeanInfo.calcurateDistance(classArray2, objectArray);
                int n2 = BeanInfo.calcurateDistance(classArray3, objectArray);
                if (n2 > n) {
                    method2 = method3;
                    classArray2 = classArray3;
                    continue;
                }
                if (n2 != n) continue;
                method3 = null;
                classArray3 = null;
                continue;
            }
            if (objectArray.length != classArray3.length) continue;
            if (method == null) {
                method = method3;
                classArray = classArray3;
                continue;
            }
            int n = BeanInfo.calcurateDistance(classArray, objectArray);
            int n3 = BeanInfo.calcurateDistance(classArray3, objectArray);
            if (n3 > n) {
                method = method3;
                classArray = classArray3;
                continue;
            }
            if (n3 != n) continue;
            method3 = null;
            classArray3 = null;
        }
        if (method2 != null) {
            if (method == null) {
                method = method2;
            } else {
                int n = BeanInfo.calcurateDistance(classArray, objectArray);
                int n4 = BeanInfo.calcurateDistance(classArray2, objectArray);
                if (n4 > n) {
                    method = method2;
                }
            }
        }
        if (method == null) {
            throw new IllegalStateException("suitable method is not found: " + this.name);
        }
        return method;
    }
}

