/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util;

import java.util.ArrayList;
import org.apache.activemq.apollo.util.Mapper;
import org.apache.activemq.apollo.util.list.LinkedNode;
import org.apache.activemq.apollo.util.list.LinkedNodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityLinkedList<E extends LinkedNode<E>> {
    private Mapper<Integer, E> priorityMapper;
    private final ArrayList<LinkedNodeList<E>> priorityLists;
    private int highesPriority = 0;

    public PriorityLinkedList(int numPriorities) {
        this(numPriorities, null);
    }

    public PriorityLinkedList(int numPriorities, Mapper<Integer, E> priorityMapper) {
        this.priorityMapper = priorityMapper;
        this.priorityLists = new ArrayList();
        for (int i = 0; i <= numPriorities; ++i) {
            this.priorityLists.add(new LinkedNodeList());
        }
    }

    public final int getHighestPriority() {
        return this.highesPriority;
    }

    public final E poll() {
        LinkedNodeList<E> ll = this.getHighestPriorityList();
        if (ll == null) {
            return null;
        }
        E node = ll.getHead();
        ((LinkedNode)node).unlink();
        return node;
    }

    public final boolean isEmpty() {
        return this.peek() != null;
    }

    public final E peek() {
        LinkedNodeList<E> ll = this.getHighestPriorityList();
        if (ll == null) {
            return null;
        }
        return ll.getHead();
    }

    public final void add(E element) {
        int prio = this.priorityMapper.map(element);
        this.add(element, prio);
    }

    public final void add(E element, int prio) {
        LinkedNodeList<E> ll = this.priorityLists.get(prio);
        ll.addLast(element);
        if (prio > this.highesPriority) {
            this.highesPriority = prio;
        }
    }

    private final LinkedNodeList<E> getHighestPriorityList() {
        LinkedNodeList<E> ll = this.priorityLists.get(this.highesPriority);
        while (ll.isEmpty()) {
            if (this.highesPriority == 0) {
                return null;
            }
            --this.highesPriority;
            ll = this.priorityLists.get(this.highesPriority);
        }
        return ll;
    }

    public Mapper<Integer, E> getPriorityMapper() {
        return this.priorityMapper;
    }

    public void setPriorityMapper(Mapper<Integer, E> priorityMapper) {
        this.priorityMapper = priorityMapper;
    }
}

