#!/usr/bin/python
#
# Like find-test-failure.py, but runs just a single test
# program, not the entire test suite.  Likely slower
# than fine-test-failure.py if there are already test
# results for most source dates, and faster otherwise.
#
# Also works for finding when a test was fixed.
#
# Does not work with noemu.
#

from __future__ import print_function

import os
import anita
from bracket import *

use_current_repository()

def find_atf_test_change(tp, tc, begin, end, sense, confirm = False):
    name = re.sub(r'/', '_', tp) + '_' + tc
    print(name)

    def f(ts):
        #dist = anita.URL(anita_dist_url(ts))
        #dist = anita.ISO(anita_dist_url(ts))
        dist = anita.distribution(anita_dist_url(ts))
        a = anita.Anita(dist, vmm_args = [], workdir = anita_workdir(ts),
                        dtb = '/usr/pkg/share/dtb/arm/vexpress-v2p-ca15-tc1.dtb')
        dir, prog = os.path.split(tp)
        a.boot()
        a.login()
        status = a.shell_cmd("cd /usr/tests/%s && atf-run %s >log && egrep '^tc-end:.* %s, passed' log" % (dir, prog, tc))
        print("shell_cmd returned exit status", status)
        return status == 0
    
    find_change(begin, end,
                TestOp(f,
                       [install_op],
                       name = name),
                sense,
                confirm)

def find_atf_test_failure(tp, tc, begin, end, confirm = False):
    find_atf_test_change(tp, tc, begin, end, False, confirm)
    
def find_atf_test_fix(tp, tc, begin, end, confirm = False):
    find_atf_test_change(tp, tc, begin, end, True, confirm)
    
#(tp, tc, begin, end) = sys.argv

#find_atf_test_failure('libexec/ld.elf_so/t_ifunc', 'rtld_ifunc',
#    rcs2ts('2017.08.08.01.56.10'),
#    rcs2ts('2017.08.11.00.58.37'),
#    confirm = True)

#find_atf_test_fix('rump/rumpkern/t_sp', 'stress_long',
#    rcs2ts('2018.07.05.13.11.58'),
#    rcs2ts('2018.09.05.06.27.07'),
#    confirm = False)

# Bisect on sparc64 due to i386/amd64 build failures and the test failing on sparc
find_atf_test_failure('usr.bin/c++/t_cxxruntime', 'cxxruntime_pic_profile',
                  rcs2ts('2019.02.16.17.56.57'),
                  rcs2ts('2019.02.17.07.34.44'),
                  confirm = True)
