/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.igoweb.igoweb.client.CChallenge;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.ChallengePlayer;
import org.igoweb.igoweb.client.swing.ChatPane;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.shared.GameAction;
import org.igoweb.igoweb.shared.GameType;
import org.igoweb.igoweb.shared.IBundle;
import org.igoweb.igoweb.shared.Proposal;
import org.igoweb.igoweb.shared.Role;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.BlinkLabel;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.Prefs;

public abstract class ChallengeWindow<UserRoleT extends Proposal.UserRole<User>, PropT extends Proposal<User, UserRoleT, PropT>>
extends DFrame {
    public static final String GLOBAL_GAME_PREF = ",-IB_Nk8";
    public static final String NOTES_PREF = "4).TeVdg";
    public static final String INIT_PROPOSAL_PREF = "'4r]|j2S";
    protected final Client client;
    protected final CRoom room;
    private boolean responseSent;
    private CChallenge<PropT> chal;
    private final JTextField notesIn;
    public final boolean isCreator;
    private PropT curProp;
    private boolean[] gtVisibilities = new boolean[GameType.count()];
    private final Listener listener = new Listener();
    private JComboBox<String> gameTypeIn;
    private JLabel gameTypeLabel;
    private JPanel gameTypeFlipper;
    private CardLayout gameTypeLayout;
    private JCheckBox privateIn;
    private JCheckBox globalIn;
    private boolean active = false;
    private final JPanel chalPlayerPanel = new JPanel(new GCLayout());
    private BlinkLabel hint;
    private JButton helpBut;
    private JButton retryBut;
    private JButton closeBut;
    private JButton okBut;
    private JButton playerGrowBut;
    private JButton playerShrinkBut;
    private boolean closeWanted = false;
    private ChatPane chatPane;
    private List<ChallengePlayer<UserRoleT, PropT>> challengePlayers = new ArrayList<ChallengePlayer<UserRoleT, PropT>>();

    public ChallengeWindow(Client client, CRoom room, Component parent) {
        super(Defs.getString(-903340563), parent);
        this.client = client;
        this.room = room;
        this.notesIn = new ATextField(Prefs.getString(NOTES_PREF, ""), 1, true);
        this.isCreator = true;
        byte[] propData = Prefs.getBytes(INIT_PROPOSAL_PREF, null);
        try {
            this.curProp = this.decodeInitialProposal(propData);
        }
        catch (IOException excep) {
            try {
                this.curProp = this.decodeInitialProposal(null);
            }
            catch (IOException excep2) {
                throw new RuntimeException();
            }
        }
        this.build();
    }

    public ChallengeWindow(Client client, CChallenge<PropT> chal, Component parent) {
        super(Defs.getString(-903340563), parent);
        this.client = client;
        this.chal = chal;
        chal.addListener(this.listener);
        this.room = client.getRoom(chal);
        this.notesIn = new ATextField(chal.getName(), 1, false);
        this.isCreator = false;
        this.curProp = this.copyProposal(chal.getInitialProposal());
        this.build();
    }

    protected abstract PropT decodeInitialProposal(byte[] var1) throws IOException;

    private void build() {
        this.setDefaultCloseOperation(0);
        this.getMainPanel().setLayout(new GCLayout());
        this.hint = new BlinkLabel(Defs.getString(-903340608), 0);
        this.hint.setFont(this.hint.getFont().deriveFont(1));
        this.getMainPanel().add("x=0,xGrow=t,yGrow=f", this.hint);
        this.getMainPanel().add("x=0", this.notesIn);
        JPanel panel = new JPanel(new GridLayout(1, 3));
        this.getMainPanel().add("x=0", panel);
        this.gameTypeLayout = new CardLayout();
        this.gameTypeFlipper = new JPanel(this.gameTypeLayout);
        panel.add(this.gameTypeFlipper);
        this.gameTypeIn = new JComboBox();
        this.gameTypeFlipper.add("1", this.gameTypeIn);
        this.gameTypeLabel = new JLabel();
        this.gameTypeFlipper.add("2", this.gameTypeLabel);
        this.gameTypeLabel.setOpaque(true);
        this.gameTypeLabel.setBorder(BorderFactory.createLineBorder(new Color(0x999999)));
        this.gameTypeLabel.setForeground(new Color(0x999999));
        this.gameTypeIn.addActionListener(this.listener);
        this.privateIn = new JCheckBox(Defs.getString(-903340786));
        this.privateIn.setSelected(this.room != null && this.room.isPrivate());
        this.privateIn.addChangeListener(this.listener);
        panel.add(this.privateIn);
        this.globalIn = new JCheckBox(Defs.getString(-903340646));
        panel.add(this.globalIn);
        if (this.room != null && this.room.isGlobalGamesOnly()) {
            this.globalIn.setSelected(true);
            this.globalIn.setEnabled(false);
        } else if (this.room != null && this.room.isPrivate()) {
            this.globalIn.setSelected(false);
            this.globalIn.setEnabled(false);
        } else {
            this.globalIn.setSelected(Prefs.getBoolean(GLOBAL_GAME_PREF, true));
        }
        JScrollPane jsp = new JScrollPane(this.chalPlayerPanel, 20, 31){

            @Override
            public Dimension getPreferredSize() {
                Dimension defPref = super.getPreferredSize();
                return new Dimension(defPref.width, UIManager.getInt("org.igoweb.fontH") * 7);
            }
        };
        this.getMainPanel().add("x=0,yGrow=t", jsp);
        JComponent gameOptionsWidget = this.getGameOptionsWidget();
        if (gameOptionsWidget != null) {
            this.getMainPanel().add("x=0,yGrow=f", gameOptionsWidget);
        }
        this.chatPane = new ChatPane(this.client, this.chal, 100);
        this.chatPane.setShowRanks(true);
        this.getMainPanel().add("x=0,yGrow=f", this.chatPane);
        int fontSize = UIManager.getInt("org.igoweb.fontH");
        this.chatPane.setPreferredSize(new Dimension(fontSize * 5, fontSize * 5));
        this.getMainPanel().add("x=0,yGrow=f", this.chatPane.getInput());
        this.okBut = this.addButton(Defs.getString(1436228518), this.listener);
        if (this.isCreator) {
            this.retryBut = this.addButton(Defs.getString(-903340797), this.listener);
        }
        this.closeBut = this.addButton(Defs.getString(1436228514), this.listener);
        this.helpBut = this.addButton(Defs.getString(1436228516), this.listener);
        GuiClientUtil.addToWindowList(this.client, this);
        this.addWindowListener(this.listener);
        this.updateGui();
        this.pack();
        this.setVisible(true);
        this.okBut.requestFocus();
    }

    protected final void updateGui() {
        if (this.responseSent) {
            this.okBut.setEnabled(false);
            return;
        }
        this.doUpdateGui();
    }

    protected void doUpdateGui() {
        if (this.challengePlayers.size() != ((Proposal)this.curProp).getUserRoles().size() || this.isChallengePlayerRebuildNeeded()) {
            this.chalPlayerPanel.removeAll();
            this.challengePlayers.clear();
            List userRoles = ((Proposal)this.curProp).getUserRoles();
            for (int i = 0; i < userRoles.size(); ++i) {
                ChallengePlayer<UserRoleT, PropT> cp = this.buildChallengePlayer(this.listener, this.curProp, i);
                cp.setChallenge(this.chal);
                this.fillChallengePlayer(cp);
                this.challengePlayers.add(cp);
                this.chalPlayerPanel.add("x=0,xGrow=t,yGrow=f", cp);
            }
            if (this.isCreator && (((Proposal)this.curProp).isAddUserRoleAllowed() || ((Proposal)this.curProp).isRemoveUserRoleAllowed())) {
                this.playerGrowBut = new JButton(Defs.getString(-903340789));
                this.playerGrowBut.addActionListener(this.listener);
                this.playerShrinkBut = new JButton(Defs.getString(-903340625));
                this.playerShrinkBut.addActionListener(this.listener);
                JPanel butPanel = new JPanel(new GridLayout(1, 2));
                butPanel.add(this.playerGrowBut);
                butPanel.add(this.playerShrinkBut);
                this.chalPlayerPanel.add("x=0", butPanel);
            } else {
                this.playerGrowBut = null;
                this.playerShrinkBut = null;
            }
        }
        this.updateGameTypeList();
        this.setGameTypeSelected(((Proposal)this.curProp).getGameType());
        int hintId = 0;
        boolean okEnabled = false;
        boolean gameTypeEnabled = false;
        boolean privateEnabled = false;
        boolean openEnabled = false;
        GameAction action = this.getAction();
        this.notesIn.setEditable(action == GameAction.CHALLENGE_CREATE);
        switch (action == null ? -1 : action.id) {
            case 3: {
                hintId = -903340608;
                okEnabled = true;
                gameTypeEnabled = true;
                privateEnabled = true;
                openEnabled = true;
                break;
            }
            case 4: {
                hintId = -903340551;
                if (!this.isChangeableSetup()) break;
                okEnabled = ((Proposal)this.getProposal()).isComplete();
                gameTypeEnabled = true;
                privateEnabled = true;
                break;
            }
            case 5: {
                hintId = -903340753;
                break;
            }
            case 6: {
                hintId = -903340821;
                okEnabled = true;
                if (this.hint.isBlinking()) break;
                this.toFront();
                Defs.ringBell();
                break;
            }
            case 7: {
                hintId = -903340753;
                okEnabled = false;
                break;
            }
            case -1: {
                hintId = -903340754;
                okEnabled = true;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (hintId != 0) {
            this.hint.setText(Defs.getString(hintId));
        }
        this.hint.setBlinking(action == GameAction.CHALLENGE_ACCEPT);
        if (this.retryBut != null) {
            this.retryBut.setEnabled(action == GameAction.CHALLENGE_WAIT);
        }
        this.okBut.setEnabled(okEnabled);
        this.privateIn.setEnabled(privateEnabled && this.room != null && !this.room.isPrivate() && !((Proposal)this.curProp).getGameType().isRanked());
        if (((Proposal)this.curProp).getGameType().isRanked()) {
            this.privateIn.setSelected(false);
        } else {
            this.privateIn.setSelected(((Proposal)this.curProp).isPrivate());
        }
        this.globalIn.setEnabled(openEnabled && !this.room.isGlobalGamesOnly() && !this.room.isPrivate());
        if (this.chal != null) {
            this.globalIn.setSelected(this.chal.isGlobal());
        }
        if (gameTypeEnabled) {
            this.gameTypeLayout.first(this.gameTypeFlipper);
        } else {
            this.gameTypeLayout.last(this.gameTypeFlipper);
            this.gameTypeLabel.setText(this.gameTypeIn.getSelectedItem().toString());
        }
        this.gameTypeIn.setEnabled(gameTypeEnabled);
        for (int i = 0; i < this.challengePlayers.size(); ++i) {
            this.challengePlayers.get(i).updateGui(this.curProp, action, this.isCurrent());
        }
        if (this.playerGrowBut != null) {
            this.playerGrowBut.setEnabled(((Proposal)this.curProp).isAddUserRoleAllowed() && (action == GameAction.CHALLENGE_CREATE || action == GameAction.CHALLENGE_SETUP));
            this.playerShrinkBut.setEnabled(((Proposal)this.curProp).isRemoveUserRoleAllowed() && (action == GameAction.CHALLENGE_CREATE || action == GameAction.CHALLENGE_SETUP));
        }
    }

    private void handleChallengePlayerEvent(Event event) {
        ChallengePlayer<UserRoleT, PropT> cp;
        int i = 0;
        while ((cp = this.getChallengePlayer(i++)) != event.source) {
        }
        switch (event.type) {
            case 0: {
                this.handleRoleChange(cp);
                break;
            }
            case 1: {
                if (cp.getUser() == ((Proposal.UserRole)((Proposal)this.getProposal()).getUserRole((int)cp.playerNum)).getUser() || !this.handlePlayerChange(cp)) break;
                this.updateGui();
                break;
            }
            case 2: {
                User u = (User)event.arg;
                this.chal.sendDecline(u);
                this.removeUser(u);
            }
        }
    }

    private void handleEvent(final Event event) {
        switch (event.type) {
            case 118: {
                this.chal = this.castChallenge((CChallenge)event.arg);
                this.chatPane.setChannel(this.chal);
                for (int i = 0; i < this.challengePlayers.size(); ++i) {
                    this.challengePlayers.get(i).setChallenge(this.chal);
                }
                if (this.closeWanted) {
                    this.chal.sendUnjoinRequest();
                    break;
                }
                this.chal.addListener(this.listener);
                this.updateGui();
                break;
            }
            case 15: {
                this.updateGui();
                break;
            }
            case 97: {
                GuiClientUtil.messageReceived(Defs.getString(2031923640), 13, null);
                this.dispose();
                break;
            }
            case 16: 
            case 22: 
            case 119: {
                this.dispose();
                break;
            }
            case 40: {
                if (!this.isCreator && this.isCurrent() && this.chal.getCurrentProposal() != null) {
                    this.curProp = this.copyProposal(this.chal.getProposal());
                }
                this.updateGui();
                break;
            }
            case 73: {
                User u = (User)event.arg;
                int cpNum = this.addSubmittedUser(u);
                if (cpNum == -1) break;
                this.highlightChanges(this.chal.getExpectedProposal(u), this.challengePlayers.size() == 2 ? -1 : cpNum);
                break;
            }
            case 20: {
                if (!this.isCreator) break;
                this.removeUser((User)event.arg);
                break;
            }
            case 69: {
                if (!this.isCurrent()) break;
                this.handleNewProposal(this.chal.getProposal());
                this.updateGui();
                break;
            }
            case 71: {
                if (((Proposal)this.curProp).getGameType().isRanked()) {
                    ((Proposal)this.curProp).setGameType(((Proposal)this.curProp).getGameType().getFreeType());
                    this.updateGui();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new MsgOut(Defs.getString(-903340547), (String)event.arg, 2, (Component)ChallengeWindow.this);
                    }
                });
                break;
            }
            case 72: {
                this.handleDeclineFromServer();
                break;
            }
            case 28: {
                this.toFront();
            }
        }
    }

    protected void handleDeclineFromServer() {
        new MsgOut(Defs.getString(-903340547), Defs.getString(-903340657), 2, (Component)this);
        this.responseSent = false;
        this.updateGui();
    }

    protected int addSubmittedUser(User user) {
        List userRoles = ((Proposal)this.curProp).getUserRoles();
        int insertedSlot = -1;
        for (int i = 0; i < userRoles.size(); ++i) {
            Proposal.UserRole ur;
            if (!this.isPlayerAllowed(user, i)) continue;
            this.challengePlayers.get(i).add(user);
            if (insertedSlot != -1 || (ur = (Proposal.UserRole)userRoles.get(i)).getUser() != null) continue;
            this.challengePlayers.get(i).setUser(user);
            insertedSlot = i;
        }
        if (insertedSlot != -1) {
            if (userRoles.size() == 2) {
                this.setGameTypeSelected(((Proposal)this.chal.getSubmission(user.name)).getGameType());
            }
            this.updateGui();
            if (((Proposal)this.curProp).isComplete()) {
                this.toFront();
                Defs.ringBell();
            }
        }
        return insertedSlot;
    }

    private void removeUser(User user) {
        for (int i = this.challengePlayers.size() - 1; i >= 0; --i) {
            Object userRole = ((Proposal)this.curProp).getUserRole((int)i);
            if (((Proposal.UserRole)userRole).getUser() == user) {
                ((Proposal.UserRole)userRole).setUser(null);
            }
            this.getChallengePlayer(i).remove(user);
        }
    }

    protected boolean isPlayerAllowed(User user, int playerNum) {
        for (int i = 0; i < this.challengePlayers.size(); ++i) {
            ChallengePlayer<UserRoleT, PropT> cp;
            if (i == playerNum || !(cp = this.challengePlayers.get(i)).isPlayerFixed() || cp.getUser() != user) continue;
            return false;
        }
        return true;
    }

    protected abstract void handleRoleChange(ChallengePlayer<UserRoleT, PropT> var1);

    protected boolean handlePlayerChange(ChallengePlayer<UserRoleT, PropT> cp) {
        User newUser;
        Object prevUser = ((Proposal.UserRole)((Proposal)this.curProp).getUserRole((int)cp.playerNum)).getUser();
        if (this.challengePlayers.size() == 2 && prevUser != null) {
            this.chal.setUserProposal(((User)prevUser).name, this.curProp);
        }
        if (prevUser == (newUser = cp.getUser())) {
            return false;
        }
        if (newUser != null) {
            for (int i = 0; i < ((Proposal)this.curProp).getUserRoles().size(); ++i) {
                if (i == cp.playerNum || ((Proposal.UserRole)((Proposal)this.curProp).getUserRole((int)i)).getUser() != newUser) continue;
                ((Proposal.UserRole)((Proposal)this.curProp).getUserRole((int)i)).setUser(prevUser);
            }
        }
        ((Proposal.UserRole)((Proposal)this.curProp).getUserRole((int)cp.playerNum)).setUser((User)newUser);
        this.updateGameTypeList();
        return true;
    }

    protected abstract JComponent getGameOptionsWidget();

    protected boolean isChallengePlayerRebuildNeeded() {
        return false;
    }

    protected abstract void updateGameTypeList();

    protected void setGameTypeVisibility(GameType gameType, boolean newVisibility) {
        if (newVisibility != this.gtVisibilities[gameType.id]) {
            this.gtVisibilities[gameType.id] = newVisibility;
            int slot = 0;
            for (int i = 0; i < gameType.id; ++i) {
                if (!this.gtVisibilities[i]) continue;
                ++slot;
            }
            if (newVisibility) {
                this.gameTypeIn.insertItemAt(IBundle.get().getGameTypeDescription(gameType), slot);
            } else {
                this.gameTypeIn.removeItemAt(slot);
            }
        }
    }

    protected void setGameTypeSelected(GameType newGt) {
        int failures = 0;
        while (!this.gtVisibilities[newGt.id]) {
            newGt = GameType.get(newGt.id == 0 ? GameType.count() - 1 : newGt.id - 1);
            if (++failures <= this.gtVisibilities.length + 2) continue;
            throw new RuntimeException();
        }
        int slot = 0;
        for (int i = 0; i < newGt.id; ++i) {
            if (!this.gtVisibilities[i]) continue;
            ++slot;
        }
        this.gameTypeIn.setSelectedIndex(slot);
    }

    protected GameType getGameTypeSelected() {
        int slot = this.gameTypeIn.getSelectedIndex();
        int i = 0;
        while (!this.gtVisibilities[i] || --slot >= 0) {
            ++i;
        }
        return GameType.get(i);
    }

    @Override
    public void toFront() {
        if (!this.active) {
            this.notesIn.requestFocus();
        }
        super.toFront();
    }

    private void handleActionEvent(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.gameTypeIn) {
            GameType newGameType = this.getGameTypeSelected();
            if (newGameType != ((Proposal)this.curProp).getGameType()) {
                ((Proposal)this.curProp).setGameType(newGameType);
                this.updateGui();
            }
        } else if (src == this.retryBut) {
            this.chal.sendRetry();
        } else if (src == this.closeBut) {
            this.close();
        } else if (src == this.okBut) {
            this.okPressed();
        } else if (src == this.helpBut) {
            GuiUtil.loadHelp("newGameWin.html");
        } else if (src == this.playerGrowBut) {
            ((Proposal)this.curProp).addUserRole();
            Container butPanel = this.playerGrowBut.getParent();
            this.chalPlayerPanel.remove(butPanel);
            ChallengePlayer<UserRoleT, PropT> cp = this.buildChallengePlayer(this.listener, this.curProp, this.challengePlayers.size());
            cp.setChallenge(this.chal);
            this.challengePlayers.add(cp);
            this.fillChallengePlayer(cp);
            this.chalPlayerPanel.add("x=0,y=" + cp.playerNum, cp);
            this.chalPlayerPanel.add("x=0", butPanel);
            this.updateGui();
        } else if (src == this.playerShrinkBut) {
            ((Proposal)this.curProp).removeUserRole();
            Container butPanel = this.playerGrowBut.getParent();
            this.chalPlayerPanel.remove(butPanel);
            this.chalPlayerPanel.remove(this.challengePlayers.remove(((Proposal)this.curProp).getUserRoles().size()));
            this.chalPlayerPanel.add("x=0,y=" + this.challengePlayers.size(), butPanel);
            this.updateGui();
        }
    }

    private void okPressed() {
        int i;
        GameAction action = this.getAction();
        if (this.responseSent || !this.isExtraWidgetsValid()) {
            return;
        }
        this.highlightChanges(null, -1);
        for (i = 0; i < this.challengePlayers.size(); ++i) {
            if (this.challengePlayers.get(i).isPlayerValid()) continue;
            return;
        }
        this.readExtraWidgets();
        for (i = 0; i < this.challengePlayers.size(); ++i) {
            this.challengePlayers.get(i).read(this.curProp);
        }
        if (action == null) {
            this.chal.sendProposal(CChallenge.SUBMIT, this.curProp);
            return;
        }
        switch (action.id) {
            case 3: {
                String notes = this.notesIn.getText();
                if (notes.length() > 80) {
                    new Errout(Defs.getString(-903340639, 80.0));
                    return;
                }
                ((Proposal)this.curProp).setPrivate(this.room != null && this.room.isPrivate() || this.privateIn.isEnabled() && this.privateIn.isSelected());
                PropT savedProp = this.copyProposal(this.curProp);
                for (int i2 = 0; i2 < ((Proposal)savedProp).getUserRoles().size(); ++i2) {
                    ((Proposal.UserRole)((Proposal)savedProp).getUserRoles().get(i2)).setUser(null);
                }
                Prefs.putBytes(INIT_PROPOSAL_PREF, ((Proposal)savedProp).toBytes());
                if (!this.room.isPrivate() && !this.room.isGlobalGamesOnly()) {
                    Prefs.putBoolean(GLOBAL_GAME_PREF, this.globalIn.isSelected());
                }
                Prefs.putString(NOTES_PREF, notes);
                this.room.sendNewGameRequest((Proposal<?, ?, ?>)this.curProp, notes, this.globalIn.isSelected(), this.listener);
                this.sync();
                break;
            }
            case 4: {
                this.readExtraWidgets();
                ((Proposal)this.curProp).setPrivate(this.room != null && this.room.isPrivate() || this.privateIn.isEnabled() && this.privateIn.isSelected());
                this.chal.sendProposal(CChallenge.PROPOSAL, this.curProp);
                this.sync();
                break;
            }
            case 6: {
                this.chal.sendProposal(CChallenge.ACCEPT, this.curProp);
                break;
            }
        }
    }

    private void close() {
        if (this.chal == null) {
            if (this.responseSent) {
                this.closeWanted = true;
            }
            this.dispose();
        } else {
            this.chal.sendUnjoinRequest();
        }
    }

    protected abstract ChallengePlayer<UserRoleT, PropT> buildChallengePlayer(EventListener var1, PropT var2, int var3);

    protected abstract boolean isExtraWidgetsValid();

    protected abstract void readExtraWidgets();

    protected abstract PropT copyProposal(PropT var1);

    protected int getNumChallengePlayers() {
        return this.challengePlayers.size();
    }

    protected ChallengePlayer<UserRoleT, PropT> getChallengePlayer(int i) {
        return this.challengePlayers.get(i);
    }

    protected User getChallengeOwner() {
        return this.isCreator ? this.client.getMe() : this.chal.getPlayer(Role.CHALLENGE_CREATOR);
    }

    protected PropT getProposal() {
        return this.curProp;
    }

    protected PropT getInitialProposal() {
        return this.chal == null ? this.curProp : this.chal.getInitialProposal();
    }

    protected abstract CChallenge<PropT> castChallenge(CChallenge<?> var1);

    protected CChallenge<PropT> getChallenge() {
        return this.chal;
    }

    protected GameAction getAction() {
        return this.chal == null ? GameAction.CHALLENGE_CREATE : this.chal.getAction();
    }

    public void sync() {
        this.responseSent = true;
        this.client.sendSync(this.listener);
        this.updateGui();
    }

    public boolean isCurrent() {
        GameAction action = this.getAction();
        return action != null;
    }

    protected void handleNewProposal(PropT newProposal) {
        this.curProp = newProposal;
        this.highlightChanges(this.chal.getExpectedProposal(newProposal), -1);
    }

    private void fillChallengePlayer(ChallengePlayer<UserRoleT, PropT> cp) {
        if (!cp.isCreator || this.chal == null) {
            return;
        }
        for (User user : this.chal.getSubmitters()) {
            if (!this.isPlayerAllowed(user, cp.playerNum)) continue;
            cp.add(user);
        }
    }

    protected void handlePrivateInChange() {
        this.updateGameTypeList();
    }

    public boolean isPrivateSelected() {
        return this.privateIn.isSelected();
    }

    @Override
    public void dispose() {
        if (this.chal != null) {
            this.chal.removeListener(this.listener);
        }
        super.dispose();
    }

    protected void highlightChanges(PropT expected, int cpNum) {
        if (expected == null) {
            expected = this.curProp;
        }
        Color stdBg = this.getBackground();
        Color litBg = UIManager.getColor("org.igoweb.highlightBg");
        Color color = ((Proposal)expected).getGameType() == ((Proposal)this.curProp).getGameType() ? stdBg : litBg;
        this.gameTypeIn.setBackground(color);
        this.gameTypeLabel.setBackground(color);
        this.privateIn.setBackground(((Proposal)expected).isPrivate() == ((Proposal)this.curProp).isPrivate() ? stdBg : litBg);
        if (cpNum == -1) {
            for (int i = 0; i < this.challengePlayers.size(); ++i) {
                this.getChallengePlayer(i).highlightChanges(expected, this.curProp);
            }
        } else {
            this.getChallengePlayer(cpNum).highlightChanges(expected, this.curProp);
        }
    }

    protected boolean isChangeableSetup() {
        if (this.challengePlayers.size() != 2) {
            return true;
        }
        User me = this.client.getMe();
        for (int i = 0; i < 2; ++i) {
            User u = this.getChallengePlayer(i).getUser();
            if (u == null || u == me) continue;
            return true;
        }
        return false;
    }

    private class Listener
    extends WindowAdapter
    implements EventListener,
    ActionListener,
    Runnable,
    ChangeListener {
        private Listener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (event.source instanceof ChallengePlayer) {
                ChallengeWindow.this.handleChallengePlayerEvent(event);
            } else {
                ChallengeWindow.this.handleEvent(event);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ChallengeWindow.this.handleActionEvent(event);
        }

        @Override
        public void windowClosing(WindowEvent event) {
            ChallengeWindow.this.close();
        }

        @Override
        public void windowActivated(WindowEvent e) {
            ChallengeWindow.this.active = true;
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            ChallengeWindow.this.active = false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ChallengeWindow.this.handlePrivateInChange();
        }

        @Override
        public void run() {
            ChallengeWindow.this.responseSent = false;
            ChallengeWindow.this.updateGui();
        }
    }
}

