/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.actions;

import com.intellij.cidr.translateCode.CidrTranslateCodeService;
import com.intellij.cidr.translateCode.CidrTranslator;
import com.intellij.cidr.translateCode.CidrTranslatorProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.jetbrains.cidr.cpp.actions.CLionCompilerAsmTranslatorKt;
import com.jetbrains.cidr.cpp.actions.ClangClAsmTranslator;
import com.jetbrains.cidr.cpp.actions.CompilerAsmTranslator;
import com.jetbrains.cidr.cpp.actions.GCCAsmTranslator;
import com.jetbrains.cidr.cpp.actions.MSVCAsmTranslator;
import com.jetbrains.cidr.cpp.execution.build.CLionCompileFileUtil;
import com.jetbrains.cidr.cpp.execution.build.runners.CLionCompileTaskRunner;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/cpp/actions/CompilerAsmTranslatorProvider;", "Lcom/intellij/cidr/translateCode/CidrTranslatorProvider;", "<init>", "()V", "isAvailable", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "srcFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getTranslators", "", "Lcom/intellij/cidr/translateCode/CidrTranslator;", "getFileDescriptor", "Lcom/jetbrains/cidr/cpp/execution/build/CLionCompileFileUtil$FileDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.execution"})
public final class CompilerAsmTranslatorProvider
implements CidrTranslatorProvider {
    public boolean isAvailable(@NotNull Editor editor, @Nullable VirtualFile srcFile, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return srcFile != null && editor.getProject() != null && OCFileTypeHelpers.getLanguageKind((String)srcFile.getName()) != null;
    }

    @NotNull
    public List<CidrTranslator> getTranslators(@NotNull Editor editor, @Nullable VirtualFile srcFile, @NotNull DataContext dataContext) {
        CompilerAsmTranslator compilerAsmTranslator;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (srcFile == null) {
            return CollectionsKt.emptyList();
        }
        Project project = editor.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        CLionCompileFileUtil.FileDescriptor compileDescriptor = this.getFileDescriptor(project2, srcFile);
        if (compileDescriptor == null) {
            CidrTranslateCodeService.LOG.debug("Failed to get compile file descriptor for " + srcFile.getPath());
            return CollectionsKt.emptyList();
        }
        CPPEnvironment cppEnv = compileDescriptor.getEnvironment();
        VirtualFile virtualFile = srcFile.getCanonicalFile();
        if (virtualFile == null) {
            virtualFile = srcFile;
        }
        VirtualFile canonicalSrcFile = virtualFile;
        String string = canonicalSrcFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String mappedSrcFile = CLionCompilerAsmTranslatorKt.access$mapPath(compileDescriptor, string);
        OCCompilerKind oCCompilerKind = compileDescriptor.getCompilerKind();
        if (Intrinsics.areEqual((Object)oCCompilerKind, (Object)GCCCompilerKind.INSTANCE)) {
            compilerAsmTranslator = new GCCAsmTranslator(compileDescriptor, mappedSrcFile, project2);
        } else if (Intrinsics.areEqual((Object)oCCompilerKind, (Object)ClangCompilerKind.INSTANCE) || Intrinsics.areEqual((Object)oCCompilerKind, (Object)AppleClangCompilerKind.INSTANCE)) {
            compilerAsmTranslator = new GCCAsmTranslator(compileDescriptor, mappedSrcFile, project2);
        } else if (Intrinsics.areEqual((Object)oCCompilerKind, (Object)MSVCCompilerKind.INSTANCE)) {
            compilerAsmTranslator = cppEnv.getToolchain().getToolSetKind().isRemoteLike() ? null : new MSVCAsmTranslator(compileDescriptor, mappedSrcFile, project2);
        } else if (Intrinsics.areEqual((Object)oCCompilerKind, (Object)ClangClCompilerKind.INSTANCE)) {
            compilerAsmTranslator = cppEnv.getToolchain().getToolSetKind().isRemoteLike() ? null : new ClangClAsmTranslator(compileDescriptor, mappedSrcFile, project2);
        } else {
            CidrTranslateCodeService.LOG.debug("Unsupported compiler " + compileDescriptor.getCompilerKind() + " for " + srcFile.getPath());
            compilerAsmTranslator = null;
        }
        CompilerAsmTranslator translator = compilerAsmTranslator;
        return CollectionsKt.listOfNotNull((Object)translator);
    }

    private final CLionCompileFileUtil.FileDescriptor getFileDescriptor(Project project, VirtualFile srcFile) {
        CLionCompileTaskRunner compileTaskRunner;
        CidrProjectTaskRunner projectTaskRunner;
        Object object;
        ProjectTaskContext taskContext;
        ModuleFilesBuildTaskImpl task;
        block3: {
            Module module = (Module)ApplicationManager.getApplication().runReadAction(() -> CompilerAsmTranslatorProvider.getFileDescriptor$lambda$0(project, srcFile));
            if (module == null) {
                CidrTranslateCodeService.LOG.debug("Cannot find module for " + srcFile.getPath());
                return null;
            }
            VirtualFile[] virtualFileArray = new VirtualFile[]{srcFile};
            task = new ModuleFilesBuildTaskImpl(module, false, virtualFileArray);
            taskContext = new ProjectTaskContext().withUserData(CLionCompileTaskRunner.Companion.getCOMPILER_FLAGS_SYNTAX_ONLY(), (Object)false);
            for (Object object2 : ProjectTaskRunner.EP_NAME.getExtensions()) {
                ProjectTaskRunner it = (ProjectTaskRunner)object2;
                boolean bl = false;
                if (!(it instanceof CidrProjectTaskRunner && ((CidrProjectTaskRunner)it).canRun(project, (ProjectTask)task, taskContext))) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        Object object3 = object;
        CidrProjectTaskRunner cidrProjectTaskRunner = projectTaskRunner = object3 instanceof CidrProjectTaskRunner ? (CidrProjectTaskRunner)object3 : null;
        CidrTaskRunner cidrTaskRunner = cidrProjectTaskRunner != null ? cidrProjectTaskRunner.runnerForTask((ProjectTask)task, project) : null;
        CLionCompileTaskRunner cLionCompileTaskRunner = compileTaskRunner = cidrTaskRunner instanceof CLionCompileTaskRunner ? (CLionCompileTaskRunner)cidrTaskRunner : null;
        if (compileTaskRunner == null) {
            CidrTranslateCodeService.LOG.debug("Cannot find compile task runner for " + srcFile.getPath());
            return null;
        }
        Intrinsics.checkNotNull((Object)taskContext);
        return compileTaskRunner.getFileDescriptor(project, srcFile, taskContext);
    }

    private static final Module getFileDescriptor$lambda$0(Project $project, VirtualFile $srcFile) {
        return ProjectFileIndex.getInstance((Project)$project).getModuleForFile($srcFile, false);
    }
}

