/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.CidrRunnerBundle;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.execution.build.CidrBuild;
import com.jetbrains.cidr.execution.build.CidrBuildEvent;
import com.jetbrains.cidr.execution.build.CidrBuildId;
import com.jetbrains.cidr.execution.build.CidrBuildListener;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.execution.build.CidrBuildUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CLionBuildUtil
extends CidrBuildUtil {
    public static final Key<RunnerAndConfigurationSettings> BEFORE_RUN_TASK_CONFIGURATION = Key.create((String)"BEFORE_RUN_TASK_EXECUTION_ENVIRONMENT");

    @NotNull
    public static CidrBuildListener notificationListener(final @NotNull MessageBusConnection connection, final @NotNull CidrBuildId buildId, final @NotNull ProcessHandler processHandler, final @NotNull String taskName, final @Nullable String preBuildMessage) {
        if (connection == null) {
            CLionBuildUtil.$$$reportNull$$$0(0);
        }
        if (buildId == null) {
            CLionBuildUtil.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            CLionBuildUtil.$$$reportNull$$$0(2);
        }
        if (taskName == null) {
            CLionBuildUtil.$$$reportNull$$$0(3);
        }
        return new CidrBuildListener(){

            public void beforeStarted(@NotNull CidrBuildEvent buildEvent) {
                if (buildEvent == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!buildId.equals((Object)buildEvent.getBuildId())) {
                    return;
                }
                if (preBuildMessage != null) {
                    CLionBuildUtil.showBuildLogNotification(processHandler, MessageType.INFO, preBuildMessage + "\n");
                }
            }

            public void afterFinished(@NotNull CidrBuildEvent buildEvent, @NotNull CidrBuildResult result2) {
                if (buildEvent == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!buildId.equals((Object)buildEvent.getBuildId())) {
                    return;
                }
                if (result2.getMessageType() != MessageType.ERROR) {
                    CLionBuildUtil.showBuildLogNotification(processHandler, result2.getMessageType(), "\n" + CidrRunnerBundle.message((String)"build.finished", (Object[])new Object[]{taskName}) + "\n");
                }
                connection.disconnect();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "buildEvent";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/build/CLionBuildUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeStarted";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static void showBuildLogNotification(@NotNull ProcessHandler handler, @NotNull MessageType messageType, @NotNull String message) {
        if (handler == null) {
            CLionBuildUtil.$$$reportNull$$$0(4);
        }
        if (messageType == null) {
            CLionBuildUtil.$$$reportNull$$$0(5);
        }
        if (message == null) {
            CLionBuildUtil.$$$reportNull$$$0(6);
        }
        handler.notifyTextAvailable(message, messageType == MessageType.ERROR ? ProcessOutputTypes.STDERR : ProcessOutputTypes.SYSTEM);
    }

    @Nullable
    public static Object getBuildSessionId(@Nullable Content content) {
        if (content == null || !(content.getComponent() instanceof ConsoleViewImpl)) {
            return null;
        }
        return content.getUserData(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY);
    }

    @NotNull
    public static String buildDescription(@Nullable String preBuildMessage, @NotNull String task, @Nullable String target, @Nullable String profile) {
        if (task == null) {
            CLionBuildUtil.$$$reportNull$$$0(7);
        }
        String header = target != null && profile != null ? CLionExecutionBundle.message("cpp.build.description.3", task, target, profile) : (target != null ? CLionExecutionBundle.message("cpp.build.description.2", task, target) : (profile != null ? CLionExecutionBundle.message("cpp.build.description.2", task, profile) : CLionExecutionBundle.message("cpp.build.description.1", task)));
        StringBuilder description = new StringBuilder();
        description.append(header);
        description.append(StringUtil.repeatSymbol((char)'=', (int)Math.max(80 - header.length(), 0)));
        if (preBuildMessage != null) {
            description.append('\n');
            description.append(preBuildMessage);
        }
        String string = description.toString();
        if (string == null) {
            CLionBuildUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/build/CLionBuildUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/build/CLionBuildUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "notificationListener";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showBuildLogNotification";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildDescription";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    public static class StopBuildAction
    extends DumbAwareAction {
        @NotNull
        private final ConsoleViewImpl myConsoleView;

        public StopBuildAction(@NotNull ConsoleViewImpl consoleView) {
            if (consoleView == null) {
                StopBuildAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.message((String)"action.stop", (Object[])new Object[0]), null, AllIcons.Actions.Suspend);
            this.myConsoleView = consoleView;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CidrBuild.BuildContext context;
            if (e == null) {
                StopBuildAction.$$$reportNull$$$0(1);
            }
            if ((context = this.getConsoleBuildContext()) != null) {
                context.stop();
            }
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                StopBuildAction.$$$reportNull$$$0(2);
            }
            CidrBuild.BuildContext context = this.getConsoleBuildContext();
            event.getPresentation().setEnabled(context != null && context.isRunning());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                StopBuildAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        @Nullable
        public CidrBuild.BuildContext getConsoleBuildContext() {
            return (CidrBuild.BuildContext)this.myConsoleView.getClientProperty(CidrBuild.BuildContext.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/build/CLionBuildUtil$StopBuildAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/build/CLionBuildUtil$StopBuildAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

