/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.peripheralview;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdNode;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRegister;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SvdAddressCoalescer {
    protected final List<Pair<AddressRange, List<SvdRegister>>> myRanges = new ArrayList<Pair<AddressRange, List<SvdRegister>>>();

    public void loadFrom(@NotNull Collection<SvdNode<?>> nodes) {
        if (nodes == null) {
            SvdAddressCoalescer.$$$reportNull$$$0(0);
        }
        List<SvdRegister> sortedRegisters = nodes.stream().filter(SvdRegister.class::isInstance).map(SvdRegister.class::cast).filter(register -> register.getAccess().isReadable()).sorted(Comparator.comparing(SvdRegister::getAddress)).toList();
        if (sortedRegisters.isEmpty()) {
            return;
        }
        SmartList lastList = null;
        Address lastStart = null;
        Address lastEnd = null;
        for (SvdRegister register2 : sortedRegisters) {
            Address registerEnd = register2.getAddress().plus((Number)SvdAddressCoalescer.calcSize(register2));
            if (lastStart != null) {
                if (lastStart.compareTo(register2.getAddress()) <= 0 && lastEnd.compareTo(register2.getAddress()) >= 0) {
                    lastList.add(register2);
                    if (lastEnd.compareTo(registerEnd) >= 0) continue;
                    lastEnd = registerEnd;
                    continue;
                }
                if (lastStart.compareTo(registerEnd) <= 0 && lastEnd.compareTo(registerEnd) >= 0) {
                    lastList.add(register2);
                    if (lastStart.compareTo(register2.getAddress()) >= 0) continue;
                    lastStart = register2.getAddress();
                    continue;
                }
                this.myRanges.add((Pair<AddressRange, List<SvdRegister>>)Pair.create((Object)new AddressRange(lastStart, lastEnd.minus((Number)1)), (Object)lastList));
                lastStart = register2.getAddress();
                lastEnd = registerEnd;
                lastList = new SmartList();
                lastList.add(register2);
                continue;
            }
            lastStart = register2.getAddress();
            lastEnd = registerEnd;
            lastList = new SmartList();
            lastList.add(register2);
        }
        this.myRanges.add((Pair<AddressRange, List<SvdRegister>>)Pair.create((Object)new AddressRange(lastStart, lastEnd.minus((Number)1)), lastList));
    }

    public static SvdAddressCoalescer create(@NotNull Collection<SvdNode<?>> nodes) {
        if (nodes == null) {
            SvdAddressCoalescer.$$$reportNull$$$0(1);
        }
        SvdAddressCoalescer coalescer = new SvdAddressCoalescer();
        coalescer.loadFrom(nodes);
        return coalescer;
    }

    private static int calcSize(SvdRegister register) {
        return (register.getBitSize() + 7) / 8;
    }

    public void updateValues(@NotNull CidrDebugProcess process2, @NotNull Runnable updateListener) {
        if (process2 == null) {
            SvdAddressCoalescer.$$$reportNull$$$0(2);
        }
        if (updateListener == null) {
            SvdAddressCoalescer.$$$reportNull$$$0(3);
        }
        for (Pair<AddressRange, List<SvdRegister>> pair : this.myRanges) {
            for (SvdRegister register : (List)pair.getSecond()) {
                register.markNoValue(XDebuggerUIConstants.getCollectingDataMessage(), false);
            }
        }
        updateListener.run();
        for (Pair<AddressRange, List<SvdRegister>> pair : this.myRanges) {
            @NotNull AddressRange addressRange = (AddressRange)pair.first;
            process2.postCommand((CidrDebugProcess.DebuggerCommand)((CidrDebugProcess.SuspendedDebuggerCommand)driver -> driver.dumpMemory(addressRange))).whenComplete((hunks, exception) -> {
                try {
                    for (SvdRegister register : (List)pair.getSecond()) {
                        try {
                            register.processValue((List<LLMemoryHunk>)hunks, (Throwable)exception);
                        }
                        catch (Throwable e) {
                            register.markNoValue(StringUtil.notNullize((String)e.getMessage()), true);
                            Logger.getInstance(SvdAddressCoalescer.class).error(e);
                        }
                    }
                }
                finally {
                    updateListener.run();
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateListener";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdAddressCoalescer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateValues";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

