/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.SpinnerKt;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.DownloadType;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetMacroSupportKt;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetParameters;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetParametersBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b\u001a$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u001a-\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0011\u0010\u0016\u001a\r\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00180\u0017H\u0007\u001a\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\u0006\u0010\u001b\u001a\u00020\u0015\u001a\u0016\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"DEBUG_TARGET_HISTORY_CAPACITY", "", "warmupControl", "", "Lcom/intellij/ui/dsl/builder/Panel;", "debugTargetParameters", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetParameters;", "resetControl", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetParametersBase;", "downloadControl", "bindHexUIntText", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBTextField;", "property", "Lkotlin/reflect/KMutableProperty0;", "Lkotlin/UInt;", "validateExecutablePath", "Lcom/intellij/openapi/ui/ValidationInfo;", "enabled", "", "path", "", "errorMessageSupplier", "Ljava/util/function/Supplier;", "Lorg/jetbrains/annotations/Nls;", "getHistory", "", "key", "saveToHistory", "value", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nDebugTargetEditorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTargetEditorBase.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetEditorBaseKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n774#2:279\n865#2,2:280\n1#3:282\n*S KotlinDebug\n*F\n+ 1 DebugTargetEditorBase.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetEditorBaseKt\n*L\n275#1:279\n275#1:280,2\n*E\n"})
public final class DebugTargetEditorBaseKt {
    public static final int DEBUG_TARGET_HISTORY_CAPACITY = 10;

    public static final void warmupControl(@NotNull Panel $this$warmupControl, @NotNull DebugTargetParameters debugTargetParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$warmupControl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)debugTargetParameters, (String)"debugTargetParameters");
        Panel.row$default((Panel)$this$warmupControl, null, arg_0 -> DebugTargetEditorBaseKt.warmupControl$lambda$2(debugTargetParameters, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
    }

    public static final void resetControl(@NotNull Panel $this$resetControl, @NotNull DebugTargetParametersBase debugTargetParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$resetControl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)debugTargetParameters, (String)"debugTargetParameters");
        Panel.group$default((Panel)$this$resetControl, (String)CLionExecutionBundle.message("debug.targets.edit.group.reset", new Object[0]), (boolean)false, arg_0 -> DebugTargetEditorBaseKt.resetControl$lambda$13(debugTargetParameters, arg_0), (int)2, null);
    }

    public static final void downloadControl(@NotNull Panel $this$downloadControl, @NotNull DebugTargetParametersBase debugTargetParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$downloadControl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)debugTargetParameters, (String)"debugTargetParameters");
        Panel.row$default((Panel)$this$downloadControl, null, arg_0 -> DebugTargetEditorBaseKt.downloadControl$lambda$14(debugTargetParameters, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
    }

    @NotNull
    public static final Cell<JBTextField> bindHexUIntText(@NotNull Cell<? extends JBTextField> $this$bindHexUIntText, @NotNull KMutableProperty0<UInt> property) {
        Intrinsics.checkNotNullParameter($this$bindHexUIntText, (String)"<this>");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Function2 uintValidation = DebugTargetEditorBaseKt::bindHexUIntText$lambda$15;
        TextFieldKt.bindText($this$bindHexUIntText, () -> DebugTargetEditorBaseKt.bindHexUIntText$lambda$16(property), arg_0 -> DebugTargetEditorBaseKt.bindHexUIntText$lambda$18(property, arg_0)).validationOnInput(uintValidation).validationOnApply(uintValidation);
        return $this$bindHexUIntText;
    }

    @RequiresBackgroundThread
    @Nullable
    public static final ValidationInfo validateExecutablePath(boolean enabled, @NotNull String path, @NotNull Supplier<String> errorMessageSupplier) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(errorMessageSupplier, (String)"errorMessageSupplier");
        if (!enabled) {
            return null;
        }
        try {
            File file;
            if (new File(path).canExecute()) {
                return null;
            }
            File file2 = PathEnvironmentVariableUtil.findInPath((String)path);
            boolean bl = file2 != null ? file2.canExecute() : false;
            if (bl) {
                return null;
            }
            File file3 = file = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)path);
            boolean bl2 = file3 != null ? file3.canExecute() : false;
            if (bl2) {
                return null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ValidationInfo(errorMessageSupplier.get()).withOKEnabled();
    }

    @NotNull
    public static final List<String> getHistory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List list2 = PropertiesComponent.getInstance().getList(key);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String saveToHistory(@NotNull String key, @NotNull String value) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.isBlank((CharSequence)value)) {
            return value;
        }
        Iterable iterable = DebugTargetEditorBaseKt.getHistory(key);
        Collection collection = CollectionsKt.listOf((Object)value);
        boolean $i$f$filter = false;
        void var5_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)value))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (int)10);
        PropertiesComponent.getInstance().setList(key, (Collection)list2);
        return value;
    }

    private static final int warmupControl$lambda$2$lambda$0(DebugTargetParameters $debugTargetParameters) {
        return $debugTargetParameters.getWarmUpMs();
    }

    private static final Unit warmupControl$lambda$2$lambda$1(DebugTargetParameters $debugTargetParameters, int it) {
        $debugTargetParameters.setWarmUpMs(it);
        return Unit.INSTANCE;
    }

    private static final Unit warmupControl$lambda$2(DebugTargetParameters $debugTargetParameters, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        IntRange startupDelayRangeMs = new IntRange(0, 60000);
        int startupDelayStep = 500;
        Cell cell = $this$row.spinner(startupDelayRangeMs, startupDelayStep);
        String string = CLionExecutionBundle.message("debug.targets.edit.label.startup.delay", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        SpinnerKt.bindIntValue((Cell)Cell.label$default((Cell)cell, (String)string, null, (int)2, null), () -> DebugTargetEditorBaseKt.warmupControl$lambda$2$lambda$0($debugTargetParameters), arg_0 -> DebugTargetEditorBaseKt.warmupControl$lambda$2$lambda$1($debugTargetParameters, arg_0)).gap(RightGap.SMALL);
        String string2 = CLionExecutionBundle.message("debug.targets.edit.label.ms", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.label(string2);
        return Unit.INSTANCE;
    }

    private static final String resetControl$lambda$13$lambda$7$lambda$3(DebugTargetParametersBase $debugTargetParameters) {
        return $debugTargetParameters.getResetCommand();
    }

    private static final Unit resetControl$lambda$13$lambda$7$lambda$4(DebugTargetParametersBase $debugTargetParameters, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $debugTargetParameters.setResetCommand(it);
        return Unit.INSTANCE;
    }

    private static final boolean resetControl$lambda$13$lambda$7$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit resetControl$lambda$13$lambda$7$lambda$6(ExtendableTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        MacrosDialog.addTextFieldExtension((ExtendableTextField)$this$applyToComponent, arg_0 -> DebugTargetEditorBaseKt.resetControl$lambda$13$lambda$7$lambda$6$lambda$5(DebugTargetMacroSupportKt.getDEBUG_TARGET_MACRO_FILTER(), arg_0), null);
        return Unit.INSTANCE;
    }

    private static final Unit resetControl$lambda$13$lambda$7(DebugTargetParametersBase $debugTargetParameters, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = TextFieldKt.bindText((Cell)$this$row.cell((JComponent)new ExtendableTextField()), () -> DebugTargetEditorBaseKt.resetControl$lambda$13$lambda$7$lambda$3($debugTargetParameters), arg_0 -> DebugTargetEditorBaseKt.resetControl$lambda$13$lambda$7$lambda$4($debugTargetParameters, arg_0));
        String string = CLionExecutionBundle.message("debug.targets.edit.reset.label.command", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.label$default((Cell)cell, (String)string, null, (int)2, null).align(Align.FILL).applyToComponent(DebugTargetEditorBaseKt::resetControl$lambda$13$lambda$7$lambda$6);
        return Unit.INSTANCE;
    }

    private static final boolean resetControl$lambda$13$lambda$12$lambda$8(DebugTargetParametersBase $debugTargetParameters) {
        return $debugTargetParameters.isResetBeforeLoad();
    }

    private static final Unit resetControl$lambda$13$lambda$12$lambda$9(DebugTargetParametersBase $debugTargetParameters, boolean it) {
        $debugTargetParameters.setResetBeforeLoad(it);
        return Unit.INSTANCE;
    }

    private static final boolean resetControl$lambda$13$lambda$12$lambda$10(DebugTargetParametersBase $debugTargetParameters) {
        return $debugTargetParameters.isResetAfterLoad();
    }

    private static final Unit resetControl$lambda$13$lambda$12$lambda$11(DebugTargetParametersBase $debugTargetParameters, boolean it) {
        $debugTargetParameters.setResetAfterLoad(it);
        return Unit.INSTANCE;
    }

    private static final Unit resetControl$lambda$13$lambda$12(DebugTargetParametersBase $debugTargetParameters, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CLionExecutionBundle.message("debug.targets.edit.reset.label.before.download", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), () -> DebugTargetEditorBaseKt.resetControl$lambda$13$lambda$12$lambda$8($debugTargetParameters), arg_0 -> DebugTargetEditorBaseKt.resetControl$lambda$13$lambda$12$lambda$9($debugTargetParameters, arg_0));
        String string2 = CLionExecutionBundle.message("debug.targets.edit.reset.label.after.download", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string2), () -> DebugTargetEditorBaseKt.resetControl$lambda$13$lambda$12$lambda$10($debugTargetParameters), arg_0 -> DebugTargetEditorBaseKt.resetControl$lambda$13$lambda$12$lambda$11($debugTargetParameters, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit resetControl$lambda$13(DebugTargetParametersBase $debugTargetParameters, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> DebugTargetEditorBaseKt.resetControl$lambda$13$lambda$7($debugTargetParameters, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
        String string = CLionExecutionBundle.message("debug.targets.edit.reset.label.reset", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$group.row(string, arg_0 -> DebugTargetEditorBaseKt.resetControl$lambda$13$lambda$12($debugTargetParameters, arg_0)).layout(RowLayout.LABEL_ALIGNED);
        return Unit.INSTANCE;
    }

    private static final Unit downloadControl$lambda$14(DebugTargetParametersBase $debugTargetParameters, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = Row.comboBox$default((Row)$this$row, (Collection)((Collection)EntriesMappings.entries$0), null, (int)2, null);
        String string = CLionExecutionBundle.message("debug.targets.edit.label.download.executable", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ComboBoxKt.bindItem((Cell)Cell.label$default((Cell)cell, (String)string, null, (int)2, null), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($debugTargetParameters){

            public Object get() {
                return ((DebugTargetParametersBase)this.receiver).getDownloadType();
            }

            public void set(Object value) {
                ((DebugTargetParametersBase)this.receiver).setDownloadType((DownloadType)((Object)value));
            }
        }))).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final UInt bindHexUIntText$parseUint(String s) {
        UInt uInt;
        if (StringsKt.startsWith((String)s, (String)"0x", (boolean)true)) {
            String string = s.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            uInt = UStringsKt.toUIntOrNull((String)string, (int)16);
        } else {
            uInt = UStringsKt.toUIntOrNull((String)s);
        }
        return uInt;
    }

    private static final ValidationInfo bindHexUIntText$lambda$15(ValidationInfoBuilder validationInfoBuilder, JBTextField field2) {
        Intrinsics.checkNotNullParameter((Object)validationInfoBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        String string = field2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return DebugTargetEditorBaseKt.bindHexUIntText$parseUint(string) == null ? new ValidationInfo(UIBundle.message((String)"please.enter.a.number", (Object[])new Object[0]), (JComponent)field2) : null;
    }

    private static final String bindHexUIntText$lambda$16(KMutableProperty0 $property) {
        return "0x" + UStringsKt.toString-V7xB4Y4((int)((UInt)$property.invoke()).unbox-impl(), (int)16);
    }

    private static final Unit bindHexUIntText$lambda$18(KMutableProperty0 $property, String s) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            UInt uInt = DebugTargetEditorBaseKt.bindHexUIntText$parseUint(s);
            if (uInt == null) break block0;
            int it = uInt.unbox-impl();
            boolean bl = false;
            $property.set((Object)UInt.box-impl((int)it));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DownloadType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])DownloadType.values());
        }
    }
}

