/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.live;

import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.MouseButtonKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.live.AddAction;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.live.CopyCellsAction;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.live.EditAction;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.live.LiveWatchesFormat;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.live.LiveWatchesTreeTable;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.live.LiveWatchesVariable;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.live.RemoveAction;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/VariableMouseClick;", "Ljava/awt/event/MouseAdapter;", "table", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/LiveWatchesTreeTable;", "<init>", "(Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/LiveWatchesTreeTable;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "SetFormatAction", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nVariableMouseClick.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableMouseClick.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/VariableMouseClick\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1869#2,2:72\n*S KotlinDebug\n*F\n+ 1 VariableMouseClick.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/VariableMouseClick\n*L\n50#1:72,2\n*E\n"})
public final class VariableMouseClick
extends MouseAdapter {
    @NotNull
    private final LiveWatchesTreeTable table;

    public VariableMouseClick(@NotNull LiveWatchesTreeTable table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        this.table = table;
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        int columnIndex;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (MouseButtonKt.getMouseButton((MouseEvent)e) == MouseButton.Right) {
            LiveWatchesVariable clickedVar;
            Object object = this.table.getModel().getValueAt(this.table.rowAtPoint(e.getPoint()), 0);
            LiveWatchesVariable liveWatchesVariable = clickedVar = object instanceof LiveWatchesVariable ? (LiveWatchesVariable)object : null;
            if (clickedVar != null) {
                DefaultActionGroup group = new DefaultActionGroup();
                AnAction[] anActionArray = new AnAction[]{new AddAction(this.table), new EditAction(this.table), new RemoveAction(this.table)};
                group.addAll(anActionArray);
                group.addSeparator(CLionExecutionBundle.message("livewatches.popup.separator.title", new Object[0]));
                Iterable $this$forEach$iv = (Iterable)LiveWatchesFormat.getEntries();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LiveWatchesFormat it = (LiveWatchesFormat)((Object)element$iv);
                    boolean bl = false;
                    group.add((AnAction)new SetFormatAction(clickedVar, it));
                }
                group.addSeparator();
                group.add((AnAction)new CopyCellsAction(this.table));
                ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, DataContext.EMPTY_CONTEXT, null, true);
                Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
                ListPopup popup = listPopup;
                popup.showInScreenCoordinates((Component)((Object)this.table), e.getLocationOnScreen());
            }
        } else if (MouseButtonKt.getMouseButton((MouseEvent)e) == MouseButton.Left && e.getClickCount() >= 2 && (columnIndex = this.table.columnAtPoint(e.getPoint())) >= 0 && Intrinsics.areEqual((Object)this.table.getColumnModel().getColumn(columnIndex).getIdentifier(), (Object)"livewatches.column.name.watch")) {
            LiveWatchesVariable clickedVar;
            Object object = this.table.getModel().getValueAt(this.table.rowAtPoint(e.getPoint()), 0);
            LiveWatchesVariable liveWatchesVariable = clickedVar = object instanceof LiveWatchesVariable ? (LiveWatchesVariable)object : null;
            if (clickedVar != null) {
                this.table.createEditVariablePopup$intellij_clion_execution(clickedVar).showInScreenCoordinates((Component)((Object)this.table), e.getLocationOnScreen());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/VariableMouseClick$SetFormatAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "variable", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/LiveWatchesVariable;", "format", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/LiveWatchesFormat;", "<init>", "(Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/VariableMouseClick;Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/LiveWatchesVariable;Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/LiveWatchesFormat;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "setSelected", "", "state", "intellij.clion.execution"})
    @SourceDebugExtension(value={"SMAP\nVariableMouseClick.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableMouseClick.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/VariableMouseClick$SetFormatAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,71:1\n13472#2:72\n13473#2:74\n19#3:73\n*S KotlinDebug\n*F\n+ 1 VariableMouseClick.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/live/VariableMouseClick$SetFormatAction\n*L\n34#1:72\n34#1:74\n35#1:73\n*E\n"})
    private final class SetFormatAction
    extends DumbAwareToggleAction {
        @NotNull
        private final LiveWatchesVariable variable;
        @NotNull
        private final LiveWatchesFormat format;

        public SetFormatAction(@NotNull LiveWatchesVariable variable, LiveWatchesFormat format) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            super(CLionExecutionBundle.messagePointer(format.getTitleKey(), new Object[0]));
            this.variable = variable;
            this.format = format;
            this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.Never);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return this.variable.getFormat() == this.format;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (state) {
                TreePath[] treePathArray = VariableMouseClick.this.table.getTree().getSelectionPaths();
                Intrinsics.checkNotNullExpressionValue((Object)treePathArray, (String)"getSelectionPaths(...)");
                Object[] $this$forEach$iv = treePathArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TreePath it = (TreePath)element$iv;
                    boolean bl = false;
                    Object $this$asSafely$iv = it.getLastPathComponent();
                    boolean $i$f$asSafely = false;
                    Object object = $this$asSafely$iv;
                    if (!(object instanceof LiveWatchesVariable)) {
                        object = null;
                    }
                    LiveWatchesVariable liveWatchesVariable = (LiveWatchesVariable)object;
                    if (liveWatchesVariable == null) continue;
                    liveWatchesVariable.setFormat(this.format);
                }
                VariableMouseClick.this.table.repaint();
                VariableMouseClick.this.table.storeState();
            }
        }
    }
}

