/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAbstractGenerateTestHandler<P extends OCMembersContainer, M extends OCSymbolWithParent, C extends OCActionContext<P, M>>
extends OCClassActionHandlerBase<P, M, C> {
    private static final Logger LOG = Logger.getInstance((String)OCAbstractGenerateTestHandler.class.getName());
    private final @NlsContexts.Command @NotNull String myActionTitle;
    @NotNull
    @NonNls
    private final String myTemplateName;

    protected OCAbstractGenerateTestHandler(@NlsContexts.Command @NotNull String actionTitle, @NotNull @NonNls String templateName) {
        if (actionTitle == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(0);
        }
        if (templateName == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(1);
        }
        this.myActionTitle = actionTitle;
        this.myTemplateName = templateName;
    }

    @NotNull
    protected String getActionTitle() {
        String string = this.myActionTitle;
        if (string == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected String getMembersChooserTitle() {
        return "";
    }

    protected boolean enableChooseDialog(Collection<M> candidates) {
        return false;
    }

    protected boolean allowEmptySelection(C context) {
        return true;
    }

    @NotNull
    private Template createTestMethodTemplate(@NotNull FileTemplateDescriptor templateDesc, Project project) {
        if (templateDesc == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(3);
        }
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
        String templateText = this.getTemplateText(templateDesc, project);
        int from = 0;
        Pattern pattern = Pattern.compile("\\$\\{(\\w+)}");
        Matcher m = pattern.matcher(templateText);
        HashSet<String> createdVariables = new HashSet<String>();
        while (m.find()) {
            String name = m.group(1);
            template.addTextSegment(templateText.substring(from, m.start()));
            if (name.equals("END")) {
                template.addEndVariable();
            } else if (createdVariables.contains(name)) {
                template.addVariableSegment(name);
            } else {
                ConstantNode nameExpr = new ConstantNode(name);
                template.addVariable(name, (Expression)nameExpr, (Expression)nameExpr, true);
                createdVariables.add(name);
            }
            from = m.end();
        }
        template.addTextSegment(templateText.substring(from));
        template.setToIndent(true);
        template.setToReformat(true);
        template.setToShortenLongNames(true);
        Template template2 = template;
        if (template2 == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(4);
        }
        return template2;
    }

    @NotNull
    protected String getTemplateText(@NotNull FileTemplateDescriptor templateDesc, Project project) {
        String templateText;
        if (templateDesc == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(5);
        }
        String templateName = templateDesc.getFileName();
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getCodeTemplate(templateName);
        try {
            templateText = fileTemplate.getText(FileTemplateManager.getInstance((Project)project).getDefaultProperties());
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            templateText = fileTemplate.getText();
        }
        String string = templateText;
        if (string == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected abstract int getInsertPos(@NotNull PsiElement var1, int var2, @Nullable PsiElement var3, @NotNull List<M> var4, @NotNull C var5);

    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        if (body == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(7);
        }
        return false;
    }

    @Nullable
    protected PsiElement getElementToModify(@NotNull C context) {
        if (context == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(8);
        }
        List symbols = context.getSymbolsToModify();
        PsiElement result = null;
        if (symbols.size() == 1) {
            result = ((OCSymbol)symbols.get(0)).locateDefinition(context.getProject());
        }
        if (result == null) {
            LOG.warn("Can't locate element to modify");
        }
        return result;
    }

    protected void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull C actionContext, @NotNull List<M> chosenCandidates) {
        PsiElement element;
        if (project == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(10);
        }
        if (actionContext == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(11);
        }
        if (chosenCandidates == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(12);
        }
        if ((element = this.getElementToModify(actionContext)) == null) {
            return;
        }
        final PsiFile elementFile = element.getContainingFile();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{elementFile}).withName(this.getActionTitle()).run(() -> {
            int caretPos = editor != null ? editor.getCaretModel().getOffset() : -1;
            PsiElement at = null;
            if (editor != null && (at = file.findElementAt(caretPos)) == null) {
                at = file.getLastChild();
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(elementFile)) {
                return;
            }
            if (element.isValid()) {
                VirtualFile virtualFile = elementFile.getVirtualFile();
                if (virtualFile != null) {
                    CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{virtualFile});
                }
                final Editor elementEditor = EditorHelper.openInEditor((PsiElement)elementFile);
                final int insertPosition = this.getInsertPos(element, caretPos, at, chosenCandidates, actionContext);
                if (elementEditor == null || insertPosition == -1) {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)elementEditor, (String)CidrBundle.message("abstract.generate.action.invalid", new Object[0]), (String)this.getActionTitle(), null);
                } else {
                    elementEditor.getCaretModel().moveToOffset(insertPosition);
                    FileTemplateDescriptor fileTemplateDescriptor = new FileTemplateDescriptor(this.myTemplateName);
                    Template template = this.createTestMethodTemplate(fileTemplateDescriptor, project);
                    TemplateManager.getInstance((Project)project).startTemplate(elementEditor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

                        public void templateFinished(@NotNull Template template, boolean brokenOff) {
                            PsiElement element;
                            if (template == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if ((element = elementFile.findElementAt(insertPosition)) instanceof PsiWhiteSpace) {
                                element = element.getNextSibling();
                            }
                            if (element != null) {
                                RangeMarker rangeMarker = elementEditor.getDocument().createRangeMarker(element.getTextRange());
                                OCAbstractGenerateTestHandler.this.onTemplateFinished(elementFile, rangeMarker);
                                OCCodeInsightUtil.showCallableInEditorAndSelectBody((PsiFile)elementFile, (Segment)rangeMarker, OCAbstractGenerateTestHandler.this::shouldSelectResult);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler$1", "templateFinished"));
                        }
                    });
                }
            }
        });
    }

    protected void onTemplateFinished(@NotNull PsiFile file, @NotNull RangeMarker rangeMarker) {
        if (file == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(13);
        }
        if (rangeMarker == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(14);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionTitle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateDesc";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCandidates";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestMethodTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTestMethodTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldSelectResult";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementToModify";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onTemplateFinished";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6 -> new IllegalStateException(string);
        };
    }
}

