/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u0016\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u0006\u0010\u001b\u001a\u00020\u0011J\u0010\u0010\u001c\u001a\u00020\u00112\b\b\u0002\u0010\u001d\u001a\u00020\u000fJ\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0012\u0010\u001e\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerPythonSelfProfilingService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lock", "pids", "", "", "snapshotDirectory", "Ljava/nio/file/Path;", "profilingScope", "Lkotlinx/coroutines/CoroutineScope;", "isProfiling", "", "registerCreatedDebuggerPid", "", "pid", "registerLoadedDebuggerProcess", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "unregisterDebuggerPid", "startProfiling", "resultDirectory", "", "parentScope", "stopProfiling", "cancelProfiling", "shouldCleanUp", "startProfilingImpl", "debugProcess", "saveSnapshot", "stopProfilingImpl", "cleanUp", "directory", "getDebugProcess", "Companion", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrDebuggerPythonSelfProfilingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDebuggerPythonSelfProfilingService.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebuggerPythonSelfProfilingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,181:1\n1869#2,2:182\n1869#2,2:184\n1563#2:189\n1634#2,3:190\n295#2,2:193\n3829#3:186\n4344#3,2:187\n*S KotlinDebug\n*F\n+ 1 CidrDebuggerPythonSelfProfilingService.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebuggerPythonSelfProfilingService\n*L\n76#1:182,2\n163#1:184,2\n173#1:189\n173#1:190,3\n174#1:193,2\n172#1:186\n172#1:187,2\n*E\n"})
public final class CidrDebuggerPythonSelfProfilingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Object lock;
    @NotNull
    private final Set<Long> pids;
    @Nullable
    private Path snapshotDirectory;
    @Nullable
    private CoroutineScope profilingScope;
    private boolean isProfiling;

    public CidrDebuggerPythonSelfProfilingService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lock = new Object();
        this.pids = new LinkedHashSet();
    }

    public final void registerCreatedDebuggerPid(long pid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerLoadedDebuggerProcess(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Long l = process.getLocalDebuggerPid();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            if (!(process.getRunParameters().getDebuggerDriverConfiguration() instanceof LLDBDriverConfiguration)) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                boolean bl2;
                boolean bl3 = false;
                if (this.isProfiling) {
                    this.startProfilingImpl(process);
                    bl2 = this.pids.add(it);
                } else {
                    bl2 = this.pids.add(it);
                }
                boolean bl4 = bl2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterDebuggerPid(long pid) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.pids.remove(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startProfiling(@NotNull String resultDirectory, @NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)resultDirectory, (String)"resultDirectory");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.isProfiling) {
                CidrDebuggerLog.LOG.error("Profiling is already started");
                return;
            }
            Iterable $this$forEach$iv = this.pids;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long it = ((Number)element$iv).longValue();
                boolean bl2 = false;
                this.startProfilingImpl(it);
            }
            Path path = Paths.get(resultDirectory, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            this.snapshotDirectory = path;
            this.profilingScope = CoroutineScopeKt.childScope$default((CoroutineScope)parentScope, (String)"PythonProfiling", null, (boolean)false, (int)2, null);
            this.isProfiling = true;
            CoroutineScope coroutineScope = this.profilingScope;
            Intrinsics.checkNotNull((Object)coroutineScope);
            Job job2 = BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)new CoroutineName("CidrDebuggerPythonProfiling")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ CidrDebuggerPythonSelfProfilingService this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final Object invokeSuspend(Object $result) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ** GOTO lbl27
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            do {
                                var2_3 = CidrDebuggerPythonSelfProfilingService.access$getLock$p(this.this$0);
                                var3_4 = this.this$0;
                                var4_5 = var2_3;
                                synchronized (var4_5) {
                                    $i$a$-synchronized-CidrDebuggerPythonSelfProfilingService$startProfiling$1$2$1 = false;
                                    $this$forEach$iv = CidrDebuggerPythonSelfProfilingService.access$getPids$p(var3_4);
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        it = ((Number)element$iv).longValue();
                                        $i$a$-forEach-CidrDebuggerPythonSelfProfilingService$startProfiling$1$2$1$1 = false;
                                        CidrDebuggerPythonSelfProfilingService.access$saveSnapshot(var3_4, it);
                                    }
                                    var5_6 = Unit.INSTANCE;
                                }
lbl27:
                                // 2 sources

                                this.label = 1;
                            } while ((v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this))) != var13_2);
                            return var13_2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopProfiling() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.isProfiling) {
                CidrDebuggerLog.LOG.error("Profiling was not started");
                return;
            }
            Iterator<Long> iterator = this.pids.iterator();
            while (iterator.hasNext()) {
                long pid = ((Number)iterator.next()).longValue();
                this.saveSnapshot(pid);
            }
            this.cancelProfiling(false);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelProfiling(boolean shouldCleanUp) {
        Path resultDirectory = null;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.isProfiling) {
                CidrDebuggerLog.LOG.error("Profiling was not started");
                return;
            }
            Path path = this.snapshotDirectory;
            Intrinsics.checkNotNull((Object)path);
            resultDirectory = path;
            Iterator<Long> iterator = this.pids.iterator();
            while (iterator.hasNext()) {
                long pid = ((Number)iterator.next()).longValue();
                this.stopProfilingImpl(pid);
            }
            CoroutineScope coroutineScope = this.profilingScope;
            Intrinsics.checkNotNull((Object)coroutineScope);
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope, null, (int)1, null);
            this.profilingScope = null;
            this.snapshotDirectory = null;
            this.isProfiling = false;
            Unit unit = Unit.INSTANCE;
        }
        if (shouldCleanUp) {
            Path path = resultDirectory;
            if (path == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resultDirectory");
                path = null;
            }
            this.cleanUp(path);
        }
    }

    public static /* synthetic */ void cancelProfiling$default(CidrDebuggerPythonSelfProfilingService cidrDebuggerPythonSelfProfilingService, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        cidrDebuggerPythonSelfProfilingService.cancelProfiling(bl);
    }

    private final void startProfilingImpl(long pid) {
        CidrDebugProcess debugProcess = this.getDebugProcess(pid);
        this.startProfilingImpl(debugProcess);
    }

    private final void startProfilingImpl(CidrDebugProcess debugProcess) {
        block0: {
            CidrDebugProcess cidrDebugProcess = debugProcess;
            if (cidrDebugProcess == null) break block0;
            cidrDebugProcess.postCommand(CidrDebuggerPythonSelfProfilingService::startProfilingImpl$lambda$7);
        }
    }

    private final void saveSnapshot(long pid) {
        block0: {
            CidrDebugProcess debugProcess;
            Path path = this.snapshotDirectory;
            Intrinsics.checkNotNull((Object)path);
            String outputFile = path + "/Snapshot_" + pid + ".pstat";
            CidrDebugProcess cidrDebugProcess = debugProcess = this.getDebugProcess(pid);
            if (cidrDebugProcess == null) break block0;
            cidrDebugProcess.postCommand(arg_0 -> CidrDebuggerPythonSelfProfilingService.saveSnapshot$lambda$8(outputFile, arg_0));
        }
    }

    private final void stopProfilingImpl(long pid) {
        block0: {
            CidrDebugProcess debugProcess;
            CidrDebugProcess cidrDebugProcess = debugProcess = this.getDebugProcess(pid);
            if (cidrDebugProcess == null) break block0;
            cidrDebugProcess.postCommand(CidrDebuggerPythonSelfProfilingService::stopProfilingImpl$lambda$9);
        }
    }

    private final void cleanUp(Path directory) {
        try {
            Iterable $this$forEach$iv = PathsKt.listDirectoryEntries((Path)directory, (String)"*.pstat");
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Files.deleteIfExists(it);
            }
        }
        catch (Throwable e) {
            CidrDebuggerLog.LOG.error("Failed to cleanup snapshot directory", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CidrDebugProcess getDebugProcess(long pid) {
        Object v3;
        block4: {
            void $this$firstOrNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            XDebugSession[] xDebugSessionArray = XDebuggerManager.getInstance((Project)this.project).getDebugSessions();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSessionArray, (String)"getDebugSessions(...)");
            Object[] objectArray = xDebugSessionArray;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (XDebugSession element$iv$iv : $this$filterTo$iv$iv) {
                XDebugSession it = element$iv$iv;
                boolean bl = false;
                if (!(it.getDebugProcess() instanceof CidrDebugProcess)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                XDebugSession element$iv$iv;
                element$iv$iv = (XDebugSession)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                XDebugProcess xDebugProcess = it.getDebugProcess();
                Intrinsics.checkNotNull((Object)xDebugProcess, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.CidrDebugProcess");
                collection.add((CidrDebugProcess)xDebugProcess);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CidrDebugProcess it = (CidrDebugProcess)element$iv;
                boolean bl = false;
                Long l = it.getLocalDebuggerPid();
                long l2 = pid;
                if (!(l != null && l == l2)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        CidrDebugProcess process = v3;
        if (process == null) {
            CidrDebuggerLog.LOG.error("Cannot find debug process for pid " + pid);
        }
        return process;
    }

    private static final void startProfilingImpl$lambda$7(DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        driver.executeInterpreterCommand(-1L, -1, "jb_python_profiler start");
    }

    private static final void saveSnapshot$lambda$8(String $outputFile, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        driver.executeInterpreterCommand(-1L, -1, "jb_python_profiler dump \"" + $outputFile + "\"");
    }

    private static final void stopProfilingImpl$lambda$9(DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        driver.executeInterpreterCommand(-1L, -1, "jb_python_profiler stop");
    }

    public static final /* synthetic */ Object access$getLock$p(CidrDebuggerPythonSelfProfilingService $this) {
        return $this.lock;
    }

    public static final /* synthetic */ void access$saveSnapshot(CidrDebuggerPythonSelfProfilingService $this, long pid) {
        $this.saveSnapshot(pid);
    }

    public static final /* synthetic */ Set access$getPids$p(CidrDebuggerPythonSelfProfilingService $this) {
        return $this.pids;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerPythonSelfProfilingService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerPythonSelfProfilingService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CidrDebuggerPythonSelfProfilingService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(CidrDebuggerPythonSelfProfilingService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (CidrDebuggerPythonSelfProfilingService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

