/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrThreadFreezer;
import com.jetbrains.cidr.execution.debugger.actions.CidrOneByOneThreadFreezeHandler;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrFreezeInactiveThreadsAmongSelectedHandler;", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrOneByOneThreadFreezeHandler;", "<init>", "()V", "getThreads", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "canHandle", "", "threads", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "handle", "freezer", "Lcom/jetbrains/cidr/execution/debugger/CidrThreadFreezer;", "(Lcom/jetbrains/cidr/execution/debugger/CidrThreadFreezer;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrFreezeThreadActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrFreezeThreadActions.kt\ncom/jetbrains/cidr/execution/debugger/actions/CidrFreezeInactiveThreadsAmongSelectedHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n1761#2,3:344\n*S KotlinDebug\n*F\n+ 1 CidrFreezeThreadActions.kt\ncom/jetbrains/cidr/execution/debugger/actions/CidrFreezeInactiveThreadsAmongSelectedHandler\n*L\n103#1:344,3\n*E\n"})
public final class CidrFreezeInactiveThreadsAmongSelectedHandler
extends CidrOneByOneThreadFreezeHandler {
    @NotNull
    public static final CidrFreezeInactiveThreadsAmongSelectedHandler INSTANCE = new CidrFreezeInactiveThreadsAmongSelectedHandler();

    private CidrFreezeInactiveThreadsAmongSelectedHandler() {
        String string = CidrDebuggerBundle.message("debug.freezeInactiveThreadsAmongSelected.progress", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = CidrDebuggerBundle.message("debug.freezeInactiveThreadsAmongSelected.notification.success", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = CidrDebuggerBundle.message("debug.freezeInactiveThreadsAmongSelected.notification.error", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        super(string, string2, string3);
    }

    @Override
    @Nullable
    protected List<LLThread> getThreads(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        XDebugSession xDebugSession = (XDebugSession)dataContext.getData(XDebugSession.DATA_KEY);
        if (xDebugSession == null) {
            return null;
        }
        XDebugSession session = xDebugSession;
        List list = super.getThreads(dataContext);
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            return null;
        }
        List threads2 = list;
        CidrStackFrame cidrStackFrame = CidrDebuggerUtilKt.getCidrCurrentStackFrame(session);
        if (cidrStackFrame == null || (cidrStackFrame = cidrStackFrame.getThread()) == null) {
            return null;
        }
        CidrStackFrame selectedThread = cidrStackFrame;
        if (threads2.remove((Object)selectedThread)) {
            return threads2;
        }
        return null;
    }

    @Override
    public boolean canHandle(@NotNull List<? extends LLThread> threads2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(threads2, (String)"threads");
            Iterable $this$any$iv = threads2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LLThread it = (LLThread)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isFrozen())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setText(CidrDebuggerBundle.message("debug.freezeInactiveThreadsAmongSelected.text", new Object[0]));
    }

    @Override
    @Nullable
    public Object handle(@NotNull CidrThreadFreezer freezer, @NotNull List<? extends LLThread> threads2, @NotNull Continuation<? super Unit> $completion) {
        Object object = freezer.freezeThreads(threads2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

