/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.lang.GDBLanguage;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GDBDriverConfiguration
extends DebuggerDriverConfiguration {
    @NotNull
    @NlsSafe
    public String getDriverName() {
        return "GDB";
    }

    public boolean isAttachSupported() {
        return !SystemInfo.isMac;
    }

    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) throws ExecutionException {
        if (handler == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(0);
        }
        if (architectureType == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(1);
        }
        return new GDBDriver(handler, this, architectureType);
    }

    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull ArchitectureType architectureType) throws ExecutionException {
        if (driver == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(2);
        }
        if (architectureType == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(3);
        }
        GeneralCommandLine result = new GeneralCommandLine();
        result.withExePath(this.getGDBExecutablePath());
        GDBDriverConfiguration.setupCommonParameters((GeneralCommandLine)result);
        result.addParameters(new String[]{"--interpreter=mi2"});
        GeneralCommandLine generalCommandLine = result;
        if (generalCommandLine == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    @NotNull
    protected String getGDBExecutablePath() {
        String string = CidrDebuggerPathManager.getBundledGDBBinary().getAbsolutePath();
        if (string == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public File getWinbreakFile(@NotNull String name) {
        if (name == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(6);
        }
        File file = CidrDebuggerPathManager.getWinbreakFile(name);
        if (file == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull UserDataHolderEx cacheHolder) {
        if (driver == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(8);
        }
        if (thread == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(9);
        }
        if (frame == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(10);
        }
        if (cacheHolder == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(11);
        }
        return new EvaluationContext(driver, expirable, thread, frame, cacheHolder){

            @NotNull
            public String convertToRValue(@NotNull LLValueData rValue, @NotNull Pair<LLValue, String> valuePair) {
                if (rValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (valuePair == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = 1.cast((String)((String)valuePair.getSecond()), (String)((LLValue)valuePair.getFirst()).getType());
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rValue";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "valuePair";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriverConfiguration$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriverConfiguration$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertToRValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convertToRValue";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public Language getConsoleLanguage() {
        GDBLanguage gDBLanguage = GDBLanguage.INSTANCE;
        if (gDBLanguage == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(12);
        }
        return gDBLanguage;
    }

    @ApiStatus.Experimental
    public boolean isPrepareGdbIndexes() {
        return false;
    }

    @ApiStatus.Experimental
    @Nullable
    public String getGdbIndexAdvancedSettingsText() {
        return null;
    }

    @ApiStatus.Experimental
    public boolean shouldExtractRichStrings() {
        return Registry.is((String)"cidr.debugger.gdb.extractRichStrings");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "architectureType";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriverConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriverConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriverCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGDBExecutablePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWinbreakFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDriverCommandLine";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getWinbreakFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 12 -> new IllegalStateException(string);
        };
    }
}

