/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBEvaluationContext
extends EvaluationContext {
    private final DebuggerDriver myDriver;

    public LLDBEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull UserDataHolderEx cacheHolder) {
        if (driver == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(0);
        }
        if (thread == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(2);
        }
        if (cacheHolder == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(3);
        }
        super(driver, expirable, thread, frame, cacheHolder);
        this.myDriver = driver;
    }

    @NotNull
    public String castIDToNumber(@NotNull String expr, @NotNull String type) {
        if (expr == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(4);
        }
        if (type == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(5);
        }
        String string = LLDBEvaluationContext.cast((String)expr, (String)"long");
        if (string == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String convertToRValue(@NotNull LLValueData lValueData, @NotNull Pair<LLValue, String> rValuePair) throws DebuggerCommandException, ExecutionException {
        LLValueData rValueData;
        if (lValueData == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(7);
        }
        if (rValuePair == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(8);
        }
        if ((rValueData = this.getData((LLValue)rValuePair.first)).isNullPointer()) {
            return "((id)0)";
        }
        String string = lValueData.isPointer() && ((LLValue)rValuePair.first).getType().equals("int") && rValueData.intValue() == 0L ? "0" : (String)rValuePair.getSecond();
        if (string == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(9);
        }
        return string;
    }

    public long getValueAddress(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(10);
        }
        return ((LLDBDriver)this.myDriver).getValueAddress(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lValueData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rValuePair";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "castIDToNumber";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "castIDToNumber";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertToRValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValueAddress";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }
}

