/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrBreakpointStatisticKind;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CidrBreakpointHandler
extends CidrCodePointHandlerBase<XLineBreakpoint<?>, LLBreakpoint> {
    private final Map<Integer, Map<String, LLBreakpointLocation>> myLocationsMap;

    public CidrBreakpointHandler(CidrDebugProcess process) {
        this(process, (Class<? extends XLineBreakpointType<?>>)CidrLineBreakpointType.class);
    }

    public CidrBreakpointHandler(CidrDebugProcess process, @NotNull Class<? extends XLineBreakpointType<?>> type) {
        if (type == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(process, type, CidrBreakpointStatisticKind.Line);
        this.myLocationsMap = new LinkedHashMap<Integer, Map<String, LLBreakpointLocation>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<LLBreakpoint> addCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull XLineBreakpoint<?> breakpoint, long threadId, int n) throws ExecutionException {
        CidrLineBreakpointType.Properties properties;
        if (driver == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(1);
        }
        if (breakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(2);
        }
        String condition = this.convertCondition((XBreakpoint<? extends XBreakpointProperties>)breakpoint);
        String path = VfsUtilCore.urlToPath((String)breakpoint.getFileUrl());
        boolean ignoreSourceHash = false;
        XBreakpointProperties xBreakpointProperties = breakpoint.getProperties();
        if (xBreakpointProperties instanceof CidrLineBreakpointType.Properties && (properties = (CidrLineBreakpointType.Properties)xBreakpointProperties).isRelaxedMatch()) {
            path = PathUtil.getFileName((String)path);
            ignoreSourceHash = true;
        }
        try {
            DebuggerDriver.AddBreakpointResult result = driver.addBreakpoint(path, breakpoint.getLine(), condition, ignoreSourceHash);
            LLBreakpoint brk = result.getBreakpoint();
            List brkLocations = result.getBreakpointLocations();
            LinkedHashMap<String, LLBreakpointLocation> brkLocationsMap = new LinkedHashMap<String, LLBreakpointLocation>(brkLocations.size());
            for (LLBreakpointLocation location : brkLocations) {
                brkLocationsMap.put(location.getId(), location);
            }
            Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
            synchronized (map) {
                this.myLocationsMap.put(brk.getId(), brkLocationsMap);
            }
            this.updateBreakpointPresentation(breakpoint, !brkLocations.isEmpty());
            return Collections.singletonList(brk);
        }
        catch (DebuggerCommandException e) {
            this.myProcess.getSession().setBreakpointInvalid(breakpoint, e.getMessage());
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull List<Integer> ids, @NotNull XLineBreakpoint<?> breakpoint) throws ExecutionException, DebuggerCommandException {
        if (driver == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(3);
        }
        if (ids == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(4);
        }
        if (breakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(5);
        }
        try {
            super.removeCodepointsInBackend(driver, ids, breakpoint);
        }
        finally {
            Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
            synchronized (map) {
                for (int id : ids) {
                    this.myLocationsMap.remove(id);
                }
            }
        }
    }

    public void handleBreakpointAdded(@NotNull LLBreakpoint newBreakpoint) {
        XLineBreakpoint uiBreakpoint;
        if (newBreakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(6);
        }
        if ((uiBreakpoint = (XLineBreakpoint)this.getXBreakpoint(newBreakpoint.getId())) != null) {
            return;
        }
    }

    public void handleBreakpointRemoved(int breakpointId) {
        XLineBreakpoint uiBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (uiBreakpoint == null) {
            return;
        }
    }

    public void handleBreakpointUpdated(int breakpointId, @NotNull LLBreakpoint newBreakpoint) {
        if (newBreakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(7);
        }
        this.updateCodepoint(breakpointId, newBreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBreakpointLocationsReplaced(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        boolean resolved;
        if (locations == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(8);
        }
        Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
        synchronized (map) {
            Map<String, LLBreakpointLocation> locationsMap = this.myLocationsMap.get(breakpointId);
            if (locationsMap == null) {
                return;
            }
            locationsMap = new LinkedHashMap<String, LLBreakpointLocation>(locations.size());
            for (LLBreakpointLocation location : locations) {
                locationsMap.put(location.getId(), location);
            }
            this.myLocationsMap.put(breakpointId, locationsMap);
            resolved = !locationsMap.isEmpty();
        }
        XLineBreakpoint uiBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (uiBreakpoint == null) {
            return;
        }
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBreakpointLocationsUpdated(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        boolean resolved;
        if (locations == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(9);
        }
        Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
        synchronized (map) {
            Map<String, LLBreakpointLocation> locationsMap = this.myLocationsMap.get(breakpointId);
            if (locationsMap == null) {
                return;
            }
            for (LLBreakpointLocation location : locations) {
                locationsMap.put(location.getId(), location);
            }
            resolved = !locationsMap.isEmpty();
        }
        XLineBreakpoint uiBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (uiBreakpoint == null) {
            return;
        }
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBreakpointLocationsRemoved(int breakpointId, @NotNull List<String> locationIds) {
        boolean resolved;
        if (locationIds == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(10);
        }
        Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
        synchronized (map) {
            Map<String, LLBreakpointLocation> locationsMap = this.myLocationsMap.get(breakpointId);
            if (locationsMap == null) {
                return;
            }
            for (String locationId : locationIds) {
                locationsMap.remove(locationId);
            }
            resolved = !locationsMap.isEmpty();
        }
        XLineBreakpoint uiBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (uiBreakpoint == null) {
            return;
        }
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    private void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> uiBreakpoint, boolean resolved) {
        if (uiBreakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(11);
        }
        if (resolved) {
            this.myProcess.getSession().setBreakpointVerified(uiBreakpoint);
        } else {
            this.myProcess.getSession().setBreakpointInvalid(uiBreakpoint, CidrDebuggerBundle.message("debug.breakpoint.line.unresolved.hint", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBreakpoint";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationIds";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiBreakpoint";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addCodepointsInBackend";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCodepointsInBackend";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBreakpointAdded";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBreakpointUpdated";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBreakpointLocationsReplaced";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBreakpointLocationsUpdated";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBreakpointLocationsRemoved";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "updateBreakpointPresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

