/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class CidrWatchpointPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XBreakpoint<CidrWatchpointType.CidrWatchpointProperties>> {
    private JPanel rootPane;
    private JComboBox myLifetimeComboBox;
    private JComboBox myAccessComboBox;
    private JLabel errorLabel;
    private JLabel myLifeTimeLabel;

    CidrWatchpointPropertiesPanel(@NotNull Project project) {
        CidrDebugProcess process;
        if (project == null) {
            CidrWatchpointPropertiesPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myLifetimeComboBox.setModel(new EnumComboBoxModel(LLWatchpoint.Lifetime.class));
        this.myAccessComboBox.setModel(new EnumComboBoxModel(LLWatchpoint.AccessType.class));
        XDebugSession currentSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        CidrDebugProcess cidrDebugProcess = process = currentSession == null ? null : CidrDebuggerUtilKt.getCidrDebugProcess(currentSession);
        if (process != null && !process.supportsWatchpointLifetime()) {
            this.myLifetimeComboBox.setVisible(false);
            this.myLifeTimeLabel.setVisible(false);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.rootPane;
        if (jPanel == null) {
            CidrWatchpointPropertiesPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public void saveTo(@NotNull XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint) {
        CidrWatchpointType.CidrWatchpointProperties properties;
        if (breakpoint == null) {
            CidrWatchpointPropertiesPanel.$$$reportNull$$$0(2);
        }
        if ((properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties()) == null) {
            return;
        }
        boolean changed = properties.updateAccessType((LLWatchpoint.AccessType)this.myAccessComboBox.getSelectedItem()) | properties.updateLifetime((LLWatchpoint.Lifetime)this.myLifetimeComboBox.getSelectedItem());
        if (changed && breakpoint instanceof XBreakpointBase) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    public void loadFrom(@NotNull XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint) {
        CidrWatchpointType.CidrWatchpointProperties properties;
        if (breakpoint == null) {
            CidrWatchpointPropertiesPanel.$$$reportNull$$$0(3);
        }
        if ((properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties()) != null) {
            this.myLifetimeComboBox.setSelectedItem(properties.getLifetime());
            this.myAccessComboBox.setSelectedItem(properties.getAccessType());
            this.errorLabel.setVisible(properties.getError() != null);
            if (properties.getError() != null) {
                this.errorLabel.setText(properties.getError());
            }
        } else {
            this.myLifetimeComboBox.setEnabled(false);
            this.myAccessComboBox.setEnabled(false);
            this.errorLabel.setVisible(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JComboBox jComboBox;
        JLabel jLabel2;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.rootPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myLifetimeComboBox = jComboBox2 = new JComboBox();
        jPanel3.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myLifeTimeLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrWatchpointPropertiesPanel.class).getString("debug.watchpoint.properties.lifeTime"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAccessComboBox = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 3, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrWatchpointPropertiesPanel.class).getString("debug.watchpoint.properties.accessType"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.errorLabel = jLabel = new JLabel();
        ((Component)jLabel).setForeground(new Color(-65536));
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrWatchpointPropertiesPanel.class).getString("debug.watchpoint.properties.error.label"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrWatchpointPropertiesPanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrWatchpointPropertiesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

