/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSCollectionValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSEnumerableValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSEnumerableCollectionValueRenderer
extends NSEnumerableValueRenderer {
    private final NSCollectionValueRenderer.Kind myKind;
    private volatile LLValue myEnumerator;

    public NSEnumerableCollectionValueRenderer(@NotNull CidrPhysicalValue value, @NotNull NSCollectionValueRenderer.Kind kind) {
        if (value == null) {
            NSEnumerableCollectionValueRenderer.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            NSEnumerableCollectionValueRenderer.$$$reportNull$$$0(1);
        }
        super(value);
        this.myKind = kind;
    }

    @Override
    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            NSEnumerableCollectionValueRenderer.$$$reportNull$$$0(2);
        }
        if (this.myValue.getVar().getType().matches("__NS.+0 \\*")) {
            return 0;
        }
        return (int)this.messageSendToSelfData("count", "unsigned int", context).intValue();
    }

    @Override
    @Nullable
    protected CidrValue createChild(@NotNull EvaluationContext context, int index) throws ExecutionException, DebuggerCommandException {
        CidrValue child;
        if (context == null) {
            NSEnumerableCollectionValueRenderer.$$$reportNull$$$0(3);
        }
        if (!context.getData(this.myEnumerator).isValidPointer()) {
            return null;
        }
        LLValue next = context.messageSend(this.myEnumerator, "nextObject");
        if (this.myKind == NSCollectionValueRenderer.Kind.DICTIONARY) {
            LLValueData nextData = context.getData(next);
            LLValue object = this.messageSendToSelf("objectForKey:" + EvaluationContext.cast((String)nextData.getPointer(), (String)"id"), "id", context);
            child = this.createMapElementValue(next, object, index);
        } else {
            child = this.createElementValue(next, index);
        }
        return child;
    }

    @Override
    protected void willExpand(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            NSEnumerableCollectionValueRenderer.$$$reportNull$$$0(4);
        }
        this.myEnumerator = this.myKind == NSCollectionValueRenderer.Kind.DICTIONARY ? context.messageSend(this.myValue.getVar(), "keyEnumerator") : context.messageSend(this.myValue.getVar(), "objectEnumerator");
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (child == null) {
            NSEnumerableCollectionValueRenderer.$$$reportNull$$$0(5);
        }
        String string = NSCollectionValueRenderer.getChildEvaluationExpression(this.myValue, this.myKind, child, lvalue);
        if (string == null) {
            NSEnumerableCollectionValueRenderer.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSEnumerableCollectionValueRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSEnumerableCollectionValueRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEvaluationExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildrenCount";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "willExpand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChildEvaluationExpression";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

