/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.disasm;

import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.IntervalUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u0011\u0012\u0013\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\fJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataProvider;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "<init>", "()V", "createDataPlaceholder", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "holeRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "fromInstructionList", "", "Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlock;", "instructions", "readOnlyReason", "", "DisasmBlock", "DisasmBlockImpl", "InstructionDataEntry", "InstructionDataPlaceholder", "Companion", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nAbstractDisasmDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDisasmDataProvider.kt\ncom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1056#2:90\n1563#2:91\n1634#2,3:92\n*S KotlinDebug\n*F\n+ 1 AbstractDisasmDataProvider.kt\ncom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider\n*L\n56#1:90\n57#1:91\n57#1:92,3\n*E\n"})
public abstract class AbstractDisasmDataProvider
implements CidrMemoryData.DataProvider<LLInstruction> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Object UNDEFINED = new Object();

    @Override
    @NotNull
    public CidrMemoryData.DataPlaceholder<LLInstruction> createDataPlaceholder(@NotNull Address address, @NotNull AddressRange holeRange) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)holeRange, (String)"holeRange");
        AddressRange surroundingRange = AddressUtil.addressRangeInclusive((Address)address.minus(Address.Companion.getCoercing((Number)AbstractDisasmDataProvider.Companion.getFETCH_BYTES_BEFORE())), (Address)address.plus(Address.Companion.getCoercing((Number)(AbstractDisasmDataProvider.Companion.getFETCH_BYTES_AFTER() - 1))));
        return new InstructionDataPlaceholder(AddressUtil.addressToRange((Address)address, (long)1L), surroundingRange.intersectWith(holeRange));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DisasmBlock> fromInstructionList(@NotNull List<LLInstruction> instructions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        Iterable $this$sortedBy$iv = instructions;
        boolean $i$f$sortedBy = false;
        List groupedByFunctions = AbstractDisasmDataProvider.Companion.groupByContiguous(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LLInstruction it = (LLInstruction)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getAddress();
                it = (LLInstruction)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getAddress()));
            }
        }), AbstractDisasmDataProvider::fromInstructionList$lambda$1);
        Iterable $this$map$iv = groupedByFunctions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List instructions2 = (List)pair.component2();
            collection.add(DisasmBlockImpl.Companion.fromInstructions(((LLInstruction)CollectionsKt.first((List)instructions2)).getFunctionOffset(), instructions2));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public String readOnlyReason() {
        Object[] objectArray = new Object[]{"disassembly"};
        return CidrDebuggerBundle.message("debug.memory.view.modify.not.supported", objectArray);
    }

    private static final String fromInstructionList$lambda$1(LLInstruction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LLSymbolOffset lLSymbolOffset = it.getFunctionOffset();
        return lLSymbolOffset != null ? lLSymbolOffset.getSymbolName() : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u000b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\f0\r0\f\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$Companion;", "", "<init>", "()V", "FETCH_BYTES_BEFORE", "", "getFETCH_BYTES_BEFORE", "()I", "FETCH_BYTES_AFTER", "getFETCH_BYTES_AFTER", "UNDEFINED", "groupByContiguous", "", "Lkotlin/Pair;", "K", "T", "", "keySelector", "Lkotlin/Function1;", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        private final int getFETCH_BYTES_BEFORE() {
            return Registry.Companion.intValue("cidr.debugger.memory.disasm.fallbackRangeBytes", 256) / 2;
        }

        private final int getFETCH_BYTES_AFTER() {
            return Registry.Companion.intValue("cidr.debugger.memory.disasm.fallbackRangeBytes", 256) / 2;
        }

        private final <K, T> List<Pair<K, List<T>>> groupByContiguous(Iterable<? extends T> $this$groupByContiguous, Function1<? super T, ? extends K> keySelector) {
            List result = new ArrayList();
            Object currentKey = UNDEFINED;
            List currentList = null;
            for (T each : $this$groupByContiguous) {
                List list;
                Object key = keySelector.invoke(each);
                if (!Intrinsics.areEqual((Object)currentKey, (Object)key)) {
                    currentKey = key;
                    currentList = new ArrayList();
                    result.add(TuplesKt.to((Object)currentKey, (Object)currentList));
                }
                if ((list = currentList) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentList");
                    list = null;
                }
                list.add(each);
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlock;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataBlock;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "getFunctionOffset", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "entries", "", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "getEntries", "()Ljava/util/List;", "intellij.cidr.debugger.core"})
    public static interface DisasmBlock
    extends CidrMemoryData.DataBlock<LLInstruction> {
        @Nullable
        public LLSymbolOffset getFunctionOffset();

        @Override
        @NotNull
        public List<CidrMemoryData.DataEntry<LLInstruction>> getEntries();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlockImpl;", "Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlock;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "entries", "", "Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$InstructionDataEntry;", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/List;Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;)V", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getEntries", "()Ljava/util/List;", "getFunctionOffset", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "subRangeImpl", "subRange", "toString", "", "Companion", "intellij.cidr.debugger.core"})
    private static final class DisasmBlockImpl
    implements DisasmBlock {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final AddressRange range;
        @NotNull
        private final List<InstructionDataEntry> entries;
        @Nullable
        private final LLSymbolOffset functionOffset;

        public DisasmBlockImpl(@NotNull AddressRange range, @NotNull List<InstructionDataEntry> entries, @Nullable LLSymbolOffset functionOffset) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            this.range = range;
            this.entries = entries;
            this.functionOffset = functionOffset;
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.range;
        }

        @NotNull
        public List<InstructionDataEntry> getEntries() {
            return this.entries;
        }

        @Override
        @Nullable
        public LLSymbolOffset getFunctionOffset() {
            return this.functionOffset;
        }

        @Override
        @NotNull
        public DisasmBlockImpl subRangeImpl(@NotNull AddressRange subRange) {
            Intrinsics.checkNotNullParameter((Object)subRange, (String)"subRange");
            return new DisasmBlockImpl(subRange, IntervalUtilKt.filterSubRange(this.getEntries(), subRange), this.getFunctionOffset());
        }

        @NotNull
        public String toString() {
            return "DisasmBlock(" + this.getRange() + ")";
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlockImpl$Companion;", "", "<init>", "()V", "fromInstructions", "Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlockImpl;", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "instructions", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "intellij.cidr.debugger.core"})
        @SourceDebugExtension(value={"SMAP\nAbstractDisasmDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDisasmDataProvider.kt\ncom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlockImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1#2:90\n1563#3:91\n1634#3,3:92\n*S KotlinDebug\n*F\n+ 1 AbstractDisasmDataProvider.kt\ncom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$DisasmBlockImpl$Companion\n*L\n29#1:91\n29#1:92,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DisasmBlockImpl fromInstructions(@Nullable LLSymbolOffset functionOffset, @NotNull List<LLInstruction> instructions) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
                if (!(!((Collection)instructions).isEmpty())) {
                    boolean $i$a$-check-AbstractDisasmDataProvider$DisasmBlockImpl$Companion$fromInstructions$22 = false;
                    String $i$a$-check-AbstractDisasmDataProvider$DisasmBlockImpl$Companion$fromInstructions$22 = "Instructions list is empty";
                    throw new IllegalStateException($i$a$-check-AbstractDisasmDataProvider$DisasmBlockImpl$Companion$fromInstructions$22.toString());
                }
                Iterable $this$map$iv = instructions;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LLInstruction lLInstruction = (LLInstruction)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new InstructionDataEntry((LLInstruction)it));
                }
                List entries = (List)destination$iv$iv;
                return new DisasmBlockImpl(IntervalUtilKt.boundSpan(entries), entries, functionOffset);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$InstructionDataEntry;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "value", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;)V", "getValue", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "intellij.cidr.debugger.core"})
    private static final class InstructionDataEntry
    implements CidrMemoryData.DataEntry<LLInstruction> {
        @NotNull
        private final LLInstruction value;

        public InstructionDataEntry(@NotNull LLInstruction value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }

        @Override
        @NotNull
        public LLInstruction getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.getValue().getRange();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/AbstractDisasmDataProvider$InstructionDataPlaceholder;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "requestRange", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)V", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRequestRange", "subRangeImpl", "subRange", "intellij.cidr.debugger.core"})
    private static final class InstructionDataPlaceholder
    implements CidrMemoryData.DataPlaceholder<LLInstruction> {
        @NotNull
        private final AddressRange range;
        @NotNull
        private final AddressRange requestRange;

        public InstructionDataPlaceholder(@NotNull AddressRange range, @NotNull AddressRange requestRange) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)requestRange, (String)"requestRange");
            this.range = range;
            this.requestRange = requestRange;
            AddressUtil.requireNotEmpty((ClosedRange)((ClosedRange)this.getRange()));
            AddressUtil.requireNotEmpty((ClosedRange)((ClosedRange)this.getRequestRange()));
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.range;
        }

        @Override
        @NotNull
        public AddressRange getRequestRange() {
            return this.requestRange;
        }

        @Override
        @NotNull
        public InstructionDataPlaceholder subRangeImpl(@NotNull AddressRange subRange) {
            Intrinsics.checkNotNullParameter((Object)subRange, (String)"subRange");
            return new InstructionDataPlaceholder(subRange, this.getRequestRange());
        }
    }
}

