/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.ui;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointPropertiesPanel;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import com.jetbrains.cidr.lang.ui.OCFieldAdapterForSymbolName;
import com.jetbrains.cidr.lang.ui.OCTextFieldCompletionProvider;
import com.jetbrains.cidr.lang.ui.OCTextFieldWithSymbolAutoCompletion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCSymbolicBreakpointPropertiesPanel
extends CidrSymbolicBreakpointPropertiesPanel {
    private static final Pattern OBJC_METHOD_PATTERN = Pattern.compile("[-+]?(\\[(\\w*)( ([\\w:]*))?]?)");

    public OCSymbolicBreakpointPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            OCSymbolicBreakpointPropertiesPanel.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @NotNull
    protected TextFieldWithAutoCompletion createSymbolNameField() {
        return new OCTextFieldWithSymbolAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new ClassSymbolsProvider(this.myProject));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel", "<init>"));
    }

    private static final class ClassSymbolsProvider
    extends OCTextFieldCompletionProvider<OCSymbolNavigationItem> {
        @NotNull
        private final Project myProject;

        private ClassSymbolsProvider(final @NotNull Project project) {
            if (project == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(0);
            }
            super((OCFieldAdapter)new OCFieldAdapterForSymbolName(){

                @NotNull
                public String getReadableName(@NotNull OCSymbolNavigationItem item) {
                    if (item == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    OCSymbol symbol = item.getSymbol();
                    OCResolveContext context = OCResolveContext.forSymbol((OCSymbol)symbol, (Project)project);
                    if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).getResolvedOwner(context) != null) {
                        String string = ((OCFunctionSymbol)symbol).getSignatureWithoutParamNames(true, false, context);
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    String string = symbol.getPresentableName();
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "item";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$ClassSymbolsProvider$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$ClassSymbolsProvider$1";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getReadableName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getReadableName";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2 -> new IllegalStateException(string);
                    };
                }
            });
            this.myProject = project;
        }

        @NotNull
        public Collection<OCSymbolNavigationItem> getItems(@Nullable String prefix, boolean cached, @NotNull CompletionParameters parameters) {
            if (parameters == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(1);
            }
            OCLog.LOG.assertTrue(ProgressManager.getInstance().getProgressIndicator() != null, (Object)"No progress for completion!");
            Collection collection = (Collection)ReadAction.compute(() -> {
                Collection<OCSymbolNavigationItem> items;
                String text = parameters.getOriginalFile().getText();
                if (cached || prefix == null || text.isEmpty()) {
                    return Collections.emptyList();
                }
                Matcher m = OBJC_METHOD_PATTERN.matcher(text);
                if (m.matches()) {
                    items = m.group(4) != null ? this.collectMethodsForClass(m.group(2)) : this.collectAllClasses();
                } else {
                    PrefixMatcher prefixMatcher = this.createPrefixMatcher(prefix);
                    items = this.collectFunctions(text, prefixMatcher, OCResolveContext.forPsi((PsiElement)parameters.getPosition()));
                    if (!text.contains("::")) {
                        items.addAll(this.collectMatchingMethods(prefixMatcher));
                        items.addAll(this.collectAllClasses());
                    }
                }
                ArrayList<OCSymbolNavigationItem> list = new ArrayList<OCSymbolNavigationItem>(items);
                list.sort((Comparator<OCSymbolNavigationItem>)((Object)this));
                return list;
            });
            if (collection == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        private Collection<OCSymbolNavigationItem> collectMethodsForClass(@Nullable String className) {
            HashSet set = new HashSet();
            ArrayList<OCSymbolNavigationItem> results = new ArrayList<OCSymbolNavigationItem>();
            final Processor methodSymbolCollector = method -> {
                if (set.add(method.getPresentableName())) {
                    results.add(new OCSymbolNavigationItem(method, this.myProject));
                }
                return true;
            };
            Processor<OCSymbol> processor = new Processor<OCSymbol>(){

                @Contract(value="null -> true")
                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCClassSymbol) {
                        ((OCClassSymbol)symbol).processMembersInAllCategories(null, OCMethodSymbol.class, methodSymbolCollector, myProject);
                        for (String protocolName : ((OCClassSymbol)symbol).getProtocolNames()) {
                            if (protocolName.equals(symbol.getName())) continue;
                            OCGlobalProjectSymbolsCache.processTopLevelSymbols((Project)myProject, (Processor)this, (String)protocolName);
                        }
                    }
                    return true;
                }
            };
            OCGlobalProjectSymbolsCache.processTopLevelSymbols((Project)this.myProject, (Processor)processor, (String)className);
            ArrayList<OCSymbolNavigationItem> arrayList = results;
            if (arrayList == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @NotNull
        private Collection<OCSymbolNavigationItem> collectAllClasses() {
            Collection collection = this.collectValuesFromProject(this.myProject, item -> (item.getSymbol() instanceof OCImplementationSymbol || item.getSymbol() instanceof OCInterfaceSymbol) && ((OCClassSymbol)item.getSymbol()).getCategoryName() == null);
            if (collection == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @NotNull
        private Collection<OCSymbolNavigationItem> collectFunctions(final @NotNull String text, final @NotNull PrefixMatcher prefixMatcher, final @NotNull OCResolveContext context) {
            if (text == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(5);
            }
            if (prefixMatcher == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(6);
            }
            if (context == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(7);
            }
            final HashSet set = new HashSet();
            String[] strings = text.split("::", -1);
            String parentName = strings.length >= 2 ? strings[strings.length - 2] : null;
            final ArrayList<OCSymbolNavigationItem> results = new ArrayList<OCSymbolNavigationItem>();
            Processor<OCSymbol> processor = new Processor<OCSymbol>(){

                private boolean accept(OCSymbol symbol) {
                    OCQualifiedName qualifiedName;
                    String nameWithParent;
                    if ((symbol instanceof OCFunctionSymbol || ClassSymbolsProvider.isValidNamespace(symbol)) && prefixMatcher.prefixMatches(nameWithParent = ((OCSymbolWithQualifiedName)symbol).getNameWithParent(context)) && (qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(context)) != null) {
                        String canonicalName = qualifiedName.getFullName(context);
                        return this.createPrefixMatcher(text).prefixMatches(canonicalName) && set.add(canonicalName);
                    }
                    return false;
                }

                public boolean process(OCSymbol symbol) {
                    if (this.accept(symbol)) {
                        results.add(new OCSymbolNavigationItem(symbol, myProject));
                    }
                    return true;
                }
            };
            ReadAction.run(() -> this.lambda$collectFunctions$4(parentName, (Processor)processor, results));
            ArrayList<OCSymbolNavigationItem> arrayList = results;
            if (arrayList == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        private static boolean isValidNamespace(OCSymbol symbol) {
            boolean validNamespace;
            boolean bl = validNamespace = symbol instanceof OCNamespaceSymbol && symbol.getKind() != OCSymbolKind.ENUM;
            if (validNamespace) {
                CommonProcessors.FindFirstProcessor<OCSymbol> findFirstProcessor = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                    protected boolean accept(OCSymbol symbol) {
                        return symbol instanceof OCFunctionSymbol || symbol instanceof OCNamespaceSymbol;
                    }
                };
                ((OCNamespaceSymbol)symbol).processMembers(null, (Processor)findFirstProcessor);
                validNamespace = findFirstProcessor.isFound();
            }
            return validNamespace;
        }

        private Collection<OCSymbolNavigationItem> collectMatchingMethods(PrefixMatcher prefixMatcher) {
            HashSet set = new HashSet();
            ArrayList<OCSymbolNavigationItem> results = new ArrayList<OCSymbolNavigationItem>();
            Processor objCProcessor = symbol -> {
                if (symbol instanceof OCMethodSymbol && prefixMatcher.prefixMatches(symbol.getPresentableName()) && set.add(symbol.getPresentableName())) {
                    results.add(new OCSymbolNavigationItem(symbol, this.myProject));
                }
                return true;
            };
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols((Project)this.myProject, (Processor)objCProcessor, null);
            return results;
        }

        @Nullable
        protected InsertHandler<LookupElement> createInsertHandler(@NotNull OCSymbolNavigationItem item) {
            if (item == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(9);
            }
            if (item.getSymbol() instanceof OCMethodSymbol) {
                return new LookupElementInsertHandler(']', (Condition<InsertionContext>)((Condition)c -> c.getDocument().getText(TextRange.create((int)0, (int)c.getTailOffset())).contains("[")));
            }
            if (item.getSymbol() instanceof OCNamespaceSymbol || item.getSymbol() instanceof OCFunctionSymbol) {
                return new CppLookupElementInsertHandler();
            }
            if (item.getSymbol() instanceof OCClassSymbol) {
                return new OCClassLookupElementInsertHandler();
            }
            return new LookupElementInsertHandler(' ');
        }

        @Nullable
        public String getPrefix(@NotNull String text, int offset) {
            Matcher m;
            if (text == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(10);
            }
            if ((m = OBJC_METHOD_PATTERN.matcher(text)).matches()) {
                String prefix = ClassSymbolsProvider.getCurrentToken(text, m, offset, 4);
                if (prefix != null) {
                    return prefix;
                }
                return ClassSymbolsProvider.getCurrentToken(text, m, offset, 2);
            }
            int i = (text = text.substring(0, offset)).lastIndexOf("::");
            if (i != -1) {
                return text.substring(i + 2);
            }
            return text;
        }

        private static String getCurrentToken(@NotNull String text, @NotNull Matcher m, int pos, int groupIndex) {
            if (text == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(11);
            }
            if (m == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(12);
            }
            return m.start(groupIndex) <= pos && pos <= m.end(groupIndex) ? text.substring(m.start(groupIndex), pos) : null;
        }

        private /* synthetic */ void lambda$collectFunctions$4(String parentName, Processor processor, ArrayList results) throws RuntimeException {
            boolean topLevelOnly = false;
            if (parentName != null) {
                if (parentName.isEmpty()) {
                    topLevelOnly = true;
                } else {
                    OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols((Project)this.myProject, symbol -> {
                        if (symbol instanceof OCNamespaceSymbol) {
                            ((OCNamespaceSymbol)symbol).processMembers(null, processor);
                        }
                        return true;
                    }, (String)parentName);
                }
            }
            if (results.isEmpty()) {
                OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols((Project)this.myProject, (Processor)processor, null, (boolean)topLevelOnly);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$ClassSymbolsProvider";
                    break;
                }
                case 5: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixMatcher";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "m";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$ClassSymbolsProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectMethodsForClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectAllClasses";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectFunctions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getItems";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collectFunctions";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createInsertHandler";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getPrefix";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getCurrentToken";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static final class OCClassLookupElementInsertHandler
    extends LookupElementInsertHandler {
        private OCClassLookupElementInsertHandler() {
            super(' ');
        }

        @Override
        public void handleInsert(@NotNull InsertionContext c, @NotNull LookupElement item) {
            if (c == null) {
                OCClassLookupElementInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                OCClassLookupElementInsertHandler.$$$reportNull$$$0(1);
            }
            CharSequence sequence = c.getDocument().getCharsSequence();
            if (c.getStartOffset() == 0 || !sequence.isEmpty() && sequence.charAt(c.getStartOffset() - 1) != '[') {
                c.getDocument().insertString(c.getStartOffset(), (CharSequence)String.valueOf('['));
            }
            super.handleInsert(c, item);
            OCClassLookupElementInsertHandler.reInvokeCompletion(c);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$OCClassLookupElementInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LookupElementInsertHandler
    implements InsertHandler<LookupElement> {
        private final char myChar;
        private final Condition<InsertionContext> myCondition;

        private LookupElementInsertHandler() {
            this(' ');
        }

        private LookupElementInsertHandler(char aChar) {
            this(aChar, null);
        }

        private LookupElementInsertHandler(char aChar, @Nullable Condition<InsertionContext> condition) {
            this.myChar = aChar;
            this.myCondition = condition;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            CharSequence text;
            int offset;
            if (context == null) {
                LookupElementInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                LookupElementInsertHandler.$$$reportNull$$$0(1);
            }
            if (context.getCompletionChar() != this.myChar && (this.myCondition == null || this.myCondition.value((Object)context)) && (offset = context.getTailOffset()) == (text = context.getDocument().getCharsSequence()).length()) {
                LookupElementInsertHandler.addCompletionString(context, offset, String.valueOf(this.myChar));
            }
        }

        protected static void addCompletionString(@NotNull InsertionContext context, int offset, @NotNull String string) {
            if (context == null) {
                LookupElementInsertHandler.$$$reportNull$$$0(2);
            }
            if (string == null) {
                LookupElementInsertHandler.$$$reportNull$$$0(3);
            }
            context.getDocument().insertString(offset, (CharSequence)string);
            context.getEditor().getCaretModel().moveCaretRelatively(string.length(), 0, false, false, true);
        }

        protected static void reInvokeCompletion(@NotNull InsertionContext context) {
            if (context == null) {
                LookupElementInsertHandler.$$$reportNull$$$0(4);
            }
            context.setLaterRunnable(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(context.getProject(), context.getEditor()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$LookupElementInsertHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInsert";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletionString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reInvokeCompletion";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CppLookupElementInsertHandler
    extends LookupElementInsertHandler {
        private CppLookupElementInsertHandler() {
        }

        @Override
        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Object object;
            if (context == null) {
                CppLookupElementInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                CppLookupElementInsertHandler.$$$reportNull$$$0(1);
            }
            if (!((object = item.getObject()) instanceof OCSymbolNavigationItem)) {
                return;
            }
            OCSymbolNavigationItem symbolItem = (OCSymbolNavigationItem)object;
            OCSymbol oCSymbol = symbolItem.getSymbol();
            if (oCSymbol instanceof OCSymbolWithQualifiedName) {
                OCSymbolWithQualifiedName symbol = (OCSymbolWithQualifiedName)oCSymbol;
                OCResolveContext resolveContext = OCResolveContext.forSymbol((OCSymbol)symbol, (Project)context.getProject());
                OCQualifiedName qualifiedName = symbol.getResolvedQualifiedName(resolveContext);
                if (qualifiedName != null) {
                    Object text = qualifiedName.getFullName(resolveContext);
                    if (symbol instanceof OCFunctionSymbol) {
                        text = (String)text + "(" + StringUtil.join((Collection)ContainerUtil.map((Collection)((OCFunctionSymbol)symbol).getParameterSymbols(), symbol1 -> {
                            String canonicalName = symbol1.getResolvedType(resolveContext).getCanonicalName(resolveContext);
                            canonicalName = StringUtil.trimStart((String)canonicalName, (String)"::");
                            canonicalName = canonicalName.replace(" *", "*");
                            return canonicalName;
                        }), (String)", ") + ")";
                        if (symbol.isConst()) {
                            text = (String)text + " const";
                        }
                    }
                    context.getDocument().replaceString(0, context.getTailOffset(), (CharSequence)((String)text).substring(2));
                }
                if (!(symbolItem.getSymbol() instanceof OCFunctionSymbol)) {
                    CppLookupElementInsertHandler.addCompletionString(context, context.getDocument().getTextLength(), "::");
                    CppLookupElementInsertHandler.reInvokeCompletion(context);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$CppLookupElementInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

