/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb.execution.tasks;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.jetbrains.cidr.cpp.compdb.CompDBLog;
import com.jetbrains.cidr.cpp.compdb.CompDBUtilKt;
import com.jetbrains.cidr.cpp.compdb.CompDBWorkspace;
import com.jetbrains.cidr.cpp.compdb.execution.tasks.CompDBCompileTaskRunner;
import com.jetbrains.cidr.cpp.compdb.execution.tasks.CompDBExternalTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/execution/tasks/CompDBProjectTaskRunner;", "Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "<init>", "()V", "buildSystemId", "", "getBuildSystemId", "()Ljava/lang/String;", "canRun", "", "project", "Lcom/intellij/openapi/project/Project;", "projectTask", "Lcom/intellij/task/ProjectTask;", "task", "runnerForTask", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "intellij.clion.compdb"})
@SourceDebugExtension(value={"SMAP\nCompDBProjectTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompDBProjectTaskRunner.kt\ncom/jetbrains/cidr/cpp/compdb/execution/tasks/CompDBProjectTaskRunner\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,62:1\n12637#2,2:63\n*S KotlinDebug\n*F\n+ 1 CompDBProjectTaskRunner.kt\ncom/jetbrains/cidr/cpp/compdb/execution/tasks/CompDBProjectTaskRunner\n*L\n32#1:63,2\n*E\n"})
public final class CompDBProjectTaskRunner
extends CidrProjectTaskRunner {
    @NotNull
    private final String buildSystemId;

    public CompDBProjectTaskRunner() {
        String string = CompDBUtilKt.getID().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        this.buildSystemId = string;
    }

    @NotNull
    public String getBuildSystemId() {
        return this.buildSystemId;
    }

    public boolean canRun(@NotNull Project project, @NotNull ProjectTask projectTask) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectTask, (String)"projectTask");
        CompDBWorkspace compDBWorkspace = CompDBWorkspace.Companion.getInstance(project);
        if (compDBWorkspace == null) {
            return false;
        }
        CompDBWorkspace workspace = compDBWorkspace;
        return workspace.isInitialized() && this.canRun(projectTask);
    }

    public boolean canRun(@NotNull ProjectTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ProjectTask projectTask = task;
        if (projectTask instanceof ModuleFilesBuildTask) {
            boolean bl;
            block6: {
                VirtualFile[] virtualFileArray = ((ModuleFilesBuildTask)task).getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                if (((Object[])virtualFileArray).length == 0) {
                    return false;
                }
                VirtualFile[] virtualFileArray2 = ((ModuleFilesBuildTask)task).getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getFiles(...)");
                Object[] $this$any$iv = virtualFileArray2;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!(it.isDirectory() || !OCFileTypeHelpers.isSourceFile((String)it.getName()) && !OCFileTypeHelpers.isHeaderFile((String)it.getName()))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)CompDBUtilKt.getID(), (Module)((ModuleFilesBuildTask)task).getModule());
        }
        if (projectTask instanceof ModuleBuildTask) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)CompDBUtilKt.getID(), (Module)((ModuleBuildTask)task).getModule())) {
                return false;
            }
            return CompDBExternalTaskRunner.INSTANCE.canExecute(task);
        }
        return false;
    }

    @Nullable
    public CidrTaskRunner runnerForTask(@NotNull ProjectTask task, @NotNull Project project) {
        CidrTaskRunner cidrTaskRunner;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectTask projectTask = task;
        if (projectTask instanceof ModuleFilesBuildTask) {
            cidrTaskRunner = (CidrTaskRunner)new CompDBCompileTaskRunner();
        } else if (projectTask instanceof ModuleBuildTask) {
            cidrTaskRunner = CompDBExternalTaskRunner.INSTANCE;
        } else if (projectTask instanceof ProjectModelBuildTask) {
            cidrTaskRunner = CompDBExternalTaskRunner.INSTANCE;
        } else {
            CompDBLog.INSTANCE.getLOG().error("Unexpected project task type: " + task.getPresentableName());
            return null;
        }
        return cidrTaskRunner;
    }
}

