/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb.ui;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.compdb.CompDBBundle;
import com.jetbrains.cidr.cpp.compdb.CompDBUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/ui/GsonErrorFilter;", "Lcom/intellij/execution/filters/Filter;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "string", "", "entireLength", "", "createOpenFileHyperlink", "Lcom/intellij/execution/filters/HyperlinkInfo;", "line", "column", "Companion", "intellij.clion.compdb"})
public class GsonErrorFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private static final String PREFIX;
    @NotNull
    private static final Regex PATTERN;

    public GsonErrorFilter(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String string, int entireLength) {
        int ignore2;
        int n;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)string, (long)250L);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        MatchResult matchResult = Regex.find$default((Regex)PATTERN, (CharSequence)charSequence, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        try {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"line");
            if (matchGroup == null) {
                return null;
            }
            n = Integer.parseInt(matchGroup.getValue()) - 1;
        }
        catch (NumberFormatException ignore2) {
            n = -1;
        }
        int line = n;
        try {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"column");
            if (matchGroup == null) {
                return null;
            }
            ignore2 = Integer.parseInt(matchGroup.getValue()) - 1;
        }
        catch (NumberFormatException ignore3) {
            ignore2 = -1;
        }
        int column = ignore2;
        HyperlinkInfo hyperlinkInfo = this.createOpenFileHyperlink(line, column);
        if (hyperlinkInfo == null) {
            return null;
        }
        HyperlinkInfo hyperlink = hyperlinkInfo;
        return new Filter.Result(entireLength - string.length(), entireLength, hyperlink);
    }

    @Nullable
    protected HyperlinkInfo createOpenFileHyperlink(int line, int column) {
        VirtualFile virtualFile = CompDBUtil.INSTANCE.findDatabaseFile(this.myProject);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile compDB = virtualFile;
        return (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, compDB, line, column);
    }

    static {
        String string = CompDBBundle.message("model.malformed.gson.prefix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        PREFIX = string;
        PATTERN = new Regex(PREFIX + ".*?at\\s+line\\s+(?<line>\\d+)\\s+column\\s+(?<column>\\d+)");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/ui/GsonErrorFilter$Companion;", "", "<init>", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "PATTERN", "Lkotlin/text/Regex;", "intellij.clion.compdb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

