/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.script;

import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaScriptConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaMessageReporter;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.startup.QodanaRunContextFactory;
import org.jetbrains.qodana.staticAnalysis.script.QodanaScript;
import org.jetbrains.qodana.staticAnalysis.script.UnvalidatedParameters;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\bg\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u0003H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/script/QodanaScriptFactory;", "", "scriptName", "", "getScriptName", "()Ljava/lang/String;", "createScript", "Lorg/jetbrains/qodana/staticAnalysis/script/QodanaScript;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "messageReporter", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaMessageReporter;", "contextFactory", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/startup/QodanaRunContextFactory;", "parameters", "Lorg/jetbrains/qodana/staticAnalysis/script/UnvalidatedParameters;", "parseParameters", "", "Companion", "intellij.qodana"})
@ApiStatus.Internal
public interface QodanaScriptFactory {
    @NotNull
    public static final Companion Companion = org.jetbrains.qodana.staticAnalysis.script.QodanaScriptFactory$Companion.$$INSTANCE;

    @NotNull
    public String getScriptName();

    @NotNull
    public QodanaScript createScript(@NotNull QodanaConfig var1, @NotNull QodanaMessageReporter var2, @NotNull QodanaRunContextFactory var3, @NotNull UnvalidatedParameters var4);

    @NotNull
    public Map<String, String> parseParameters(@NotNull String var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/script/QodanaScriptFactory$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/qodana/staticAnalysis/script/QodanaScriptFactory;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "parseConfigFromArgument", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;", "argument", "", "buildScript", "Lorg/jetbrains/qodana/staticAnalysis/script/QodanaScript;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "contextFactory", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/startup/QodanaRunContextFactory;", "messageReporter", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaMessageReporter;", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nQodanaScriptFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaScriptFactory.kt\norg/jetbrains/qodana/staticAnalysis/script/QodanaScriptFactory$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n295#2,2:101\n*S KotlinDebug\n*F\n+ 1 QodanaScriptFactory.kt\norg/jetbrains/qodana/staticAnalysis/script/QodanaScriptFactory$Companion\n*L\n85#1:101,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ExtensionPointName<QodanaScriptFactory> EP_NAME;

        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<QodanaScriptFactory> getEP_NAME() {
            return EP_NAME;
        }

        @Nullable
        public final QodanaScriptConfig parseConfigFromArgument(@NotNull String argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            for (QodanaScriptFactory factory : EP_NAME.getExtensionList()) {
                String afterName;
                String scriptName = factory.getScriptName();
                if (!StringsKt.startsWith$default((String)argument, (String)scriptName, (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)argument.substring(scriptName.length()), (String)"substring(...)");
                if (((CharSequence)afterName).length() == 0) {
                    return new QodanaScriptConfig(scriptName, factory.parseParameters(""));
                }
                if (!StringsKt.startsWith$default((String)afterName, (String)":", (boolean)false, (int)2, null)) continue;
                String string = afterName.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String parameters = string;
                if (((CharSequence)parameters).length() == 0) {
                    throw new QodanaException("Script parameters in '--script " + argument + "' must not be empty");
                }
                return new QodanaScriptConfig(scriptName, factory.parseParameters(parameters));
            }
            return null;
        }

        @NotNull
        public final QodanaScript buildScript(@NotNull QodanaConfig config, @NotNull QodanaRunContextFactory contextFactory, @NotNull QodanaMessageReporter messageReporter) {
            Object v2;
            String name;
            block3: {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                Intrinsics.checkNotNullParameter((Object)contextFactory, (String)"contextFactory");
                Intrinsics.checkNotNullParameter((Object)messageReporter, (String)"messageReporter");
                name = config.getScript().getName();
                Iterable $this$firstOrNull$iv = EP_NAME.getExtensionList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    QodanaScriptFactory it = (QodanaScriptFactory)element$iv;
                    boolean bl = false;
                    String string = it.getScriptName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    String string2 = name.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string, (Object)string2)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            QodanaScriptFactory qodanaScriptFactory = v2;
            if (qodanaScriptFactory == null) {
                throw new QodanaException("Script '" + name + "' does not exist");
            }
            QodanaScriptFactory factory = qodanaScriptFactory;
            String scriptName = factory.getScriptName();
            if (!Intrinsics.areEqual((Object)scriptName, (Object)"default")) {
                messageReporter.reportMessage(1, "Using '" + scriptName + "' script as qodana run scenario");
            }
            UnvalidatedParameters parameters = new UnvalidatedParameters(scriptName, config.getScript().getParameters());
            QodanaScript script = factory.createScript(config, messageReporter, contextFactory, parameters);
            parameters.done();
            return script;
        }

        static {
            $$INSTANCE = new Companion();
            EP_NAME = ExtensionPointName.Companion.create("org.intellij.qodana.qodanaScriptFactory");
        }
    }
}

