/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.packagemanager.vcpkg.problemfinder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.packagemanager.bundle.PackageManagerBundle;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00142\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\t\u001a\u000f\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rJ\u001b\u0010\u000e\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\u00032\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u001b\u0010\u0010\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\u00032\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u001b\u0010\u0012\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\u00032\u0006\u0010\u0013\u001a\u00020\nH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder;", "", "packages", "", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$PackageManagerTriggerHint;", "<init>", "(Ljava/util/List;)V", "getPackages", "()Ljava/util/List;", "resolve", "", "Lorg/jetbrains/annotations/Nls;", "typeOfPackageProblem", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem;", "tryToFindPackage", "pkgName", "tryToFindInclude", "include", "tryToFindMissingModule", "module", "Companion", "PackageManagerTriggerHint", "InlineSolveOfProblem", "TypeOfPackageProblem", "intellij.clion.packageManager"})
@SourceDebugExtension(value={"SMAP\nPackageProblemFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageProblemFinder.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n774#3:114\n865#3:115\n1761#3,3:116\n866#3:119\n1563#3:120\n1634#3,3:121\n774#3:124\n865#3:125\n1761#3,3:126\n866#3:129\n1563#3:130\n1634#3,3:131\n774#3:134\n865#3:135\n1761#3,3:136\n866#3:139\n1563#3:140\n1634#3,3:141\n*S KotlinDebug\n*F\n+ 1 PackageProblemFinder.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder\n*L\n49#1:114\n49#1:115\n49#1:116,3\n49#1:119\n49#1:120\n49#1:121,3\n53#1:124\n53#1:125\n53#1:126,3\n53#1:129\n53#1:130\n53#1:131,3\n57#1:134\n57#1:135\n57#1:136,3\n57#1:139\n57#1:140\n57#1:141,3\n*E\n"})
public final class PackageProblemFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PackageManagerTriggerHint> packages;
    @NotNull
    public static final String PACKAGE_NAME_KEY = "packageName";
    @NotNull
    public static final String CMAKE_KEY = "cmakeLines";
    @NotNull
    public static final String C_INCLUDE_KEY = "cppIncludes";
    @NotNull
    private static final String CMAKE_PACKAGES_MODULES_KEY = "moduleCMakePackages";

    public PackageProblemFinder(@NotNull List<PackageManagerTriggerHint> packages) {
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        this.packages = packages;
    }

    @NotNull
    public final List<PackageManagerTriggerHint> getPackages() {
        return this.packages;
    }

    @Nullable
    public final List<String> resolve(@NotNull TypeOfPackageProblem typeOfPackageProblem) {
        List list;
        Intrinsics.checkNotNullParameter((Object)typeOfPackageProblem, (String)"typeOfPackageProblem");
        TypeOfPackageProblem typeOfPackageProblem2 = typeOfPackageProblem;
        if (typeOfPackageProblem2 instanceof TypeOfPackageProblem.CMakePackageFindFailed) {
            Collection collection;
            Collection collection2 = this.tryToFindPackage(typeOfPackageProblem.getName());
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = null;
            } else {
                collection = collection2;
            }
            list = (List)collection;
        } else if (typeOfPackageProblem2 instanceof TypeOfPackageProblem.CPPFileNotFind) {
            Collection collection;
            Collection collection3 = this.tryToFindInclude(typeOfPackageProblem.getName());
            if (collection3.isEmpty()) {
                boolean bl = false;
                collection = null;
            } else {
                collection = collection3;
            }
            list = (List)collection;
        } else if (typeOfPackageProblem2 instanceof TypeOfPackageProblem.CMakeModuleFindFailed) {
            Collection collection;
            Collection collection4 = this.tryToFindMissingModule(typeOfPackageProblem.getName());
            if (collection4.isEmpty()) {
                boolean bl = false;
                collection = null;
            } else {
                collection = collection4;
            }
            list = (List)collection;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> tryToFindPackage(String pkgName) {
        void $this$mapTo$iv$iv;
        PackageManagerTriggerHint hint;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.packages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                hint = (PackageManagerTriggerHint)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = hint.getCmakeLines();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        String string = it.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                        String string2 = pkgName.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        if (!Intrinsics.areEqual((Object)string, (Object)string2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            hint = (PackageManagerTriggerHint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPackageName());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> tryToFindInclude(String include) {
        void $this$mapTo$iv$iv;
        PackageManagerTriggerHint hint;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.packages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                hint = (PackageManagerTriggerHint)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = hint.getCppIncludes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String line = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)include, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            hint = (PackageManagerTriggerHint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPackageName());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> tryToFindMissingModule(String module) {
        void $this$mapTo$iv$iv;
        PackageManagerTriggerHint hint;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.packages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                hint = (PackageManagerTriggerHint)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = hint.getCMakePackagesModules();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)it, (String)module, (boolean)true)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            hint = (PackageManagerTriggerHint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPackageName());
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$Companion;", "", "<init>", "()V", "PACKAGE_NAME_KEY", "", "CMAKE_KEY", "C_INCLUDE_KEY", "CMAKE_PACKAGES_MODULES_KEY", "createTriggerHintList", "", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$PackageManagerTriggerHint;", "inputString", "Ljava/io/InputStream;", "intellij.clion.packageManager"})
    @SourceDebugExtension(value={"SMAP\nPackageProblemFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageProblemFinder.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1563#2:113\n1634#2,3:114\n1056#2:117\n1563#2:118\n1634#2,3:119\n*S KotlinDebug\n*F\n+ 1 PackageProblemFinder.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$Companion\n*L\n29#1:113\n29#1:114,3\n37#1:117\n26#1:118\n26#1:119,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PackageManagerTriggerHint> createTriggerHintList(@NotNull InputStream inputString) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
            JsonNode jsonNode = new ObjectMapper().readTree(inputString);
            Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            Iterable $this$map$iv = (Iterable)((ObjectNode)jsonNode);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void currentNode;
                JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)currentNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                ObjectNode cfr_ignored_0 = (ObjectNode)currentNode;
                JsonNode jsonNode3 = ((ObjectNode)currentNode).get(PackageProblemFinder.PACKAGE_NAME_KEY);
                Intrinsics.checkNotNull((Object)jsonNode3);
                String string = jsonNode3.asText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
                collection.add(new PackageManagerTriggerHint(string, com.jetbrains.cidr.packagemanager.vcpkg.problemfinder.PackageProblemFinder$Companion.createTriggerHintList$getAsStringArray(((ObjectNode)currentNode).get(PackageProblemFinder.CMAKE_KEY)), com.jetbrains.cidr.packagemanager.vcpkg.problemfinder.PackageProblemFinder$Companion.createTriggerHintList$getAsStringArray(((ObjectNode)currentNode).get(PackageProblemFinder.C_INCLUDE_KEY)), com.jetbrains.cidr.packagemanager.vcpkg.problemfinder.PackageProblemFinder$Companion.createTriggerHintList$getAsStringArray(((ObjectNode)currentNode).get(PackageProblemFinder.CMAKE_PACKAGES_MODULES_KEY))));
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PackageManagerTriggerHint it = (PackageManagerTriggerHint)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getPackageName());
                    it = (PackageManagerTriggerHint)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPackageName())));
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private static final List<String> createTriggerHintList$getAsStringArray(JsonNode $this$createTriggerHintList_u24getAsStringArray) {
            List list;
            Object object = $this$createTriggerHintList_u24getAsStringArray;
            if (object != null && (object = CollectionsKt.toList((Iterable)((Iterable)object))) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonNode jsonNode = (JsonNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.asText());
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0010\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J7\u0010\u0013\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$InlineSolveOfProblem;", "", "text", "", "Lorg/jetbrains/annotations/Nls;", "tooltip", "action", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getText", "()Ljava/lang/String;", "getTooltip", "getAction", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clion.packageManager"})
    public static final class InlineSolveOfProblem {
        @NotNull
        private final String text;
        @NotNull
        private final String tooltip;
        @NotNull
        private final Function0<Unit> action;

        public InlineSolveOfProblem(@NotNull String text, @NotNull String tooltip, @NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.text = text;
            this.tooltip = tooltip;
            this.action = action;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getTooltip() {
            return this.tooltip;
        }

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final String component2() {
            return this.tooltip;
        }

        @NotNull
        public final Function0<Unit> component3() {
            return this.action;
        }

        @NotNull
        public final InlineSolveOfProblem copy(@NotNull String text, @NotNull String tooltip, @NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return new InlineSolveOfProblem(text, tooltip, action);
        }

        public static /* synthetic */ InlineSolveOfProblem copy$default(InlineSolveOfProblem inlineSolveOfProblem, String string, String string2, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                string = inlineSolveOfProblem.text;
            }
            if ((n & 2) != 0) {
                string2 = inlineSolveOfProblem.tooltip;
            }
            if ((n & 4) != 0) {
                function0 = inlineSolveOfProblem.action;
            }
            return inlineSolveOfProblem.copy(string, string2, function0);
        }

        @NotNull
        public String toString() {
            return "InlineSolveOfProblem(text=" + this.text + ", tooltip=" + this.tooltip + ", action=" + this.action + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + this.tooltip.hashCode();
            result = result * 31 + this.action.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InlineSolveOfProblem)) {
                return false;
            }
            InlineSolveOfProblem inlineSolveOfProblem = (InlineSolveOfProblem)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)inlineSolveOfProblem.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tooltip, (Object)inlineSolveOfProblem.tooltip)) {
                return false;
            }
            return Intrinsics.areEqual(this.action, inlineSolveOfProblem.action);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$PackageManagerTriggerHint;", "", "packageName", "", "cmakeLines", "", "cppIncludes", "cMakePackagesModules", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getPackageName", "()Ljava/lang/String;", "getCmakeLines", "()Ljava/util/List;", "setCmakeLines", "(Ljava/util/List;)V", "getCppIncludes", "setCppIncludes", "getCMakePackagesModules", "setCMakePackagesModules", "intellij.clion.packageManager"})
    public static final class PackageManagerTriggerHint {
        @NotNull
        private final String packageName;
        @NotNull
        private List<String> cmakeLines;
        @NotNull
        private List<String> cppIncludes;
        @NotNull
        private List<String> cMakePackagesModules;

        public PackageManagerTriggerHint(@NotNull String packageName, @NotNull List<String> cmakeLines, @NotNull List<String> cppIncludes, @NotNull List<String> cMakePackagesModules) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)PackageProblemFinder.PACKAGE_NAME_KEY);
            Intrinsics.checkNotNullParameter(cmakeLines, (String)PackageProblemFinder.CMAKE_KEY);
            Intrinsics.checkNotNullParameter(cppIncludes, (String)PackageProblemFinder.C_INCLUDE_KEY);
            Intrinsics.checkNotNullParameter(cMakePackagesModules, (String)"cMakePackagesModules");
            this.packageName = packageName;
            this.cmakeLines = cmakeLines;
            this.cppIncludes = cppIncludes;
            this.cMakePackagesModules = cMakePackagesModules;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final List<String> getCmakeLines() {
            return this.cmakeLines;
        }

        public final void setCmakeLines(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.cmakeLines = list;
        }

        @NotNull
        public final List<String> getCppIncludes() {
            return this.cppIncludes;
        }

        public final void setCppIncludes(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.cppIncludes = list;
        }

        @NotNull
        public final List<String> getCMakePackagesModules() {
            return this.cMakePackagesModules;
        }

        public final void setCMakePackagesModules(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.cMakePackagesModules = list;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u001f !B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0017\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0018H&J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u0082\u0001\u0003\"#$\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "onOfferResolve", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "getOnOfferResolve", "()Lcom/intellij/internal/statistic/eventLog/events/EventId;", "setOnOfferResolve", "(Lcom/intellij/internal/statistic/eventLog/events/EventId;)V", "onResolveEvent", "getOnResolveEvent", "setOnResolveEvent", "profile", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProfileInfo;", "getProfile", "()Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProfileInfo;", "setProfile", "(Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProfileInfo;)V", "getDescription", "Lorg/jetbrains/annotations/Nls;", "equals", "", "other", "hashCode", "", "toString", "CMakePackageFindFailed", "CPPFileNotFind", "CMakeModuleFindFailed", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem$CMakeModuleFindFailed;", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem$CMakePackageFindFailed;", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem$CPPFileNotFind;", "intellij.clion.packageManager"})
    public static abstract class TypeOfPackageProblem {
        @NotNull
        private final String name;
        @Nullable
        private EventId onOfferResolve;
        @Nullable
        private EventId onResolveEvent;
        @Nullable
        private CMakeProfileInfo profile;

        private TypeOfPackageProblem(String name) {
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final EventId getOnOfferResolve() {
            return this.onOfferResolve;
        }

        public final void setOnOfferResolve(@Nullable EventId eventId) {
            this.onOfferResolve = eventId;
        }

        @Nullable
        public final EventId getOnResolveEvent() {
            return this.onResolveEvent;
        }

        public final void setOnResolveEvent(@Nullable EventId eventId) {
            this.onResolveEvent = eventId;
        }

        @Nullable
        public final CMakeProfileInfo getProfile() {
            return this.profile;
        }

        public final void setProfile(@Nullable CMakeProfileInfo cMakeProfileInfo) {
            this.profile = cMakeProfileInfo;
        }

        @NotNull
        public abstract String getDescription();

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.cidr.packagemanager.vcpkg.problemfinder.PackageProblemFinder.TypeOfPackageProblem");
            TypeOfPackageProblem cfr_ignored_0 = (TypeOfPackageProblem)other;
            return Intrinsics.areEqual((Object)this.name, (Object)((TypeOfPackageProblem)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @NotNull
        public String toString() {
            Object object;
            if (this.profile != null) {
                CMakeProfileInfo cMakeProfileInfo = this.profile;
                Intrinsics.checkNotNull((Object)cMakeProfileInfo);
                object = ", profileName='" + cMakeProfileInfo.getProfile().getName() + "'";
            } else {
                object = "";
            }
            return "TypeOfPackageProblem(name='" + this.name + "'" + (String)object + ")";
        }

        public /* synthetic */ TypeOfPackageProblem(String name, DefaultConstructorMarker $constructor_marker) {
            this(name);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem$CMakeModuleFindFailed;", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem;", "name", "", "<init>", "(Ljava/lang/String;)V", "getDescription", "Lorg/jetbrains/annotations/Nls;", "intellij.clion.packageManager"})
        public static final class CMakeModuleFindFailed
        extends TypeOfPackageProblem {
            public CMakeModuleFindFailed(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(name, null);
            }

            @Override
            @NotNull
            public String getDescription() {
                Object[] objectArray = new Object[]{this.getName()};
                return PackageManagerBundle.message("toolwindow.problem.cmake.module.description", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem$CMakePackageFindFailed;", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem;", "name", "", "<init>", "(Ljava/lang/String;)V", "getDescription", "Lorg/jetbrains/annotations/Nls;", "intellij.clion.packageManager"})
        public static final class CMakePackageFindFailed
        extends TypeOfPackageProblem {
            public CMakePackageFindFailed(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(name, null);
            }

            @Override
            @NotNull
            public String getDescription() {
                Object[] objectArray = new Object[]{this.getName()};
                return PackageManagerBundle.message("toolwindow.problem.cmake.description", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem$CPPFileNotFind;", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem;", "name", "", "<init>", "(Ljava/lang/String;)V", "getDescription", "Lorg/jetbrains/annotations/Nls;", "intellij.clion.packageManager"})
        public static final class CPPFileNotFind
        extends TypeOfPackageProblem {
            public CPPFileNotFind(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(name, null);
            }

            @Override
            @NotNull
            public String getDescription() {
                Object[] objectArray = new Object[]{this.getName()};
                return PackageManagerBundle.message("toolwindow.problem.cpp.description", objectArray);
            }
        }
    }
}

