/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.packagemanager.vcpkg.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.cidr.packagemanager.bundle.PackageManagerBundle;
import com.jetbrains.cidr.packagemanager.calling.CallEngineContextUtils;
import com.jetbrains.cidr.packagemanager.calling.CallEngineStatus;
import com.jetbrains.cidr.packagemanager.calling.CallEngineStatusContext;
import com.jetbrains.cidr.packagemanager.calling.TaskBuilder;
import com.jetbrains.cidr.packagemanager.fus.PackageManagerCollector;
import com.jetbrains.cidr.packagemanager.utils.PackageManagerUtils;
import com.jetbrains.cidr.packagemanager.vcpkg.PackageManagerEventListener;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGPackageManager;
import com.jetbrains.cidr.packagemanager.vcpkg.service.VcpkgExecutorService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service
@State(name="PackageManager", storages={@Storage(value="packageManager.xml")}, reloadable=false)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001&B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\u0002H\u0016J\u0011\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f*\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0007J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0007J1\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000b\u0010\u001a\u001a\u00070\u000b\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bJ3\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000b\u0010\u001a\u001a\u00070\u000b\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0007J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J(\u0010#\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\b2\u000b\u0010$\u001a\u00070\u000b\u00a2\u0006\u0002\b\u001b2\u000b\u0010%\u001a\u00070\u000b\u00a2\u0006\u0002\b\u001bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/service/VcpkgPackageManagerModelService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "packagesModel", "", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager;", "getState", "getElementName", "", "Lcom/intellij/openapi/util/NlsSafe;", "loadState", "", "state", "getPackages", "addWithDispose", "packageManager", "removeWithDispose", "add", "remove", "install", "Lcom/jetbrains/cidr/packagemanager/calling/TaskBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "name", "Lorg/jetbrains/annotations/Nls;", "path", "Ljava/nio/file/Path;", "url", "testInstall", "vcpkgPackageManager", "isRemoveFolder", "", "rename", "oldName", "newName", "Companion", "intellij.clion.packageManager"})
@SourceDebugExtension(value={"SMAP\nVcpkgPackageManagerModelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcpkgPackageManagerModelService.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/service/VcpkgPackageManagerModelService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1869#2,2:155\n1563#2:157\n1634#2,3:158\n1869#2,2:161\n*S KotlinDebug\n*F\n+ 1 VcpkgPackageManagerModelService.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/service/VcpkgPackageManagerModelService\n*L\n53#1:155,2\n69#1:157\n69#1:158,3\n134#1:161,2\n*E\n"})
public final class VcpkgPackageManagerModelService
implements PersistentStateComponent<Element>,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Set<VCPKGPackageManager> packagesModel = new LinkedHashSet();

    @NotNull
    public Element getState() {
        Element mainElement = new Element("mainNode");
        Iterable $this$forEach$iv = this.packagesModel;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VCPKGPackageManager packageManager = (VCPKGPackageManager)element$iv;
            boolean bl = false;
            Element packageManagerElement = new Element("repository");
            packageManagerElement.setAttribute("name", packageManager.getName());
            packageManagerElement.setAttribute("path", ((Object)packageManager.getPath()).toString());
            packageManagerElement.setAttribute("baseUrl", packageManager.getBaseUrl());
            packageManagerElement.setAttribute("forcedCMakeNinja", String.valueOf((Boolean)packageManager.isForcedBundledNinjaCMake().get()));
            mainElement.addContent(packageManagerElement);
        }
        return mainElement;
    }

    private final String getElementName(Element $this$getElementName) {
        String string = $this$getElementName.getAttributeValue("name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull Element state) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List list = state.getChildren("repository");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable iterable = list;
        VcpkgPackageManagerModelService vcpkgPackageManagerModelService = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void repository;
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)repository);
            String name = this.getElementName((Element)repository);
            Path path = Path.of(repository.getAttributeValue("path"), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            String string = repository.getAttributeValue("baseUrl");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            String string2 = repository.getAttributeValue("forcedCMakeNinja");
            if (string2 == null) {
                string2 = "false";
            }
            VCPKGPackageManager packageManager = new VCPKGPackageManager(name, path, string, (AtomicProperty<Boolean>)new AtomicProperty((Object)Boolean.parseBoolean(string2)));
            Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)packageManager));
            collection.add(packageManager);
        }
        vcpkgPackageManagerModelService.packagesModel = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Set<VCPKGPackageManager> getPackages() {
        return this.packagesModel;
    }

    private final void addWithDispose(VCPKGPackageManager packageManager) {
        this.packagesModel.add(packageManager);
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)packageManager));
    }

    private final void removeWithDispose(VCPKGPackageManager packageManager) {
        this.packagesModel.remove(packageManager);
        Disposer.dispose((Disposable)((Disposable)packageManager));
    }

    @TestOnly
    public final void add(@NotNull VCPKGPackageManager packageManager) {
        Intrinsics.checkNotNullParameter((Object)packageManager, (String)"packageManager");
        this.addWithDispose(packageManager);
    }

    @TestOnly
    public final void remove(@NotNull VCPKGPackageManager packageManager) {
        Intrinsics.checkNotNullParameter((Object)packageManager, (String)"packageManager");
        this.removeWithDispose(packageManager);
    }

    @NotNull
    public final TaskBuilder<VCPKGPackageManager> install(@NotNull Project project, @NotNull String name, @NotNull Path path, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        VCPKGPackageManager packageManager = new VCPKGPackageManager(name, path, url, null, 8, null);
        this.addWithDispose(packageManager);
        ((PackageManagerEventListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PackageManagerEventListener.Companion.getTOPIC())).onPackageManagerAdded(packageManager);
        return TaskBuilder.TaskBuilderInfo.Companion.taskBuilder(project, PackageManagerBundle.message("progress.title.checking.for.install", new Object[0])).task(arg_0 -> VcpkgPackageManagerModelService.install$lambda$3(packageManager, project, arg_0)).onSuccess(VcpkgPackageManagerModelService::install$lambda$4).onFailure((Function1<CallEngineStatusContext.FailedContext, Unit>)((Function1)arg_0 -> VcpkgPackageManagerModelService.install$lambda$5(packageManager, arg_0)));
    }

    @TestOnly
    @NotNull
    public final TaskBuilder<VCPKGPackageManager> testInstall(@NotNull Project project, @NotNull String name, @NotNull Path path, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        VCPKGPackageManager packageManager = new VCPKGPackageManager(name, path, url, null, 8, null);
        this.addWithDispose(packageManager);
        ((PackageManagerEventListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PackageManagerEventListener.Companion.getTOPIC())).onPackageManagerAdded(packageManager);
        return TaskBuilder.TaskBuilderInfo.Companion.taskBuilder(project, PackageManagerBundle.message("progress.title.checking.for.install", new Object[0])).task(arg_0 -> VcpkgPackageManagerModelService.testInstall$lambda$7(packageManager, arg_0));
    }

    @NotNull
    public final TaskBuilder<Unit> remove(@NotNull Project project, @NotNull VCPKGPackageManager vcpkgPackageManager, boolean isRemoveFolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vcpkgPackageManager, (String)"vcpkgPackageManager");
        Iterable $this$forEach$iv = PackageManagerUtils.Companion.getProfilesPackageManagerWithLocks(project, (Function1<? super VCPKGPackageManager, Boolean>)((Function1)VcpkgPackageManagerModelService::remove$lambda$8));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PackageManagerUtils.ProfilePackageManagerInfo info = (PackageManagerUtils.ProfilePackageManagerInfo)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)info.getPackageManager(), (Object)vcpkgPackageManager)) continue;
            PackageManagerUtils.Companion.setActiveToolchain(project, info.getProfile(), null);
        }
        ((PackageManagerEventListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PackageManagerEventListener.Companion.getTOPIC())).onPackageManagerRemoved(vcpkgPackageManager);
        this.removeWithDispose(vcpkgPackageManager);
        PackageManagerCollector.countOfRemoveVCPKG.log();
        Object[] objectArray = new Object[]{vcpkgPackageManager.getName()};
        return TaskBuilder.TaskBuilderInfo.Companion.taskBuilder(project, PackageManagerBundle.message("vcpkg.toolwindow.task.remove.package.manager", objectArray)).task(arg_0 -> VcpkgPackageManagerModelService.remove$lambda$10(vcpkgPackageManager, isRemoveFolder, arg_0)).onSuccess(VcpkgPackageManagerModelService::remove$lambda$11).onFailure((Function1<CallEngineStatusContext.FailedContext, Unit>)((Function1)VcpkgPackageManagerModelService::remove$lambda$12));
    }

    public final void rename(@NotNull VCPKGPackageManager vcpkgPackageManager, @NotNull String oldName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)vcpkgPackageManager, (String)"vcpkgPackageManager");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        vcpkgPackageManager.setName(newName);
        ((PackageManagerEventListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PackageManagerEventListener.Companion.getTOPIC())).onPackageManagerRenamed(vcpkgPackageManager, oldName, newName);
    }

    private static final VCPKGPackageManager install$lambda$3$lambda$2(VCPKGPackageManager $packageManager, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $packageManager;
    }

    private static final CallEngineStatus install$lambda$3(VCPKGPackageManager $packageManager, Project $project, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return $packageManager.safeStartWithInstall($project, VcpkgExecutorService.Companion.getInstance($project).getExecutor($packageManager).runner(indicator), indicator).withTransformResult(arg_0 -> VcpkgPackageManagerModelService.install$lambda$3$lambda$2($packageManager, arg_0));
    }

    private static final Unit install$lambda$4(CallEngineStatusContext.SuccessfulContext $this$onSuccess) {
        Intrinsics.checkNotNullParameter((Object)$this$onSuccess, (String)"$this$onSuccess");
        CallEngineContextUtils.Companion.showInfo$default(CallEngineContextUtils.Companion, $this$onSuccess, PackageManagerBundle.message("vcpkg.toolwindow.task.clone.and.bootstrap.successful", new Object[0]), null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit install$lambda$5(VCPKGPackageManager $packageManager, CallEngineStatusContext.FailedContext $this$onFailure) {
        Intrinsics.checkNotNullParameter((Object)$this$onFailure, (String)"$this$onFailure");
        CallEngineContextUtils.Companion.showErrorWithOutputLink($this$onFailure, $this$onFailure.getProblem().getShortError(), $packageManager);
        return Unit.INSTANCE;
    }

    private static final VCPKGPackageManager testInstall$lambda$7$lambda$6(VCPKGPackageManager $packageManager, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $packageManager;
    }

    private static final CallEngineStatus testInstall$lambda$7(VCPKGPackageManager $packageManager, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $packageManager.testInstall().withTransformResult(arg_0 -> VcpkgPackageManagerModelService.testInstall$lambda$7$lambda$6($packageManager, arg_0));
    }

    private static final boolean remove$lambda$8(VCPKGPackageManager it) {
        return false;
    }

    private static final CallEngineStatus remove$lambda$10(VCPKGPackageManager $vcpkgPackageManager, boolean $isRemoveFolder, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $vcpkgPackageManager.safeRemove(it, $isRemoveFolder);
    }

    private static final Unit remove$lambda$11(CallEngineStatusContext.SuccessfulContext $this$onSuccess) {
        Intrinsics.checkNotNullParameter((Object)$this$onSuccess, (String)"$this$onSuccess");
        CallEngineContextUtils.Companion.showInfo$default(CallEngineContextUtils.Companion, $this$onSuccess, PackageManagerBundle.message("vcpkg.toolwindow.task.remove.package.manager.success", new Object[0]), null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit remove$lambda$12(CallEngineStatusContext.FailedContext $this$onFailure) {
        Intrinsics.checkNotNullParameter((Object)$this$onFailure, (String)"$this$onFailure");
        Object[] objectArray = new Object[]{$this$onFailure.getProblem().getShortError()};
        CallEngineContextUtils.Companion.showError$default(CallEngineContextUtils.Companion, $this$onFailure, PackageManagerBundle.message("vcpkg.toolwindow.task.remove.package.manager.failed", objectArray), null, 2, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/service/VcpkgPackageManagerModelService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/cidr/packagemanager/vcpkg/service/VcpkgPackageManagerModelService;", "intellij.clion.packageManager"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VcpkgPackageManagerModelService getInstance() {
            Object object = ApplicationManager.getApplication().getService(VcpkgPackageManagerModelService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (VcpkgPackageManagerModelService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

