/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.packagemanager.vcpkg.utils;

import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.MinGW;
import com.jetbrains.cidr.packagemanager.vcpkg.problemfinder.PackageProblemFinder;
import com.jetbrains.cidr.packagemanager.vcpkg.utils.VcpkgTripletUtilsKt;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/utils/VcpkgTripletUtils;", "", "<init>", "()V", "guessTripletFromContext", "", "project", "Lcom/intellij/openapi/project/Project;", "profile", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProfileInfo;", "problem", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$TypeOfPackageProblem;", "intellij.clion.packageManager"})
@SourceDebugExtension(value={"SMAP\nVcpkgTripletUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcpkgTripletUtils.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/utils/VcpkgTripletUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1740#2,3:94\n774#2:97\n865#2,2:98\n1563#2:100\n1634#2,3:101\n346#2,8:104\n*S KotlinDebug\n*F\n+ 1 VcpkgTripletUtils.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/utils/VcpkgTripletUtils\n*L\n49#1:94,3\n50#1:97\n50#1:98,2\n50#1:100\n50#1:101,3\n65#1:104,8\n*E\n"})
public final class VcpkgTripletUtils {
    @NotNull
    public static final VcpkgTripletUtils INSTANCE = new VcpkgTripletUtils();

    private VcpkgTripletUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @Nullable
    public final String guessTripletFromContext(@NotNull Project project, @Nullable CMakeProfileInfo profile) {
        int n;
        List list;
        Object generationDir;
        block19: {
            void $this$indexOfFirst$iv;
            Iterable $this$mapTo$iv$iv;
            boolean bl;
            block18: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                CMakeProfileInfo cMakeProfileInfo = profile;
                boolean bl2 = cMakeProfileInfo != null && (cMakeProfileInfo = cMakeProfileInfo.getEnvironment()) != null ? cMakeProfileInfo.isMinGW() : false;
                if (bl2) {
                    CPPEnvironment cPPEnvironment = profile.getEnvironment();
                    Object object = cPPEnvironment != null ? cPPEnvironment.getToolSet() : null;
                    MinGW minGW = object instanceof MinGW ? (MinGW)object : null;
                    String minGWPath = minGW != null ? minGW.getHomePath() : null;
                    Path path = MinGW.getBundledPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getBundledPath(...)");
                    if (Intrinsics.areEqual((Object)minGWPath, (Object)((Object)path.toAbsolutePath()).toString())) {
                        String buildType = profile.getProfile().getBuildType();
                        if (StringsKt.equals((String)buildType, (String)"Debug", (boolean)true)) {
                            return "x64-mingw-dynamic";
                        }
                        if (StringsKt.equals((String)buildType, (String)"Release", (boolean)true)) {
                            return "x64-mingw-static";
                        }
                        VcpkgTripletUtilsKt.access$getLogger$p().info("Found MinGW toolset, bundled, but unknown build type. Suggest x64-mingw-dynamic");
                        return "x64-mingw-dynamic";
                    }
                    VcpkgTripletUtilsKt.access$getLogger$p().info("Found MinGW toolset, but MinGW is not bundled. Do not suggest forced triplet because of MinGW");
                }
                Iterable $this$all$iv = CMakeWorkspace.Companion.getInstance(project).getProfileInfos();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        CMakeProfileInfo it = (CMakeProfileInfo)element$iv;
                        boolean bl3 = false;
                        CPPEnvironment cPPEnvironment = it.getEnvironment();
                        if ((cPPEnvironment != null ? cPPEnvironment.isMinGW() : false) || !it.getProfile().getEnabled()) continue;
                        bl = false;
                        break block18;
                    }
                    bl = true;
                }
            }
            if (bl) {
                void $this$map$iv;
                CMakeProfileInfo it;
                void $this$filterTo$iv$iv;
                Object element$iv;
                Iterable $this$filter$iv = CMakeWorkspace.Companion.getInstance(project).getProfileInfos();
                boolean $i$f$filter = false;
                element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (CMakeProfileInfo)element$iv$iv;
                    boolean bl4 = false;
                    if (!it.getProfile().getEnabled()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (CMakeProfileInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(it.getProfile().getBuildType());
                }
                List buildTypes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                String triplet = buildTypes.size() == 1 ? (Intrinsics.areEqual((Object)((String)CollectionsKt.first((List)buildTypes)), (Object)"Release") ? "x64-mingw-static" : "x64-mingw-dynamic") : "x64-mingw-dynamic";
                return triplet;
            }
            Object object = profile;
            if (object == null || (object = object.getGenerationDir()) == null) {
                return null;
            }
            generationDir = object;
            CMakeWorkspace workspace = CMakeWorkspace.Companion.getInstance(project);
            $this$mapTo$iv$iv = workspace.getProfileInfos();
            list = workspace.getModelConfigurationData();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                CMakeProfileInfo it = (CMakeProfileInfo)item$iv;
                boolean bl6 = false;
                if (Intrinsics.areEqual((Object)it.getProfile().getName(), (Object)profile.getProfile().getName())) {
                    n = index$iv;
                    break block19;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n2 = n;
        CMakeModelConfigurationData configurationData = (CMakeModelConfigurationData)list.get(n2);
        if (configurationData == null) {
            CMakeCacheFile cacheFile = new CMakeCacheFile(FilesKt.resolve((File)generationDir, (String)"CMakeCache.txt"), StandardCharsets.UTF_8.name());
            CMakeVariable targetTripletVariable = cacheFile.getVariable("VCPKG_TARGET_TRIPLET");
            if (targetTripletVariable != null) {
                return targetTripletVariable.getValue();
            }
        } else {
            CMakeVariable targetTripletVariable = configurationData.getCacheConfigurator().findVariable("VCPKG_TARGET_TRIPLET");
            if (targetTripletVariable != null) {
                return targetTripletVariable.getValue();
            }
        }
        return null;
    }

    @RequiresBackgroundThread
    @Nullable
    public final String guessTripletFromContext(@NotNull Project project, @Nullable PackageProblemFinder.TypeOfPackageProblem problem) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PackageProblemFinder.TypeOfPackageProblem typeOfPackageProblem = problem;
        return this.guessTripletFromContext(project, (CMakeProfileInfo)(typeOfPackageProblem != null ? typeOfPackageProblem.getProfile() : null));
    }
}

