/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.completion.ml.MLWeigherUtil;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixChangedBuiltinTemplate;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.IconManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.completion.ClangPostfixTemplateFlags;
import com.jetbrains.cidr.lang.completion.ClangdCompletionUtils;
import com.jetbrains.cidr.lang.completion.ClangdLiveTemplate;
import com.jetbrains.cidr.lang.completion.ClangdLookupElement;
import com.jetbrains.cidr.lang.completion.ClangdPostfixTemplateProvider;
import com.jetbrains.cidr.lang.completion.CompletionKindsCollector;
import com.jetbrains.cidr.lang.completion.ExternalCompletionProvider;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultFuture;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionSnippetFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import icons.CidrLangIcons;
import icons.CidrProjectModelIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangdCodeCompletionProviderBase
implements ExternalCompletionProvider,
DumbAware {
    private static final Map<Pair<Icon, Icon>, Icon> myPatchedIcons = new ConcurrentHashMap<Pair<Icon, Icon>, Icon>();
    private static final ConcurrentHashMap<Icon, Icon> myDesaturatedIconsCache = new ConcurrentHashMap();
    @NonNls
    private static final String CPP_GROUP = "C/C++";
    @NonNls
    private static final String COMPLETION_SEPARATOR = "\\\\u2029";
    private static final int ourDefaultFirstItemsBatchSize = 100;
    private static final int LABEL_INDEX = 0;
    private static final int KIND_INDEX = 1;
    private static final int DETAIL_INDEX = 2;
    private static final int FILTER_TEXT_INDEX = 3;
    private static final int SORT_TEXT_INDEX = 4;
    private static final int CLION_FLAGS_INDEX = 5;
    private static final int CLION_SNIPPET_FLAGS_INDEX = 6;
    private static final int CLION_POSTFIX_FLAG_INDEX = 7;
    private static final int FROM_FILE_INDEX = 8;
    private static final int FROM_FILE_OFFSET_INDEX = 9;
    private static final int INSERT_TEXT_INDEX = 10;
    private static final int RANGE_START_LINE_INDEX = 11;
    private static final int RANGE_START_CHAR_INDEX = 12;
    private static final int RANGE_END_LINE_INDEX = 13;
    private static final int RANGE_END_CHAR_INDEX = 14;
    private static final int NEXT_REPLACEMENT_INDEX = 15;

    private static boolean isKeyword(@NotNull CLionCompletionItem completion) {
        if (completion == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(0);
        }
        return completion.getKind() == CompletionItemKind.Keyword || completion.getKind() == CompletionItemKind.Snippet;
    }

    private static boolean isHeaderFile(@NotNull CLionCompletionItem completion) {
        if (completion == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(1);
        }
        return completion.getKind() == CompletionItemKind.File;
    }

    private static boolean isFolder(@NotNull CLionCompletionItem completion) {
        if (completion == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(2);
        }
        return completion.getKind() == CompletionItemKind.Folder;
    }

    private static boolean isPPDirective(@NotNull CLionCompletionItem completion) {
        if (completion == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(3);
        }
        return CLionCompletionFlags.isDirective(completion.getCLionFlags());
    }

    @Nullable
    private static Icon addLayer(@Nullable Icon baseIcon, @NotNull Icon newLayer, boolean nextRow) {
        if (newLayer == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(4);
        }
        if (baseIcon == null) {
            return null;
        }
        Pair pair = Pair.create((Object)baseIcon, (Object)newLayer);
        Icon patchedIcon = myPatchedIcons.get(pair);
        if (patchedIcon == null) {
            if (baseIcon instanceof LayeredIcon && !nextRow) {
                Icon[] layers = ((LayeredIcon)baseIcon).getAllLayers();
                LayeredIcon layeredIcon = new LayeredIcon(layers.length + 1);
                for (int i = 0; i < layers.length; ++i) {
                    layeredIcon.setIcon(layers[i], i);
                }
                layeredIcon.setIcon(newLayer, layers.length);
                patchedIcon = layeredIcon;
            } else if (nextRow) {
                RowIcon rowIcon = IconManager.getInstance().createRowIcon(2);
                rowIcon.setIcon(baseIcon, 0);
                rowIcon.setIcon(newLayer, 1);
                patchedIcon = rowIcon;
            } else {
                patchedIcon = new LayeredIcon(new Icon[]{baseIcon, newLayer});
            }
            myPatchedIcons.put((Pair<Icon, Icon>)pair, patchedIcon);
        }
        return patchedIcon;
    }

    @Nullable
    protected Icon iconFromCompletionKind(@NotNull CLionCompletionItem item, int clionCompletionFlags) {
        if (item == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(5);
        }
        CompletionItemKind itemKind = item.getKind();
        int clionFlags = item.getCLionFlags();
        boolean applyVisibility = false;
        Icon baseIcon = null;
        switch (itemKind) {
            case Enum: {
                baseIcon = CidrLangIcons.CodeAssistantEnum;
                break;
            }
            case File: {
                baseIcon = CidrLangIcons.FileTypes.H;
                break;
            }
            case Folder: {
                baseIcon = CLionCompletionFlags.isFramework(clionFlags) ? CidrProjectModelIcons.Framework : com.intellij.util.PlatformIcons.FOLDER_ICON;
                break;
            }
            case Class: 
            case Struct: {
                applyVisibility = true;
                if (CLionCompletionFlags.isClass(clionFlags)) {
                    baseIcon = CidrLangIcons.CodeAssistantClass;
                    break;
                }
                if (CLionCompletionFlags.isUnion(clionFlags)) {
                    baseIcon = CidrLangIcons.CodeAssistantUnion;
                    break;
                }
                baseIcon = CidrLangIcons.CodeAssistantStruct;
                break;
            }
            case Field: {
                applyVisibility = true;
                baseIcon = CidrLangIcons.CodeAssistantField;
                if (CLionCompletionFlags.isStatic(clionFlags)) {
                    baseIcon = ClangdCodeCompletionProviderBase.addLayer(baseIcon, IconManager.getInstance().getPlatformIcon(PlatformIcons.StaticMark), false);
                }
                if (!CLionCompletionFlags.isConstant(clionFlags)) break;
                baseIcon = ClangdCodeCompletionProviderBase.addLayer(baseIcon, IconManager.getInstance().getPlatformIcon(PlatformIcons.FinalMark), false);
                break;
            }
            case Function: 
            case Method: 
            case Constructor: {
                applyVisibility = true;
                baseIcon = CidrLangIcons.CodeAssistantFunction;
                if (CLionCompletionFlags.isStatic(clionFlags)) {
                    baseIcon = ClangdCodeCompletionProviderBase.addLayer(baseIcon, IconManager.getInstance().getPlatformIcon(PlatformIcons.StaticMark), false);
                }
                if (CLionCompletionFlags.isVirtualMethod(clionFlags) && !CLionCompletionFlags.isConstant(clionFlags)) break;
                baseIcon = ClangdCodeCompletionProviderBase.addLayer(baseIcon, IconManager.getInstance().getPlatformIcon(PlatformIcons.FinalMark), false);
                break;
            }
            case Variable: {
                Icon icon = baseIcon = CLionCompletionFlags.isLocal(clionFlags) ? CidrLangIcons.CodeAssistantLocal : CidrLangIcons.CodeAssistantGlobal;
                if (!CLionCompletionFlags.isConstant(clionFlags)) break;
                baseIcon = ClangdCodeCompletionProviderBase.addLayer(baseIcon, IconManager.getInstance().getPlatformIcon(PlatformIcons.FinalMark), false);
                break;
            }
            case Module: {
                baseIcon = CidrLangIcons.CodeAssistantNamespace;
                break;
            }
            case TypeParameter: 
            case Reference: 
            case Interface: {
                baseIcon = CidrLangIcons.CodeAssistantType;
                break;
            }
            case Text: {
                if (!CLionCompletionFlags.isMacro(clionFlags)) break;
                baseIcon = CidrLangIcons.CodeAssistantMacro;
                break;
            }
            case EnumMember: 
            case Value: {
                baseIcon = CidrLangIcons.CodeAssistantEnumConst;
                break;
            }
            case Property: {
                baseIcon = CidrLangIcons.CodeAssistantParameter;
                break;
            }
        }
        if (baseIcon != null && (CLionCompletionFlags.isNotAvailable(clionFlags) || CLionCompletionFlags.isNotAccessible(clionFlags))) {
            if (myDesaturatedIconsCache.containsKey(baseIcon)) {
                baseIcon = myDesaturatedIconsCache.get(baseIcon);
            } else {
                Icon desaturatedIcon = IconUtil.desaturate((Icon)baseIcon);
                myDesaturatedIconsCache.put(baseIcon, desaturatedIcon);
                baseIcon = desaturatedIcon;
            }
        }
        if (!applyVisibility) {
            return baseIcon;
        }
        IconManager iconManager = IconManager.getInstance();
        if (CLionCompletionFlags.isPrivate(clionCompletionFlags)) {
            return ClangdCodeCompletionProviderBase.addLayer(baseIcon, iconManager.getPlatformIcon(PlatformIcons.Private), true);
        }
        if (CLionCompletionFlags.isProtected(clionCompletionFlags)) {
            return ClangdCodeCompletionProviderBase.addLayer(baseIcon, iconManager.getPlatformIcon(PlatformIcons.Protected), true);
        }
        return ClangdCodeCompletionProviderBase.addLayer(baseIcon, iconManager.getPlatformIcon(PlatformIcons.Public), true);
    }

    @Nullable
    protected Icon functionIcon() {
        return CidrLangIcons.CodeAssistantFunction;
    }

    private static Range subtractFromRange(Range range, Position shift) {
        Position start = range.getStart();
        Position end = range.getEnd();
        start.setLine(start.getLine() - shift.getLine());
        if (start.getLine() == 0) {
            start.setCharacter(start.getCharacter() - shift.getCharacter());
        }
        end.setLine(end.getLine() - shift.getLine());
        if (end.getLine() == 0) {
            end.setCharacter(end.getCharacter() - shift.getCharacter());
        }
        range.setStart(start);
        range.setEnd(end);
        return range;
    }

    private static Range addToRange(Range range, Position shift) {
        Position start = range.getStart();
        Position end = range.getEnd();
        if (start.getLine() == 0) {
            start.setCharacter(start.getCharacter() + shift.getCharacter());
        }
        start.setLine(start.getLine() + shift.getLine());
        if (end.getLine() == 0) {
            end.setCharacter(end.getCharacter() + shift.getCharacter());
        }
        end.setLine(end.getLine() + shift.getLine());
        range.setStart(start);
        range.setEnd(end);
        return range;
    }

    private static ClangdLiveTemplate decodeCompletion(@NotNull CLionCompletionItem completion, Position extraPositionOffset, Position fakeEditorOffset, @NotNull ClangUrlConverter urlConverter) {
        if (completion == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(6);
        }
        if (urlConverter == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(7);
        }
        String wholeCompletion = completion.getLabel();
        String[] lines = wholeCompletion.split(COMPLETION_SEPARATOR);
        String signature = lines[0];
        completion.setLabel(signature);
        completion.setKind(CompletionItemKind.forValue((int)Integer.parseInt(lines[1])));
        completion.setDetail(lines[2]);
        completion.setFilterText(lines[3]);
        completion.setSortText(lines[4]);
        completion.setCLionFlags(Integer.parseInt(lines[5]));
        completion.setCLionSnippetFlags(Integer.parseInt(lines[6]));
        completion.setCLionPostfixFlag(Long.parseLong(lines[7]));
        completion.setFromFile(lines[8]);
        if (urlConverter.isWslMode()) {
            completion.setFromFile(urlConverter.fromWslPath(completion.getFromFile()));
        }
        completion.setFromFileOffset(Integer.parseUnsignedInt(lines[9]));
        Object insertText = lines[10];
        int rangeStartLine = Integer.parseInt(lines[11]);
        int rangeStartChar = Integer.parseInt(lines[12]);
        int rangeEndLine = Integer.parseInt(lines[13]);
        int rangeEndChar = Integer.parseInt(lines[14]);
        Range range = new Range(new Position(rangeStartLine, rangeStartChar), new Position(rangeEndLine, rangeEndChar));
        completion.setTextEdit(Either.forLeft((Object)new TextEdit(range, (String)insertText)));
        Ref nextReplacementIndex = new Ref((Object)15);
        Supplier<Boolean> nextReplacement = () -> lines.length > (Integer)nextReplacementIndex.get();
        ArrayList<TextEdit> additionalTextEdits = null;
        while (nextReplacement.get().booleanValue()) {
            int index = (Integer)nextReplacementIndex.get();
            int startLine = Integer.parseInt(lines[index + 1]);
            int startChar = Integer.parseInt(lines[index + 2]);
            int endLine = Integer.parseInt(lines[index + 3]);
            int endChar = Integer.parseInt(lines[index + 4]);
            if (additionalTextEdits == null) {
                additionalTextEdits = new ArrayList<TextEdit>();
            }
            additionalTextEdits.add(new TextEdit(new Range(new Position(startLine, startChar), new Position(endLine, endChar)), lines[index]));
            nextReplacementIndex.set((Object)(index + 5));
        }
        if (additionalTextEdits != null) {
            completion.setAdditionalTextEdits(additionalTextEdits);
        }
        ClangdLiveTemplate snippet = null;
        if (ClangdCodeCompletionProviderBase.isKeyword(completion)) {
            if (ClangdCodeCompletionProviderBase.isPPDirective(completion)) {
                completion.setFilterText("#" + completion.getFilterText());
            }
            if (completion.getKind() == CompletionItemKind.Snippet) {
                Matcher snippetMatcher = Pattern.compile("\\$\\{[0-9]+:([^}]+)}").matcher((CharSequence)insertText);
                Object snippetText = insertText;
                ArrayList<Variable> variables = new ArrayList<Variable>();
                int shift = 0;
                int insertTextShift = 0;
                boolean insertPlaceholders = CLionCompletionSnippetFlags.needInsertPlaceholders(completion.getCLionSnippetFlags());
                while (snippetMatcher.find()) {
                    String matched = snippetMatcher.group(1).replaceAll("-", "_");
                    if (variables.isEmpty()) {
                        insertText = ((String)insertText).substring(0, snippetMatcher.start()) + "<caret>" + ((String)insertText).substring(snippetMatcher.end());
                        insertTextShift += 7 - (snippetMatcher.end() - snippetMatcher.start());
                    } else {
                        insertText = ((String)insertText).substring(0, snippetMatcher.start() + insertTextShift) + ((String)insertText).substring(snippetMatcher.end() + insertTextShift);
                        insertTextShift += snippetMatcher.start() - snippetMatcher.end();
                    }
                    snippetText = ((String)snippetText).substring(0, snippetMatcher.start() + shift) + "$" + matched + "$" + ((String)snippetText).substring(snippetMatcher.end() + shift);
                    shift += matched.length() + 2 - (snippetMatcher.end() - snippetMatcher.start());
                    variables.add(new Variable(matched, null, (Expression)new TextExpression(matched), true, false));
                }
                if (insertPlaceholders) {
                    snippet = new ClangdLiveTemplate(completion.getFilterText(), (String)snippetText, CPP_GROUP);
                    String description = ((String)snippetText).replaceAll("\\$", "");
                    snippet.setDescription(description);
                    if (CLionCompletionSnippetFlags.dontCompleteName(completion.getCLionSnippetFlags())) {
                        snippet.setDontCompleteName(true);
                    }
                    if (!((String)snippetText).endsWith(")")) {
                        snippet.setToReformat(true);
                    }
                    for (Variable variable : variables) {
                        if (description.substring(0, description.indexOf(variable.getName())).trim().endsWith("{")) {
                            snippet.setEndSegmentNumber(variables.indexOf(variable));
                            break;
                        }
                        snippet.addVariable(variable.getName(), variable.getDefaultValueExpression(), variable.isAlwaysStopAt());
                    }
                }
            }
            if (((String)insertText).contains("(<caret>,")) {
                insertText = ((String)insertText).replaceAll(", |,", "");
            }
        } else if (ClangdCodeCompletionProviderBase.isHeaderFile(completion)) {
            if (((String)insertText).endsWith("\"") || ((String)insertText).endsWith(">")) {
                completion.setFilterText(((String)insertText).substring(0, ((String)insertText).length() - 1));
            }
        } else if (ClangdCodeCompletionProviderBase.isFolder(completion) && ((String)insertText).endsWith("/")) {
            completion.setFilterText(((String)insertText).substring(0, ((String)insertText).length() - 1));
        }
        ((TextEdit)completion.getTextEdit().getLeft()).setNewText((String)insertText);
        if (extraPositionOffset.getLine() != 0 || extraPositionOffset.getCharacter() != 0) {
            ((TextEdit)completion.getTextEdit().getLeft()).setRange(ClangdCodeCompletionProviderBase.subtractFromRange(((TextEdit)completion.getTextEdit().getLeft()).getRange(), extraPositionOffset));
        }
        if (fakeEditorOffset.getLine() != 0 || fakeEditorOffset.getCharacter() != 0) {
            ((TextEdit)completion.getTextEdit().getLeft()).setRange(ClangdCodeCompletionProviderBase.addToRange(((TextEdit)completion.getTextEdit().getLeft()).getRange(), fakeEditorOffset));
        }
        return snippet;
    }

    @NotNull
    private static String getActionShortcut() {
        String string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
        if (string == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static CompletionSorterImpl createClangdSorter(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(9);
        }
        final int caseSensitivity = CodeInsightSettings.getInstance().getCompletionCaseSensitive();
        final CompletionLocation location = new CompletionLocation(parameters);
        CompletionSorterImpl sorter = ((CompletionSorterImpl)CompletionService.getCompletionService().emptySorter()).weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh(new LookupElementWeigher("exactMatch"){

            @NotNull
            public Comparable weigh(@NotNull LookupElement element, @NotNull WeighingContext context) {
                if (element == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    6.$$$reportNull$$$0(1);
                }
                LookupElementPresentation presentation = new LookupElementPresentation();
                element.renderElement(presentation);
                if (presentation.getItemText() == null) {
                    Boolean bl = true;
                    if (bl == null) {
                        6.$$$reportNull$$$0(2);
                    }
                    return bl;
                }
                String itemText = presentation.getItemText();
                String pattern = context.itemPattern(element);
                Boolean bl = switch (caseSensitivity) {
                    case 2 -> !StringUtil.equalsIgnoreCase((CharSequence)itemText, (CharSequence)pattern);
                    case 3 -> {
                        boolean equalsCaseInsensitive = StringUtil.equalsIgnoreCase((CharSequence)itemText, (CharSequence)pattern);
                        yield !equalsCaseInsensitive || pattern.isEmpty() || itemText.charAt(0) != pattern.charAt(0);
                    }
                    default -> !itemText.equals(pattern);
                };
                if (bl == null) {
                    6.$$$reportNull$$$0(3);
                }
                return bl;
            }

            public boolean isPrefixDependent() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$6";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        }).weigh(new LookupElementWeigher("exactPrefixMatch"){

            @NotNull
            public Comparable weigh(@NotNull LookupElement element, @NotNull WeighingContext context) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(1);
                }
                String lookupString = element.getLookupString();
                String pattern = context.itemPattern(element);
                Boolean bl = switch (caseSensitivity) {
                    case 2 -> !StringUtil.startsWithIgnoreCase((String)lookupString, (String)pattern);
                    case 3 -> {
                        boolean equalsCaseInsensitive = StringUtil.startsWithIgnoreCase((String)lookupString, (String)pattern);
                        yield !equalsCaseInsensitive || pattern.isEmpty() || lookupString.charAt(0) != pattern.charAt(0);
                    }
                    default -> !lookupString.startsWith(pattern);
                };
                if (bl == null) {
                    5.$$$reportNull$$$0(2);
                }
                return bl;
            }

            public boolean isPrefixDependent() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }).weigh(new LookupElementWeigher("priority"){

            @NotNull
            public Double weigh(@NotNull LookupElement element) {
                ClangdLookupElement clangdElement;
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((clangdElement = (ClangdLookupElement)((Object)element.as(ClangdLookupElement.CLASS_CONDITION_KEY))) != null) {
                    Double d = -clangdElement.getScore();
                    if (d == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return d;
                }
                Double d = 0.0;
                if (d == null) {
                    4.$$$reportNull$$$0(2);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$4";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }).weigh((LookupElementWeigher)new RealPrefixMatchingWeigher()).weigh(new LookupElementWeigher("alphabetic"){

            @NotNull
            public String weigh(@NotNull LookupElement element) {
                ClangdLookupElement clangdElement;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((clangdElement = (ClangdLookupElement)((Object)element.as(ClangdLookupElement.CLASS_CONDITION_KEY))) == null || !ClangdCodeCompletionProviderBase.isKeyword(clangdElement.getCompletionItem())) {
                    return "";
                }
                String string = StringUtil.trimStart((String)element.getLookupString(), (String)"#").trim();
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }).weigh(new LookupElementWeigher("kind"){

            @NotNull
            public Boolean weigh(@NotNull LookupElement element) {
                ClangdLookupElement clangdElement;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((clangdElement = (ClangdLookupElement)((Object)element.as(ClangdLookupElement.CLASS_CONDITION_KEY))) != null) {
                    Boolean bl = clangdElement.getKind() == CompletionItemKind.Snippet;
                    if (bl == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return bl;
                }
                Boolean bl = false;
                if (bl == null) {
                    2.$$$reportNull$$$0(2);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }).withClassifier((ClassifierFactory)new ClassifierFactory<LookupElement>("stats"){

            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
            }
        }).weigh(new LookupElementWeigher("alphabetic"){

            @NotNull
            public String weigh(@NotNull LookupElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = StringUtil.trimStart((String)element.getLookupString(), (String)"#").trim();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }).withClassifier("prefix", true, (ClassifierFactory)new ClassifierFactory<LookupElement>("liftShorter"){

            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new LiftShorterItemsClassifier("liftShorter", next, new LiftShorterItemsClassifier.LiftingCondition(), false);
            }
        });
        LookupElementWeigher mlWeigher = MLWeigherUtil.findMLWeigher((CompletionLocation)location);
        if (mlWeigher != null) {
            sorter = sorter.weigh(mlWeigher);
        }
        return sorter;
    }

    protected abstract LookupElementBuilder createSnippetLookup(@NotNull CLionCompletionItem var1);

    protected abstract InsertHandler<LookupElement> createClangdInsertHandler(@NotNull CLionCompletionItem var1, int var2, String var3, Position var4);

    protected LookupElement lookup(final @NotNull CLionCompletionItem completion, @Nullable Icon icon, int prefixLength, String charBeforePrefix, Position completionCaretPosition, @Nullable ClangdLiveTemplate snippet) {
        String qualifier;
        if (completion == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(10);
        }
        if (completion.getKind() == CompletionItemKind.Snippet) {
            if (snippet != null) {
                return new LiveTemplateLookupElementImpl(snippet, false){

                    public void handleInsert(@NotNull InsertionContext context) {
                        Document document;
                        int completionStart;
                        if (context == null) {
                            9.$$$reportNull$$$0(0);
                        }
                        if ((completionStart = ClangLanguageServiceUtils.lspPos2Offset(document = context.getDocument(), ((TextEdit)completion.getTextEdit().getLeft()).getRange().getStart())) != context.getStartOffset()) {
                            document.deleteString(completionStart, context.getStartOffset());
                            context.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, completionStart);
                        }
                        super.handleInsert(context);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$9", "handleInsert"));
                    }
                };
            }
            String type = completion.getDetail();
            String description = CLionCompletionSnippetFlags.dontInsertName(completion.getCLionSnippetFlags()) || !type.isEmpty() ? completion.getLabel() : completion.getFilterText() + completion.getLabel();
            return this.createSnippetLookup(completion).withBoldness(true).withPresentableText(completion.getFilterText()).withTailText(type.isEmpty() ? "" : description).withTypeText(type.isEmpty() ? description : type).withIcon(icon);
        }
        if (completion.getKind() == CompletionItemKind.Keyword) {
            String newText = ((TextEdit)completion.getTextEdit().getLeft()).getNewText();
            final boolean hasSpaceAfterKeyword = newText.endsWith(" ");
            return LookupElementBuilder.create((Object)((Object)completion), (String)newText.trim()).withPresentableText(completion.getFilterText()).withTypeText(completion.getDetail()).withTailText(completion.getLabel()).withBoldness(true).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    boolean isObjC;
                    if (context == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        10.$$$reportNull$$$0(1);
                    }
                    if (isObjC = FileUtilRt.getExtension((String)context.getFile().getName()).endsWith("m")) {
                        context.setAddCompletionChar(false);
                    }
                    Document document = context.getDocument();
                    int endOffset = context.getTailOffset();
                    if (TemplateManager.getInstance((Project)context.getProject()).getActiveTemplate(context.getEditor()) == null && hasSpaceAfterKeyword && (context.getCompletionChar() != ' ' || isObjC)) {
                        Caret completionCaret;
                        if (!ClangdCompletionUtils.hasMatchingSpaceAfterInsertion(document, endOffset)) {
                            document.insertString(endOffset, (CharSequence)" ");
                        }
                        if ((completionCaret = ClangdCompletionUtils.getCompletionCaret(context, item.getLookupString().length())) != null) {
                            completionCaret.moveToOffset(endOffset + 1);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$10";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        Object presentation = completion.getFilterText();
        String insertedText = ((TextEdit)completion.getTextEdit().getLeft()).getNewText();
        int presentationStringStart = insertedText.indexOf((String)presentation);
        String string = qualifier = presentationStringStart >= 0 ? insertedText.substring(0, presentationStringStart) : "";
        if (CLionCompletionFlags.isOverrideCall(completion.getCLionFlags()) || qualifier.endsWith("::")) {
            completion.setRequiredQualifier(qualifier);
            presentation = qualifier + (String)presentation;
        }
        return LookupElementBuilder.create((Object)((Object)completion), (String)StringUtil.trimStart((String)completion.getFilterText(), (String)"~")).withPresentableText((String)presentation).withTypeText(completion.getDetail()).withTailText(completion.getLabel()).withIcon(icon).withStrikeoutness(CLionCompletionFlags.isDeprecated(completion.getCLionFlags())).withInsertHandler(this.createClangdInsertHandler(completion, prefixLength, charBeforePrefix, completionCaretPosition));
    }

    protected abstract boolean isCppFile(@NotNull VirtualFile var1);

    private boolean isValidHeaderFile(@NotNull String fileName, @NotNull VirtualFile origFile, @NotNull String textSoFar, @Nullable OCResolveConfiguration resolveConfiguration) {
        if (fileName == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(11);
        }
        if (origFile == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(12);
        }
        if (textSoFar == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(13);
        }
        if (resolveConfiguration == null) {
            return true;
        }
        OCLanguageKind languageKind = resolveConfiguration.getDeclaredLanguageKind(origFile);
        if (languageKind == null) {
            return true;
        }
        OCCompilerSettings compilerSettings = resolveConfiguration.getCompilerSettings(languageKind);
        int includeStartIndex = StringUtil.lastIndexOfAny((CharSequence)textSoFar, (String)"\"<") + 1;
        String additionalPath = textSoFar.substring(includeStartIndex);
        int lastSlashIndex = StringUtil.lastIndexOfAny((CharSequence)additionalPath, (String)"/");
        additionalPath = lastSlashIndex > 0 ? additionalPath.substring(0, lastSlashIndex + 1) : "";
        LocalFileSystem localFS = LocalFileSystem.getInstance();
        @Nullable VirtualFile foundFile = localFS.findFileByPath(origFile.getParent().getPath() + "/" + additionalPath + fileName);
        if (foundFile != null) {
            return this.isCppFile(foundFile);
        }
        for (HeadersSearchPath path : compilerSettings.getHeadersSearchPaths()) {
            foundFile = localFS.findFileByPath(path.getPath() + "/" + additionalPath + fileName);
            if (foundFile == null) continue;
            return this.isCppFile(foundFile);
        }
        return true;
    }

    @NotNull
    private LookupElement createClangdItem(@NotNull CompletionResultSet result, CLionCompletionItem completion, String charBeforePrefix, Position completionCaretPosition, int clionCompletionFlags, ClangdLiveTemplate snippet) {
        if (result == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(14);
        }
        int prefixLength = result.getPrefixMatcher().getPrefix().length();
        if (ClangdCodeCompletionProviderBase.isKeyword(completion)) {
            if (charBeforePrefix.equals("@")) {
                completion.setFilterText("@" + completion.getFilterText());
            }
            Icon icon = null;
            if (CLionCompletionFlags.isSnippetFunction(completion.getCLionFlags())) {
                icon = this.functionIcon();
            }
            LookupElement lookupElement = ClangdLookupElement.withCompletionItem(this.lookup(completion, icon, prefixLength, charBeforePrefix, completionCaretPosition, snippet), completion);
            if (lookupElement == null) {
                ClangdCodeCompletionProviderBase.$$$reportNull$$$0(15);
            }
            return lookupElement;
        }
        Icon icon = this.iconFromCompletionKind(completion, clionCompletionFlags);
        LookupElement lookupElement = ClangdLookupElement.withCompletionItem(this.lookup(completion, icon, prefixLength, charBeforePrefix, completionCaretPosition, snippet), completion);
        if (lookupElement == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(16);
        }
        return lookupElement;
    }

    protected void addElement(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull LookupElement element) {
        if (parameters == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(17);
        }
        if (result == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(18);
        }
        if (element == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(19);
        }
        result.addElement(element);
    }

    protected void addLookupAdvertisement(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NlsContexts.PopupAdvertisement @NotNull String text) {
        if (parameters == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(20);
        }
        if (result == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(21);
        }
        if (text == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(22);
        }
        result.addLookupAdvertisement(text);
    }

    protected void consumeResult(@NotNull CompletionParameters parameters, @NotNull VirtualFile virtualFile, @Nullable OCResolveConfiguration resolveConfiguration, @NotNull CompletionResultSet result, @NotNull Either<List<CLionCompletionItem>, CLionCompletionList> completionResult, String charBeforePrefix, Position completionCaretPosition, Position extraPositionOffset, Position fakeEditorOffset, ClangUrlConverter urlConverter) throws ProcessCanceledException {
        if (parameters == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(23);
        }
        if (virtualFile == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(24);
        }
        if (result == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(25);
        }
        if (completionResult == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(26);
        }
        List<CLionCompletionItem> completions = completionResult.isLeft() ? (List<CLionCompletionItem>)completionResult.getLeft() : ((CLionCompletionList)completionResult.getRight()).getItems();
        int invocationCount = parameters.getInvocationCount();
        if (parameters.getProcess().isAutopopupCompletion()) {
            ++invocationCount;
        }
        String textSoFar = null;
        boolean fileCompletion = false;
        for (CLionCompletionItem completion : completions) {
            ClangdLiveTemplate snippet = ClangdCodeCompletionProviderBase.decodeCompletion(completion, extraPositionOffset, fakeEditorOffset, urlConverter);
            if (!fileCompletion && completion.getKind() == CompletionItemKind.File && result.getPrefixMatcher().getPrefix().contains("/")) {
                fileCompletion = true;
                String prefix = result.getPrefixMatcher().getPrefix();
                prefix = prefix.substring(prefix.indexOf("/") + 1);
                result = result.withPrefixMatcher(prefix);
            }
            if (((CLionCompletionList)completionResult.getRight()).anyAvailableOrAccessibleResults() && (CLionCompletionFlags.isNotAccessible(completion.getCLionFlags()) || CLionCompletionFlags.isNotAvailable(completion.getCLionFlags())) && invocationCount <= 1) {
                if (invocationCount != 1) continue;
                this.addLookupAdvertisement(parameters, result, ClangdBundle.message("completion.press.shortcut.for.non.public.members", ClangdCodeCompletionProviderBase.getActionShortcut()));
                --invocationCount;
                continue;
            }
            if (completion.getKind() == CompletionItemKind.File && FileUtilRt.getExtension((String)completion.getFilterText()).isEmpty()) {
                if (textSoFar == null) {
                    textSoFar = ClangdCompletionUtils.getText(parameters.getEditor(), 0, parameters.getOffset());
                }
                if (!this.isValidHeaderFile(completion.getFilterText(), virtualFile, textSoFar, resolveConfiguration)) continue;
            }
            @NotNull LookupElement element = this.createClangdItem(result, completion, charBeforePrefix, completionCaretPosition, completion.getCLionFlags(), snippet);
            boolean prefixMatches = result.getPrefixMatcher().prefixMatches(element);
            if (!prefixMatches) continue;
            this.addElement(parameters, result, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consume(@NotNull ClangLanguageService clangdService, @NotNull CompletionParameters parameters, @NotNull VirtualFile virtualFile, @Nullable OCResolveConfiguration resolveConfiguration, @NotNull CompletionResultSet result, @NotNull Either<List<CLionCompletionItem>, CLionCompletionList> completionResult, int line, int column, @NotNull String fileText, String charBeforePrefix, Position completionCaretPosition, Position extraPositionOffset, Position fakeEditorOffset, @NotNull Pair<Integer, ArrayList<String>> postfixTemplates, int completionKind, ClangUrlConverter urlConverter) throws ProcessCanceledException, ExecutionException, TimeoutException {
        if (clangdService == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(27);
        }
        if (parameters == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(28);
        }
        if (virtualFile == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(29);
        }
        if (result == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(30);
        }
        if (completionResult == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(31);
        }
        if (fileText == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(32);
        }
        if (postfixTemplates == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(33);
        }
        this.consumeResult(parameters, virtualFile, resolveConfiguration, result, completionResult, charBeforePrefix, completionCaretPosition, extraPositionOffset, fakeEditorOffset, urlConverter);
        while (completionResult.isRight() && ((CLionCompletionList)completionResult.getRight()).isIncomplete()) {
            ProgressManager.checkCanceled();
            ClangResultFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> future = this.clangdCompletionFuture(clangdService, virtualFile, CompletionTriggerKind.TriggerForIncompleteCompletions, line, column, fileText, extraPositionOffset, postfixTemplates, completionKind);
            try {
                completionResult = (Either)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(future.asFuture(), (long)Long.MAX_VALUE, (String)"complete");
            }
            finally {
                future.release();
            }
            if (completionResult == null) break;
            this.consumeResult(parameters, virtualFile, resolveConfiguration, result, (Either<List<CLionCompletionItem>, CLionCompletionList>)completionResult, charBeforePrefix, completionCaretPosition, extraPositionOffset, fakeEditorOffset, urlConverter);
        }
    }

    protected void waitUntilReadyForCompletion(ClangLanguageService service, VirtualFile virtualFile) {
    }

    private ClangResultFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> clangdCompletionFuture(ClangLanguageService clangdService, @NotNull VirtualFile virtualFile, @NotNull CompletionTriggerKind kind, int line, int column, @NotNull String fileText, Position extraPositionOffset, @NotNull Pair<Integer, ArrayList<String>> postfixTemplates, int completionKind) {
        if (virtualFile == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(34);
        }
        if (kind == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(35);
        }
        if (fileText == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(36);
        }
        if (postfixTemplates == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(37);
        }
        if (virtualFile instanceof OCFragmentVirtualFile) {
            int parentOffset = ((OCFragmentVirtualFile)virtualFile).getParentOffset();
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)((OCFragmentVirtualFile)virtualFile).getParentFileContent(), (int)parentOffset);
            if (lineColumn != null) {
                extraPositionOffset.setLine(lineColumn.line);
                extraPositionOffset.setCharacter(lineColumn.column);
            }
            virtualFile = virtualFile.getParent();
        }
        this.waitUntilReadyForCompletion(clangdService, virtualFile);
        Ref resultRef = Ref.create();
        clangdService.complete(virtualFile, line, column, fileText, kind, completionKind, postfixTemplates, result -> resultRef.set(result.iWillNotForgetToCancelTheFuture()));
        return (ClangResultFuture)resultRef.get();
    }

    private static void waitForConsumerFinished(@NotNull Future<?> accepted) throws ProcessCanceledException {
        if (accepted == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(38);
        }
        try {
            CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(accepted, (long)Long.MAX_VALUE, (String)"clangd all completions");
        }
        catch (ExecutionException | TimeoutException exception) {
            CidrLogService.LOG.warn((Throwable)exception);
            throw new ProcessCanceledException();
        }
    }

    protected boolean isEnabled(@NotNull Project project) {
        ClangdSettings settings;
        if (project == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(39);
        }
        return (settings = ClangdSettings.getInstance(project)) != null && settings.isClangdOn() && settings.getCompletionType() != ClangdSettings.CompletionType.Builtin;
    }

    protected abstract void runNameSuggestionContributor(@NotNull CompletionParameters var1, @NotNull CompletionResultSet var2);

    protected abstract void runExtraCompletionContributors(@NotNull CompletionParameters var1, @NotNull CompletionResultSet var2, int var3, boolean var4);

    @NotNull
    private static Pair<Integer, ArrayList<String>> getEnabledPostfixTemplates() {
        int enabledPostfixTemplates = 0;
        ArrayList<String> postfixKeys = new ArrayList<String>(Collections.nCopies(ClangPostfixTemplateFlags.values().length - 1, ""));
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage((Language)OCLanguage.getInstance())) {
            if (!(provider2 instanceof ClangdPostfixTemplateProvider)) continue;
            @NotNull Set templates = PostfixTemplatesUtils.getAvailableTemplates((PostfixTemplateProvider)provider2);
            for (PostfixTemplate template : templates) {
                ClangPostfixTemplateFlags flag;
                if (!template.isEnabled(provider2)) continue;
                String name = template.getPresentableName();
                if (template instanceof PostfixChangedBuiltinTemplate) {
                    name = ((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate().getPresentableName();
                }
                if ((flag = ClangPostfixTemplateFlags.fromString(name)) == ClangPostfixTemplateFlags.None) continue;
                long value = flag.getValue();
                int index = (int)(Math.log(value) / Math.log(2.0));
                postfixKeys.set(index, template.getPresentableName());
                enabledPostfixTemplates = (int)((long)enabledPostfixTemplates | value);
            }
        }
        return new Pair((Object)enabledPostfixTemplates, postfixKeys);
    }

    protected abstract boolean isUDLElement(PsiElement var1);

    @Nullable
    protected abstract IElementType getCodeFragmentType(@NotNull PsiFile var1);

    @Nullable
    protected abstract VirtualFile getVirtualFileForCodeFragment(@NotNull PsiFile var1, @NotNull VirtualFile var2, IElementType var3);

    protected abstract int getCompletionKind(@NotNull CompletionParameters var1, IElementType var2, boolean var3);

    protected abstract OCResolveConfiguration getActiveResolveConfiguration(@NotNull VirtualFile var1, @NotNull Project var2);

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet originalResult) {
        Project project;
        if (parameters == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(40);
        }
        if (context == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(41);
        }
        if (originalResult == null) {
            ClangdCodeCompletionProviderBase.$$$reportNull$$$0(42);
        }
        if (!this.isEnabled(project = parameters.getPosition().getProject())) {
            return;
        }
        PsiElement psiContextElement = parameters.getPosition().getContext();
        boolean isUDL = this.isUDLElement(psiContextElement);
        if (isUDL && parameters.getInvocationCount() == 0) {
            return;
        }
        PsiFile psiFile = parameters.getOriginalFile();
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        ClangLanguageService clangdService = ClangLanguageServiceProvider.getIfStarted(project);
        if (clangdService == null || clangdService.isFileBanned(virtualFile.getUrl())) {
            return;
        }
        VirtualFile mainVirtualFile = virtualFile;
        IElementType fragmentElementType = this.getCodeFragmentType(psiFile);
        int parentFileOffset = 0;
        @Nullable VirtualFile codeFragmentVirtualFile = this.getVirtualFileForCodeFragment(psiFile, virtualFile, fragmentElementType);
        if (codeFragmentVirtualFile != null) {
            virtualFile = codeFragmentVirtualFile;
            if (virtualFile instanceof OCFragmentVirtualFile) {
                OCFragmentVirtualFile fragment = (OCFragmentVirtualFile)virtualFile;
                parentFileOffset = fragment.getParentOffset();
            }
            mainVirtualFile = virtualFile.getParent();
        }
        CompletionSorterImpl sorter = ClangdCodeCompletionProviderBase.createClangdSorter(parameters);
        CompletionResultSet result = originalResult.withRelevanceSorter((CompletionSorter)sorter);
        int offset = parameters.getOffset();
        Editor editor = parameters.getEditor();
        if (ClangdCompletionUtils.isLiveTemplateNameSegmentCompletion(project, editor)) {
            this.runNameSuggestionContributor(parameters, result);
            result.stopHere();
            return;
        }
        List allCarets = editor.getCaretModel().getAllCarets();
        Caret completionCaret = (Caret)allCarets.get(0);
        String prefix = result.getPrefixMatcher().getPrefix();
        if (prefix.contains(".")) {
            int dotPos = prefix.lastIndexOf(".");
            offset -= prefix.length() - dotPos;
            result = result.withPrefixMatcher(prefix.substring(dotPos + 1));
        }
        Position fakeEditorOffset = new Position(0, 0);
        if (fragmentElementType != null) {
            completionCaret = (Caret)allCarets.get(0);
            Position caretOffset = ClangLanguageServiceUtils.offset2LspPos(editor.getDocument(), completionCaret.getOffset() - offset);
            fakeEditorOffset.setLine(caretOffset.getLine());
            fakeEditorOffset.setCharacter(caretOffset.getCharacter());
        } else {
            for (Caret caret : allCarets) {
                if (offset == caret.getOffset()) {
                    completionCaret = caret;
                    break;
                }
                if (!ClangdCompletionUtils.getText(editor, caret.getOffset() - prefix.length(), caret.getOffset()).equals(prefix)) continue;
                offset = caret.getOffset();
                completionCaret = caret;
                break;
            }
        }
        int prefixOffset = offset - prefix.length();
        String charBeforePrefix = ClangdCompletionUtils.getText(editor, prefixOffset - 1, prefixOffset);
        @NotNull Pair postfixTemplates = allCarets.size() > 1 ? new Pair((Object)0, new ArrayList()) : ClangdCodeCompletionProviderBase.getEnabledPostfixTemplates();
        ClangFileFacade helper = clangdService.getClangIdeFacade().getFileFacade(virtualFile);
        if (helper == null) {
            return;
        }
        String fileText = helper.getText().toString();
        @Nullable LineColumn lineColumn = helper.getLineColumn(offset + parentFileOffset);
        int line = lineColumn != null ? lineColumn.line : 0;
        int column = lineColumn != null ? lineColumn.column : 0;
        Position extraPositionOffset = new Position(0, 0);
        int completionKind = this.getCompletionKind(parameters, fragmentElementType, isUDL);
        @Nullable LookupEx lookup = LookupManagerImpl.getActiveLookup((Editor)parameters.getEditor());
        if (lookup != null) {
            lookup.addLookupListener(new LookupListener(){

                public boolean beforeItemSelected(@NotNull LookupEvent event) {
                    LookupElement item;
                    if (event == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    if ((item = event.getItem()) instanceof ClangdLookupElement) {
                        ClangdLookupElement clangdLookupElement = (ClangdLookupElement)item;
                        @NotNull CLionCompletionItem clangdItem = clangdLookupElement.getCompletionItem();
                        CompletionItemKind itemKind = clangdItem.getKind();
                        long postfixFlag = clangdItem.getCLionPostfixFlag();
                        String insertion = ((TextEdit)clangdItem.getTextEdit().getLeft()).getNewText();
                        int namespaceSeparatorIndex = insertion.indexOf("::");
                        boolean fromNamespace = namespaceSeparatorIndex > 0 && insertion.indexOf(clangdItem.getFilterText()) > namespaceSeparatorIndex;
                        CompletionKindsCollector.ITEM_SELECTED.log(project, (Object)itemKind, (Object)ClangPostfixTemplateFlags.fromLong(postfixFlag), (Object)fromNamespace);
                    }
                    return super.beforeItemSelected(event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase$11", "beforeItemSelected"));
                }
            });
        }
        OCResolveConfiguration resolveConfiguration = this.getActiveResolveConfiguration(mainVirtualFile, parameters.getPosition().getProject());
        CompletionProgressIndicator completionProgressIndicator = (CompletionProgressIndicator)CompletionService.getCompletionService().getCurrentCompletion();
        ClangResultFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> future = this.clangdCompletionFuture(clangdService, virtualFile, CompletionTriggerKind.Invoked, line, column, fileText, extraPositionOffset, (Pair<Integer, ArrayList<String>>)postfixTemplates, completionKind);
        try {
            if (completionProgressIndicator != null) {
                completionProgressIndicator.unfreezeImmediatelyAfterFirstNItems(100);
            }
            Position completionCaretPosition = completionCaret != null ? ClangLanguageServiceUtils.offset2LspPos(editor.getDocument(), completionCaret.getOffset()) : new Position(0, 0);
            ProgressManager progressManager = ProgressManager.getInstance();
            CompletionResultSet finalResult = result;
            VirtualFile finalVirtualFile = virtualFile;
            ClangUrlConverter urlConverter = clangdService.getUrlConverter();
            Future resultIsConsumed = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                assert (progressManager.getProgressIndicator() == null) : "Freshly created Java Thread has progress indicator?!";
                ProgressManager.checkCanceled();
                progressManager.runProcess(() -> {
                    try {
                        @Nullable Either completionResult = (Either)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(future.asFuture(), (long)Long.MAX_VALUE, (String)"complete");
                        if (completionResult != null) {
                            @Nullable Either finalCompletionResult = completionResult;
                            this.consume(clangdService, parameters, finalVirtualFile, resolveConfiguration, finalResult, (Either<List<CLionCompletionItem>, CLionCompletionList>)finalCompletionResult, line, column, fileText, charBeforePrefix, completionCaretPosition, extraPositionOffset, fakeEditorOffset, (Pair<Integer, ArrayList<String>>)postfixTemplates, completionKind, urlConverter);
                        }
                    }
                    catch (ExecutionException | TimeoutException exception) {
                        CidrLogService.LOG.warn((Throwable)exception);
                        throw new ProcessCanceledException();
                    }
                }, (ProgressIndicator)ProgressWrapper.wrap((ProgressIndicator)completionProgressIndicator));
            });
            this.runExtraCompletionContributors(parameters, result, parameters.getInvocationCount(), allCarets.size() == 1);
            ClangdCodeCompletionProviderBase.waitForConsumerFinished(resultIsConsumed);
            result.stopHere();
        }
        catch (ProcessCanceledException cancelledException) {
            result.stopHere();
            result.restartCompletionOnAnyPrefixChange();
            if (completionProgressIndicator != null) {
                completionProgressIndicator.cancel();
            }
            throw cancelledException;
        }
        finally {
            if (completionProgressIndicator != null) {
                completionProgressIndicator.unfreezeImmediatelyAfterFirstNItems(-1);
            }
            future.release();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLayer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlConverter";
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase";
                break;
            }
            case 9: 
            case 17: 
            case 20: 
            case 23: 
            case 28: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textSoFar";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResult";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangdService";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixTemplates";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accepted";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/completion/ClangdCodeCompletionProviderBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionShortcut";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createClangdItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isHeaderFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFolder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPPDirective";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLayer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iconFromCompletionKind";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "decodeCompletion";
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createClangdSorter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lookup";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidHeaderFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createClangdItem";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addLookupAdvertisement";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "consumeResult";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "clangdCompletionFuture";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "waitForConsumerFinished";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 15, 16 -> new IllegalStateException(string);
        };
    }
}

