/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20Module;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.CppModulesState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.CppModulesStateUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CppModulesStateImpl
implements CppModulesState,
Disposable {
    @NotNull
    private final Project myProject;
    private final HashMap<String, Cpp20Module> myModulesByPath;

    public CppModulesStateImpl(@NotNull Project project) {
        if (project == null) {
            CppModulesStateImpl.$$$reportNull$$$0(0);
        }
        this.myModulesByPath = new HashMap();
        this.myProject = project;
    }

    @TestOnly
    @NotNull
    public String getAsCpp20ModuleMap() {
        @Nullable ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(this.myProject);
        if (provider2 == null) {
            return "<failed>";
        }
        @Nullable ClangLanguageService service = provider2.getIfStarted();
        if (service == null) {
            return "<failed>";
        }
        @NotNull ClangUrlConverter converter = service.getUrlConverter();
        ArrayList modules = this.byPath(modmap -> new ArrayList(modmap.values()));
        modules.sort(Comparator.comparing(Cpp20Module::getName));
        String string = CppModulesStateUtil.getAsCpp20ModuleMapImpl(converter, modules);
        if (string == null) {
            CppModulesStateImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public synchronized <T> T byPath(@NotNull Function<Map<String, Cpp20Module>, T> consumer) {
        if (consumer == null) {
            CppModulesStateImpl.$$$reportNull$$$0(2);
        }
        return consumer.apply(this.myModulesByPath);
    }

    @Override
    public synchronized void addCppModule(@NotNull Cpp20Module cppModule) {
        if (cppModule == null) {
            CppModulesStateImpl.$$$reportNull$$$0(3);
        }
        this.myModulesByPath.put(cppModule.getSourcePath(), cppModule);
    }

    @Override
    public synchronized void removeCppModuleByPath(@NotNull String cppModulePath) {
        if (cppModulePath == null) {
            CppModulesStateImpl.$$$reportNull$$$0(4);
        }
        this.myModulesByPath.remove(cppModulePath);
    }

    @Override
    public synchronized void removeCppModulesInDir(@NotNull String dirPath) {
        if (dirPath == null) {
            CppModulesStateImpl.$$$reportNull$$$0(5);
        }
        ArrayList<Cpp20Module> toDelete = new ArrayList<Cpp20Module>();
        for (Map.Entry<String, Cpp20Module> entry : this.myModulesByPath.entrySet()) {
            if (!entry.getKey().startsWith(dirPath)) continue;
            toDelete.add(entry.getValue());
        }
        for (Cpp20Module module : toDelete) {
            this.myModulesByPath.remove(module.getSourcePath());
        }
    }

    @Override
    public synchronized void clearCppModules() {
        this.myModulesByPath.clear();
    }

    @Override
    public synchronized int size() {
        return this.myModulesByPath.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public synchronized boolean hasCppModule(@NotNull String cppModulePath) {
        if (cppModulePath == null) {
            CppModulesStateImpl.$$$reportNull$$$0(6);
        }
        return this.myModulesByPath.containsKey(cppModulePath);
    }

    @Override
    public boolean dirContainsCppModule(@NotNull String dirPath) {
        if (dirPath == null) {
            CppModulesStateImpl.$$$reportNull$$$0(7);
        }
        for (String path : this.myModulesByPath.keySet()) {
            if (!path.startsWith(dirPath)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/CppModulesStateImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cppModule";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cppModulePath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/CppModulesStateImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsCpp20ModuleMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "byPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCppModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeCppModuleByPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeCppModulesInDir";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasCppModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dirContainsCppModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

