/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.problems;

import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.problems.ClangIndexProblem;
import com.jetbrains.cidr.lang.problems.ClangIndexProblemSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010\u0013\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/problems/ClangIndexProblemReporter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "serializer", "Lcom/jetbrains/cidr/lang/problems/ClangIndexProblemSerializer;", "problems", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lcom/jetbrains/cidr/lang/problems/ClangIndexProblem;", "updateIndexProblems", "", "file", "newProbs", "cleanupStaleProblems", "intellij.cidr.clangd"})
@SourceDebugExtension(value={"SMAP\nClangIndexProblemReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangIndexProblemReporter.kt\ncom/jetbrains/cidr/lang/problems/ClangIndexProblemReporter\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n30#2,2:48\n30#2,2:50\n30#2,2:56\n1869#3,2:52\n1869#3,2:54\n*S KotlinDebug\n*F\n+ 1 ClangIndexProblemReporter.kt\ncom/jetbrains/cidr/lang/problems/ClangIndexProblemReporter\n*L\n15#1:48,2\n26#1:50,2\n33#1:56,2\n27#1:52,2\n29#1:54,2\n*E\n"})
public final class ClangIndexProblemReporter {
    @NotNull
    private final Project project;
    @NotNull
    private final ClangIndexProblemSerializer serializer;
    @NotNull
    private Map<VirtualFile, List<ClangIndexProblem>> problems;

    public ClangIndexProblemReporter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.serializer = new ClangIndexProblemSerializer(this.project);
        this.problems = this.serializer.loadAllProblems();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProblemsCollector> serviceClass$iv = ProblemsCollector.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProblemsCollector service = (ProblemsCollector)object;
        for (Map.Entry<VirtualFile, List<ClangIndexProblem>> rec : this.problems.entrySet()) {
            for (ClangIndexProblem problem : rec.getValue()) {
                service.problemAppeared((Problem)problem);
            }
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void updateIndexProblems(@NotNull VirtualFile file, @NotNull List<ClangIndexProblem> newProbs) {
        block4: {
            ClangIndexProblem it;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(newProbs, (String)"newProbs");
            this.serializer.writeUpdate(file, newProbs);
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<ProblemsCollector> serviceClass$iv = ProblemsCollector.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ProblemsCollector service = (ProblemsCollector)object;
            List<ClangIndexProblem> list = this.problems.get(file);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (ClangIndexProblem)element$iv;
                    boolean bl = false;
                    service.problemDisappeared((Problem)it);
                }
            }
            this.problems.put(file, newProbs);
            List<ClangIndexProblem> list2 = this.problems.get(file);
            if (list2 == null) break block4;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ClangIndexProblem)element$iv;
                boolean bl = false;
                service.problemAppeared((Problem)it);
            }
        }
    }

    public final void cleanupStaleProblems() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProblemsCollector> serviceClass$iv = ProblemsCollector.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProblemsCollector service = (ProblemsCollector)object;
        for (Map.Entry<VirtualFile, List<ClangIndexProblem>> record : this.problems.entrySet()) {
            List filtered = new ArrayList();
            for (ClangIndexProblem problem : record.getValue()) {
                long modificationStamp = record.getKey().getModificationStamp();
                if (problem.getGeneration() != modificationStamp) {
                    service.problemDisappeared((Problem)problem);
                    continue;
                }
                filtered.add(problem);
            }
            record.setValue(filtered);
            this.serializer.writeUpdate(record.getKey(), filtered);
        }
    }
}

